<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * @package formateur
 * @modulegroup plpgsql
 * @module plpgsql_formateur
 */


/**
* DEPRECATED- Fonction qui donne le nombre de formations du formateur 
*
* Retourne le nombre de classes dont est charg le formateur spcifi.
*	!!!!   !!   !!!! Utiliser get_classes_formateur  la place. !!!!   !!   !!!! 
*
* @param integer : le formateur
*
* @return integer : le nombre de classes
*/
function get_nb_classes($formateur)
{
    $req="SELECT  _af_get_nb_classes($formateur)";
    $nb_classes=pg_query($req);
    $nb = pg_fetch_row($nb_classes,0);

    return $nb[0];
}

/**
*	Obtenir les formations sur une periode - OLD
*   @deprecated : utiliser get_formateur_formations_periode
*   Retourne toutes les formations sur la periode spcifie dont $formateur est le numero de formateur.
*
*
*   @param  integer : le formateur
*   @param  integer : la priode concerne (1=pass;2=prsent;3=futur)
*   @param string : DESC ou ASC pour le tri decroissant ou croissant
*   @param  integer  : si egal  1 ordonne par classe
*
*   @return  le resultat de la requete  (num_formation integer, nom_formation varchar, debut date, fin date, langue varchar, num_groupe integer, nom_groupe varchar, ordre varchar)
*/
function get_formations_formateur_periode_tri_old( $formateur, $periode, $ordre, $ordonne_par_classe)
{
        $req="SELECT DISTINCT C.num_cal AS num_formation, C.nom_cal AS nom_formation,
                        g_num_gest_g, CL.nom, datedeb, datefin, lower(C.nom_cal) AS ordre, CL.id
        FROM GESTIONNAIRE G, CALENDRIER C, CLASSE CL  , dates D  " ;
        if($periode==2)$req.=", dates D2 ";
        $req.="where G.g_num_cal=C.num_cal and g_num_user=$formateur
        and G.g_num_gest_g=CL.id";

        if($periode==1)
        {
                $req.=" and  datefin =num_date
                and jour < current_date
                order by ";
        }
        else
        {
                if ($periode==2)
                {
                        $req.=" and datedeb=D.num_date
                        and datefin =  D2.num_date
                        and   current_date BETWEEN D.jour AND D2.jour
                        order by ";
                }
                else
                {
                        if ($periode==3)
                        {
                                $req.=" and   datedeb =num_date
                                and jour > current_date
                                order by";
                        }
                        else
                        {
                                echo '<br/>la periode specifiee est invalide<br/>';
                                return null;
                        }
                }
        }
        if($ordonne_par_classe)
                $req.=" CL.nom, ";   //on groupe sur les classes
        else
                $req.=" nom_formation, ";   // On groupe par nom de formations

        $req.=" ordre $ordre"; // dcroissant ou non...

        $result=pg_query($req);

        return $result;
}

/**
* Obtenir toutes les formations du formateurs sur une periode precise
*
*   @deprecated : utiliser get_formateur_formations_periode
* Retourne les formations sur la periode spcifie dont $formateur est le numero de formateur.
*
*   @param integer : le formateur
*   @param integer : la priode concerne
*   @param string : DESC ou ASC pour le tri decroissant ou croissant
*   @param integer : si egal  1 ordonne par classe
*
*   @return integer : le resultat de la requete  (num_formation integer, nom_formation varchar, debut date, fin date, langue varchar, num_groupe integer, nom_groupe varchar, ordre varchar)
*/
function get_formations_formateur_periode_tri($formateur, $periode, $ordre, $ordonne_par_classe)
{
    //echo "get_formations_formateur AVEC periode connue<br>" ;

    if(VERSION_BASE>VERSION)
    {
        $req="SELECT * FROM  _af_get_formations_formateur_periode($formateur, $periode, '$ordre', $ordonne_par_classe)
        AS (num_formation integer, nom_formation varchar, debut date, fin date, langue varchar, num_groupe integer, nom_groupe varchar, ordre varchar) ";

        $formations=pg_query($req);
    }
    else    // Fonction de substitution
        $formations=get_formations_formateur_periode_tri_old( $formateur, $periode, $ordre, $ordonne_par_classe) ;


   // retourne 0 (false) ou 1 (true)
    return $formations;
}

/**
	Obtenir les formations d'un formateur pour une periode (OLD)
*   @param integer : le formateur
*   @param integer : la priode concerne
*   @param string : DESC ou ASC pour le tri decroissant ou croissant
*   @param integer : si egal  1 ordonne par classe
*
*   @return integer : le resultat de la requete  (num_formation integer, nom_formation varchar, debut date, fin date, langue varchar, num_groupe integer, nom_groupe varchar, ordre varchar)
*/
function get_formateur_formations_periode_tri_old( $formateur, $periode, $ordre, $ordonne_par_classe){
	$req="SELECT DISTINCT C.num_cal AS num_formation, C.nom_cal AS nom_formation,
    				g_num_gest_g, CL.nom, datedeb, datefin, lower(C.nom_cal) AS ordre, CL.id
        			FROM GESTIONNAIRE G, CALENDRIER C, CLASSE CL  , dates D  " ;
 	if($periode==2)
		$req.=", dates D2 ";
  	$req.="where G.g_num_cal=C.num_cal and g_num_user=$formateur and G.g_num_gest_g=CL.id";
   	if($periode==1){
    		$req.=" and  datefin =num_date and jour < current_date order by ";
    }
    else{
    		if ($periode==2){
      		$req.=" and datedeb=D.num_date and datefin =  D2.num_date and   current_date BETWEEN D.jour AND D2.jour order by ";
    		}
    		else{
    			if ($periode==3){
      			$req.=" and   datedeb =num_date and jour > current_date order by";
        		}
        		else{
        			echo '<br/>la periode specifiee est invalide<br/>';
             	return null;
        		}
    		}
   	}
    if($ordonne_par_classe)
    		$req.=" CL.nom, ";   //on groupe sur les classes
    else
    		$req.=" nom_formation, ";   // On groupe par nom de formations
    $req.=" ordre $ordre"; // dcroissant ou non...
    $result=pg_query($req);
    return $result;
}
/**
	Obtenir les formations d'un formateur pour une periode (OLD)
*   @param integer : le formateur
*   @param integer : la priode concerne
*   @param string : DESC ou ASC pour le tri decroissant ou croissant
*   @param integer : si egal  1 ordonne par classe
*
*   @return integer : le resultat de la requete  (num_formation integer, nom_formation varchar, debut date, fin date, langue varchar, num_groupe integer, nom_groupe varchar, ordre varchar)
*/
function get_formateur_formations_periode_tri( $formateur, $periode, $ordre, $ordonne_par_classe){
	if(VERSION_BASE>VERSION){
 		$req="SELECT * FROM  _af_get_formations_formateur_periode($formateur, $periode, '$ordre', $ordonne_par_classe)
        				AS (num_formation integer, nom_formation varchar, debut date, fin date, langue varchar, num_groupe integer, nom_groupe varchar, ordre varchar) ";
   		$formations=pg_query($req);
    }
    else    // Fonction de substitution
		$formations=get_formateur_formations_periode_tri_old( $formateur, $periode, $ordre, $ordonne_par_classe) ;


   // retourne 0 (false) ou 1 (true)
    return $formations;
}


/**
*  Obtenir toutes les formations d'un formateur (attention : quelquesoit la periode) - OLD
*
* Retourne les formations
* dont $id_formateur est le numero de formateur.
*
* @param integer : identifiant du formateur
* @param string : DESC ou ASC pour le tri1 decroissant ou croissant
* @param string : DESC ou ASC pour le tri2 decroissant ou croissant
* @param integer : spcifie le classement1 (0 pas de classement, 1, par nom de formation, 2 par date de debut, 3 par nom de la classe)
* @param integer : spcifie le classement2 (0 pas de classement, 1, par nom de formation, 2 par date de debut, 3 par nom de la classe) par date de dbut, sinon par nom
*
* @return string : le resultat de la requete
*/
function get_formations_formateur_old($id_formateur, $ordre_affich1="ASC", $ordre_affich2="ASC", $classement1=1, $classement2=0)
{
        if($classement1 <= 0 || $classement1 > 3)
        {
                echo 'erreur classement non valide' ;
                // On corrige si le classement n'est pas bon
                $classement1=1;
        }

        $req = "SELECT DISTINCT num_cal AS num_formation, nom_cal AS nom_formation,
                        D1.jour AS debut, D2.jour AS fin, langue, id AS num_groupe , nom AS nom_groupe
        FROM gestionnaire G, calendrier C, classe Cl, dates D1, dates D2
        WHERE g_num_user=$id_formateur
        AND g_num_cal=num_cal
        AND g_num_gest_g=id
        AND datedeb=D1.num_date
        AND datefin=D2.num_date" ;

        $req.= " ORDER BY " ;

        if($classement1==1) $req .= " nom_formation " ;
        if($classement1==2) $req .= " debut " ;
        if($classement1==3) $req .= " nom_groupe " ;
        // ASC (ou " ")  ou DESC
        $req.=" $ordre_affich1" ;

        // Il est possible de classer sur deux champs, pour cela le paramtre $classement2 doit tre valu
        if($classement2!=0)
        {
                if($classement2 < 0 || $classement2 > 3)
                {
                        echo 'erreur classement2 non valide' ;
                        // On corrige si le classement n'est pas bon
                        $classement2=1;
                }

                $req .= " , " ;
                if($classement2==1) $req .= " nom_formation " ;
                if($classement2==2) $req .= " debut " ;
                if($classement2==3) $req .= " nom_groupe " ;
                $req.=" $ordre_affich2 ;" ;
        }
        //echo "<font color=red>Requete : $req</font><br>";
        return pg_query($req) ;
}

/**
*  Obtenir toutes les formations d'un formateur (attention : quelquesoit la periode)
*
* Retourne les formations
* dont $id_formateur est le numero de formateur.
*
* @param integer : identifiant du formateur
* @param string : DESC ou ASC pour le tri1 decroissant ou croissant
* @param string : DESC ou ASC pour le tri2 decroissant ou croissant
* @param integer : spcifie le classement1 (0 pas de classement, 1, par nom de formation, 2 par date de debut, 3 par nom de la classe)
* @param integer : spcifie le classement2 (0 pas de classement, 1, par nom de formation, 2 par date de debut, 3 par nom de la classe)
* par date de dbut, sinon par nom
*
* @return string : le resultat de la requete
*/
function get_formations_formateur($id_formateur, $ordre_affich1="ASC", $ordre_affich2="ASC", $classement1=1, $classement2=0)
{
        if(!$id_formateur)
                return(-2) ;  // code erreur identifiant non connu

        // Si ASC n'est pas prcis
        if($ordre_affich1=='') $ordre_affich1="ASC";
        if($ordre_affich2=='') $ordre_affich2="ASC";

        if(VERSION_BASE>VERSION)
        {
                $req="SELECT * FROM _af_get_formations_formateur($id_formateur, '$ordre_affich1',  '$ordre_affich2', $classement1, $classement2)
                AS ( num_formation integer, nom_formation varchar, debut date, fin date, langue varchar, num_groupe integer, nom_groupe varchar) ";

                $formations=pg_query($req);
        }
        else
            $formations=get_formations_formateur_old($id_formateur, $ordre_affich1, $ordre_affich2, $classement1, $classement2) ;

        return $formations;
}

/**
* 	Obtenir les classes  d'un formateur (OLD)
*  @deprecated : utiliser get_formateur_classes
* 	Retourne les identifiants et liblls des groupes(classes d'un formateur).
*
*   @param integer : le formateur
*
*   @return integer : le resultat de la requete  (num_classe integer, nom_classe varchar)
*/
function get_classes_formateur_old($formateur){
	
	$req="SELECT DISTINCT id,CL.nom
		from GESTIONNAIRE G, CALENDRIER C, CLASSE CL
		where G.g_num_cal=C.num_cal and g_num_user=$formateur
		and G.g_num_gest_g=CL.id; ";

     return  pg_query($req);

}

/**
* 	Obtenir les classes  d'un formateur
*  @deprecated : utiliser get_formateur_classes
* 	Retourne les identifiants et liblls des groupes(classes d'un formateur).
*
*   @param integer : le formateur
*
*   @return integer : le resultat de la requete  (num_classe integer, nom_classe varchar)
*/
function get_classes_formateur($formateur){

    if(VERSION_BASE>VERSION)
    {
        $req="SELECT * FROM  _af_get_classes_formateur($formateur)
        AS (num_classe integer, nom_classe varchar); ";

        $classes=pg_query($req);
    }
    else    // Fonction de substitution
        $classes=get_classes_formateur_old( $formateur) ;

    return $classes;
}

/**
	Obtenir les classes  d'un formateur  (OLD)
*	@param integer : le numero de formateur
*	@return integer : le resultat de la requete
*/
function get_formateur_classes_old($formateur){
	$req="SELECT DISTINCT id,CL.nom from GESTIONNAIRE G, CALENDRIER C, CLASSE CL
				where G.g_num_cal=C.num_cal and g_num_user=$formateur and G.g_num_gest_g=CL.id; ";
    return  pg_query($req);
}
/**
	Obtenir les classes  d'un formateur
*	@param integer : le numero de formateur
*	@return integer : le resultat de la requete
*/
function get_formateur_classes($formateur){
	if(VERSION_BASE>VERSION){
 		$req="SELECT * FROM  contraintes.af_get_formateur_classes($formateur)  AS (id integer,libelle varchar,pere int4,min int4,max int4); ";
   		$classes=pg_query($req);
    }
    else    // Fonction de substitution
        $classes=get_formateur_classes_old( $formateur) ;
    return $classes;
}


/**
* 	Obtenir les classes de formation  d'un formateur (OLD)
*
* 	Retourne les identifiants et libelles des groupes(classes d'un formateur).
*
*   @param integer : le formateur
*
*   @return integer : le resultat de la requete  (num_classe integer, nom_classe varchar)
*/
function get_formateur_classes_formation_old($formateur, $formation){
	
	    $req="	select * 
    			from classe 
    			where id in (
    				select distinct g_num_gest_g 
    				from GESTIONNAIRE 
    				where g_num_cal=$formation
    				and g_num_user=$formateur)";
    				
    $classes=pg_query($req);
  
    return $classes ;
}

/**
* 	Obtenir les classes de formation  d'un formateur
*
* 	Retourne les identifiants et libelles des groupes(classes d'un formateur).
*
*   @param integer : le formateur
*
*   @return integer : le resultat de la requete  (num_classe integer, nom_classe varchar)
*/
function get_formateur_classes_formation($formateur, $formation){

    if(VERSION_BASE>VERSION)
    {

    }
    else    // Fonction de substitution
        $classes=get_formateur_classes_formation_old($formateur, $formation) ;

    return $classes;
}


/**
*   Obtenir les formations d'un formateur pour une priode (OLD)
*
*   @param integer : le numero du formateur
*   @param integer : le numero de la priode 1=pass 2=prsent 3=futur>
*   @return integer : l'entier resultat de la requete
*/
function get_formations_formateur_periode_old($formateur,$periode){
    switch($periode){
        case 1: $condition=" AND D2.jour < current_date ";
        break;
        case 2: $condition=" AND NOT (D1.jour > current_date OR D2.jour < current_date) ";
        break;
        case 3: $condition=" AND D1.jour > current_date ";
        break;
    }
    $sql="SELECT DISTINCT g_num_gest_g , C.nom_cal as formation, C.num_cal, D1.jour as debut, D2.jour as fin
                                    FROM gestionnaire G, calendrier C, dates D1, dates D2
                                    WHERE G.g_num_user=$formateur
                                    $condition
                                    AND C.num_cal=G.g_num_cal
                                    AND D1.num_date=C.datedeb
                                    AND D2.num_date=C.datefin
                                    ORDER BY D1.jour";

    return (pg_query($sql));

}
/**
*   Obtenir les formations d'un formateur pour une p\x{00E9}riode
*
*   @param integer : le numero du formateur
*   @param integer : le numero de la periode 1=passe 2=present 3=futur>
*   @return integer : l'entier resultat de la requete
*/
function get_formations_formateur_periode($formateur,$periode){
    if (VERSION_BASE > VERSION) {
        // Appel de la fonction plpgsql  crer : _af_get_formation_selection_periode("groupe",$groupe,$periode)
        $sql="A IMPLEMENTER";
        $res=pg_query($sql);
    }
    else
        $res=get_formations_formateur_periode_old($formateur,$periode);
    return $res;
}


/**
*   Obtenir les formations d'un formateur pour une p\x{00E9}riode (OLD)
*
*   @param integer : le numero du formateur
*	 @param binary la ou les periodes voulues en binaire: 100 passees, 010 presentes et 001 futures
*   @return integer : l'entier resultat de la requete
*/
function get_formateur_formations_periode_old($formateur,$periode=""){
	
		if($periode!="100"&&$periode!="010"&&$periode!="001"){
			$cond_d=" AND (";
			$cond_m="";
			$cond_m_val=" OR ";
			$cond_f=" ) "; 	
		}
		else{
			$cond_d=" AND ";
			$cond_m="";
			$cond_m_val=" AND ";
			$cond_f=""; 
		}
		
        $temp=$periode &"100";
        if($temp=="100"){
        	$condition.="  D2.jour < current_date ";
        	$cond_m=$cond_m_val;
        }
        
        $temp=$periode &"010";
        if($temp=="010"){
         	$condition.="$cond_m  NOT (D1.jour > current_date OR D2.jour < current_date) ";
         	$cond_m=$cond_m_val;
         }
        
        $temp=$periode &"001";
        if($temp=="001")$condition.="$cond_m  D1.jour > current_date ";
    
    $sql="SELECT DISTINCT C.num_cal , C.nom_cal as formation,  D1.jour as debut, D2.jour as fin , g_num_gest_g, lower(nom_cal) AS ordre
                                    FROM gestionnaire G, calendrier C, dates D1, dates D2
                                    WHERE G.g_num_user=$formateur
                                   	$cond_d  $condition $cond_f
                                    AND C.num_cal=G.g_num_cal
                                    AND D1.num_date=C.datedeb
                                    AND D2.num_date=C.datefin
                                    ORDER BY ordre";

    return (pg_query($sql));

}
/**
*   Obtenir les formations d'un formateur pour une p\x{00E9}riode
*
*   @param integer : le numero du formateur
*	 @param binary la ou les periodes voulues en binaire: 100 passees, 010 presentes et 001 futures
*   @return integer : l'entier resultat de la requete
*/
function get_formateur_formations_periode($formateur,$periode=""){
    if (VERSION_BASE > VERSION) {
        // Appel de la fonction plpgsql \x{00E0} cr\x{00E9}er : _af_get_formation_selection_periode("groupe",$groupe,$periode)
        $sql="A IMPLEMENTER";
        $res=pg_query($sql);
    }
    else
        $res=get_formateur_formations_periode_old($formateur,$periode);
    return $res;
}

function get_formateur_exostlcs_old($formateur){
    
    $sql="select num_exo, titre from EXOTLC where formateur='$formateur';";

    return (pg_query($sql));
}

function get_formateur_exostlcs($formateur){
    if (VERSION_BASE > VERSION) {
        // Appel de la fonction plpgsql \x{00E0} cr\x{00E9}er : _af_get_formation_selection_periode("groupe",$groupe,$periode)
        $sql="A IMPLEMENTER";
        $res=pg_query($sql);
    }
    else
        $res=get_formateur_exostlcs_old($formateur,$periode);
    return $res;
}

/**
    Obtenir les alertes pour un formateur (OLD)
*
*   @param integer : le numero de formateur
*   @return integer : le resultat e la requete
*/
function get_formateur_alertes_old($formateur){
    $sql="select * from alert where num_cal in (select distinct g_num_cal from gestionnaire where g_num_user=$formateur)";
    //echo "sql=$sql<br>";
    $res=pg_query($sql);
    return $res;
}
/**
    Obtenir les alertes pour un formateur (OLD)
*
*   @param integer : le numero de formateur
*   @return integer : le resultat e la requete
*/
function get_formateur_alertes($formateur){
    if (VERSION_BASE > VERSION) {
        $sql="A IMPLEMENTER";
        $res=pg_query($sql);
    }
    else
        $res=get_formateur_alertes_old($formateur);
    return $res;
}

/**
	Obtenir les formations avec predentiel note pour un formateur (OLD)

 	@param integer : le numero du formateur
 	@return integer : le resultat de la requete
*/
function get_formateur_formations_presentiel_note_old($formateur){
	$sql="select num_cal,nom_cal from calendrier where num_cal in
			(select distinct g_num_cal from gestionnaire where g_num_cal in
			(select distinct num_cal from notation) and g_num_user=$formateur)";
   return (pg_query($sql));
}
/**
	Obtenir les formations avec predentiel note pour un formateur

 	@param integer : le numero du formateur
 	@return integer : le resultat de la requete
*/
function get_formateur_formations_presentiel_note($formateur){
	if (VERSION_BASE > VERSION) {
        $sql="A IMPLEMENTER";
        $res=pg_query($sql);
    }
    else
        $res=get_formateur_formations_presentiel_note_old($formateur);
    return $res;
}

/**
	Obtenir les formations presentes et futures d'un formateur (OLD)

 	@param integer : le numero du formateur
 	@return integer :  le resultat de la requete
*/
function get_formateur_formations_presentes_futures_old($formateur){
	$sql="select distinct C.num_cal,C.nom_cal,D1.jour,D2.jour from gestionnaire G,calendrier C,dates D1,dates D2 where C.num_cal=G.g_num_cal and
			D1.num_date=C.datedeb and D2.num_date=C.datefin and G.g_num_user=$formateur and not (D2.jour<current_date)
			order by D1.jour";
   return pg_query($sql);
}
/**
	Obtenir les formations presentes et futures d'un formateur

 	@param integer : le numero du formateur
 	@return integer :  le resultat de la requete
*/
function get_formateur_formations_presentes_futures($formateur){
	if (VERSION_BASE > VERSION) {
        $sql="A IMPLEMENTER";
        $res=pg_query($sql);
    }
    else
        $res=get_formateur_formations_presentes_futures_old($formateur);
    return $res;
}

/**
	Obtenir les formations d'un formateur  (OLD)
	@param integer : numero formateur
	@param string : classement (asc ou desc)
	@param string : order by (libelle ou date debut)
	@param integer : periode (1 passes, 2 prsentes, 3 futures, 0 toutes)
*/
function get_formateur_formations_old($formateur,$classement,$orderby,$periode){
	//$today=date("Y-m-d");
	$sql="SELECT DISTINCT C.num_cal,C.nom_cal,G.g_num_parcours,D1.jour as debut, D2.jour as fin,C.langue
			        FROM gestionnaire G, calendrier C, dates D1, dates D2
                    WHERE C.num_cal=G.g_num_cal
                    AND D1.num_date=C.datedeb
                    AND D2.num_date=C.datefin
                    AND G.g_num_user=$formateur ";
					
					// traitement periode
					//$periode=2;
					switch($periode){
						case 1 : $sql .=" and D2.jour<current_date ";
						break;
						case 2 : $sql .=" and current_date between D1.jour and D2.jour ";
						break;
						case 3 : $sql .=" and D1.jour>current_date ";
						break;
					}
					
					// traitement du tri
					if($orderby=='libelle')
						$sql .=" order by C.nom_cal ";
					else
						$sql .=" order by D1.jour ";
					
					// classement
					$sql .="  $classement";
					
					//echo "sql=$sql<br>";
					
					//echo "sql=$sql et periode=$periode<br>";
					return pg_query($sql);
                    
}
/**
	Obtenir les formations d'un formateur 
	@param integer : numero formateur
	@param string : classement (asc ou desc)
	@param string : order by (libelle ou date debut)
	@param integer : periode (1 passes, 2 prsentes, 3 futures, 0 toutes)
*/
function get_formateur_formations($formateur,$classement,$orderby,$periode){
	if (VERSION_BASE > VERSION) {
		$sql="select * from contraintes.af_get_formateur_formations($formateur,'$classement','$orderby',$periode) as (id int4,libelle varchar,parcours int4,date_debut date,date_fin date,langue int4,formateur int4)";
		//echo"sql= $sql";
		$res=pg_query($sql);
	}
	else
		$res=get_formateur_formations_old($formateur,$classement,$orderby,$periode);
	return $res;
}

/**
	Obtenir les droits du formateur (OLD)
	@param integer : formation
	@param integer : classe
	@return integer : l'entier resultat de la requete
*/
function get_formateur_droits_old($formation,$classe){
	$sql="select distinct num_droit,libelle_droit, type_droit,defaut from DROIT
          where num_droit in (select gu_num_droit from GESTIONUTIL where gu_num_gest_gr=$classe)
          UNION
          select distinct libelle_droit, type_droit from DROIT where num_droit in
          (select distinct g_num_droit from GESTIONNAIRE where g_num_cal=$formation)";
	return pg_query($sql);
}
/**
	Obtenir les droits du formateur 
	@param integer : formation
	@param integer : classe
	@return integer : l'entier resultat de la requete
*/
function get_formateur_droits($formation,$classe){
	if (VERSION_BASE > VERSION) {
		//$sql="select * from contraintes.af_get_formation_droits($formation) as (id int4,libelle varchar)"; 
		$sql="select * from contraintes.af_get_formateur_droits($formation,$classe) as (id int4,libelle varchar)"; 
		//echo "sql=$sql<br>";
		$res=pg_query($sql);
	}
	else
		$res=get_formateur_droits_old($formation,$classe);
	return $res;
}

/**
	Obtenir les formations d'un formateur_utilisateur (old)
	@param integer : le numero de l'individu
	@param string : Classement croissant (ASC) ou dcroissant (DESC)
	@param string : order by 'date_debut' ou 'libelle'
	@param integer : 1 passes, 2 prsentes, 3 futures, 0 toutes
	@return integer : l'entier resultat de la requete
*/
function get_formateur_individu_formations_old($formateur,$ordre, $orderby,$periode){

}
/**
	Obtenir les formations d'un formateur_utilisateur 
	@param integer : le numero de l'individu
	@param string : Classement croissant (ASC) ou dcroissant (DESC)
	@param string : order by 'date_debut' ou 'libelle'
	@param integer : 1 passes, 2 prsentes, 3 futures, 0 toutes
	@return integer : l'entier resultat de la requete
*/
function get_formateur_individu_formations($formateur,$ordre='asc', $orderby='date_debut',$periode=0){
	if (VERSION_BASE > VERSION) {
		 $sql="select * from contraintes.af_get_formateur_individu_formations($formateur,'$classement','$orderby',$periode) as (id int4,libelle varchar,parcours int4,date_debut date,date_fin date,langue int4,formateur int4,type int4)";
		$res=pg_query($sql);
	}
	else
		$res=get_formateur_utilisateur_formations_old($formateur,$ordre, $orderby,$periode);
	return $res;			
}



?>