<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * D�finition d'un DoFormation.
 * Cette classe est d�riv�e de la classe DoElementEntity
 * Un DoFormation est l'objet de base servant � gerer l'avancement d'une Formation.
 * 
 * DESIGN PATTERN: Fa�ade
 * Une fa�ade est un objet qui h�rite forc�ment d'une classe m�re.
 * Elle ne contient aucun attribut.
 * La fa�ade appelle des m�thodes de la classe m�re et ne contient aucun traitement.
 * Ses m�thodes permettent en g�n�ral de "renomer" une m�thode de la classe m�re.
 * 
 * @package formation
 */
class DoFormation extends DoElementEntity{  
	
	/**
	 * Constructeur
	 * 
	 * Creation de l'objet et initialisation
	 * de ses attributs h�rit�s.
	 * @param integer $formation la formation de l'individu
	 * @param integer $individu l'individu qui effectue la formation
	 * @param object DoNodeFactory &$obj_DoNodeFactory Fabrique servant � la cr�ation des objets d'avancement de la Formation
	 */
	function DoFormation($formation, $individu,&$obj_DoNodeFactory){
		messageDebug("DoFormation::DoFormation($formation,$individu,&\$obj_DoNodeFactory)");
		parent::DoElementEntity($formation,$individu,$obj_DoNodeFactory);
		$this->initDoFormation();
	}
	
	/**
	 * Initialise les attributs propres a l'objet.
	 */
	function initDoFormation(){
		messageDebug("DoFormation::initDoFormation()");
		$this->entity=null;
		$this->current_node=null;
		$this->current_node_type=null;
	}

//-----------------------------------------------------
//			METHODES PUBLIQUES
//-----------------------------------------------------
	
	/**
	 * D�but de la formation.
	 * Initialise le parcours et l'�tape courante en fonction de l'avancement.
	 * D�bute l'�tape courante.
	 * @return integer identifiant r�sultat en base de donn�es
	 */
	function beginCurrentEtape(){
		messageDebug("DoFormation::beginCurrentEtape()");
		return parent::beginCurrentNode();
	}
	
	/**
	 * Construction de l'objet de l'�tape courante.
	 * @return object Etape  L'objet correspondant � l'�tape 
	 */
	function &performCurrentEtape(){
		messageDebug("DoFormation::performCurrentEtape()");
		return parent::performCurrentNode($this->obj_DoNodeFactory->obj_NodeFactory);
	}

	/**
	 * Termine l'�tape courante.
	 * @param object Resultat $obj_resultat : Resultat associ� � l'objet associ� � l'avancement.
	 * @return boolean TRUE ou FALSE suivant le succ�s ou non de la m�thode.
	 */
	function endCurrentEtape($obj_resultat=null){
		messageDebug("DoFormation::endCurrentEtape($obj_resultat)");
		return parent::endCurrentNode($obj_resultat);
	}	

	/**
	 * Indique si la formation est commenc�e ou non.
	 * @return boolean TRUE ou FALSE.
	 */
	function isBegin(){
		return parent::isBegin();
	}	
//-----------------------------------------------------
//			ACCESSEURS
//-----------------------------------------------------
	
	/**
	 * Obtenir la factory permettant de construire les objets d'avancement d'�tapes. 
	 * @return object DoEtapeFactory La fabrique d'Etapes de la Formation.
	 */
	function &getDoEtapeFactory(){
		return parent::getDoNodeFactory();
	}
	
	/**
	 * Obtenir l'identifiant de la formation.
	 * @return integer l'identifiant de formation.
	 */
	function getFormation(){
		return parent::getElement();
	}	
	
	/**
	 * Obtenir l'identifiant du parcours courrant.
	 * @return integer l'identifiant du parcours.
	 */
	function getParcours(){
		return parent::getEntity();
	}	
	
	/**
	 * Obtenir l'objet d'avancement de l'Etape en cours.
	 * @return object DoEtape l'objet d'avancement de l'Etape en cours.
	 */
	function &getCurrentDoEtape(){
		
		return parent::getDoNode();
	}
	
	function setCurrentDoEtape($obj_DoEtape){
		parent::setDoNode($obj_DoEtape);
	}
	
	/**
	 * Obtenir l'identifiant de l'individu.
	 * @return integer l'identifiant d'individu.
	 */
	function getIndividu(){
		return parent::getIndividu();
	}	
	
	/**
	 * Obtenir les Etapes du Parcours.
	 * @return integer le r�sultat de la requ�te (id int4, libelle_pour_parcours varchar, libelle_etape  varchar,libelle_type_etape  varchar, type varchar,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool,libelle_type_original varchar, modifiable bool)
	 */
	function getEtapes(){
		messageDebug("DoFormation::getEtapes()");
		//return get_formation_etapes($this->getFormation());
		return get_formation_etapes_individu($this->getFormation(),$this->getIndividu());
	}
	
	/**
	 * Obtenir les Etapes relles de la formation (les etapes  faire rellement)
	 * @return integer le r�sultat de la requ�te (id int4, libelle_pour_parcours varchar, libelle_etape  varchar,libelle_type_etape  varchar, type varchar,  pere int4, parcours int4, obligatoire bool, chrono int4, fin bool,libelle_type_original varchar, modifiable bool)
	 */
	function getEtapesReelles(){
		messageDebug("DoFormation::getEtapes()");
		//return get_formation_etapes($this->getFormation());
		return get_formation_etapes_reelles_individu($this->getFormation(),$this->getIndividu());
	}
}
?>
