<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
Fichier de dfinition de la Class Formation

@package formation
*/
class Formation{

        /**
        * @var integer  Identifiant en base de donnes
        */
        var $id ;
        
        /**
        * @var string  Libell de la Formation
        */
        var $libelle ;
        
        /**
        * @var string  Date de dbut de la formation (au format SQL)
        */
        var $debut ;
        
        /**
        * @var string  Date de fin de la formation (au format SQL)
        */
        var $fin ;

        /**
        * @var integer  Langue par defaut
        */        
        var $langue;
        
        /**
        * @var integer Identifiant du parcours principal de la formation
        */
        var $parcours ;
        
        /**
        * @var object Parcours Parcours principal de la formation
        */
        var $obj_parcours ;

        /**
        * Constructeur de la classe Formation
        * @param integer $formation Identifiant de la formation
        * @
        */
        function Formation($formation){
        		$res=get_formation($formation);
        		$row=pg_fetch_row($res,0);
        		$this->id=$row[0];
        		$this->libelle=$row[1];
        		$this->debut=$row[3];
        		$this->fin=$row[4];
        		$this->langue=$row[5];
        		$this->parcours=$row[2];
        		
        }
        
        /**
         * Fonction qui retourne l'id d'une formation
         * @return integer Identifiant d'une Formation en base de donnes
         */
        function getId(){
			return $this->id;
		}
		
		/**
		 * Fonction qui retourne la Date de Debut de la Formation
		 * @return string Date de dbut de la formation (au format SQL)
		 */
		function getDebut(){
			return $this->debut;
		}
		
		/**
		 * Fonction qui retourne la Date de Fin de la Formation
		 * @return string Date de fin de la formation (au format SQL)
		 */
		function getFin(){
			return $this->fin;
		}
		
		/**
		 * Fonction qui retourne la Langue de la Formation
		 *@return integer Langue par defaut
		 */
		function getLangue(){
			return $this->langue;
		}
		
		/**
		 * Fonction qui retourne, en le construisant si besoin, l'objet du Parcours de la Formation
		 * @return object Parcours  Parcours de la Formation
		 */
		 //TODO AJOUTE POUR LES STATS, FAIRE DE MEME AVEC LES AUTRES OBJETS DE STATS A ADAPTER
		function getObjParcours(){
			if(!is_object($this->obj_parcours)){
				$this->obj_parcours= new Parcours($this->parcours);
			}
			return $this->obj_parcours;
		}
		
		/**
		 * Obtenir l'identifiant du Parcours principal de la Formation
		 * @return integer L'identifiant du parcours
		 */
		function getParcours(){
			return $this->parcours;
		}
		
		/**
		 * Fonction qui retourne le libell de la Formation 
		 * @return string Libell de la Formation
		 */
		function getLibelle(){
	       	return $this->libelle;
	    }
	    
	    /**
	     * Fonction qui retourne l'id de l'individus d'une Formation
	     * @param string $ordre ASC ou DESC ordre Ascendant ou Descendant
	     * @return integer Identifiant de l'Individus d'une Formation
	     */    
	    function getStagiaires($ordre="ASC"){
	        return get_formation_individus($this->id,$ordre);
	    }
	    
	    /**
	     * Fonction qui retourne les classes d'une Formation
	     * @return integer 
	     */
	    function getClasses(){
	    	return get_formation_classes($this->id);
	    }
	    
	    /**
	     * Function qui retourne l'identifiant du formateur d'une Formation
	     * @return integer Identifiant d'un Formateur d'une Formation
	     */
	    function getFormateur(){
	    	return get_formation_formateur($this->id);
	    }
	    
	    
	    
        
        
        
//        	/**
//	* Fonction qui retourne une chane de caractre contenant des informations sur l'objet
//	*
//	* Fonction qui retourne une chane de caractre contenant des informations sur l'objet.
//	* Si on ne passe aucun paramtre, la chane retourne contient le libelle. Par contre, si le paramtre est dfini,
//	* il est utilis comme format de retour. Cet fonction peut servir d'accesseur sur les attributs de la classe.
//	* (Attention cela retourne un affichage seulement... toString("P") ne retourne pas l'objet pre !)
//	*
//	* @param string : le paramtre determine ce qu'on retourne. Les informations disponibles sont :
//	*       [libelle],[id],[pere] retourne le libelle du pre...
//	*
//	* @return string : On retourne la chane de caractres cre  partir du format
//	*/
//	function toString($format = "") {
//		global $MSG_1594,$MSG_1595;	
//	
//		// Aucun paramtre, on retourne le libelle
//		if ($format == "")
//			return $this->libelle;
//
//		// Si aucun pre, donner "Aucune filire de niveau superieur" ?
//
//		// Ce tableau contient tous les pattern et les nouvelles valeurs
//		//echo"langue=$this->langue";
//		$libelle_langue=pg_fetch_result(get_langue($this->langue),0,1);
//		//echo "libelle_langue=$libelle_langue<br>";
//		eval("\$libelle_langue=\"$libelle_langue\";");
//		//echo "libelle_langue=$libelle_langue<br>";
//		$tab_replace = array (
//			"\[id\]"=>$this->id,
//			"\[debut\]" => $this->debut,
//			"\[fin\]" => $this->fin,
//			"\[formateur\]" => pg_fetch_result(get_formation_formateur($this->id),0,1),
//			"\[classe\]" => pg_fetch_result(get_formation_classes($this->id),0,1),
//			"\[langue\]"=> $libelle_langue,
//			"\[parcours\]" => pg_fetch_result(get_parcours($this->parcours),0,1)
//		);
//
//		while ($tab = each($tab_replace)) {
//			$format = ereg_replace($tab[0], "$tab[1]", $format);
//		}
//		return $format;
//	}
	
	
	
	
        
}
?>