<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/
 
/**
	Fichier de fonction php pour formation
	@package formation
	@modulegroup fonctions
*/   
/**
	Sockage des langues disponibles de la formation dans un tableau
	@param integer : formation
	@return array : tableau des langues
*/
function  in_array_formation_langues($formation){
	 $tab_lang=array();
	// recup des langues dispo de la formation
	$res=get_formation_langues($formation);
	
	
		 $nb=pg_num_rows($res);
		for($i=0;$i<$nb;$i++){
			$rowlang=pg_fetch_row($res,$i);
			if (VERSION_BASE > VERSION) 
				$tab_lang[]=$rowlang[0];
			else
				$tab_lang[]=$rowlang[2];
			
		}
	
	return $tab_lang;
}

/**
	Mise � jour des langues dispo de la formation
	@param integer : formation
	@param string : libelle
	@param date : debut formation
	@param date : fin formation
	@param interger / string : langue defaut
	@param array : langues dispo pour la formation
	@param array : anciennes langues dispo de la formation
*/
function modification_formation_langues($formation,$libelle,$debut,$fin,$lang_def,$langdispo,$old_langdispo){
	//echo "coucou<br>";
	//if($lang_def!=$old_lang_def)
		 if (VERSION_BASE > VERSION) 
			maj_formation($formation,$libelle,$debut,$fin,$lang_def);
		 else{
			// prepare la chaine langues
			for($i=0;$i<count($langdispo);$i++)
				$langues .=$langdispo[$i].';';
			$langues=str_replace($lang_def.';',"",$langues);
			$langues=$lang_def.';'.$langues;
			$langues=substr($langues,0,-1);
			//echo "langues=$langues<br>";
			maj_formation ($formation,$libelle,$debut,$fin,$langues);
				
		 }
		 
		 // mise � jour des langues disponibles
		 if (VERSION_BASE > VERSION){
			 $langue_insert=array();
			$langue_delete=array();
			// si pas de langues dispo
			if(!isset($langdispo))
				$langdispo=array();
			if(!isset($old_langdispo))
				$old_langdispo=array();
			 
			// les langues � inserer
			$langue_insert=array_diff($langdispo,$old_langdispo);
			//print_r($langue_insert);
			// les langues � supprimer
			$langue_delete=array_diff($old_langdispo,$langdispo);
			//print_r($langue_delete);
			maj_formation_langues($formation,$langue_insert,$langue_delete);
		 } 
}

/**
	Stockage des exotlc mail et plateforme dans des tableaux
	@param integer : formation
	@param array : tableau exotlc mail (passage par reference)
	@param array :  tableau exotlc plateforme (passage par reference)
*/
function in_arrays_formation_exotlcs($formation,&$tabmail,&$tabpf){
	if (VERSION_BASE > VERSION){
		$res=get_formation_etapes_type($formation,'5');
		$nb=pg_num_rows($res);
		//echo "bv=$nb<br>";
		for($i=0;$i<$nb;$i++){
			
			$row=pg_fetch_row($res,$i);
			$tabexos[]=array($row[0],$row[6]);
		}
	
	}
	else{
		// recup parcours de la formation
		$resformation=get_formation($formation);
		$rowformation=pg_fetch_row($resformation,0);
		$parcours=$rowformation[2];
		//stockage de toutes les �tapes dans un tableau
		// appel de la fonction qui retourne un tableau de parcours
        $stock_parcours=array();
        //$rowparc=pg_fetch_row($resparc,0); // parcours principal

        $stock_parcours[]=$parcours;

        stockage_tous_parcours($parcours,$stock_parcours);
        $nbparc=sizeof($stock_parcours);

        $stock_etape=array();
         //Pour tous les parcours
        for($p=0;$p<$nbparc;$p++){
			//$rowparc=pg_fetch_row($resparc,$p);
			$rowparc=$stock_parcours[$p];
			//recup du parcours principal
			//debug
			//echo "parc=$rowparc<br>";
			stockage($stock_etape,$rowparc);//stockage des �tapes du parcours + parcours attach�s ...
        }
        $nbetape=sizeof($stock_etape);

        for($i=0;$i<$nbetape;$i++){
            if($stock_etape[$i][3]=="E")$tabexos[]=$stock_etape[$i][5];
        }

	}
	// tri des exos
	$nbex=count($tabexos);
	
	for($i=0;$i<$nbex;$i++){
		
		$type=get_exotlc_type($tabexos[$i][0]);
		if($type==1 || $type=='pf')
			$tabpf[]=array($tabexos[$i][0],$tabexos[$i][1]);
		else
			$tabmail[]=array($tabexos[$i][0],$tabexos[$i][1]);
	} 
}


                    
/**
 * Obtenir les langues disponibles pour une formation.
 * Retourne un tableau contenant les chemins vers les langues disponibles.
 * @param integer $formation Identifiant de la formation
 * @return array() un tableau contenant les chemins vers les langues disponibles [0]contient le code de la langue,[1] son lib�ll� et [2] le code.
 */
function get_formation_langues_disponibles($formation) {

	if (VERSION_BASE > VERSION) {
		$lang_dispo = array ();

		$res_formation_langues=get_formation_langues($formation);
//		$formation_langue=pg_fetch_result(get_formation($formation),0,5);
		
		$nb_langues = pg_num_rows($res_formation_langues);

		for ($i = 0; $i < $nb_langues; $i++) {
			$row = pg_fetch_row($res_formation_langues, $i);
			//site heberg�?
			/*
			if ($site_heberge == 1) {
				//langue autoris�e?
				//eval ("$exp=($row[2]==1);");
				//if ($exp) {
					$lang_dispo[] = $row[1];
				//}
			} else {
			*/
				$lang_dispo[$i][0] = $row[0];
				$lang_dispo[$i][1] = $row[1];
				$lang_dispo[$i][2] = $row[2];
			//}
		}
		return $lang_dispo;
	} else {
		return get_plateforme_langues_disponibles_old();
	}
}

/**
 * Test si association entre formation et fichier ressource
 * @param integer formation
 * @param integer fichier ressource
 * @return bool true si association sinon false
 * 
 */
 function existe_formation_fichier_ressource($formation,$fichier){
 	// recup des ressources de la formation
 	$res=get_formation_ressources($formation);
 	$nb=pg_num_rows($res);
 	//echo "fichier=$fichier<br>";
 	for($i=0;$i<$nb;$i++){
 		$row=pg_fetch_row($res,$i);
 		//print_rr($row);
 		if($row[0]==$fichier)
 			return true;
 	}
 	return false;
 }

 /**
 * Savoir si une formation est supprimable
 * 
 * @param integer $formation numero de la formation
 * @return bool : true si la filiere est utilis�e par un Parcours, false sinon.
 */
function is_formation_supprimable($formation) {
	
	return !sql2Bool(fk_finder('formation', 'id', $formation));
}

 /**
 * Savoir si une formation est supprimable
 * 
 * @param integer $formation numero de la formation
 * @return bool : true si la filiere est utilis�e par un Parcours, false sinon.
 */
function is_formation_resultats($formation) {
	
	return sql2Bool(fk_finder('resultat', 'formation', $formation));
}
?>