<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
         @package formation
         @modulegroup plpgsql
*/

/**
*   verification droit d'access
*
*   Verifie que l'utilisateur a bien le droit sur le calendrier
*
*
*    @param integer : le droit que l'on veut vrifier
*    @param integer : le numero du calendrier concern
*    @param  integer : l'utilisateur concern
*
*    @return integer : 0 si l'utilisateur n'a pas le droit,  1 s'il l'a
*/
function check_access_old($droit, $cal, $user) {

	$req = "select count(*) from DROIT
		        where libelle_droit ='$droit' and num_droit in
		        (select distinct g_num_droit from GESTIONNAIRE
		        where g_num_cal =$cal
		        and g_num_user =$user) ";
	$test_droit = pg_query($req);

	$droit_acces = pg_fetch_row($test_droit, 0); //on test si l'utilisateur a le droit  de voir la classe

	//retourne 0 (false) ou 1 (true)
	return $droit_acces[0];
}

/**
 *   verification droit d'access
 *
 *   Verifie que l'utilisateur a bien le droit sur le calendrier
 *
 *
 *    @param integer : le droit que l'on veut vrifier
 *    @param integer : le numero du calendrier concern
 *    @param  integer : l'utilisateur concern
 *
 *    @return bool : 't' si l'utilisateur n'a pas le droit,  'f' s'il l'a
 */
function check_access($droit, $cal, $user) {

	if (VERSION_BASE > VERSION) {
		$req = "SELECT _af_check_access ('$droit', $cal, $user)";
		$test_droit = pg_query($req);
		$droit_acces = pg_fetch_row($test_droit, 0); //on test si l'utilisateur a le droit  de voir la classe
		return $droit_acces[0];
	} else
		return check_access_old($droit, $cal, $user);
	//retourne 0 (false) ou 1 (true)

}
///**
//*   verification droit d'access
//*
//*   Verifie que l'utilisateur a bien le droit sur le calendrier
//*
//*
//*    @param integer : le droit que l'on veut vrifier
//*    @param integer : le numero du calendrier concern
//*    @param  integer : l'utilisateur concern
//*
//*    @return integer : 0 si l'utilisateur n'a pas le droit,  1 s'il l'a
//*/
//function check_access_old($droit, $cal, $user) {
//
//	$req = "select count(*) from DROIT
//	        where libelle_droit ='$droit' and num_droit in
//	        (select distinct g_num_droit from GESTIONNAIRE
//	        where g_num_cal =$cal
//	        and g_num_user =$user) ";
//	$test_droit = pg_query($req);
//
//	$droit_acces = pg_fetch_row($test_droit, 0); //on test si l'utilisateur a le droit  de voir la classe
//
//	//retourne 0 (false) ou 1 (true)
//	return $droit_acces[0];
//}
//
///**
//*   verification droit d'access
//*
//*   Verifie que l'utilisateur a bien le droit sur le calendrier
//*
//*
//*    @param integer : le droit que l'on veut vrifier
//*    @param integer : le numero du calendrier concern
//*    @param  integer : l'utilisateur concern
//*
//*    @return integer : 0 si l'utilisateur n'a pas le droit,  1 s'il l'a
//*/
//function check_access($droit, $cal, $user) {
//
//	if (VERSION_BASE > VERSION) {
//		$req = "SELECT _af_check_access ('$droit', $cal, $user)";
//		$test_droit = pg_query($req);
//		$droit_acces = pg_fetch_row($test_droit, 0); //on test si l'utilisateur a le droit  de voir la classe
//		return $droit_acces[0];
//	} else
//		return check_access_old($droit, $cal, $user);
//	//retourne 0 (false) ou 1 (true)
//
//}

/**
*   obtenir le nom d'un calendrier
*
*   Retourne le nom du calendrier dont le numero est pass en parametre.
*
*    @param  integer : le numero du calendrier
*
*    @return  string : le nom du calendrier
*/
function get_nom_calendrier($calendrier) {
	if (empty($calendrier)) {
		print ("Vous devez specifier un numero de calendrier.");
		exit();
	}
	$req = "SELECT  _af_get_nom_calendrier($calendrier)";
	$result_nom_calendrier = pg_query($req);
	$nb = pg_fetch_row($result_nom_calendrier, 0);

	return $nb[0];
}

/**
*   obtenir le numero du groupe d'un calendrier
*
*   Retourne le numero du groupe dont le numero du calendrier est pass en parametre.
*
*    @param  integer :  le numero du calendrier
*
*    @return  string : le numero du groupe
*/
function get_numero_groupe($calendrier) {

	$req = "SELECT _af_get_numero_groupe($calendrier)";
	$result_numero_groupe = pg_query($req);
	$nb = pg_fetch_row($result_numero_groupe, 0);

	return $nb[0];
}

/**
*   Obtenir le nombre de sries de la formation (OLD)
*
*   Retourne le nombre de sries de la formation
*
*    @param  integer numro de formation
*
*    @return integer : nombre de series
*/
function get_nb_series_old($form) {
	$req = "select count(*)
	            from gestparcours
	            where g_num_parcours in (select distinct g_num_parcours
	            from gestionnaire
	            where g_num_cal='$form')
	            and type_etape='B' or type_etape='C'";

	return (pg_query($req));
}

/**
*   Obtenir le nombre de sries de la formation
*
*   Retourne le nombre de sries de la formation
*
*    @param  integer numro de formation
*
*    @return integer : nombre de series
*/
function get_nb_series($form) {
	if (VERSION_BASE > VERSION) {
		$req = "select _af_get_nb_series($form)";
		$res = pg_query($req);
	} else
		$res = get_nb_series_old($form);
	$nb = pg_fetch_row($res, 0);
	return $nb[0];
}

/**
*   Obtenir le nombre d'exercices  tlcharger de la formation (OLD)
*
*   Retourne le nombre d'exercices  tlcharger de la formation
*
*    @param  integer : numro de formation
*
*     @return integer : nombre d'exercices  tlcharger
*/
function get_nb_exos_old($form) {
	$req = "select count(*)
	                                    from gestparcours
	                                    where g_num_parcours in (select distinct g_num_parcours
	                                                                        from gestionnaire
	                                                                        where g_num_cal='$form')
	
	                                    and type_etape='E'";
	return (pg_query($req));
}

/**
*   Obtenir le nombre d'exercices  tlcharger de la formation
*
*   Retourne le nombre d'exercices  tlcharger de la formation
*
*    @param  integer : numro de formation
*
*    @return integer : nombre d'exercices  tlcharger
*/
function get_nb_exos($form) {
	if (VERSION_BASE > VERSION) {
		$req = "select _af_get_nb_exos($form)";
		$res = pg_query($req);
	} else
		$res = get_nb_exos_old($form);
	$nb = pg_fetch_row($res, 0);
	return $nb[0];
}

// -- - -- -- - -- -- - -- -- - -- -- - -- -- - -- -- - -- -- - -- -- - -- -- - -- -- - -- -- - -- GET_STAGIAIRES_FORMATION
/**
* Obtenir les numeros d'individus lies a une formation   (OLD)
*
* Cette fonction donne la liste de tous les individus des groupes d'une formation
* (pas le formateur s'il n'est pas dans le groupe).
* 
*	Resultat:
*	num_user | nomprenom | categorie
* 
* @param  integer : numero de formation
* @param  integer : categorie des individus : 0=tous, 1=formateur & 2=stagiaire
* @param  integer : si exclusif =1 alors on ne garde que les strictement "f" ou strictement "u"
* @param  string : "ASC" ou "DESC"
* @return integer : Resultat de la requete : num_user, nom, prenom
*/
/*
function get_formation_individus_old($form, $categorie = 0, $exclusif = 0, $classement = "ASC") {
	$req = "SELECT DISTINCT num_user, textcat(textcat(U.nom,text ' '), prenom) AS nomprenom , categorie, lower(U.nom) AS lownom
	        FROM  utilisateurs U, gestionnaire, classe C, gestionutil
	        WHERE g_num_cal='$form'
	        AND gu_num_gest_gr=g_num_gest_g
	        AND num_user=gu_num_user ";

	// On veut les formations
	if ($categorie == 1) {
		// Les formateurs seulement
		if ($exclusif)
			$req.= "AND categorie = 'f' ";
		else
			$req.= "AND categorie LIKE '%f%' ";
	} else {
		// On veut les stagiaires
		if ($categorie == 2) {
			// Les stagiaires seulement
			if ($exclusif)
				$req.= "AND categorie = 'u' ";
			else
				$req.= "AND categorie LIKE '%u%' ";
		}
	}

	$req.= " ORDER BY lownom $classement";

	// echo "Requete : <i>$req</i><br>" ;
	return (pg_query($req));
}
*/
/**
* Obtenir les numeros d'individus lies a une formation   (OLD)
*
* Cette fonction donne la liste de tous les individus des groupes d'une formation
* (pas le formateur s'il n'est pas dans le groupe).
* 
*	Resultat:
*	num_user | nomprenom | categorie
* 
* @param  integer : numero de formation
* @param  integer : categorie des individus : 0=tous, 1=formateur & 2=stagiaire
* @param  integer : si exclusif =1 alors on ne garde que les strictement "f" ou strictement "u"
* @param  string : "ASC" ou "DESC"
* @return integer : Resultat de la requete : num_user, nom, prenom
*/
/*
function get_formation_individus($form, $categorie = 0, $exclusif = 0, $classement = "ASC") {
	if (VERSION_BASE > VERSION) {

	} else
		$res = get_formation_individus_old($form, $categorie, $exclusif, $classement);

	return $res;
}
*/
/**
* Obtenir les numros d'individus lis  une formation   (OLD)
*
* Cette fonction donne la liste de tous les individus des groupes d'une formation
* (pas le formateur s'il n'est pas dans le groupe).
* On donne l'identifiant mais aussi quelques coordonnes.
* Pour le moment, on ne retourne que le nom et le prnom. Ajouter quelques informations (login, password, photo...) ?
* @param  integer : numro de formation
* @param  integer : categorie des individus : 0=tous, 1=formateur & 2=stagiaire
* @param  integer : si exclusif =1 alors on ne garde que les strictement "f" ou strictement "u"
* @param  string : "ASC" ou "DESC"
* @return integer : Rsultat de la requte : num_user, nom, prenom
*/
function get_individus_formation_old($form, $categorie = 0, $exclusif = 0, $classement = "ASC") {
	$req = "SELECT DISTINCT num_user, nom, prenom, categorie
	        FROM gestionparcours, utilisateurs, gestionnaire
	        WHERE num_cal='$form'
	        AND num_cal=g_num_cal
	        AND  num_user<>g_num_user
	        AND num_user=gp_num_user ";

	// On veut les formations
	if ($categorie == 1) {
		// Les formateurs seulement
		if ($exclusif)
			$req.= "AND categorie = 'f' ";
		else
			$req.= "AND categorie LIKE '%f%' ";
	} else {
		// On veut les stagiaires
		if ($categorie == 2) {
			// Les stagiaires seulement
			if ($exclusif)
				$req.= "AND categorie = 'u' ";
			else
				$req.= "AND categorie LIKE '%u%' ";
		}
	}

	$req.= " ORDER BY nom $classement";

	// echo "Requete : <i>$req</i><br>" ;
	return (pg_query($req));
}

/**
* Obtenir les numros de stagiaires lis  une formation
*
* Cette fonction donne la liste de tous les individus des groupes d'une formation
* (pas le formateur s'il n'est pas dans le groupe).
* On donne l'identifiant mais aussi quelques coordonnes.
* Pour le moment, on ne retourne que le nom et le prnom. Ajouter quelques informations (login, password, photo...) ?
* @param  integer : numro de formation
* @param  integer : categorie des individus : 0=tous, 1=formateur & 2=stagiaire
* @param  integer : si exclusif =1 alors on ne garde que les strictement "f" ou strictement "u"
* @param  string : "ASC" ou "DESC"
* @return integer : Rsultat de la requte : num_user, nom, prenom
*/
function get_individus_formation($form, $categorie = 0, $exclusif = 0, $classement = "ASC") {
	if (VERSION_BASE > VERSION) {
		$req = "select * from _af_get_individus_formation($form, $categorie,$exclusif,'$classement') AS (num_user integer, nom varchar, prenom varchar, categorie varchar)";
		$res = pg_query($req);
	} else
		$res = get_individus_formation_old($form, $categorie, $exclusif, $classement);

	return $res;
}

// -- - -- - -- - -- - -- - -- - -- - -- - -- - -- - -- - -- - -- - -- - -- - -- - -- - -- - -- - -- - -- - GET_STAGIAIRE_EVALUATION_FINIE_FORMATION
/**
* Obtenir le nombre de stagiaires ayant commenc des valuations d'une formation  (OLD)
* De la mme faon que la fonction get_stagiaires_formation, on donne l'identifiant et le nom et le prnom.
* @param integer : numro de formation
* @return : Rsultat de requte = num_user, nom, prenom
*/
function get_stagiaires_evaluation_finie_formation_old($form) {
	$req = "SELECT DISTINCT id_stag, nom, prenom
	                        FROM res_serie, utilisateurs
	                        WHERE id_formation='$form'
	                        AND id_stag=num_user
	                        UNION
	                        SELECT DISTINCT R.num_user, nom, prenom
	                        FROM resexouser R, utilisateurs U
	                        WHERE num_cal='$form'
	                        AND R.num_cal=U.num_user";
	return (pg_query($req));
}

/**
* Obtenir le nombre de stagiaires ayant commenc des valuations d'une formation
* De la mme faon que la fonction get_stagiaires_formation, on donne l'identifiant et le nom et le prnom.
* @param integer : numro de formation
* @return : Rsultat de requte = num_user, nom, prenom
*/
function get_stagiaires_evaluation_finie_formation($form) {
	if (VERSION_BASE > VERSION) {
		$req = "select * FROM _af_get_stagiaires_evaluation_finie_formation($form) AS (num_user integer, nom varchar, prenom varchar)";
		$res = pg_query($req);
	} else
		$res = get_stagiaires_evaluation_finie_formation_old($form);

	return $res;
}

// -- -- - --- -- -- - --- -- -- - --- -- -- - --- -- -- - --- -- -- - --- -- -- - --- -- -- - --- -- -- - --- -- -- - --- -- -- - --- GET_INFOS_FORMATION
///**
//* Fonction qui donne les informations utiles d'une formation (nom, dates, langues, formateur, groupe, filiere, etc.) OLD
//* Cette fonction est a utiliser dans le constructeur de la classe Formation. Il faut construire les objets Formateur, Groupe et Filiere
//* a partir des numero recuperer.
//* @param integer : numero de formation dans la table calendrier
//* @return integer : resultat de requete : {num_formation, nom_formation, debut, fin, langues, num_formateur, num_groupe, num_filiere}
//*/
//function get_formation_infos_old($id_form) {
//	return pg_query("SELECT DISTINCT num_cal AS num_formation, nom_cal AS nom_formation, d1.jour AS debut, d2.jour AS fin, langue AS langues,
//	                                g_num_user AS num_formateur, g_num_gest_g AS num_groupe, g_num_gest_c AS num_filiere,g_num_parcours as num_parcours
//	                                FROM calendrier, gestionnaire, dates d1, dates d2
//	                                WHERE num_cal=g_num_cal
//	                                AND num_cal=$id_form
//	                                AND datedeb=d1.num_date AND datefin=d2.num_date;");
//}
//
///**
//* Fonction qui donne les informations utiles d'une formation (nom, dates, langues, formateur, groupe, filiere, etc.) OLD
//* Cette fonction est a utiliser dans le constructeur de la classe Formation. Il faut construire les objets Formateur, Groupe et Filiere
//* a partir des numero recuperer.
//* @param integer : numero de formation dans la table calendrier
//* @return integer : resultat de requete : {num_formation, nom_formation, debut, fin, langues, num_formateur, num_groupe, num_filiere}
//*/
//function get_formation_infos($id_form) {
//	if (VERSION_BASE > VERSION) {
//		$req = "select * FROM _af_get_infos_formation($id_form)
//		                        AS (num_formation integer, nom_formation varchar, debut date, fin date, langues varchar, num_formateur integer, num_groupe integer, num_filiere integer,num_parcours integer)";
//		$res = pg_query($req);
//	} else
//		$res = get_formation_infos_old($id_form);
//
//	return $res;
//}
/**
* Fonction qui donne les informations utiles d'une formation (nom, dates, langues, formateur, groupe, filiere, etc.) OLD
* Cette fonction est a utiliser dans le constructeur de la classe Formation. Il faut construire les objets Formateur, Groupe et Filiere
* a partir des numero recuperer.
*	@deprecated utiliser get_formation_infos($id_form)
* @param integer : numero de formation dans la table calendrier
* @return integer : resultat de requete : {num_formation, nom_formation, debut, fin, langues, num_formateur, num_groupe, num_filiere}
*/
function get_infos_formation_old($id_form) {
	return pg_query("SELECT DISTINCT num_cal AS num_formation, nom_cal AS nom_formation, d1.jour AS debut, d2.jour AS fin, langue AS langues,
	                                g_num_user AS num_formateur, g_num_gest_g AS num_groupe, g_num_gest_c AS num_filiere,g_num_parcours as num_parcours
	                                FROM calendrier, gestionnaire, dates d1, dates d2
	                                WHERE num_cal=g_num_cal
	                                AND num_cal=$id_form
	                                AND datedeb=d1.num_date AND datefin=d2.num_date;");
}

/**
* Fonction qui donne les informations utiles d'une formation (nom, dates, langues, formateur, groupe, filiere, etc.) OLD
* Cette fonction est a utiliser dans le constructeur de la classe Formation. Il faut construire les objets Formateur, Groupe et Filiere
* a partir des numero recuperer.
*	@deprecated utiliser get_formation_infos($id_form)
* @param integer : numero de formation dans la table calendrier
* @return integer : resultat de requete : {num_formation, nom_formation, debut, fin, langues, num_formateur, num_groupe, num_filiere}
*/
function get_infos_formation($id_form) {
	if (VERSION_BASE > VERSION) {
		$req = "select * FROM _af_get_infos_formation($id_form)
		                        AS (num_formation integer, nom_formation varchar, debut date, fin date, langues varchar, num_formateur integer, num_groupe integer, num_filiere integer,num_parcours integer)";
		$res = pg_query($req);
	} else
		$res = get_infos_formation_old($id_form);

	return $res;
}
// -- -- - --- -- -- - --- -- -- - --- -- -- - --- -- -- - --- -- -- - --- -- -- - --- -- -- - --- -- -- - --- -- -- - --- -- -- - --- GET_INFOS_FORMATION

/**
*  Renvoie les parcours d'une formation(OLD).
*
*  Renvoie les numeros des parcours d'une formation.
*
*	@deprecated : utiliser get_formation_parcours_principal($formation)
* @param integer : numro de formation
* @return integer : num_parcours}
*/
function get_parcours_formation_old($formation) {
	$req = ("select distinct g_num_parcours from gestionnaire where g_num_cal=$formation;");
	$res = pg_query($req);
	return pg_fetch_result($res, 0, 0);
}

/**
*  Renvoie les parcours d'une formation.
*
*  Renvoie les numeros des parcours d'une formation.
*
* @param integer : numro de formation
* @return integer : rsultat de requete : {num_parcours}
*/
function get_parcours_formation($formation) {
	if (VERSION_BASE > VERSION) {
		$req = "select * FROM _af_get_parcours_formation($formation);";
		$res = pg_query($req);
		$res = pg_fetch_result($res, 0, 0);
	} else
		$res = get_parcours_formation_old($formation);

	return $res;
}

/**
*  Renvoie le numero de parcours d'une formation(OLD).
*
* @param integer : numro de formation
* @return integer : numero du parcours
*/
function get_formation_parcours_principale_old($formation) {
	$req = ("select distinct g_num_parcours from gestionnaire where g_num_cal=$formation;");
	$res = pg_query($req);
	return pg_fetch_result($res, 0, 0);
}

/**
*  Renvoie les parcours d'une formation.
*
*  Renvoie les numeros des parcours d'une formation.
*
* @param integer : numro de formation
* @return integer : rsultat de requete : {num_parcours}
*/
function get_formation_parcours_principale($formation) {
	if (VERSION_BASE > VERSION) {
		$req = "select * FROM _af_get_parcours_formation($formation);";
		$res = pg_query($req);
		$res = pg_fetch_result($res, 0, 0);
	} else
		$res = get_formation_parcours_principale_old($formation);

	return $res;
}

/**
*  Obtenir l'avancement d'un stagiaire (OLD)
*
*  Renvoie l'avancement du stagiaire
*
* @param integer : numro de formation
* @return integer : tous les champs de l'avancement
*/
function get_avancement_stagiaires_formation_old($formation) {
	$req = ("select distinct gp_num_user,avancement, etape_libre
	                    from gestionparcours
	                    where  num_cal=$formation");

	return pg_query($req);
}

/**
*  Obtenir l'avancement d'un stagiaire
*
*  Renvoie l'avancement du stagiaire
*
* @param integer : numro de formation
* @return integer : tous les champs de l'avancement
*/
function get_avancement_stagiaires_formation($formation) {
	if (VERSION_BASE > VERSION) {
		$req = "select * FROM _af_get_avancement_stagiaires_formation($formation) AS ( num_stagiaire integer, avancement integer , etape_libre varchar);";
		$res = pg_query($req);
	} else
		$res = get_avancement_stagiaires_formation_old($formation);

	return $res;
}

/**
*  Obtenir les rsultats des sries d'une formation (OLD)
*
*  Renvoie les rsulats des sries d'une formation
*
* @param integer : numro de formation
* @return integer : tous les champs de la table res_serie
*/
function get_resultats_series_formation_old($formation) {
	$req = "select * from res_serie where id_formation='$formation'";

	return pg_query($req);
}

/**
*  Obtenir les rsultats des sries d'une formation
*
*  Renvoie les rsulats des sries d'une formation
*
* @param integer : numro de formation
* @return integer : tous les champs de la table res_serie
*/
function get_resultats_series_formation($formation) {
	if (VERSION_BASE > VERSION) {
		$req = "select * FROM _af_get_resultats_series_formation($formation) AS (id_stag smallint,id_formation smallint,id_serie smallint,score real,date_fin integer);";
		$res = pg_query($req);
	} else
		$res = get_resultats_series_formation_old($formation);

	return $res;
}

/**
*  Obtenir les rsultats des exercices  tlcharger d'une formation (OLD)
*
*  Renvoie les rsulats des exercices  tlcharger d'une formation
*
* @param integer : numro de formation
* @return integer : tous les champs de la table resexouser
*/
function get_resultats_exos_formation_old($formation) {

	$req = "select *
	             from resexouser
	            where num_cal='$formation'
	            and num_cal>0
	            and surtotal<>0";
	return pg_query($req);
}

/**
*  Obtenir les rsultats des exercices  tlcharger d'une formation
*
*  Renvoie les rsulats des exercices  tlcharger d'une formation
*
* @param integer : numro de formation
* @return integer : tous les champs de la table resexouser
*/
function get_resultats_exos_formation($formation) {
	if (VERSION_BASE > VERSION) {
		$req = "select * FROM _af_get_resultats_exos_formation($formation) AS (num_resexouser integer,num_user integer,num_exo integer,commentaire character varying(256),surtotal integer,score integer,date_correction integer,num_cal integer);";
		$res = pg_query($req);
	} else
		$res = get_resultats_exos_formation_old($formation);

	return $res;
}

/**
* Obtenir les infos rsultats des sries effectues. (OLD)
*
* Fonction qui rcupre les infos rsultats des sries effectues par la
* formation passe en paramtre
*
* @param integer : numro de formation
* @return integer : les infos rsultats des sries
*/
function get_infos_series_formation_old($formation) {

	$req = "select * from res_serie where id_formation='$formation' and score>=0 and date_fin>0";
	$res = pg_query($req);

	return $res;
}

/**
* Obtenir les infos rsultats des sries effectues.
*
* Fonction qui rcupre les infos rsultats des sries effectues par la
* formation passe en paramtre
*
* @param integer : numro de formation
* @return integer : les infos rsultats des sries
*/
function get_infos_series_formation($formation) {
	if (VERSION_BASE > VERSION) {
		$req = "select * FROM _af_get_infos_series_formation($formation) AS (id_stag smallint, id_formation smallint, id_serie smallint, score real, date_fin integer);";
		$res = pg_query($req);
	} else
		$res = get_infos_series_formation_old($formation);

	return $res;
}

/**
* Obtenir les infos rsultats d'une srie effectue pour un utilisateur. (OLD)
*
* Fonction qui rcupre les infos rsultats de la srie effectue par l'utilisateur


* @param integer : numro de formation
* @param integer : numero de la srie
* @param integer : numero de l'utilisateur
* @return integer : les infos rsultats de la srie
*/
function get_infos_serie_formation_utilisateur_old($formation, $serie, $user) {

	$req = "select * from res_serie where id_formation='$formation' and id_serie=$serie and id_stag=$user and score>=0 and date_fin>0";
	$res = pg_query($req);

	return $res;
}

/**
* Obtenir les infos rsultats d'une srie effectue pour un utilisateur.
*
* Fonction qui rcupre les infos rsultats des sries effectues par l'utilisateur

* @param integer : numro de formation
* @param integer : numero de la srie
* @param integer : numero de l'utilisateur
* @return integer : les infos rsultats des sries
*/
function get_infos_serie_formation_utilisateur($formation, $serie, $user) {
	if (VERSION_BASE > VERSION) {
		echo "A IMPLEMENTER<br>";
	} else
		$res = get_infos_series_formation_old($formation);

	return $res;
}

/**
* Obtenir les infos rsultats des exercices  tlcharger effectus. (OLD)
*
* Fonction qui rcupre les infos rsultats des exercices  tlcharger effectus par la
* formation passe en paramtre
*
* @param integer : numro de formation
* @return integer : les infos rsultats des sries
*/
function get_infos_exos_formation_old($formation) {

	$req = "select *
	                        from resexouser
	                        where num_cal='$formation'
	                        and num_cal <> 0
	                        group by num_resexouser, num_user, num_exo, commentaire, surtotal, score, date_correction, num_cal";
	$res = pg_query($req);

	return $res;
}

/**
* Obtenir les infos rsultats des exercices  tlcharger effectus.
*
* Fonction qui rcupre les infos rsultats des exercices  tlcharger effectus par la
* formation passe en paramtre
*
* @param integer : numro de formation
* @return integer : les infos rsultats des sries
*/
function get_infos_exos_formation($formation) {
	if (VERSION_BASE > VERSION) {
		$req = "select * FROM _af_get_infos_exos_formation($formation) AS (num_resexouser integer, num_user integer, num_exo integer, commentaire character varying(256), surtotal integer, score integer, date_correction integer, num_cal integer);";
		$res = pg_query($req);
	} else
		$res = get_infos_exos_formation_old($formation);

	return $res;
}

///**
//* Obtenir les infos des ressources d'une formation (OLD)
//*
//* @param integer : numero de formation
//* @param integer : les infos rsultats des ressources
//*/
//function get_formation_infos_ressources_old($formation) {
//	$sql = "(SELECT G.num_gest_res, F.num_fic as num, T.num_themedir, T.nom_theme, E.num_espace, E.titre as espace, S.num_section, S.titre as section, G.libelle, G.num_cal, G.type,G.motcle
//	        FROM ressource_fic F, THEMEDIR T, ressource_sec S, ressource_esp  E, ressource_gest G
//	        WHERE F.num_themedir=T.num_themedir
//	        AND G.num_fic=F.num_fic
//	        AND G.num_section=S.num_section
//	        AND G.num_espace=E.num_espace
//	        AND G.num_cal=$formation
//	        AND G.type='f'
//	        )
//	        UNION
//	        (SELECT G.num_gest_res, F.num_text as num, T.num_themedir, T.nom_theme, E.num_espace, E.titre as espace, S.num_section, S.titre as section, G.libelle, G.num_cal, G.type,G.motcle
//	        FROM ressource_txt F, THEMEDIR T, ressource_sec S, ressource_esp  E, ressource_gest G
//	        WHERE F.num_themedir=T.num_themedir
//	        AND G.num_fic=F.num_text
//	        AND G.num_section=S.num_section
//	        AND G.num_espace=E.num_espace
//	        AND G.num_cal=$formation
//	        AND G.type='t'
//	        )
//	        ORDER BY  nom_theme, espace,section, libelle ;
//	        ";
//	$res = pg_query($sql);
//	return $res;
//}
///**
//* Obtenir les infos des ressources d'une formation
//*
//* @param integer : numero de formation
//* @param integer : les infos rsultats des ressources
//*/
//function get_formation_infos_ressources($formation) {
//	if (VERSION_BASE > VERSION) {
//		echo "A IMPLEMENTER<br>";
//	} else
//		$res = get_formation_infos_ressources_old($formation);
//	return $res;
//}

/**
*   obtenir le numero du theme d'un calendrier  (OLD)
*
*   Retourne le numero du theme dont le numero du calendrier est pass en parametre.
*
*    @param  integer :  le numero du calendrier
*
*    @return  integer : le numero du theme
*/
function get_formation_numero_theme_old($formation) {
	$sql = "select distinct num_thematik from gestparcours where g_num_parcours in
	                (select distinct g_num_parcours from gestionnaire where g_num_cal=$formation) and num_etape=1";
 //echo "sql=$sql<br>";
	$res = pg_query($sql);
	$row = @pg_fetch_row($res, 0);
	return $row[0];

}
/**
*   obtenir le numero du theme d'un calendrier
*
*   Retourne le numero du theme dont le numero du calendrier est pass en parametre.
*
*    @param  integer :  le numero du calendrier
*
*    @return  integer : le numero du theme
*/
function get_formation_numero_theme($formation) {
	if (VERSION_BASE > VERSION) {
		echo "A IMPLEMENTER<br>";
	} else {
		$res = get_formation_numero_theme_old($formation);
	}
	return $res;
}


/**
*   obtenir les series notees pour une formation donne
*
*   Retourne les numero de series distinct
*
*    @param  integer :  le numero du calendrier
*
*    @return  integer : le numero de serie
*/
function get_formation_series_notees_old($formation) {
	$req = "select distinct id_serie from res_serie where id_formation='$formation' and score>=0 and date_fin>0 order by id_serie";
	$res = pg_query($req);
	return $res;
}

/**
*   obtenir les series notees pour une formation donnee
*
*   Retourne les numero de series distinct
*
*    @param  integer :  le numero du calendrier
*
*    @return  integer : le numero de serie
*/
function get_formation_series_notees($formation) {
	if (VERSION_BASE > VERSION) {
		print ("A implmenter...");
	} else
		$res = get_formation_series_notees_old($formation);

	return $res;
}

/**
*   obtenir les exercices (numero, titre et mode_rendu) d'une formation donne
*
*   Retourne les exercices  tlcharges d'une formation
*
*    @param  integer :  le numero du calendrier
*
*    @return array : numero d'exercice | titre | mode de rendu
*/
function get_formation_exercices_telecharges_old($formation) {
	$req = "select num_exo, titre, mode_rendu from exotlc
	                 where num_exo in(select distinct gesttlc_exo from gestexotlc where num_cal=$formation)";
	$res = pg_query($req);
	return $res;
}

/**
*   obtenir les exercices (numero, titre et mode_rendu) d'une formation donnee
*
*   Retourne les exercices a telecharges d'une formation
*
*    @param  integer :  le numero du calendrier
*
*    @return array : numero d'exercice | titre | mode de rendu
*/
function get_formation_exercices_telecharges($formation) {
	if (VERSION_BASE > VERSION) {
		print ("A implmenter...");
	} else
		$res = get_formation_exercices_telecharges_old($formation);

	return $res;
}

/**
*   obtenir les scores d'un exercice a telecharger pour une formation donne
*
*   Retourne les scores et le total max du score
*
*    @param  integer :  le numero du calendrier
*    @param  integer :  le numero d'exercice
*
*    @return array : resultat | notesur
*/
function get_formation_scores_exercice_old($formation, $exercice) {
	$req = "select score, surtotal from resexouser where num_exo=$exercice and num_cal=$formation";
	$res = pg_query($req);
	return $res;
}

/**
*   obtenir les scores d'un exercice a telecharger pour une formation donnee
*
*   Retourne les scores et le total max du score
*
*    @param  integer :  le numero du calendrier
*    @param  integer :  le numero d'exercice
*
*    @return array : resultat | notesur
*/
function get_formation_scores_exercice($formation, $exercice) {
	if (VERSION_BASE > VERSION) {
		print ("A implmenter...");
	} else
		$res = get_formation_scores_exercice_old($formation, $exercice);

	return $res;
}

/**
*   obtenir le nombre d'exercices rendus d'une formation pour un exercice  telecharger donn
*
*   Retourne le nombre d'exercice rendu
*
*    @param  integer :  le numero du calendrier
*    @param  integer :  le numero d'exercice
*
*    @return int : nombre d'exercice rendu
*/
function get_formation_nb_exercices_rendus_old($formation, $exercice) {
	$req = "select count(*) from reception_exostlc where num_cal=$formation and num_exo=$exercice";
	$res = pg_query($req);
	return $res;
}

/**
*   obtenir le nombre d'exercices rendus d'une formation pour un exercice a telecharger donne
*
*   Retourne le nombre d'exercice rendu
*
*    @param  integer :  le numero du calendrier
*    @param  integer :  le numero d'exercice
*
*    @return int : nombre d'exercice rendu
*/
function get_formation_nb_exercices_rendus($formation, $exercice) {
	if (VERSION_BASE > VERSION) {
		print ("A implmenter...");
	} else
		$res = get_formation_nb_exercices_rendus_old($formation, $exercice);

	return $res;
}

/**
*   obtenir le nombre d'exercices corrigs d'une formation pour un exercice  tlcharger donn
*
*   Retourne le nombre d'exercices corrigs
*
*    @param  integer :  le numero du calendrier
*    @param  integer :  le numero d'exercice
*
*    @return int : nombre d'exercices corrigs
*/
function get_formation_nb_exercices_corriges_old($formation, $exercice) {
	$req = "select count(*) from resexouser where num_cal=$formation and num_exo=$exercice";
	$res = pg_query($req);
	return $res;
}

/**
*   obtenir le nombre d'exercices corriges d'une formation pour un exercicea telecharger donne
*
*   Retourne le nombre d'exercices corriges
*
*    @param  integer :  le numero du calendrier
*    @param  integer :  le numero d'exercice
*
*    @return int : nombre d'exercices corriges
*/
function get_formation_nb_exercices_corriges($formation, $exercice) {
	if (VERSION_BASE > VERSION) {
		print ("A implmenter...");
	} else
		$res = get_formation_nb_exercices_corriges_old($formation, $exercice);

	return $res;
}

/**
*   obtenir l'effectif d'un groupe pour une formation donne (OLD)
*
*   Retourne le nombre de stagiaire d'une formation
*
*    @param  integer :  le numero du calendrier
*
*    @return int : nombre de stagiaire
*/
function get_formation_effectif_groupe_old($formation) {
	$req = "select count(num_user) from utilisateurs where categorie like '%u%'
	               and num_user in (select distinct gu_num_user from gestionutil gu,utilisateurs u
	                                            where gu_num_gest_gr in (select distinct g_num_gest_g from gestionnaire
	                                                                                        where g_num_cal=$formation));";
	$res = pg_query($req);
	$row = pg_fetch_row($res, 0);
	return $row[0];
}

/**
*   obtenir l'effectif d'un groupe pour une formation donnee
*
*   Retourne le nombre de stagiaire d'une formation
*
*    @param  integer :  le numero du calendrier
*
*    @return int : nombre de stagiaire
*/
function get_formation_effectif_groupe($formation) {
	if (VERSION_BASE > VERSION) {
		print ("A implmenter...");
	} else
		$res = get_formation_effectif_groupe_old($formation);

	return $res;
}



///**
//*   Obtenir les infos des espaces d'une formation (OLD)
//*
//*   @param integer : le numero de la formation
//*   @param integer : le resultat de la requete
//*/
//function get_formation_espaces_infos_old($formation){
//    $sql="select * from ressource_esp where num_espace in (select num_espace from ressource_gest where num_cal=$formation)";
//    $res=pg_query($sql);
//    return $res;
//}
///**
//*   Obtenir les infos des espaces d'une formation
//*
//*   @param integer : le numero de la formation
//*   @param integer : le resultat de la requete
//*/
//function get_formation_espaces_infos($formation){
//    if (VERSION_BASE > VERSION) {
//		print ("A implementer...");
//	} else
//		$res = get_formation_espaces_infos_old($formation);
//
//	return $res;
//}

/**
    Obtenir le nombre de journes de cours pour une formation (OLD)
*
*   @param integer : le numero de formation
*   @param date : la date de debut
*   @param date : la date de fin
*   @return integer : le resultat de la requete
*/
function get_formation_nombre_journees_cours_old($formation,$date_debut,$date_fin){
    $sql="SELECT COUNT(*) FROM Dates D, gest_cal G WHERE D.num_date=G.num_date AND (D.jour <'$date_debut' OR D.jour>'$date_fin') AND G.gnum_cal=$formation and demi_jour<>'C'";
	//$sql="SELECT * FROM Dates D, gest_cal G WHERE D.num_date=G.num_date AND (D.jour <'$date_debut' OR D.jour>'$date_fin') AND G.gnum_cal=$formation";
	//echo "sql=$sql<br>";
    $res=pg_query($sql);
    return $res;
}
/**
    Obtenir le nombre de journes de cours pour une formation
*
*   @param integer : le numero de formation
*   @param date : la date de debut
*   @param date : la date de fin
*   @return integer : le resultat de la requete
*/
function get_formation_nombre_journees_cours($formation,$date_debut,$date_fin){
    if (VERSION_BASE > VERSION) {
        print ("A implementer...");
    }
    else
        $res = get_formation_nombre_journees_cours_old($formation,$date_debut,$date_fin);
    return $res;
}


/**
    Obtenir les dates de debut et fin d'une formation (OLD)
*
*   @param integer : le numero de formation
*   @return integer : le resultat de la requete
*/
function get_formation_dates_old($formation){
    $sql="SELECT D1.jour, D2.jour FROM Calendrier C, dates D1, dates D2
                WHERE D1.num_date=C.datedeb
                AND D2.num_date=C.datefin
                AND num_cal=$formation";
    $res=pg_query($sql);
    return $res;
}
/**
    Obtenir les dates de debut et fin d'une formation
*
*   @param integer : le numero de formation
*   @param date : la date de debut
*   @param date : la date de fin
*   @return integer : le resultat de la requete
*/
function get_formation_dates($formation){
    if (VERSION_BASE > VERSION) {
        print ("A implementer...");
    }
    else
        $res = get_formation_dates_old($formation);
    return $res;
}

/**
    Supprime une joune de cours d'une formation (OLD)
*
*   @param integer : le numero de formation
*   @param integer : le numero de date  supprimer
*   @return integer : le resultat de la requete
*/
function del_formation_journee_cours_old($formation,$num_date){
    $sql="DELETE from gest_cal WHERE num_date=$num_date AND gnum_cal=$formation;";
    $del = pg_query($sql);
    return $del;
}
/**
    Supprime une joune de cours d'une formation
*
*   @param integer : le numero de formation
*   @param integer : le numero de date  supprimer
*   @return integer : le resultat de la requete
*/
function del_formation_journee_cours($formation,$num_date){
    if (VERSION_BASE > VERSION) {
        print ("A implementer...");
    }
    else
        $res = del_formation_journee_cours_old($formation,$num_date);
    return $res;
}

/**
    Supprime un cours d'une formation (OLD)
*
*   @param integer : le numero de formation
*   @param integer : le numero de date  supprimer
*   @param varchar : l'heure de debut
*   @return integer : le resultat de la requete
*/
function del_formation_cours_old($formation,$num_date,$heure_debut){
    $sql="DELETE from gest_cal WHERE num_date=$num_date AND gnum_cal=$formation AND hdeb='$heure_debut';";
    //echo "sql=$sql<br>";
    $del = pg_query($sql);
    return $del;
}
/**
    Supprime une joune de cours d'une formation
*
*   @param integer : le numero de formation
*   @param integer : le numero de date  supprimer
*   @param varchar : l'heure de debut
*   @return integer : le resultat de la requete
*/
function del_formation_cours($formation,$num_date,$heure_debut){
    if (VERSION_BASE > VERSION) {
        print ("A implementer...");
    }
    else
        $res = del_formation_cours_old($formation,$num_date,$heure_debut);
    return $res;
}

/**
    Obtenir les cours d'une formation pour une priode donne (OLD)
*
*   @param integer : le numero de formation
*   @param date : le debut de priode
*   @param date : la fin de priode
*   @return integer : le resultat de la requete
*/
function get_formation_cours_periode_old($formation,$datedebut,$datefin){
    $sql="SELECT D.jour FROM dates D,gest_cal G
                WHERE D.num_date=g.num_date
                AND G.gnum_cal=$formation
                and G.demi_jour <> 'C'
                AND  D.jour BETWEEN '$datedebut' AND   '$datefin'";
    $res=pg_query($sql);
    return $res;
}
/**
    Obtenir les cours d'une formation pour une priode donne (OLD)
*
*   @param integer : le numero de formation
*   @param date : le debut de priode
*   @param date : la fin de priode
*   @return integer : le resultat de la requete
*/
function get_formation_cours_periode($formation,$datedebut,$datefin){
    if (VERSION_BASE > VERSION) {
        print ("A implementer...");
    }
    else
        $res = get_formation_cours_periode_old($formation,$datedebut,$datefin);
    return $res;
}



/*
    Obtenir les infos des cours pour une date de formation  (OLD)
*
*   @param integer : le numero de formation
*   @param date : la date de formation
*   @return integer : le resultat de la requete
*/
function get_formation_cours_infos_old($formation,$date){
    $sql="SELECT  G.demi_jour, G.hdeb, G.hfin, G.libelle, G.num_intervenant, G.num_salle,T.libelle_form, I.code_couleur,I.nom  as coul
                FROM gest_cal G, dates D, typeform T, intervention I
                WHERE G.num_date=D.num_date
                AND D.jour='$date'
                AND G.gnum_cal=$formation
                AND T.num_typeform=G.numtype
                AND I.id=G.type
                ORDER BY hdeb asc";
    $res=pg_query($sql);
    return $res;
}
/*
    Obtenir les infos des cours pour une date de formation
*
*   @param integer : le numero de formation
*   @param date : la date de formation
*   @return integer : le resultat de la requete
*/
function get_formation_cours_infos($formation,$date){
    if (VERSION_BASE > VERSION) {
        print ("A implementer...");
    }
    else
        $res = get_formation_cours_infos_old($formation,$date);
    return $res;
}

/*
    Obtenir les infos d'un cours pour une date de formation  (OLD)
*
*   @param integer : le numero de formation
*   @param date : la date de formation
*   @param varchar : l'heure de debut du cours
*   @return integer : le resultat de la requete
*/
function get_formation_cours_info_old($formation,$date,$heure_debut){
     $sql="SELECT G.numtype, G.gnum_cal , G.demi_jour, G.hdeb, G.hfin, G.libelle, G.type,G.numtype, G.num_intervenant, G.num_salle
                FROM gest_cal G , dates D
                WHERE hdeb='$heure_debut'
                AND G.gnum_cal=$formation
                AND D.jour='$date'
                AND D.num_date=G.num_date";
    $res=pg_query($sql);
    return $res;
}
/*
    Obtenir les infos des cours pour une date de formation
*
*   @param integer : le numero de formation
*   @param date : la date de formation
*   @param varchar : l'heure de debut du cours
*   @return integer : le resultat de la requete
*/
function get_formation_cours_info($formation,$date,$heure_debut){
    if (VERSION_BASE > VERSION) {
        print ("A implementer...");
    }
    else
        $res = get_formation_cours_info_old($formation,$date,$heure_debut);
    return $res;
}

/**
*   Obtenir les professeurs associs  une formation (OLD)
*
*   @param integer : le numero de la formation
*   @return integer : le resultat de la requete
*/
function get_formation_professeurs_old($formation){
     $sql="SELECT distinct num_user, nom, prenom FROM gestionutil G, utilisateurs U, gestionnaire Ge
                WHERE U.num_user=G.gu_num_user
                AND Ge.g_num_gest_g=G.gu_num_gest_gr
                AND Ge.g_num_cal=$formation
                AND categorie like 'f%'";
     $res=pg_query($sql);
     return $res;
}
/**
*   Obtenir les professeurs associs  une formation
*
*   @param integer : le numero de la formation
*   @return integer : le resultat de la requete
*/
function get_formation_professeurs($formation){
    if (VERSION_BASE > VERSION) {
        print ("A implementer...");
    }
    else
        $res = get_formation_professeurs_old($formation);
    return $res;
}

/**
*    Vrification des heures de cours pour une date de formation (OLD)
*
*   @param integer : le numero de formation
*   @param date : le jour du cours
*   @param varchar : l'heure de debut du cours
*   @param varchar : l'heure de fin de cours
*   @param varchar : l'heure de denut du cours que l'on veut modifier (mode edition)
*   @return integer : le resulltat de la requete
*/
function check_formation_heures_cours_old($formation,$date,$heure_debut,$heure_fin,$heure_cours=""){
    $sql="SELECT COUNT(*) FROM  dates D, gest_cal G
                WHERE D.num_date=G.num_date
                AND D.jour='$date'
                AND ( ( G.hdeb >= '$heure_debut' AND G.hdeb <= '$heure_fin')  OR ( G.hdeb <= '$heure_debut' AND G.hfin>='$heure_debut') )
                AND G.gnum_cal=$formation";
    if(!empty($heure_cours))
        $sql .= "AND G.hdeb != '$heure_cours'";
    $res=pg_query($sql);
    return $res;
}
/**
*    Vrification des heures de cours pour une date de formation

*   @param integer : le numero de formation
*   @param date : le jour du cours
*   @param varchar : l'heure de debut du cours
*   @param varchar : l'heure de fin de cours
*   @param varchar : l'heure de denut du cours que l'on veut modifier (mode edition)
*   @return integer : le resultat de la requete
*/
function check_formation_heures_cours($formation,$date,$heure_debut,$heure_fin,$heure_cours=""){
    if (VERSION_BASE > VERSION) {
        print ("A implementer...");
    }
    else
        $res = check_formation_heures_cours_old($formation,$date,$heure_debut,$heure_fin,$heure_cours);
    return $res;
}

/**
    Obtenir le numero de groupe d'une formation (OLD)
*
*   @param integer : le numero de formation
*   @return integer : le resultat de la requete
*/
function get_formation_num_groupe_old($formation){
    $sql="select distinct g_num_gest_g from gestionnaire where g_num_cal=$formation";
    $res=pg_query($sql);
    return $res;
}
/**
    Obtenir le numero de groupe d'une formation
*
*   @param integer : le numero de formation
*   @return integer : le resultat de la requete
*/
function get_formation_num_groupe($formation){
    if (VERSION_BASE > VERSION) {
        print ("A implementer...");
    }
    else
        $res = get_formation_num_groupe_old($formation);
    return $res;
}

/**
    Enregistre un cours de formation (OLD)
*
*   @param integer : le numero de formation
*   @param integer : le numero de date
*   @param char : la periode (M -> matin , A -> aprs-midi , T -> journe entire)
*   @param varchar : heure de debut
*   @param varchar : heure de fin
*   @param varchar : intitul
*   @param integer : le type d'intervention
*   @param integer : la modalite (1 -> Synchrone , 2 -> Asynchrone ou 3 -> Presentiel)
*   @param integer : le numero d'intervenant
*   @param integer : le numero de salle
*/
function set_formation_cours_old($formation,$num_date,$periode,$heure_debut,$heure_fin,$intitule,$intervention,$modalite,$intervenant,$salle){
    $sql="INSERT INTO gest_cal (gnum_cal,num_date,demi_jour,hdeb,hfin,libelle,type,numtype,num_intervenant,num_salle)
                              VALUES ($formation,$num_date,'$periode','$heure_debut','$heure_fin','$intitule',$intervention,$modalite,$intervenant,$salle);";
    $res = pg_query($sql);
    return $res;
}
/**
    Enregistre un cours de formation
*
*   @param integer : le numero de formation
*   @param integer : le numero de date
*   @param char : la periode (M -> matin , A -> aprs-midi , T -> journe entire)
*   @param varchar : heure de debut
*   @param varchar : heure de fin
*   @param varchar : intitul
*   @param integer : le type d'intervention
*   @param integer : la modalite (1 -> Synchrone , 2 -> Asynchrone ou 3 -> Presentiel)
*   @param integer : le numero d'intervenant
*   @param integer : le numero de salle
*/
function set_formation_cours($formation,$num_date,$periode,$heure_debut,$heure_fin,$intitule,$intervention,$modalite,$intervenant,$salle){
    if (VERSION_BASE > VERSION) {
        print ("A implementer...");
    }
    else
        $res = set_formation_cours_old($formation,$num_date,$periode,$heure_debut,$heure_fin,$intitule,$intervention,$modalite,$intervenant,$salle);
    return $res;
}

/**
    Modifie un cours de formation (OLD)
*
*   @param integer : le numero de formation
*   @param integer : le numero de date
*   @param char : la periode (M -> matin , A -> aprs-midi , T -> journe entire)
*   @param varchar : heure de debut
*   @param varchar : heure de fin
*   @param varchar : intitul
*   @param integer : le type d'intervention
*   @param integer : la modalite (1 -> Synchrone , 2 -> Asynchrone ou 3 -> Presentiel)
*   @param integer : le numero d'intervenant
*   @param integer : le numero de salle
*   @param integer : l'heure du cours
*   @param integer : la date du cours
*/
function maj_formation_cours_old($formation,$num_date,$periode,$heure_debut,$heure_fin,$intitule,$intervention,$modalite,$intervenant,$salle,$heure_cours,$date_cours){
    $sql="UPDATE gest_cal SET num_date=$num_date,demi_jour='$periode' ,hdeb='$heure_debut' ,hfin='$heure_fin' ,libelle='$intitule' ,
                type=$intervention ,numtype='$modalite',num_intervenant=$intervenant,num_salle=$salle
                WHERE gnum_cal=$formation AND hdeb='$heure_cours' AND num_date='$date_cours'";
    $res = pg_query($sql);
    return $res;
}
/**
    Enregistre un cours de formation
*
*   @param integer : le numero de formation
*   @param integer : le numero de date
*   @param char : la periode (M -> matin , A -> aprs-midi , T -> journe entire)
*   @param varchar : heure de debut
*   @param varchar : heure de fin
*   @param varchar : intitul
*   @param integer : le type d'intervention
*   @param integer : la modalite (1 -> Synchrone , 2 -> Asynchrone ou 3 -> Presentiel)
*   @param integer : le numero d'intervenant
*   @param integer : le numero de salle
*   @param integer : l'heure du cours
*   @param integer : la date du cours
*/
function maj_formation_cours($formation,$num_date,$periode,$heure_debut,$heure_fin,$intitule,$intervention,$modalite,$intervenant,$salle,$heure_cours,$date_cours){
    if (VERSION_BASE > VERSION) {
        print ("A implementer...");
    }
    else
        $res = maj_formation_cours_old($formation,$num_date,$periode,$heure_debut,$heure_fin,$intitule,$intervention,$modalite,$intervenant,$salle,$heure_cours,$date_cours);
    return $res;
}

/**
    Vrifie l'existence du calendrier (OLD)
*
*   @param integer : le numero de formation
*   @return bool : true OK , false Pb
*/
function check_formation_calendrier_old($formation){
    $sql="SELECT count(*) FROM calendrier WHERE num_cal=$formation";
    $res=pg_query($sql);
    if(pg_numrows($res)==1)
        return true;
    return false;
}
/**
    Vrifie l'existence du calendrier (OLD)
*
*   @param integer : le numero de formation
*   @return bool : true OK , false Pb
*/
function check_formation_calendrier($formation){
    if (VERSION_BASE > VERSION) {
        print ("A implementer...");
    }
    else
        $res = check_formation_calendrier_old($formation);
    return $res;
}

/**
    Vrifie l'existence d'un nom de calendrier  (OLD)
*
*   @param varchar : le nom de formation
*   @return bool : true existe , false n'existe pas
*/
function check_formation_nom_old($nom_formation){
    $sql="select * from calendrier where nom_cal like '%$nom_formation%';";
    $res=pg_query($sql);
    if(pg_numrows($res)==0)
        return false;
    return true;
}
/**
    Vrifie l'existence d'un nom de calendrier
*
*   @param varchar : le nom de formation
*   @return bool : true existe , false n'existe pas
*/
function check_formation_nom($nom_formation){
    if (VERSION_BASE > VERSION) {
        print ("A implementer...");
    }
    else
        $res = check_formation_nom_old($nom_formation);
    return $res;
}

/**
    Obtenir le numero et nom d'une classe pour une formation (OLD)
*
*   @param integer : le numero de formation
*   @return integer : le resultat de la requete
*/
function get_formation_classe_infos_old($formation){
    //$sql="SELECT id, nom FROM classe C, gestionnaire G WHERE C.id=G.g_num_gest_g AND G.g_num_cal=$formation";
	$sql="select id,nom from classe where id in (select distinct g_num_gest_g from gestionnaire where g_num_cal=$formation)";
    $res=pg_query($sql);
    return $res;
}
/**
    Obtenir le numero et nom d'une classe pour une formation
*
*   @param integer : le numero de formation
*   @return integer : le resultat de la requete
*/
function get_formation_classe_infos($formation){
    if (VERSION_BASE > VERSION) {
        print ("A implementer...");
    }
    else
        $res = get_formation_classe_infos_old($formation);
    return $res;
}

/**
    Obtenir les cours d'une formation (OLD)
*
*   @param integer : le numero de formation
*   @return integer : le resultat de la requete
*/
function get_formation_cours_old($formation){
    $sql="SELECT * FROM gest_cal  G, dates D WHERE gnum_cal=$formation AND G.num_date=d.num_date AND G.demi_jour!='C' ORDER BY jour,hdeb";
    $res=pg_query($sql);
    return $res;
}
/**
    Obtenir les cours d'une formation
*
*   @param integer : le numero de formation
*   @return integer : le resultat de la requete
*/
function get_formation_cours($formation){
    if (VERSION_BASE > VERSION) {
        print ("A implementer...");
    }
    else
        $res = get_formation_cours_old($formation);
    return $res;
}

/**
    Enregistre les donnes du calendrier (OLD)
*
*   @param varchar : le nom du calendrier
*   @param integer : le numero de date de debut
*   @param integer : le numero de date de fin
*   @param varchar : les langues pour le calendrier
*   @return integer : le numero du calendrier
*/
function set_formation_calendrier_old($nomcal,$debut,$fin,$langue){
    $sql="insert into calendrier(nom_cal,datedeb,datefin,langue) values('$nomcal',$debut,$fin,'$langue');";
    $ins=pg_query($sql);
    $oid=pg_getlastoid($ins);
    $res=pg_query("SELECT num_cal FROM calendrier WHERE OID=$oid;");
    return pg_result($res, 0, 0);
}
/**
    Enregistre les donnes du calendrier
*
*   @param varchar : le nom du calendrier
*   @param integer : le numero de date de debut
*   @param integer : le numero de date de fin
*   @param varchar : les langues pour le calendrier
*   @return integer : le numero du calendrier
*/
function set_formation_calendrier($nomcal,$debut,$fin,$langue){
    if (VERSION_BASE > VERSION) {
        print ("A implementer...");
    }
    else
        $res = set_formation_calendrier_old($nomcal,$debut,$fin,$langue);
    return $res;
}

/**
    Verifie l'existence des donnes d'une formation (OLD)
*
*   @param integer : le numero du formateur
*   @param integer : le numero de filiere
*   @param integer : le numero de la classe
*   @param integer : le numero de calendrier
*   @param integer : le numero de droit
*   @param integer : le numero de parcours
*   @return bool : true existe , false n'existe pas
*/
function check_formation_donnees_old($formateur,$filiere,$classe,$formation,$num_droit,$parcours){
    $sql="select * from gestionnaire
                where g_num_user=$formateur
                and g_num_gest_c=$filiere
                and g_num_gest_g=$classe
                and g_num_cal=$formation
                and g_num_droit=$num_droit
                and g_num_parcours=$parcours";
    //echo "sql=$sql<br>";
    $res=pg_query($sql);
    if(pg_numrows($res)==0)
        return false;
    return true;
}
/**
    Verifie l'existence des donnes d'une formation
*
*   @param integer : le numero du formateur
*   @param integer : le numero de filiere
*   @param integer : le numero de la classe
*   @param integer : le numero de calendrier
*   @param integer : le numero de droit
*   @param integer : le numero de parcours
*   @return bool : true existe , false n'existe pas
*/
function check_formation_donnees($formateur,$filiere,$classe,$formation,$num_droit,$parcours){
    if (VERSION_BASE > VERSION) {
        print ("A implementer...");
    }
    else
        $res = check_formation_donnees_old($formateur,$filiere,$classe,$formation,$num_droit,$parcours);
    return $res;
}

/**
    Enregistre les donnes d'une formation (OLD)
*
*   @param integer : le numero du formateur
*   @param integer : le numero de filiere
*   @param integer : le numero de la classe
*   @param integer : le numero de calendrier
*   @param integer : le numero de droit
*   @param integer : le numero de parcours
*   @return integer : le resultat de la requete
*/
function set_formation_donnees_old($formateur,$filiere,$classe,$formation,$num_droit,$parcours){
    $sql="insert into gestionnaire(g_num_user,g_num_gest_c,g_num_gest_g,g_num_cal,g_num_droit,g_num_parcours)
                values($formateur,$filiere,$classe,$formation,$num_droit,$parcours)";
    $ins=pg_query($sql);
    return $ins;
}
/**
    Enregistre les donnes d'une formation
*
*   @param integer : le numero du formateur
*   @param integer : le numero de filiere
*   @param integer : le numero de la classe
*   @param integer : le numero de calendrier
*   @param integer : le numero de droit
*   @param integer : le numero de parcours
*   @return integer : le resultat de la requete
*/
function set_formation_donnees($formateur,$filiere,$classe,$formation,$num_droit,$parcours){
    if (VERSION_BASE > VERSION) {
        print ("A implementer...");
    }
    else
        $res = set_formation_donnees_old($formateur,$filiere,$classe,$formation,$num_droit,$parcours);
    return $res;
}

/**
    Vrifie l'existence des individus d'une formation (OLD)
*
*   @param integer : le numero de parcours
*   @param integer : le numero de la classe
*   @param integer : le numero d'individu
*   @param integer : le numero de filiere
*   @param integer : le numero de calendrier
*   @return bool : true existe , false n'existe pas
*/
function check_formation_individu_old($parcours,$groupe,$individu,$formation){
    $sql="select * from gestionparcours
            where gp_num_parcours=$parcours
            and gp_num_groupe=$groupe
            and gp_num_user=$individu
            and num_cal=$formation;";
    $res=pg_query($sql);
    if(pg_numrows($res)==0)
        return false;
    return true;
}
/**
    Vrifie l'existence d'un individu d'une formation
*
*   @param integer : le numero de parcours
*   @param integer : le numero de la classe
*   @param integer : le numero d'individu
*   @param integer : le numero de filiere
*   @param integer : le numero de calendrier
*   @return bool : true existe , false n'existe pas
*/
function check_formation_individu($parcours,$groupe,$individu,$formation){
    if (VERSION_BASE > VERSION) {
        print ("A implementer...");
    }
    else
        $res = check_formation_individu_old($parcours,$groupe,$individu,$formation);
    return $res;
}

/**
    Enregistre un individus d'une formation (OLD)
*
*   @param integer : le numero de parcours
*   @param integer : le numero de la classe
*   @param integer : le numero d'individu
*   @param integer : le numero de calendrier
*   @return integer : le resultat de la requete
*/
function set_formation_individu_old($parcours,$groupe,$individu,$avancement,$avancement_libre,$etape_libre,$formation){
    $sql="insert into gestionparcours values($parcours,$groupe,$individu,$avancement,$avancement_libre,$etape_libre,$formation)";
    $ins=pg_query($sql);
    return $ins;

}
/**
    Enregistre un individu d'une formation
*
*   @param integer : le numero de parcours
*   @param integer : le numero de la classe
*   @param integer : le numero d'individu
*   @param integer : le numero de calendrier
*   @return bool : true existe , false n'existe pas
*/
function set_formation_individu($parcours,$groupe,$individu,$avancement,$avancement_libre,$etape_libre,$formation){
    if (VERSION_BASE > VERSION) {
        print ("A implementer...");
    }
    else
        $res = set_formation_individu_old($parcours,$groupe,$individu,$avancement,$avancement_libre,$etape_libre,$formation);
    return $res;
}

/**
    Modifie le nom d'une formation (OLD)
*
*   @param integer : le numero de formation
*   @param varchar : le nouveau nom
*   @return interger : le resultat de la requete
*/
function maj_formation_nom_old($formation,$nom_formation){
    $sql="update calendrier set nom_cal='$nom_formation' where num_cal=$formation";
    $maj=pg_query($sql);
    return $maj;
}
/**
    Modifie le nom d'une formation
*
*   @param integer : le numero de formation
*   @param varchar : le nouveau nom
*   @return interger : le resultat de la requete
*/
function maj_formation_nom($formation,$nom_formation){
     if (VERSION_BASE > VERSION) {
        print ("A implementer...");
    }
    else
        $res = maj_formation_nom_old($formation,$nom_formation);
    return $res;
}



/**
    Obtenir le nom d'une formation (OLD)
*
*   @param integer : le numero de formation
*   @return interger : le resultat de la requete
*/
function get_formation_nom_old($formation){
    $sql="select nom_cal from calendrier where num_cal=$formation";
    return (pg_query($sql));
}
/**
    Obtenir le nom d'une formation
*
*   @param integer : le numero de formation
*   @return interger : le resultat de la requete
*/
function get_formation_nom($formation){
    if (VERSION_BASE > VERSION) {
        print ("A implementer...");
    }
    else
        $res = get_formation_nom_old($formation);
    return $res;
}

/**
    Obtenir les infos des alertes d'une formation (OLD)
*
*   @param integer : le numero de formation
*   @return interger : le resultat de la requete
*/
function get_formation_alertes_infos_old($formation){
    $sql="select num_alert,intitule,texte,jour,periode from alert A,dates D where num_cal=$formation and A.num_date=D.num_date order by jour";
    return (pg_query($sql));
}
/**
    Obtenir les infos des alertes d'une formation
*
*   @param integer : le numero de formation
*   @return interger : le resultat de la requete
*/
function get_formation_alertes_infos($formation){
     if (VERSION_BASE > VERSION) {
        print ("A implementer...");
    }
    else
        $res = get_formation_alertes_infos_old($formation);
    return $res;
}

/**
    Obtenir les infos du calendrier d'une formation (OLD)
*
*   @param integer : le numero de formation
*   @return interger : le resultat de la requete
*/
function get_formation_calendrier_infos_old($formation){
    $sql="select nom_cal,D1.jour,D2.jour from calendrier,dates D1,dates D2 where D1.num_date=datedeb and D2.num_date=datefin and num_cal=$formation";
    return (pg_query($sql));
}
/**
    Obtenir les infos du calendrier d'une formation
*
*   @param integer : le numero de formation
*   @return interger : le resultat de la requete
*/
function get_formation_calendrier_infos($formation){
    if (VERSION_BASE > VERSION) {
        print ("A implementer...");
    }
    else
        $res = get_formation_calendrier_infos_old($formation);
    return $res;
}

/**
    Supprimer l'alert pour une date de formation  (OLD)
*
*   @param integer : le numero de formation
*   @param integer: le numero de date de formation
*   @return integer : le resultat de la requete
*/
function del_formation_alerte_old($formation,$num_date){
    $sql="delete from alert where num_cal=$formation and num_date=$num_date";
    return (pg_query($sql));
}
/**
    Supprimer l'alert pour une date de formation
*
*   @param integer : le numero de formation
*   @param integer: le numero de date de formation
*   @return integer : le resultat de la requete
*/
function del_formation_alerte($formation,$num_date){
    if (VERSION_BASE > VERSION) {
        print ("A implementer...");
    }
    else
        $res = del_formation_alerte_old($formation,$num_date);
    return $res;
}

/**
    Supprimer le formateur d'une formation (OLD)
*
*   @param integer : le numero de formation
*   @param integer : le numero du formateur
*   @return integer : le resultat de la requete
*/
function del_formation_formateur_old($formation,$formateur){
    $sql="delete from gestionnaire where g_num_cal=$formation and g_num_user=$formateur";
    return (pg_query($sql));
}
/**
    Supprimer le formateur d'une formation
*
*   @param integer : le numero de formation
*   @param integer : le numero du formateur
*   @return integer : le resultat de la requete
*/
function del_formation_formateur($formation,$formateur){
    if (VERSION_BASE > VERSION) {
        print ("A implementer...");
    }
    else
        $res = del_formation_formateur_old($formation,$formateur);
    return $res;
}

/**
	Obtenir les formateurs des formations pour une periode (OLD)
*	@return : le resultat de la requete
*/
function get_formation_formateurs_periode_old($periode){
	$sql="select num_user,nom,prenom from utilisateurs where categorie like'%f%' and num_user in
			(select distinct g_num_user from gestionnaire G,calendrier C,dates D1,dates D2
			where C.num_cal=G.g_num_cal
			and D1.num_date=C.datedeb
			and D2.num_date=C.datefin ";
	if($periode==1)
		$sql .="and D2.jour<current_date ";
	else
		if($periode==2)
			$sql .="and (current_date between D1.jour and D2.jour) ";
		else
			$sql .="and D1.jour>current_date ";
	$sql .=") order by nom";
 	return (pg_query($sql));
}
/**
	Obtenir les formateurs des formations pour une periode
*	@return : le resultat de la requete
*/
function get_formation_formateurs_periode($periode){
	 if (VERSION_BASE > VERSION) {
        print ("A implementer...");
    }
    else
        $res = get_formation_formateurs_periode_old($periode);
    return $res;
}

/**
	Obtenir les listes de test pour une formation donnee (OLD)
 *
 *	@param integer : le numero de la formation
 *	@return integer : le resultat de la requete
*/
function get_formation_listes_auto_positionnement_old($formation){
	$sql="select id_liste_test,nom_liste_test from liste_test where id_liste_test in (select id_liste from res_liste where id_formation=$formation)";
 	return (pg_query($sql));
}
/**
	Obtenir les listes de test pour une formation donnee
 *
 *	@param integer : le numero de la formation
 *	@return integer : le resultat de la requete
*/
function get_formation_listes_auto_positionnement($formation){
	 if (VERSION_BASE > VERSION) {
        print ("A implementer...");
    }
    else
        $res = get_formation_listes_auto_positionnement_old($formation);
    return $res;
}

/**
	Obtenir les individus qui ont fait un test d'autopositionnement (OLD)
 *
 *	@param integer : le numero de formation
 *	@param integer : le numero de la liste de tests d'autopositionnement
 *	@return integer : le resultat de la requete
*/
function get_formation_individus_positionnement_fini_old($formation,$liste){
	$sql="select num_user,nom,prenom from utilisateurs where num_user in (select id_stag from res_liste where id_formation=$formation and id_liste=$liste)";
 	return (pg_query($sql));
}
/**
	Obtenir les individus qui ont fait un test d'autopositionnement
 *
 *	@param integer : le numero de formation
 *	@param integer : le numero de la liste de tests d'autopositionnement
 *	@return integer : le resultat de la requete
*/
function get_formation_individus_positionnement_fini($formation,$liste){
	 if (VERSION_BASE > VERSION) {
        print ("A implementer...");
    }
    else
        $res = get_formation_individus_positionnement_fini_old($formation,$liste);
    return $res;
}

/**
	Obtenir les grilles presentielles notees pour une formation (OLD)

	@param integer : le numero de formation
 	@return integer : le resultat de la requete
*/
function get_formation_grilles_notees_old($formation){
	$sql="select num_grille,libelle_grille from grille where num_grille in
			(select distinct num_grille from notation where num_cal=$formation)";
   return (pg_query($sql));
}
/**
	Obtenir les grilles presentielles notees pour une formation

	@param integer : le numero de formation
 	@return integer : le resultat de la requete
*/
function get_formation_grilles_notees($formation){
	if (VERSION_BASE > VERSION) {
        print ("A implementer...");
    }
    else
        $res = get_formation_grilles_notees_old($formation);
    return $res;
}

/**
	Obtenir les stagiares d'une formation (OLD)

 	@param integer : le numero de formation
 	@return integer : le resultat de la requete
 */
function get_formation_stagiaires_old($formation){
	$sql="select distinct num_user,nom,prenom from utilisateurs where categorie='u' and num_user in
			(select distinct gp_num_user from gestionparcours where num_cal=$formation) order by nom";
   	return (pg_query($sql));
}
/**
	Obtenir les stagiares d'une formation

 	@param integer : le numero de formation
 	@return integer : le resultat de la requete
 */
function get_formation_stagiaires($formation){
	if (VERSION_BASE > VERSION) {
        print ("A implementer...");
    }
    else
        $res = get_formation_stagiaires_old($formation);
    return $res;
}

/**
	Obtenir les jours presentiels d'une formation (OLD)

	@param integer : le numero de formation
 	@return integer : le resultat de la requete
*/
function get_formation_jours_presentiels_old($formation){
	$sql="select jour from dates where num_date in
			(select num_date from gest_cal where gnum_cal=$formation and numtype=3) order by jour";
   return (pg_query($sql));
}
/**
	Obtenir les jours presentiels d'une formation

	@param integer : le numero de formation
 	@return integer : le resultat de la requete
*/
function get_formation_jours_presentiels($formation){
	if (VERSION_BASE > VERSION) {
        print ("A implementer...");
    }
    else
        $res = get_formation_jours_presentiels_old($formation);
    return $res;
}

/**
	Obtenir les notations presentielles d'un individu pour une formation (OLD)

	@param integer : le numero de formation
 	@param integer : le numero d'individu
	@param integer : le numero de grille
 	@param integer : le numero du titrecapacite
	@param integer : le numero de capacite
 	@return integer :  le resultat de la requete
 */
function get_formation_notation_presentielle_individu_old($formation,$individu,$grille,$titrecapacite,$capacite){
	$sql="select notation from notation where num_cal=$formation and num_user=$individu and num_grille=$grille and
			num_titrecapacite=$titrecapacite and num_capacite=$capacite";
   //echo "sql=$sql<br>";
   return (pg_query($sql));
}
/**
	Obtenir les notations presentielles d'un individu pour une formation

	@param integer : le numero de formation
 	@param integer : le numero d'individu
	@param integer : le numero de grille
 	@param integer : le numero du titrecapacite
	@param integer : le numero de capacite
 	@return integer :  le resultat de la requete
 */
function get_formation_notation_presentielle_individu($formation,$individu,$grille,$titrecapacite,$capacite){
 	if (VERSION_BASE > VERSION) {
        print ("A implementer...");
    }
    else
        $res = get_formation_notation_presentielle_individu_old($formation,$individu,$grille,$titrecapacite,$capacite);
    return $res;
}

/**
	Obtenir les infos note presentiellle d'un individu pour une formation et une date (OLD)

	@param integer : le numero de formation
 	@param integer : le numero d'individu
	@param integer : le numero de grille
 	@param integer : le numero du titrecapacite
	@param integer : le numero de capacite
	@param integer : le numero de date
 	@return integer :  le resultat de la requete
*/
function get_formation_note_presentielle_infos_individu_old($formation,$individu,$grille,$titrecapacite,$capacite,$num_date){
	$sql="select comment,note,notesur from comment_presentiel where num_cal=$formation  and num_user=$individu and
			num_grille=$grille and num_titrecapacite=$titrecapacite and num_capacite=$capacite and num_date=$num_date";
   return (pg_query($sql));
}
/**
	Obtenir les infos note presentiellle d'un individu pour une formation et une date

	@param integer : le numero de formation
 	@param integer : le numero d'individu
	@param integer : le numero de grille
 	@param integer : le numero du titrecapacite
	@param integer : le numero de capacite
	@param integer : le numero de date
 	@return integer :  le resultat de la requete
*/
function get_formation_note_presentielle_infos_individu($formation,$individu,$grille,$titrecapacite,$capacite,$num_date){
	if (VERSION_BASE > VERSION) {
        print ("A implementer...");
    }
    else
        $res = get_formation_note_presentielle_infos_individu_old($formation,$individu,$grille,$titrecapacite,$capacite,$num_date);
    return $res;
}

/**
	Mettre  jour les infos note presentiellle d'un individu pour une formation et une date (OLD)

 	@param integer : le numero de formation
 	@param integer : le numero d'individu
	@param integer : le numero de grille
 	@param integer : le numero du titrecapacite
	@param integer : le numero de capacite
	@param integer : le numero de date
 	@param string : le commentaire
 	@param integer : la note
 	@param integer : la note sur
 	@return integer :  le resultat de la requete
*/
function maj_formation_note_presentielle_infos_individu_old($formation,$individu,$grille,$titrecapacite,$capacite,$num_date,$commentaire,$note,$notesur){
	$sql="update comment_presentiel set comment='$commentaire',note=$note,notesur=$notesur where num_cal=$formation
			and num_user=$individu and num_grille=$grille and num_titrecapacite=$titrecapacite and num_capacite=$capacite and num_date=$num_date";
   return (pg_query($sql));
}
/**
	Mettre  jour les infos note presentiellle d'un individu pour une formation et une date

 	@param integer : le numero de formation
 	@param integer : le numero d'individu
	@param integer : le numero de grille
 	@param integer : le numero du titrecapacite
	@param integer : le numero de capacite
	@param integer : le numero de date
 	@param string : le commentaire
 	@param integer : la note
 	@param integer : la note sur
 	@return integer :  le resultat de la requete
*/
function maj_formation_note_presentielle_infos_individu($formation,$individu,$grille,$titrecapacite,$capacite,$num_date,$commentaire,$note,$notesur){
	if (VERSION_BASE > VERSION) {
        print ("A implementer...");
    }
    else
        $res = maj_formation_note_presentielle_infos_individu_old($formation,$individu,$grille,$titrecapacite,$capacite,$num_date,$commentaire,$note,$notesur);
    return $res;
}

/**
	Enregistrer les infos note presentiellle d'un individu pour une formation et une date (OLD)

 	@param integer : le numero de formation
 	@param integer : le numero d'individu
	@param integer : le numero de grille
 	@param integer : le numero du titrecapacite
	@param integer : le numero de capacite
	@param integer : le numero de date
 	@param string : le commentaire
 	@param integer : la note
 	@param integer : la note sur
 	@return integer :  le resultat de la requete
*/
function set_formation_note_presentielle_infos_individu_old($formation,$individu,$grille,$titrecapacite,$capacite,$num_date,$commentaire,$note,$notesur){
	$sql="insert into comment_presentiel
			values($formation,$individu,$grille,$titrecapacite,$capacite,$num_date,'$commentaire',$note,$notesur)";
   return (pg_query($sql));
}
/**
	Mettre  jour les infos note presentiellle d'un individu pour une formation et une date

 	@param integer : le numero de formation
 	@param integer : le numero d'individu
	@param integer : le numero de grille
 	@param integer : le numero du titrecapacite
	@param integer : le numero de capacite
	@param integer : le numero de date
 	@param string : le commentaire
 	@param integer : la note
 	@param integer : la note sur
 	@return integer :  le resultat de la requete
*/
function set_formation_note_presentielle_infos_individu($formation,$individu,$grille,$titrecapacite,$capacite,$num_date,$commentaire,$note,$notesur){
	if (VERSION_BASE > VERSION) {
        print ("A implementer...");
    }
    else
        $res = set_formation_note_presentielle_infos_individu_old($formation,$individu,$grille,$titrecapacite,$capacite,$num_date,$commentaire,$note,$notesur);
    return $res;
}

/**
	Supprimer les notations presentielles d'un individu pour une formation (OLD)

	@param integer : le numero de formation
 	@param integer : le numero d'individu
	@param integer : le numero de grille
 	@param integer : le numero du titrecapacite
	@param integer : le numero de capacite
 	@return integer :  le resultat de la requete
 */
function del_formation_notation_presentielle_individu_old($formation,$individu,$grille,$titrecapacite,$capacite){
	$sql="delete from notation where num_cal=$formation and num_user=$individu and num_grille=$grille and
			num_titrecapacite=$titrecapacite and num_capacite=$capacite";
   //echo "sql=$sql<br>";
   return (pg_query($sql));
}
/**
	Obtenir les notations presentielles d'un individu pour une formation

	@param integer : le numero de formation
 	@param integer : le numero d'individu
	@param integer : le numero de grille
 	@param integer : le numero du titrecapacite
	@param integer : le numero de capacite
 	@return integer :  le resultat de la requete
 */
function del_formation_notation_presentielle_individu($formation,$individu,$grille,$titrecapacite,$capacite){
 	if (VERSION_BASE > VERSION) {
        print ("A implementer...");
    }
    else
        $res = del_formation_notation_presentielle_individu_old($formation,$individu,$grille,$titrecapacite,$capacite);
    return $res;
}

/**
	Mettre  jour les notations presentielles d'un individu pour une formation (OLD)

	@param integer : le numero de formation
 	@param integer : le numero d'individu
	@param integer : le numero de grille
 	@param integer : le numero du titrecapacite
	@param integer : le numero de capacite
 	@param string : les notations
 	@return integer :  le resultat de la requete
 */
function maj_formation_notation_presentielle_individu_old($formation,$individu,$grille,$titrecapacite,$capacite,$notation){
	$sql="update notation set notation='$notation' where num_cal=$formation and num_user=$individu and num_grille=$grille and
			num_titrecapacite=$titrecapacite and num_capacite=$capacite";
   //echo "sql=$sql<br>";
   return (pg_query($sql));
}
/**
	Mettre  jour les notations presentielles d'un individu pour une formation

	@param integer : le numero de formation
 	@param integer : le numero d'individu
	@param integer : le numero de grille
 	@param integer : le numero du titrecapacite
	@param integer : le numero de capacite
 	@param string : les notations
 	@return integer :  le resultat de la requete
 */
function maj_formation_notation_presentielle_individu($formation,$individu,$grille,$titrecapacite,$capacite,$notation){
 	if (VERSION_BASE > VERSION) {
        print ("A implementer...");
    }
    else
        $res = maj_formation_notation_presentielle_individu_old($formation,$individu,$grille,$titrecapacite,$capacite,$notation);
    return $res;
}

/**
	Supprimer les infos note presentiellle d'un individu pour une formation et une date (OLD)

 	@param integer : le numero de formation
 	@param integer : le numero d'individu
	@param integer : le numero de grille
 	@param integer : le numero du titrecapacite
	@param integer : le numero de capacite
	@param integer : le numero de date
 	@return integer :  le resultat de la requete
*/
function del_formation_note_presentielle_infos_individu_old($formation,$individu,$grille,$titrecapacite,$capacite,$num_date){
	$sql="delete from  comment_presentiel  where num_cal=$formation
			and num_user=$individu and num_grille=$grille and num_titrecapacite=$titrecapacite and num_capacite=$capacite and num_date=$num_date";
  	return (pg_query($sql));
}
/**
	Mettre  jour les infos note presentiellle d'un individu pour une formation et une date

 	@param integer : le numero de formation
 	@param integer : le numero d'individu
	@param integer : le numero de grille
 	@param integer : le numero du titrecapacite
	@param integer : le numero de capacite
	@param integer : le numero de date
 	@return integer :  le resultat de la requete
*/
function del_formation_note_presentielle_infos_individu($formation,$individu,$grille,$titrecapacite,$capacite,$num_date){
	if (VERSION_BASE > VERSION) {
        print ("A implementer...");
    }
    else
        $res = del_formation_note_presentielle_infos_individu_old($formation,$individu,$grille,$titrecapacite,$capacite,$num_date);
    return $res;
}

/**
	Supprimer les infos note presentiellle d'un individu pour une formation  (OLD)

 	@param integer : le numero de formation
 	@param integer : le numero d'individu
	@param integer : le numero de grille
 	@param integer : le numero du titrecapacite
	@param integer : le numero de capacite

 	@return integer :  le resultat de la requete
*/
function del_formation_notes_presentielles_infos_individu_old($formation,$individu,$grille,$titrecapacite,$capacite){
	$sql="delete from  comment_presentiel  where num_cal=$formation
			and num_user=$individu and num_grille=$grille and num_titrecapacite=$titrecapacite and num_capacite=$capacite";
  	return (pg_query($sql));
}
/**
	Mettre  jour les infos note presentiellle d'un individu pour une formation

 	@param integer : le numero de formation
 	@param integer : le numero d'individu
	@param integer : le numero de grille
 	@param integer : le numero du titrecapacite
	@param integer : le numero de capacite

 	@return integer :  le resultat de la requete
*/
function del_formation_notes_presentielles_infos_individu($formation,$individu,$grille,$titrecapacite,$capacite){
	if (VERSION_BASE > VERSION) {
        print ("A implementer...");
    }
    else
        $res = del_formation_notes_presentielles_infos_individu_old($formation,$individu,$grille,$titrecapacite,$capacite);
    return $res;
}

/**
*   obtenir l'effectif d'un groupe pour une formation donn\x{00E9}e (OLD)
*
*   Retourne le nombre de stagiaire d'une formation
*
*    @param  integer :  le numero du calendrier
*
*    @return int : nombre de stagiaire
*/
function get_formation_groupes_old($formation) {
	$req = "	select * 
	    			from classe 
	    			where id in (
	    				select distinct g_num_gest_g 
	    				from GESTIONNAIRE 
	    				where g_num_cal=$formation)";

	$res = pg_query($req);

	return $res;
}

/**
*   obtenir l'effectif d'un groupe pour une formation donnee
*
*   Retourne le nombre de stagiaire d'une formation
*
*    @param  integer :  le numero du calendrier
*
*    @return int : nombre de stagiaire
*/
function get_formation_groupes($formation) {
	if (VERSION_BASE > VERSION) {
		print ("A implementer...");
	} else
		$res = get_formation_groupes_old($formation);

	return $res;
}
?>