<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
	fichier pour la fonctionnalit forum
	@package forum
	@modulegroup plpgsql
	@module plpgsql_forum
*/
/**
	Obtenir les donnes d'un forum
	@param integer : forum
	@return integer : res req
*/
function get_forum($forum){
	$sql="select * from contraintes.af_get_forum($forum) 
		as (id int4,libelle varchar,description varchar,moderation bool,moderateur_pwd varchar,fils int4,messages int4,upload bool,theme varchar)";
	return pg_query($sql);
}

/**
	Ajouter un forum
	@param string : libelle
	@param string : description
	@param bool : upload
	@param string : theme
	@param integer : arborescences par page
	@param integer : messages par page
	@param integer : configuration
	@return integer : res req
*/
function set_forum($libelle,$description,$upload,$theme,$arbo_parpage,$msg_parpage,$configuration){
	$sql="select * from contraintes.af_set_forum('$libelle','$description',$upload,'$theme',$arbo_parpage,$msg_parpage,$configuration)";
	echo "sql=$sql<br>";
	$res= pg_query($sql);
	$id=pg_fetch_result($res, 0, 0);
	return $id;
}

/**
	Modifier un forum
	@param integer : forum
	@param string : libelle
	@param string : description
	@param bool : upload
	@param string : theme
	@param integer : arborescences par page
	@param integer : messages par page
	@param integer : configuration
	@return integer : res req
*/
function maj_forum($forum,$libelle,$description,$upload,$theme,$arbo_parpage,$msg_parpage,$configuration){
	$sql="select * from contraintes.af_maj_forum($forum,'$libelle','$description',$upload,'$theme',$arbo_parpage,$msg_parpage,$configuration)";
	//echo "sql=$sql<br>";
	return pg_query($sql);
}

/**
	Obtenir l'environnement d'un forum
*/
function get_forum_forum_environnement($forum){
	$sql="select * from contraintes.af_get_forum_forum_environnement($forum) as (id int4,
  libelle varchar,
  chemin varchar,
  db_type varchar,
  db_serveur varchar,
  db_name varchar,
  db_user varchar,
  db_pwd varchar,
  admin varchar,
  admin_pwd varchar,
  email_valide bool,
  email_verification bool,
  interpretation_html bool,
  citation bool,
  noms_longs bool,
  taille_pj int4,
  lignes int4,
  block_ip bool,
  compte_vus bool,
  fils_fermes bool,
  affiche_fils bool,
  encodage varchar)";
  return pg_query($sql);
}


/**
	Obtenir un environnement de forum
*/
function get_forum_environnement($forum_environnement){
	$sql="select * from contraintes.af_get_forum_environnement($forum_environnement) as (id int4,
  libelle varchar,
  chemin varchar,
  db_type varchar,
  db_serveur varchar,
  db_name varchar,
  db_user varchar,
  db_pwd varchar,
  admin varchar,
  admin_pwd varchar,
  email_valide bool,
  email_verification bool,
  interpretation_html bool,
  citation bool,
  noms_longs bool,
  taille_pj int4,
  lignes int4,
  block_ip bool,
  compte_vus bool,
  fils_fermes bool,
  affiche_fils bool,
  encodage varchar)";
  return pg_query($sql);
}

/**
 * Mettre  jour un environnement de forum
 */
function maj_forum_environnement($id,$libelle ,$chemin ,$db_type , $db_serveur ,$db_name , $db_user ,  $db_pwd , $admin , $admin_pwd , $email_valide , $email_verification , $interpretation_html ,
  $citation , $noms_longs , $taille_pj , $lignes , $block_ip, $compte_vus , $fils_fermes , $affiche_fils , $encodage ){
		$sql="select * from contraintes.af_maj_forum_environnement($id,$libelle ,$chemin ,$db_type , $db_serveur ,$db_name , $db_user ,  $db_pwd , $admin , $admin_pwd , $email_valide , $email_verification , $interpretation_html ,
 			$citation , $noms_longs , $taille_pj , $lignes , $block_ip, $compte_vus , $fils_fermes , $affiche_fils , $encodage ) ";
  return sql2Bool(pg_fetch_result(pg_query($sql),0,0));
}
/**
 * Supprime un forum
 * @param integer : forum
 */
 function del_forum($forum){
 	$sql="select * from contraintes.af_del_forum($forum)";
 	return pg_query($sql);
 }
?>