<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/** Iterateur
 *  parcourant un tableau pour retourner des objets de type GraphicElement 
 * 
 */
class SqlResultIterator extends Iterator {
	var $sql_result;
 	var $cursor;
	var $nb_elements;
 	
  /** 
   * Constructeur
   */
  function SqlResultIterator( $sql_result ) {
   $this->sql_result=$sql_result;
   $this->nb_elements=pg_num_rows($this->sql_result);
   $this->cursor=0;
  }
  
  /** 
   * Retourne chaque lment de la collection ou null 
   */
  function getNextElement() {
	if ( $this->cursor >= $this->nb_elements) return null;
	return pg_fetch_row($this->sql_result, $this->cursor++);
  }
}
?>
