<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Objet de base pour la cr�ation de pages d'Astairs.
 */
class AstairsPage extends AstairsTemplate{
	
	var $style_files;
	var $javascript_files;
	var $pageBuilder;
//	var $pageComponents;

	/**
	 * Constructeur.
	 * @param object PageBuilder $pageBuilder L'objet permettant de cr�er une page
	 * @param Array $templates Les templates � utiliser pour la cr�ation de la page
	 * @param Array $style_files Les feuilles de style
	 * @param Array $javascript_files Les fichiers javascript
	 * @param string $javascript_internal_code Le code javascript interne
	 */
	function AstairsPage($pageBuilder,$templates,$style_files, $javascript_files,$javascript_internal_code){

		global $dbpath,$serverfront,$style_par_defaut;
		//parent
		parent::Template($pageBuilder->getRoot());
		
		//affectation des attributs
		$this->pageBuilder=$pageBuilder;
		$this->pageComponents=array();

		$this->javascript_files=$javascript_files;
		$this->javascript_files["$dbpath/lib_graphique/javascript"][]="global.js";
		
//		print_rr($this->style_files);
		$this->style_files["../../lib_graphique/styles/$style_par_defaut"][]="global.css";
		$this->style_files=array_merge($this->style_files,$style_files);
		
		//inclusion de tout les templates n�cessaires
		parent::set_file($this->pageBuilder->getRequiredTemplates()); //templates communs
		
		parent::set_root($this->pageBuilder->getModuleRoot());
		parent::set_file($templates); //templates de la page

		//affectation des variables
		$val ['PAGE_LANG']= $this->pageBuilder->getLang();
		$val ['PAGE_CHARSET']= $this->pageBuilder->getEncoding();
		$val ['PAGE_RESOLUTION']= $this->pageBuilder->getResolution();
		$val ['PAGE_FAVICO']= "http://$serverfront/".'favicone.ico';
		$val ['JAVASCRIPT_CODE']= $javascript_internal_code;
		$val ['PAGE_AUTHOR']= 'Copyright (C) 2006, 2007, 2009, 2009 AFIDE (Agir Former Innover Developper Entreprendre). Verbatim copying and distribution of this entire article is permitted in any medium, provided this notice is preserved';
		parent::set_var($val);
	}	
	
	/**
	 * Affecter le javascript d�clench� au chargemement de la page.
	 * @param string Le code javascript.
	 */
	function setOnLoad($javascript){
		parent::set_var('PAGE_ONLOAD',$javascript);
	}

	/**
	 * Affecter le javascript d�clench� � la fermeture de la page.
	 * @param string Le code javascript.
	 */
	function setOnUnLoad($javascript){
		parent::set_var('PAGE_ONUNLOAD',$javascript);
	}
	
	function parse(){
		
		//force licence
		parent::set_var('PAGE_AUTHOR','Copyright (C) 2006, 2007, 2009, 2009 AFIDE (Agir Former Innover Developper Entreprendre). Verbatim copying and distribution of this entire article is permitted in any medium, provided this notice is preserved');
		if ($this->debug & 1) {
			printf("<b>AstairsPage::parse()</b><br>\n");
		}
		
		//message d'erreur
		$msg=$this->getPageMessage();
		if(!empty($msg['MSG'])){
			parent::set_var('PAGE_MSG_CODE',$msg['MSG_CODE']);
			parent::set_var('PAGE_MSG_ERROR',$msg['MSG']);
			$this->setPageMessage(null);
		}		
		
		
		//affectation des styles (css)
		foreach($this->style_files as $style_path=>$styles){
			foreach($styles as $s=>$style_file){
				parent::set_var('STYLE_PATH',$style_path);
				parent::set_var('STYLE_FILE',$style_file);
				parent::parse('PAGE_STYLE', 'style',true);
			}
		}
		//affectation des javascripts (css)
		foreach($this->javascript_files as $javascript_path=>$javascripts){
			foreach($javascripts as $j=>$javascripts_file){
				parent::set_var('JAVASCRIPT_PATH',$javascript_path);
				parent::set_var('JAVASCRIPT_FILE',$javascripts_file);
				parent::parse('PAGE_JAVASCRIPT', 'javascript',true);
			}
		}
		
		parent::parse('PAGE_META', 'meta');
		parent::parse('PAGE_INTERNAL_JAVASCRIPT', 'internal_javascript');
		$i=0;
		
		//on parse chacun des components
		foreach($this->pageComponents as  $target=> $compts){
			foreach($compts as $ind_comp => $component){
				
				
				if ($this->debug & 4) {
					printf("Call of: (%s) AstairsPage/AstairsTemplate::parseComponents(%s,%s): <br>\n",get_class($component),get_class($component),true);
				}	
				//le parsing d'un component consiste � parser 'target' et le stocker dans 'TARGET'
				$component->parseComponents($target,true);
				
				if ($this->debug & 4) {
					printf("Call of: (%s) AstairsPage/AstairsTemplate::parseBlocks(%s,%s): <br>\n",get_class($component),$target,true);
				}	
				$component->parseBlocks($target,true);
				
				if ($this->debug){
					print_rr($component->get_undefined(strtoupper($target)));
				}
				
				
				if ($this->debug & 4) {
					printf("Call of: (%s) AstairsPage/AstairsTemplate::parseComponent(%s,%s,%s): <br>\n",get_class($component),strtoupper($target), $component->get_var(strtoupper($target)),true);
				}	
				//le resultat du parsing du component(component.'TARGET') sert ensuite � valuer this.'TARGET'
				$this->parseComponent(strtoupper($target), $component->get_var(strtoupper($target)),true);
			}
		}
		
		parent::parse('PAGE_DEV', 'page_dev');
		parent::parse('PAGE_CONTENT', 'content');
		parent::parse('structure_out', 'structure');
		
		if ($this->debug){
			print_rr(parent::get_undefined('structure_out'));
		}
	}
	
	function set_block(){
		die("Erreur: Vous ne pouvez pas cr�er de block directement dans une AstairsPage. Utilisez un PageComponent.<br>");
	}
	
	function p(){
		parent::p('structure_out');
	}
	
	/**
	 * This is shorthand for print $this->parse(...) and is functionally identical.
	 * See parse for further details.
	 *
	 * Returns: always returns false.
	 *
	 * usage: pparse(string $target, string $varname, [boolean $append])
	 * or
	 * usage: pparse(string $target, array $varname = (string $varname), [boolean $append])
	 *
	 * @param     $target      a string containing the name of the variable into which substituted $varnames are to be stored
	 * @param     $varname     if a string, the name the name of the variable to substitute or if an array a list of variables to be substituted
	 * @param     $append      if true, the substituted variables are appended to $target otherwise the existing value of $target is replaced
	 * @access    public
	 * @return    false
	 * @see       parse
	 */
	function pparse($target, $varname, $append = false) {
		if ($this->debug & 4) {
			echo "<p><b>pparse:</b> passing parameters to parse...</p>\n";
		}
		print $this->finish($this->parse($target, $varname, $append));
		return false;
	}
}
?>