<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Objet de base de la gestion des Templates Astairs.
 */
class AstairsTemplate extends Template{
	

	var $pageBuilder;
	var $pageComponents;
	var $pageBlocks;

	var $varname;
	var $name;
	var $block_vars;
		
	/**
	 * Constructeur.
	 * @param object PageBuilder $pageBuilder L'objet permettant de cr�er une page
	 * @param Array $templates Les templates � utiliser pour la cr�ation de la page
	 * @param Array $style_files Les feuilles de style
	 * @param Array $javascript_files Les fichiers javascript
	 * @param string $javascript_internal_code Le code javascript interne
	 */
	 function AstairsTemplate(){
	 	parent::Template();
	 	//debug
//		parent::set_debug(4);
	 }
	
	/**
	 * Ajoute un Component à l'objet.
	 * @param string $target Nom de la variable dans laquelle le Component doit etre affecté (Nom de la variable du tpl en minuscule)
	 * @param object Component $component Le component
	 * @param $bool $append Si true, le Component est ajouté aux éventuels Components déjà affectés à $target. Si false, les remplaces
	 * @param string $name Nom du block dans lequel est affecté le Component.
	 * @param string $varname Nom de la variable de block dans laquelle est stockée le resulat du parsing de la variable $name
	 */
	function &setComponent($target, $component = "", $append = false, $name=null,$varname=null) {
    	if (!is_array($component)) {
			if (!empty ($component)) {
				if ($this->debug  & 1) {
					printf("<b>(%s) AstairsTemplate::setComponent:</b> (with scalar) <b>%s</b> = '%s'<br>\n",get_class($this), $target, get_class($component));
				}
				if(func_num_args()==5){
					$this->setBlock($target,$name,$varname,$component);
//					$component->setVarname($varname); //$component
//					$component->setName($name);//$component
				}else{
					if ($append && isset ($this->pageComponents[$target])) {
						$this->pageComponents[$target][]= $component;
					} else {
						$this->pageComponents[$target][0] = $component;
					}
				}
			}
		} else {
			reset($component);
			while (list ($k, $v) = each($component)) {
				if (!empty ($k)) {
					if ($this->debug & 1) {
						printf("<b>AstairsTemplate::setComponent:</b> (with array) <b>%s</b> = '%s'<br>\n", $k, htmlentities($v));
					}
						$v->setVarname($varname);//$v
						$v->setName($name);//$v
						if ($append && isset ($this->pageComponents[$target])) {
							$this->pageComponents[$target][]= $v;
						} else {
							$this->pageComponents[$target][] = $v;
						}
				}
			}
		}
	}
	
	function setBlock($target,$name,$varname,$component){
		if ($this->debug & 4) {
			printf("<b>(%s)AstairsTemplate::setBlock(%s,%s,%s,%o):</b><br>\n", get_class($this), $target,$name,$varname,$component);
		}
	
		$this->pageBlocks[$name][$target]['varname']=$varname;
		$this->pageBlocks[$name][$target]['components'][]=$component;
	}
	
	/**
	 * This functions sets the value of a block variable.
	 *
	 * It may be called with either a varname and a value as two strings or an
	 * an associative array with the key being the varname and the value being
	 * the new variable value.
	 *
	 * The function inserts the new value of the variable into the 
	 * $block_vars hash. It is not necessary for a variable to exist in this hash
	 * before calling this function.
	 *
	 * An optional third parameter allows the value for each varname to be appended
	 * to the existing variable instead of replacing it. The default is to replace.
	 *
	 *
	 * usage: set_block_var(string $varname, [string $value = ""], [boolean $append = false])
	 * or
	 * usage: set_block_var(array $varname = (string $varname => string $value), [mixed $dummy_var], [boolean $append = false])
	 *
	 * @param     $varname      either a string containing a varname or a hash of varname/value pairs.
	 * @param     $value        if $varname is a string this contains the new value for the variable otherwise this parameter is ignored
	 * @param     $append       if true, the value is appended to the variable's existing value
	 * @access    public
	 * @return    void
	 */
	function set_block_var($varname, $value = "", $append = true) {
		if (!is_array($varname)) {
			if (!empty ($varname)) {
				if ($this->debug & 1) {
					printf("<b>set_block_var:</b> (with scalar) <b>%s</b> = '%s'<br>\n", $varname, htmlentities($value));
				}
				if ($append && isset ($this->block_vars[$varname])) {
					$this->block_vars[$varname][]= $value;
				} else {
					$this->block_vars[$varname][0] = $value;
				}
			}else{
				if ($this->debug & 1) {
					printf("<b>set_block_var:</b> (with scalar) <b>%s</b> = 'VIDE'<br>\n", $varname);
				}
			}
		} else {
			reset($varname);
			while (list ($k, $v) = each($varname)) {
				if (!empty ($k)) {
					if ($this->debug & 1) {
						printf("<b>set_block_var:</b> (with array) <b>%s</b> = '%s'<br>\n", $k, htmlentities($v));
					}
					$this->varkeys[$k] = "/" . $this->block_vars($k) . "/";
					if ($append && isset ($this->block_vars[$k])) {
						$this->block_vars[$k][]= $v;
					} else {
						$this->block_vars[$k][0] = $v;
					}
				}
				else{
					if ($this->debug & 1) {
						printf("<b>set_block_var:</b> (with array) <b>%s</b> = 'VIDE'<br>\n", $k);
					}
				}
			}
		}
	}
//	function set_block_var($varname, $value){
//		$this->block_vars[$varname]=$value;
//	}
	
	/**
	 * Returns the blocks vars ($block_vars array)
	 * @return string[] Vars to be affected in vars contained between <!-- BEGIN block --> <!-- END block --> wich are not components.
	 */
	function get_block_vars($i){
		if(is_array($this->block_vars)){
			$tmp=array();
			foreach($this->block_vars as $key => $value){
				$tmp[$key]=$value[$i];
			}
			return $tmp;
		}else{
			return null;
		}
	}
	
	/**
	 * The function stores or appends the value of the variable
	 * named $finished_component in the variable named $target.
	 *
	 * An optional third parameter allows the value for each varname to be appended
	 * to the existing target variable instead of replacing it. The default is to
	 * replace.
	 *
	 * Returns: the value assigned to $target.
	 *
	 * usage: parseComponent(string $target, string $finished_component, [boolean $append])
	 *
	 * @param     $target      a string containing the name of the variable into which substituted $varnames are to be stored
	 * @param     $finished_component     the result of the parsing of the component
	 * @param     $append      if true, the substituted variables are appended to $target otherwise the existing value of $target is replaced
	 * @access    private
	 * @return    string
	 */
	function parseComponent($target, $finished_component,$append=false){
		if ($this->debug & 4) {
			printf("<p><b>(%s) AstairsTemplate::parseComponent:</b> (with scalar) target = %s, finished_component = %s, append = %s</p>\n", get_class($this),$target,$finished_component,$append);
			echo "Affecte le component(\$finished_component) parsé à la variable cible (\$target)<br>\n";
		}
		$str = $finished_component;
		if ($append) {
			$this->set_var($target, $this->get_var($target) . $str);
		} else {
			$this->set_var($target, $str);
		}
		
		if ($this->debug & 4) {
			echo "<p><b>AstairsTemplate::parseComponent:</b> completed</p>\n";
		}
		return $this->get_var($target);
	}

	/**
	 * Parse all object's Components into $target
	 * 
	 * @param string $target Name of var wich receive the result of component parsing
	 * @param     $append       if true, the value is appended to the variable's existing value
	 */		 
	function &parseComponents($target, $append=false){
		if ($this->debug & 4) {
			printf("<b>(%s) AstairsTemplate::parseComponents(%s,%s):</b> <br>\n", get_class($this),$target,$append);
		}
		//on parse chacun des components
		if(is_array($this->pageComponents)){
			foreach($this->pageComponents as  $component_target=> $compts){
				foreach($compts as $ind_comp => $component){
					
						if ($this->debug & 4) {
							printf("Call of:(%s) AstairsTemplate::parseBlocks(%s,%s): <br>\n", get_class($component),$component_target,true);
						}
						$component->parseBlocks($component_target,true);

						
						if ($this->debug & 4) {
							printf("Call of:(%s) AstairsTemplate::parseComponents(%s,%s):<br>\n", get_class($component),$component_target,true);
						}
						//on parses les components du component
						$component->parseComponents($component_target,true);

						
						if ($this->debug & 4) {
							printf("(%s) Substitution des variables de %s", get_class($component),$component_target);
						}
						//on substitue les variables du component et on stocke le resultat dans $str
						$str=$component->subst($component_target);
						
						
						if ($this->debug){
							print_rr($component->get_undefined(strtoupper($component_target)));
						}
//						//on recupere les variables de block du component et on les affecte au component courant
//						$this->set_var($component->get_block_vars());

						//on parse le component
						if ($this->debug & 4) {
							printf("Call of:(%s) AstairsTemplate::parseComponent(%s,%s): <br>\n", get_class($component),strtoupper($component_target), $str,false);
						}
						$this->parseComponent(strtoupper($component_target), $str,false);
				}
			}
		}
		if ($this->debug & 4) {
			printf("Call of:(%s) AstairsTemplate::parseComponent(%s,%s): <br>\n", get_class($component),strtoupper($component_target), $str,false);
		}
		parent::parse(strtoupper($target), strtolower($target),false);
	}
	
	function parseBlocks($target,$append){
		if ($this->debug & 4) {
			printf("<b>(%s) AstairsTemplate::parseBlocks(%s,%s):</b> <br>\n",get_class($this), $target,$append);
		}
		if(is_array($this->pageBlocks)){
			foreach($this->pageBlocks as  $block_name=> $blocks_array){
				
				$values_blocks_array=array_values($blocks_array);
				$keys_blocks_array=array_keys($blocks_array);

				$nb_values_blocks_array=count($blocks_array);
				$nb_components=count($values_blocks_array[$nb_values_blocks_array-1]['components']);
//				echo "\$nb_values_blocks_array=$nb_values_blocks_array";
//				echo "\$nb_components=$nb_components";
				for($i=0;$i<$nb_components;$i++){
					
//					echo "parsing block component $i<br>\n";
					for($j=0;$j<$nb_values_blocks_array;$j++){
//						echo "parsing component  $j <br>\n";
						$line_component_to_parse=$values_blocks_array[$j]['components'][$i];
						if(is_object($line_component_to_parse)){
							if ($this->debug & 4) {
								printf("Call of:(%s) AstairsTemplate::parseBlocks(%s,%s): <br>\n", get_class($line_component_to_parse),$keys_blocks_array[$j],true);
							}
							$line_component_to_parse->parseBlocks($keys_blocks_array[$j],true);
							
							if ($this->debug & 4) {
								printf("Call of: (%s) AstairsTemplate::parseComponents(%s,%s): <br>\n",get_class($line_component_to_parse), $keys_blocks_array[$j],true);
							}	
							$line_component_to_parse->parseComponents($keys_blocks_array[$j],true);
							
							if ($this->debug & 4) {
								printf("Call of: (%s) AstairsTemplate::parseComponent(%s,finished %s): <br>\n",get_class($this), strtoupper($keys_blocks_array[$j]),strtoupper($keys_blocks_array[$j]),true);
							}
							$this->parseComponent(strtoupper($keys_blocks_array[$j]), $line_component_to_parse->get_var(strtoupper($keys_blocks_array[$j])),false);
						}
//						$this->parse($block_name,$values_blocks_array[$j]['varname'],true);
					}

					//on recupere les variables de block du component et on les affecte au component courant
					$this->set_var($this->get_block_vars($i));
						
					if ($this->debug & 4) {
							printf("(%s) Substitution des variables de %s", get_class($this),$block_name);
					}
					$str=$this->subst($block_name);

					if ($this->debug & 4) {
						printf("Call of: (%s) AstairsTemplate::parseComponent(%s,finished %s): <br>\n",get_class($this),$values_blocks_array[$j-1]['varname'],$str,true);
					}
					$this->parseComponent($values_blocks_array[$j-1]['varname'], $str,true);
					//netoyage
					for($j=0;$j<$nb_values_blocks_array;$j++){
						$this->unset_var($blocks_array[$j]);
					}
				}
//				echo "XXfin de block";
//				print_rr($this);
				if ($this->debug & 4) {
						printf("Call of: (%s) AstairsTemplate::parse(%s, %s): <br>\n",get_class($this),strtoupper($target), strtolower($target),false);
				}
				$this->parse(strtoupper($target), strtolower($target),false);
//				print_rr($this);
			}
		}
		else{
			if(is_array($this->block_vars)){
				
				$tmp=array_values($this->block_vars);
				$nb_lines=count($tmp[0]);
				for($i=0;$i<$nb_lines;$i++){
					foreach($this->block_vars as  $block_name=> $block_values){
						//on recupere les variables de block du component et on les affecte au component courant
						$this->set_var($block_name,$block_values[$i],false);
						if ($this->debug & 4) {
								printf("(%s) Substitution des variables de %s", get_class($this),$block_name);
						}
					}
					$str=$this->subst($this->block_name);
					$this->set_var($this->block_var, $str,true);
					
				}
			}else{
				if ($this->debug & 4) {
					printf("(%s) AstairsTemplate::parseBlocks(%s,%s):</b> nothing parsed<br>\n",get_class($this), $target,$append);
				}
				
			}
		}
	}
	/**
	 * Affiche un message dans la page.
	 * Le code de message peut etre MSG_ERROR,MSG_CONFIRM ou MSG_WARNING, ce qui permet d'avoir un style adapt� au message.
	 *
	 * @param string $msg Le message � afficher.
	 * @param integer $msg_code Le code d�terminant le type de message
	 */
	function setPageMessage($msg,$msg_code=MSG_ERROR){
		global $auth,$dbpath;
		if(is_null($msg))
			unset($auth->auth["MSG"]);
		else{
			unset($auth->auth["MSG"]);
			if(is_array($msg)){
				$auth->auth["MSG"]=$msg;
			}else{
				$auth->auth["MSG"]=array('MSG'=>$msg,'MSG_CODE'=>$msg_code);
			}
		}
		if($msg_code==MSG_FATAL_ERROR){
			include("$dbpath/pied_page.php");
			exit;
		}
	}
	
	function getPageMessage(){
		global $auth;
		return  $auth->auth["MSG"];
	}
}
?>