<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

class PageComponent extends AstairsTemplate{
	
	var $block_name;
	var $block_var;
	var $block_result;
	
	
	/**
	 * Constructeur.
	 * @param string $module_root Chemin racine des fichiers de templates (TPL)
	 * @param string $templates Les fichiers de Templates
	 */
	function PageComponent($module_root,$templates){
		parent::AstairsTemplate();
		$this->pageComponents=array();
		//debug
//		Template::set_debug(4);
		
		if((!empty($module_root))&&(!empty($templates))){
			parent::set_root($module_root); //emplacemement des templates de la page
			parent::set_file($templates); //templates de la page
    	}
	}	
	
	function setBlockResult($block_result){
		$this->block_result=$block_result;
	}
	
	function getBlockResult(){
		return $this->block_result;
	}
	
	function getNumBlockLines(){
		return pg_num_rows($this->block_result);
	}
	
	function setBlockLines($module_root,$templates){
		$nb=$this->getNumBlockLines();
		for($i=0;$i<$nb;$i++){
			$this->setBlockLine($i,$module_root,$templates);
		}
	}
	
	function setBlockLineVars($block_name,$block_var){
		$this->block_name=$block_name;
		$this->block_var=$block_var;
	}
	
	
	function setBlockName($block_name){
		$this->block_name=$block_name;
	}
	
	function setBlockVar($block_var){
		$this->block_var=$block_var;
	}
	
	function getBlockName(){
		return $this->block_name;
	}
	
	function getBlockVar(){
		return $this->block_var;
	}
	
	function set_block($parent, $varname, $name = ""){
		parent::set_block($parent,$varname,$name);
		$this->setBlockLineVars($varname,$name);
	}
}
?>