<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Dfinition d'un DoFtb.
 * Un DoFtb sert  grer l'avancement des Evaluations de type Ftb.
 * 
 * @package ftb
 */
class DoFtb extends DoEvaluation{
	
	/**
	 * Constructeur
	 * 
	 * Creation de l'objet et initialisation
	 * de ses attributs hrits.
	 * 
	 * @param integer $resultat identifiant rsultat associ au QuestionReponse (identifiant rsultat de la Srie par exemple)
	 * @param integer $evaluation identifiant du QuestionReponse
	 * @param integer $indice Indice de l'valuation.
	 * @param object EvaluationFactory &$obj_EvaluationFactory Fabrique servant  la cration des objets associs  l'avancement
	 */	
	function DoFtb($resultat,$evaluation,$indice,&$obj_EvaluationFactory){
		parent::DoEvaluation($resultat,$evaluation,TYPE_EVALUATION_FTB,$indice,$obj_EvaluationFactory);
	}
	
	
//-----------------------------------------------------
//			METHODES
//-----------------------------------------------------
	/**
	 * Termine le Ftb.
	 * Enregistre la date de fin de l'valuation et detruit les attributs de l'objet inutiles.
	 * @param object ResultatFtb $obj_resultat : Resultat associ  l'objet associ  l'avancement.
	 * @return boolean TRUE ou FALSE suivant le succs ou non de la mthode.
	 */		
	function end($obj_resultat){
		messageDebug("DoFtb::end($obj_resultat)");
		$fin_parent=parent::end($obj_resultat);
		if($fin_parent){
			//$fin=set_resultat_serie_ftb($this->getResultat(), $this->getEvaluation(),addslashes(serialize($obj_resultat->reponse)));
			$fin=set_resultat_serie_ftb($this->getResultat(), $this->getEvaluation(),$obj_resultat->reponse);
			if(!$fin){
				print("Erreur DoFtb::end(): L'valuation n'a pas t termine.<br>");
			}
		}
		return $fin&&$fin_parent;
	}	

//-----------------------------------------------------
//			ACCESSEURS
//-----------------------------------------------------

	/**
	 * Obtenir le Ftb associ  l'objet d'avancement
	 * @return object Ftb  Le Ftb
	 */	
	function &getFtb(){
		return parent::getObjEvaluation();
	}
	
	
	/**
	 * Traitement des donnes du formulaire soumis par le Stagiaire.
	 * @param array $valeurs_soumises Le $HTTP_POST_VARS du fomulaire
	 */
	function validerFormulaire($valeurs_soumises){
		
		$cle_nom="reponse";
		while(list($cle,$val)=each($valeurs_soumises)){
			//print_rr($valeurs_soumises);
			//echo "cle=$cle et val=$val<br>";
	       if(substr($cle, 0, strlen($cle_nom))==$cle_nom){
	            $this->obj_resultat->init($val);
	       }
	    }
	   
	}
}
?>
