<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 *	Fichier de dfinition de la classe Ftb.
 *	Un Ftb est un objet driv d'Evaluation.
 *
 *	@package ftb
 */
class Ftb extends Evaluation{
	
	/**
	 * @var string Le texte du Ftb
	 */
	var $text;

	/**
	 * @var bool Indique si les mots sont visibles ou non
	 */
	var $voir_mots;

	/**
	 * @var bool Indique si l'on doit effectuer une interprtation HTML du texte du Ftb
	 */
	var $interpretation_html;
	
	/**
	 * @var string Balise indiquant le dbut d'un blanc dans le texte du Ftb
	 */
	var $balise_start='[:';

	/**
	 * @var string Balise indiquant la fin d'un blanc dans le texte du Ftb
	 */
	var $balise_end=':]';

	/**
	 * Construit un Ftb.
	 * Le Ftb peut tre construit  partir d'un identifiant (1 seul parametre), auquel cas les donnes sont rcupres en base de donnes,
	 * ou  partir de l'ensemble des donnes (tous les parametres), pour ensuite tre enregistr en base.
	 *  
	 * @param integer $id identifiant du ParcoursOriente
	 * @param string $libelle Libell
	 * @param string $date_creation date de cration (format SQL)
	 */		
	function Ftb($id, $libelle="FTB", $texte_ftb="",$interhtml_texte=false,$liste_mots=false,$date_creation=""){
		if(func_num_args()==1){
			$res_evaluation = get_ftb($id);
			$row_evaluation=pg_fetch_row($res_evaluation,0);
			$libelle=$row_evaluation[1];
			$date_creation=$row_evaluation[5];
			$texte_ftb=$row_evaluation[2];
			$liste_mots= sql2bool($row_evaluation[3]);
			$interhtml_texte=sql2bool($row_evaluation[4]);
		}else{

		}
		parent::Evaluation($id, $libelle, TYPE_EVALUATION_FTB, $date_creation);
		$this->initFtb($texte_ftb,$liste_mots,$interhtml_texte);
	}

	/**
	 * Initialise les attributs propres au Ftb.
	 * @param string $text Texte du Ftb
	 * @param bool $voir_mots Si TRUE, indique que les mots sont visibles, FALSE cache les mots.
	 * @param bool $interpretation_html Indique si l'on doit effectuer une interprtation HTML du texte du Ftb
	 */			
	function initFtb($text, $voir_mots, $interpretation_html){
		if(!empty($text)){
			$this->text=$text;
			$this->voir_mots=$voir_mots;
			$this->interpretation_html=$interpretation_html;
		}else{
			die("Erreur initFtb($text, $voir_mots, $interpretation_html): L'objet ne peut etre initialis.");
		}	
	}
	/**
	 * Obtenir l'icone associe  l'Etape.
	 * @return string L'URL de l'icone
	 */	
	function getIcone(){
		global $serverback;
		return "http://$serverback/images/txt.gif";
	}

	/**
	 * Obtenir l'icone associe au type de l'Etape.
	 * @return string L'URL de l'icone
	 */		
	function getIconeType(){
		return get_evaluation_type_icone($this->type);
	}
	
	/**
	 * Savoir si l'on doit cacher ou non les mots du Ftb.
	 * @return bool True si l'on montre les mots, false sinon.
	 */
	function isVoirMots(){
		return $this->voir_mots;
	}

	/**
	 * Savoir si l'on doit effectuer une interprtation HTML du texte du Ftb.
	 * @return bool True si l'on interprete, False sinon.
	 */	
	function isInterpretationHtml(){
		return $this->interpretation_html;
	}
	
	/**
	 * Obtenir le texte du Ftb.
	 * Le texte contient les balises de dbut et de fin de blanc, avec la solution attendue.
	 * @return string  Le texte du Ftb
	 */
	function getText(){
		return $this->text;
	}

	/**
	 * Obtenir la balise de dbut de blanc dans le Ftb.
	 * @return string  La balise de dbut
	 */	
	function getBaliseStart(){
		return $this->balise_start;
	}

	/**
	 * Obtenir la balise de fin de blanc dans le Ftb.
	 * @return string  La balise de fin
	 */	
	function getBaliseEnd(){
		return $this->balise_end;
	}
		
	/**
	 * Fonction qui rcupre la liste des blancs
	 * contenus dans text et les renvoi sous forme de string dans un tableau.
	 * Les mots sont retournes dans leur ordre d'apparition dans le texte.
	 * @return array Un tableau contenant tous les mots servant de rponse au blanc.
	 */
	function getBlancs($langue=''){
		//echo "lg=$langue<br>";
		if(empty($langue))
	    	$tempTab=explode($this->balise_start,get_fo_libelle($this->text));
	    else
	    	$tempTab=explode($this->balise_start,get_ftb_libelle($langue,$this->text));
	    for($i=count($tempTab);$i>0;$i--){
	        // echo $i;
	        if(is_integer(strpos($tempTab[$i],$this->balise_end))){
	            $temp2=explode($this->balise_end,$tempTab[$i]);
	            $liste[]=$temp2[0];
	        }
	    }
	    //echo "liste=$liste<br>";
	    return array_reverse($liste);
	}
	
	/**
	 * Obtenir le nombre de blancs dans le Ftb
	 * @return integer Le nombre de blancs contenu dans text. 
	 */
	function getNbBlancs(){
		$nb=0;
		
	    //$tempTab=explode($this->balise_start,$this->text);
	    $tempTab=explode($this->balise_start,get_fo_libelle($this->text));
	    for($i=count($tempTab);$i>0;$i--){
	        if(is_integer(strpos($tempTab[$i],$this->balise_end))){
	            $temp2=explode($this->balise_end,$tempTab[$i]);
	            $nb++;
	        }
	    }
	    return $nb;
	}
	
	/**
	 * Obtenir le nom des attributs requis pour la creation d'un QCM.
	 * @return array Noms des attributs.
	 */
	function getRequiredVars(){
		return Array("libelle_ftb", "theme_ftb","texte","interpretationHTML_texte","liste_mots"); 
	}
	
	/**
	 * Obtenir les valeurs possibles pour un attribut.
	 * Retourne null si un attibut peu avoir n'importe quelle valeur.
	 * 
	 * @param string $var_name Nom de l'attribut.
	 * @return array Valeurs que peut avoir l'attribut. Si null, toutes les valeurs sont possibles.
	 */
	function getVarValues($var_name){
		//echo "var=$var_name<br>";
		switch($var_name){
			case "interpretationHTML_texte":
				return Array(true, false);
			case "liste_mots":
				return Array(true, false);
			default:
				return null;
		}
	}
	
	
	/**
	 * Vrifie la validit des donnes propres  l'objet.
	 
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donnes sont correctes, false si non.
	 */
	function verify(&$message){
		
		$attributs_ok=true;		
		// A suivre ....
		return $attributs_ok;
	}
	
	/**
	 * Vrifie la validit des donnes avant une insertion en base.
	 * Appel de la mthode verify() et vrifie les attributs propres aux classes hrits.
	 * @see verify() 
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donnes sont correctes, false si non.
	 */
	function verifyInsert(&$message){
		
		$res_parent=parent::verifyInsert($message);
		$verif=Ftb::verify($message);
		return $res_parent && $verif && true;
	}

	
	/**
	* Fonction qui insre le Ftb en base.
	* Affecte l'identifiant du Qcm.
	* @param integer $theme Identifiant du Theme dans lequel on enregistre le Qcm
	* @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	* @return integer Identifiant du Ftb cr ou false
	*/
	function insertToDB($theme, &$message) {
		
		//vrifie la prsence du theme
		if(empty($theme)){
			die("Erreur Ftb::insertToDB($theme, &$message=\"\"): Le thme est manquant.");
		}
	
		//vrification donnes et insertion
		if(Ftb::verifyInsert(&$message)){
			$this->id=set_Ftb(addslashes($this->libelle), $theme,addslashes($this->text),bool2sql($this->voir_mots), bool2sql($this->interpretation_html));
			return $this->id;
		}
		else{
			return false;
		}
	}
	
	function isNotable(){
		return true;
	}	
}
?>