<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * @package ftb
 */
class FtbCorrectionAleatoire extends EvaluationCorrectionAleatoire{
	
	var $correction;
	
	/**
	 * Constructeur
	 * 
	 * Creation de l'objet et initialisation
	 * de ses attributs hrits.
	 * 
	 * @param object DoQcm $obj_DoQcm 
	 */
	function FtbCorrectionAleatoire($obj_EtapeCorrection, $obj_Ftb){
		messageDebug("FtbCorrection::FtbCorrection($obj_EtapeCorrection, $obj_Ftb)");
		parent::EvaluationCorrectionAleatoire($obj_EtapeCorrection, $obj_Ftb);
		$this->nb_questions=1;
		$this->nb_reponses=0;
		$this->initFtbCorrectionAleatoire();
	}
	
	function initFtbCorrectionAleatoire(){
		$res_resultat_stagiaire=get_resultat_serie_ftb($this->resultat, $this->obj_Evaluation->getId());
		$row=pg_fetch_row($res_resultat_stagiaire);
		 //print_rr($row);
		//$mots_saisis=unserialize($row[2]);
		$mots_saisis=plpgsql_array_to_string_array($row[2]);
		$mots_attendus=$this->obj_Evaluation->getBlancs();
		$this->nb_reponses=count($mots_attendus);
		
		$this->correction["date_creation"]=$row[3];
		for($i=0;$i<$this->nb_reponses;$i++){
			
			//recupere les mots multiples
			$plusieurs_mots_attendus=explode("~",$mots_attendus[$i]);
			
			//mot saisi par le stagiaire
			$this->correction[$i]["saisi"]=$mots_saisis[$i];
			
			//recupration du mot juste: cas d'un blanc simple
			if(count($plusieurs_mots_attendus)==1){
				$this->correction[$i]["attendu"]=$mots_attendus[$i];
			}
			//recupration du mot juste: cas d'un blanc multiple
			else{
				$this->correction[$i]["attendu"]=$plusieurs_mots_attendus[0]; //le mot juste est toujours le premier
			}
			
			//juste ou faux
			if($this->correction[$i]["attendu"]==$this->correction[$i]["saisi"]){
					$this->correction[$i]["juste"]=true;
			}else{
				$this->correction[$i]["juste"]=false;
			}
		}
	}
	
	function getCorrectionElement($indice){
		if(!is_array($this->correction[$indice])){
			die("FtbCorrection::getCorrectionElement($indice) : Erreur: Paramtres incorrects, il n'y a pas d'lment de correction associs.");
		}
		return $this->correction[$indice];
	}
}
?>
