<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Dfinition de la classe ResultatFtb.
 * Cet objet est requis par la mthode endCurrentEtape() des objets
 * drivs de la classe DoEvaluation.
 * Dfini les valeurs ncessaires  la fin de l'Evaluation et fourni des mthodes
 * de d'initialisation et de vrification de ces valeurs.
 * 
 * @package ftb
 */
class ResultatFtb extends ResultatSerie{
	
	/**
	 * @var string La chaine rsultat du ftb
	 */
	var $reponse;
	
	/**
	 * Constructeur.
	 * Initialise si besoin les attributs de la classe.
	 */
	function ResultatFtb(){
		
	}
	
	/**
	 * Affecter les valeurs des attributs de l'objet.
	 * @param $reponse array Le tableau rsultat du ftb
	 */	
	function init($reponse){
		// Les reponse NULL entre cote
		$tab_reponses=array();
		while(list($cle,$val)=each($reponse)){
			if(empty($val))
				$val='NULL';
			$tab_reponses[]="'".$val."'";
		}
		
		$this->reponse=$tab_reponses;
	}
	
	/**
	 * Vrifie les valeurs des attributs.
	 * @param object QuestionReponse $ftb Evaluation associe au Resultat.
	 * @param integer la langue ams
	 * @return boolean true si les valeurs sont correctes, false sinon.
	 */
	function verify($ftb){
		
		if(!is_array($this->reponse)|| (count($this->reponse)!=($ftb->getNbBlancs())))
			return false;
		return true;
	}
}
?>
