<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

class FichierGlossaire{
	
	var $id;
	var $libelle;
	
	function FichierGlossaire($id, $libelle="" ){
		if(!empty($id)){
			$res_glossaire=get_fichier($id);
			$row_glossaire=pg_fetch_row($res_glossaire);
			$this->id=$row_glossaire[0];
			$this->libelle=$row_glossaire[1];
		}else{
			$this->id=$id;
			$this->libelle=$libelle;
		}
	}
	
	function getLibelle(){
		return $this->libelle;
	}
	
	function getId(){
		return $this->id;
	}
	
	function insertToDB($theme){
		$this->id=set_glossaire($this->libelle);
	}
	
	function getEntries(){
		return get_glossaire_fichiers($this->getGlossaire());
	}
	
	function getGlossaire(){
		$res=get_fichier_glossaire($this->id);
		$row=pg_fetch_row($res);
		return $row[6];
	}
	
	function getWords(){
		$res_fichiers=$this->getEntries();
		$glossary_words=array();
		while($row_fichiers_ressources_textes=pg_fetch_row($res_fichiers)){
			$mot_entree_glossaire=get_fo_libelle($row_fichiers_ressources_textes[1]);
			$first_letter=substr($mot_entree_glossaire,0,1);

			$glossary_words[$first_letter][]=array($row_fichiers_ressources_textes[0],$mot_entree_glossaire,$row_fichiers_ressources_textes[2],$row_fichiers_ressources_textes[3]);
			
			ksort($glossary_words,SORT_STRING);
		}
		return $glossary_words;
	}
	
	function getSections(){
		return array_keys($this->getWords());
	}
}
?>
