<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Created on 05 janvier 2009
 * @package glossaire
 * @modulegroup plpgsql
 * @module plpgsql_glossaire
 */

/**
 * Obtenir les informations d'un glossaire
 * 
 * @param integer : le numero du glossaire
 * @return integer : resultat de la requete (id int4, libelle varchar)
 */
function get_glossaire($glossaire){
	if(VERSION_BASE>VERSION){
        $req="SELECT * FROM contraintes.af_get_glossaire($glossaire) AS (id int4, libelle varchar)";
		//echo "$req<br>";
        return pg_query($req);
    }
}

/**
 * Obtenir les informations d'un glossaire � partir d'un fichier glossaire
 * 
 * @param integer : le numero du fichier glossaire
 * @return integer : resultat de la requete (id int4, libelle varchar)
 */
function get_fichier_glossaire($fichier_glossaire){
	if(VERSION_BASE>VERSION){
        $req="SELECT * FROM contraintes.af_get_fichier_glossaire($fichier_glossaire) AS (id int4, libelle varchar, type int4, connecte bool, date_modification date,libelle_glossaire varchar, glosssaire int4)";
		//echo "$req<br>";
        return pg_query($req);
    }
}

/**
 * Enregistre un glossaire
 * @param string : libelle
 * @return integer : le numero du glossaire
*/
function set_glossaire($libelle){
	$req="select * from contraintes.af_set_glossaire('$libelle')";
	
	$res=pg_query($req);
	if($res)
		return pg_fetch_result($res,0,0);
	else
		return null;	
	
}

/**
 * Retourn les glossaires pour un theme
 * @param integer : theme
 * @return integer : res req
 */
 function get_theme_glossaires($theme){
 	$req="select * from contraintes.af_get_theme_glossaires($theme) as (id int4,libelle varchar)";
 	return pg_query($req);
 }
 
 /**
  * Associe un glossaire � un fichier
  * @param integer : glossaire
  * @param integer : fichier
  * @return res req
  */
  function set_glossaire_fichier($glossaire,$fichier){
  	$req="select * from contraintes.af_set_glossaire_fichier($glossaire,$fichier)";
  	return pg_query($req);
  }
  
  /**
   * Retourne les fichier mots cles pour un glossaire
   * @param integer glossaire
   * @return res req
   */
   function get_glossaire_fichiers($glossaire){
   		$req="select * from contraintes.af_get_glossaire_fichiers($glossaire) as (id integer,libelle varchar,type integer,connecte bool)";
//   		echo "$req";
   		return pg_query($req);
   }
   

?>