<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
Fichier de dfinition de la classe Grille

La connexion  la base de donnes doit tre $db

@author LADJANI said <sladjani@afide.fr>
@since 29/03/2005

@package grille
*/
class Grille
{

        /**
        * @var integer  Identifiant en base de donnes
        */
        var $id ;

        /**
        * @var string : Libell de la grille
        */
        var $libelle ;

        /**
        * @var integer  numro de thme
        */
        var $num_theme ; //  l'avenir theme = new Theme(...)

        /**
        * @var array  Les titres capacite de la grille
        */
        var $sesTitrecapacites ;


        /**
        * Constructeur de la classe grille
        * @param mixed Integer, identifiant de l'enregistrement en BD ou string, Libell
        * @param integer : identifiant du thme en base de donnes
        */
        function Grille($num_ou_lib, $theme=0)
        {
                 // On determine le type du paramtre  l'aide d'une expression regulire (on reoit toujours une String en php si c'est une rsultat de BD)
                $une_chaine  = ereg("[^0-9]",$num_ou_lib) ;

                // Deux constructions diffrentes selon le type du paramtre ( refaire le jour o on pourra surcharger les fonctions !!!)
                if(!$une_chaine)
                {
                        $this->id = $num_ou_lib ;
                        // echo "Class Salle : constructeur avec identifiant<br>" ;
                        /*
                        $requete="SELECT * FROM grille WHERE num_grille=$num_ou_lib" ;
                        $result=pg_query($requete) ;
                        */
                        $result=get_grille($num_ou_lib);
                        $row=pg_fetch_row($result) ;
                        $this->libelle = $row[1] ;
                        //$this->num_theme = $row["theme"] ;
						$restheme=get_grille_themes(15,$num_ou_lib);
						$this->num_theme=pg_fetch_result($restheme,0,0);
                        // Construction du tableau sesTitrecapacites
                        $this->sesTitrecapacites = array() ;
                        /*
                        $sql="select gt_num_titrecapacite from grilletitrecapa where gt_num_grille=$this->id";
                        $res=pg_query($sql);
                        */
                        $res=get_grille_titrecapacites($this->id);
                         while($row = pg_fetch_row($res)){
                            //$this->sesTitrecapacites[] = new Titrecapacite($row["gt_num_titrecapacite"]) ;
                            $this->sesTitrecapacites[] = new Titrecapacite($row[0]) ;
                         }

                }
                // Construction  partir d'un nom
                else
                {
                       $this->libelle = $num_ou_lib ;
                       $this->num_theme = $theme;
                       $this->sesTitrecapacites=array();
                }

        }
        // ------------------------------------------------------------------------------------------------------------------- fin Grille()

        /**
        * Fonction qui insre un enregistrement en table grille et qui retourne l'identifiant de la ligne cre
        * On retourne l'identifiant de la ligne cre. Si l'insertion a chou, on retourne 0
        * @return integer : identifiant de l'enregistrement cre ou un code erreur ngatif
        */
        function insertToDB()
        {
                // On n'insre une ligne que si l'organisme n'existe pas dj
                if($this->libelle=="")
                {
                        return (-110) ; // libell vide
                }
                // Le libell est correcte
                else
                {
                        //$lib=addslashes($this->libelle) ;
                        $lib=$this->libelle ;
                        // Cet organisme existe-il dj ?
                        //if(pg_num_rows(pg_query("SELECT num_grille FROM grille WHERE libelle_grille='$lib'"))>0)
                        if(check_grille($lib,$this->num_theme))
                        {
                                return (-111);  // organisme existe dj
                        }
                        else
                        {
                                //$insertion = "INSERT INTO grille (libelle_grille,theme) VALUES ('$lib','".$this->num_theme."')" ;
                                $insertion=set_grille(set_ams_libelle($lib),$this->num_theme);

                                // On retourne un boolen
                                //if($res = pg_query($insertion))
                                if($insertion)
                                {
                                        /*
                                        $tmp = pg_result(pg_query("SELECT num_grille FROM grille WHERE libelle_grille='$lib'"),0,0) ;
                                        // on retourne l'identifiant de la ligne cre
                                        return($tmp);
                                        */
                                        return $insertion;
                                }
                                else
                                        return (-1) ; // Problme requte
                        }
                }
        }
        // ------------------------------------------------------------------------------------------------------------------- fin insertToDB()

        /**
        * Fonction qui met  jour l'enregistrement en table grille
        *
        * Fonction qui met  jour l'enregistrement en table grille
        * Cette fonction ne peut tre utilise que si l'objet possde un identifiant.
        *
        * @return integer : On retourne 1 si l'opration s'est correctement effectue. Autrement on retourne un code erreur
        */

        function updateToDB()
        {
                // Il faut que l'identifiant soit connu
                if($this->id != 0)
                {
                        //$update = "UPDATE grille SET libelle_grille = '".addslashes($this->libelle)."' WHERE num_grille=$this->id" ;
                        //$lib=addslashes($this->libelle) ;
                        $lib=$this->libelle ;
                        $update=maj_grille($this->id,set_ams_libelle($lib));

                        // echo "Class Grille : updateToDB. Requete =<br>$update<br>" ;

                        // On retourne un boolen
                        //if(pg_query($update))
                        if($update)
                                return true ;
                        else
                                return -1 ; // erreur base de donnes
                }
                // Identifiant inconnu : mise  jour impossible
                else
                {
                        return -2 ;
                }
        }
        // ------------------------------------------------------------------------------------------------------------------- fin updateToDB()

        /**
        * Procdure qui supprime les association grille / titrecapacite en base
        * Cette fonction ne peut tre utilise que si l'objet possde un identifiant.
        * @return integer : On retourne 1 si l'opration s'est correctement effectue. Autrement on retourne un code erreur
        */

        function removeToDB(){
            // Il faut que l'identifiant soit connu
            if($this->id != 0){
                // suppression des associations grille / titrecapacite
                if(remove_grille($this->id)){
                    $sesTitrecapacite=array();
                    return true;
                }
                else
                    return -1;
            }
            else{
                // Identifiant inconnu : suppression impossible
                return -2;
            }
        }
         // ------------------------------------------------------------------------------------------------------------------- fin removeToDB()

        /**
        * Procdure qui supprime l'enregistrement en base
        * Cette fonction ne peut tre utilise que si l'objet possde un identifiant.
        * @return integer : On retourne 1 si l'opration s'est correctement effectue. Autrement on retourne un code erreur
        */

        function deleteToDB(){
            // Il faut que l'identifiant soit connu
            if($this->id != 0){

                // suppression de la grille
                if(del_grille($this->id)){
                    $sesTitrecapacites=array();
                    return true;
                }
                else
                    return -1;  // erreur base de donnes
            }
            else{
                // Identifiant inconnu : suppression impossible
                return -2;
            }
        }
         // ------------------------------------------------------------------------------------------------------------------- fin deleteToDB()

        /**
        * Fonction qui retourne un titre de capacite de la grille
        * @param integer $indice indice du titrecapacite dans le tableau sesTitrecapacites (de 0  nbExercices -1). Si on ne met rien, on retourne le tableau entier
        * Enfin, si l'indice est incohrent on retourne faux (pour utilisation dans une boucle while)
        * @return object Titrecapacite : Titrecapacite au rang $indice+1
        */
        function getTitrecapacite($indice=0)
        {
                // Si $indice n'est pas valu alors on retourne le tableau entier
                if(func_num_args()==0)
                //if(empty($indice))
                {
                    //echo "coucou<br>";
                        return $this->sesTitrecapacites ;
                }
                // Sinon on analyse la valeur $indice
                else
                {
                        // Est-ce que $indice est cohrent ?
                        if($indice>=0 && $indice < count($this->sesTitrecapacites) ){
                            //print_r($this->sesTitrecapacites[$indice]);
                                return ($this->sesTitrecapacites[$indice]) ;
                        }
                        else
                                return false ;
                }
        }
        // ------------------------------------------------------------------------------------------------------------------- fin getTitrecapacite($indice)

        /**
        * Donne le nombre de titrecapacites d'une grille
        * Selon le paramtre pass, on donne le nombre d'exercice d'un type prcis. Pour avoir le nombre total d'exercices, on ne passe aucun
        * paramtre.

        * @return integer : Nombre d'exercices de la srie
        */
        function getNbTitrecapacites()
        {
                return count($this->sesTitrecapacites) ;
        }


        /**
        * Procdure qui ajoute un titre de capacite  la grille
        * Cette fonction ne peut tre utilise que si l'objet possde un identifiant.
        * @param integer : numro du titrecapacite  ajouter

        */

        function ajoutElement($id_titrecapacite)
        {
                // echo "Class Serie : ajoutExercice()<br>";
                if($this->id)
                {
                    /*
                    $insert = "INSERT INTO grilletitrecapa(gt_num_grille,gt_num_titrecapacite)
                                    VALUES ($this->id, $id_titrecapacite)" ;
                    */
                    $insert=set_grille_titrecapacite($this->id, $id_titrecapacite);

                    //echo $insert ;
                    //pg_query($insert) ;

                    // Mise  jour du tableau
                    $this->sesTitrecapacites[] = new Titrecapacite($id_titrecapacite) ;

                }
                else
                        echo "Erreur numro de grille inconnu<br>";
        }
        // ------------------------------------------------------------------------------------------------------------------- fin ajoutTitrecapacite($id_titrecapacite)

        /**
        * Procdure qui retire un titre de capacite de la grille
        * Cette fonction ne peut tre utilise que si l'objet possde un identifiant.
        * @param integer : n du titre de capacite
        */

        function retireElement($id_titrecapacite)
        {
            if($this->id && $id_titrecapacite){
                /*
                $sql="delete from grilletitrecapa where gt_num_titrecapacite=$id_titrecapacite and gt_num_grille=$this->id";
                $del=pg_query($sql);
                */
                $del=del_grille_titrecapacite($this->id,$id_titrecapacite);

            }
            else
                        echo "Erreur paramtre retireTitrecapacite()<br>";
        }
         // ------------------------------------------------------------------------------------------------------------------- fin retireTitrecapacite($id_titrecapacite)


        /**
        * Fonction qui retourne une chane de caractre contenant des informations sur l'objet
        *
        * Si on ne passe aucun paramtre, la chane retourne contient le nom. Par contre, si le paramtre est dfini,
        * il est utilis comme format de retour. Cet fonction peut servir d'accesseur sur les attributs de la classe.
        * @param string : le paramtre determine ce qu'on retourne. Les informations disponibles sont :
        * [id_test] (gal  [id_serie]) & [type_test]
        * @return string : On retourne la chane de caractres cre  partir du format
        */
        function toString($format="")
        {
                // Aucun paramtre, on retourne le titre de la srie
                if($format=="")
                        return $this->libelle ;

                // Ce tableau contient tous les pattern et les nouvelles valeurs
                $tab_replace = array("\[libelle\]"=>"$this->libelle","\[id\]"=>"$this->id","\[num_theme\]"=>"$this->num_theme") ;

                while($tab=each($tab_replace))
                        $format = ereg_replace($tab[0],$tab[1],$format) ;

                return $format ;
        }
        // ------------------------------------------------------------------------------------------------------------------- fin toString($format)

        /**
        *   Obtenir un tableau contenant les numeros et libelles des titres de capacite affiliables

        *   @return integer[] : le tableau resultat(id,libelle)
        */
        function getElementsAffiliables(){
            /*
            $sql="select * from titrecapacite where num_titrecapacite in
                    (select tr_num_titrecapacite from titrecapa) and num_titrecapacite not in
                    (select gt_num_titrecapacite from grilletitrecapa where gt_num_grille=$this->id) and theme=$this->num_theme order by libelle_titrecapacite";
            $res=pg_query($sql);
            */
            $res=get_grille_titrecapacites_disponibles($this->id, $this->num_theme);
            $tab=array();
            while($row=pg_fetch_array($res)){
                $tab[$row[0]]=$row[1];
            }
            return $tab;

        }

        function getId() { return $this->id ; }
        function getNumTheme() { return $this->num_theme ; }

}
?>