<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

 /**
       @package grille
       @modulegroup plpgsql
       @module plpgsql_grille
*/



/*-----------------------------------------------------------------------------------------*/
//                         LES FONCTIONS  D'ACCESS AUX FONCTIONS PLPGSQL
/*-----------------------------------------------------------------------------------------*/
/*
                            DOIVENT RETOURNER UNE VARIABLE
*/
/*
CONVENTION DE NOMAGE :
Il faut tablir une correspondance entre le nom de la fonction php et le nom de la fonction
PLPGSQL. Ainsi, on utilisera le meme nom pour les 2 fonctions, a ceci prs que le nom de
 la fonction PLPGSQL est precede de _af_ afin de la distinguer des fonctions systeme.
Exemple:

la fonction php function check_access($droit, $cal, $user) correspond  _af_check_access dans la base

*/

/**
*   Vrifier si un nom de grille est unique pour un mme thme  (OLD)
*
    @deprecated : utiliser check_grille($libelle,$theme)
*   @param integer : numero du theme
*   @param string : nom de la grille
*   @return integer : numero de la grille si existe, 0 sinon
*/
function check_libelle_grille_old($libelle_grille,$theme){
    $sql="select * from grille where libelle_grille='$libelle_grille' and theme=$theme";
    $res=pg_query($sql);
    if(pg_numrows($res)==0)
        return 0;
    $row=pg_fetch_row($res,0);
    return $row[0];
}
/**
*   Vrifier si un nom de grille est unique pour un mme thme
*
    @deprecated : utiliser check_grille($libelle,$theme)
*   @param integer : numero du theme
*   @param string : nom de la grille
*   @return integer : numero de la grille si existe, 0 sinon
*/
function check_libelle_grille($libelle_grille,$theme){
    if(VERSION_BASE>VERSION){
        //print("A IMPLEMENTER");
		// pas tester pour le moment
		return false;
    }
    else
        return check_libelle_grille_old($libelle_grille,$theme);
}

/**
*   Vrifier si un nom de grille est unique pour un mme thme  (OLD)
*
*   @param integer : numero du theme
*   @param string : nom de la grille
*   @return integer : numero de la grille si existe, 0 sinon
*/
function check_grille_old($libelle,$theme){
    $sql="select * from grille where libelle_grille='$libelle' and theme=$theme";
    $res=pg_query($sql);
    if(pg_numrows($res)==0)
        return 0;
    $row=pg_fetch_row($res,0);
    return $row[0];
}
/**
*   Vrifier si un nom de grille est unique pour un mme thme
*
*   @param integer : numero du theme
*   @param string : nom de la grille
*   @return integer : numero de la grille si existe, 0 sinon
*/
function check_grille($libelle,$theme){
    if(VERSION_BASE>VERSION){
        //print("A IMPLEMENTER");
		// pas tester pour le moment
		return false;
    }
    else
        return check_grille_old($libelle,$theme);
}

/**
*   Supprimer une grille.  (OLD)
*
*   Supprime la grille

*
*   @param integer : numero de la grille  supprimer
*   @return integer : 1
*/
function del_grille_old($grille){
    //suppression
    remove_grille($grille);
    $del=pg_query("delete from grille where num_grille=$grille;");

    return 1;
}

/**
*   Supprimer une grille.
*
*   Supprime la grille
*
*   @param integer : numero de la grille  supprimer
*   @return integer : 1
*/
function del_grille($grille){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_del_grille($grille)";
		$res=pg_query($sql);
	}
    else
		$res=del_grille_old($grille);
	return ($res);
}

/**
*   Supprimer les associations grille / titrecapacite.  (OLD)
*
*   Supprime les associations grille / titrecapacite

*
*   @param integer : numero de la grille
*   @return integer : 1
*/
function remove_grille_old($grille){

    //suppression
    $del=pg_query("delete from grilletitrecapa where gt_num_grille=$grille;");

    return 1;
}

/**
*   Supprimer les association grille / titrecapacite
*
*   Supprime les associations  grille / titrecapacite
*
*   @param integer : numero de la grille
*   @return integer : 1
*/
function remove_grille($grille){

            if(VERSION_BASE>VERSION)
            {
                print("A IMPLEMENTER");
            }
            else
                $res=remove_grille_old($grille);

            return ($res);
}

/**
*   Vrifier si un couple grille / titrecapacite est unique   (OLD)
*
*   @param integer : numero du titre de capacite
*   @param string : nom de la grille
*   @return integer : 1 si existe, 0 sinon
*/
function check_grilletitre_old($grille,$titrecapacite){
    $sql="select * from grilletitrecapa where gt_num_grille=$grille and gt_num_titrecapacite=$titrecapacite";
    $res=pg_query($sql);
    if(pg_numrows($res)==0)
        return 0;
    $row=pg_fetch_row($res,0);
    return 1;
}
/**
*   Vrifier si un couple grille / titrecapacite unique
*
*   @param integer : numero du titre de capacite
*   @param string : nom de la grille
*   @return integer : 1 si existe, 0 sinon
*/
function check_grilletitre($grille,$titrecapacite){
    if(VERSION_BASE>VERSION){
        //print("A IMPLEMENTER");
    }
    else
        return check_grilletitre_old($grille,$titrecapacite);
}

/**
    Verifie si une grille a t note (OLD)
	@deprecated : utiliser check_grille_supprimable
    @param integer : le numero de grille
    @return bool : true si note , false sinon
*/
function check_grille_notee_old($grille){
    $sql="select * from notation where num_grille=$grille";
    $res=pg_query($sql);
    if(pg_num_rows($res)==0)
        return false;
    else
        return true;
}
/**
    Verifie si une grille a t note
    @deprecated : utiliser check_grille_supprimable
    @param integer : le numero de grille
    @return bool : true si note , false sinon
*/
function check_grille_notee($grille){
    if(VERSION_BASE>VERSION){
        print("A IMPLEMENTER");
    }
    else
        return check_grille_notee_old($grille);
}

/**
    Verifie si un titrecapaci est not pour une grille donne (OLD)
    @deprecated : utiliser check_grille_titrecapacite_supprimable
    @param integer : le numero de la grille
    @param integer : le numero du titre de capacite
    @return bool : true si not , false sinon
*/
function check_grille_titrecapacite_notee_old($grille,$titrecapacite){
    $sql="select * from notation where num_titrecapacite=$titrecapacite and num_grille=$grille";
    $res=pg_query($sql);
    if(pg_num_rows($res)==0)
        return true;
    else
        return false;
}
/**
    Verifie si un titrecapaci est not pour une grille donne
	@deprecated : utiliser check_grille_titrecapacite_supprimable
    @param integer : le numero de la grille
    @param integer : le numero du titre de capacite
    @return bool : true si not , false sinon
*/
function check_grille_titrecapacite_notee($grille,$titrecapacite){
    if(VERSION_BASE>VERSION){
        print("A IMPLEMENTER");
    }
    else
        return check_grille_titrecapacite_notee_old($grille,$titrecapacite);
}

/**
	Obtenir les titre de capacite pour une grille (OLD)

 	@param integer : le numero de la grille
 	@return integer : le resultat de la requete
*/
function get_grille_titrecapacites_old($grille){
	$sql="select num_titrecapacite,libelle_titrecapacite from titrecapacite where num_titrecapacite in
			(select gt_num_titrecapacite from grilletitrecapa where gt_num_grille=$grille) order by libelle_titrecapacite";
   return (pg_query($sql));
}
/**
	Obtenir les titre de capacite pour une grille

 	@param integer : le numero de la grille
 	@return integer : le resultat de la requete
*/
function get_grille_titrecapacites($grille){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_get_grille_capacites_titres($grille) as (id int4,libelle varchar,grille int4)";
		$res=pg_query($sql);
    }
    else
        return get_grille_titrecapacites_old($grille);
	return $res;
}

/**
	Obtenir les infos d'une grille (OLD)
    @deprecated : utiliser get_grille
 	@param integer : le numero de la grille
	@return integer : le resultat de la requete
*/
function get_grille_infos_old($grille){
	$sql="select * from grille where num_grille=$grille";
 	return (pg_query($sql));
}
/**
	Obtenir les infos d'une grille
    @deprecated : utiliser get_grille
 	@param integer : le numero de la grille
	@return integer : le resultat de la requete
*/
function get_grille_infos($grille){
	if(VERSION_BASE>VERSION){
        print("A IMPLEMENTER");
    }
    else
        return get_grille_infos_old($grille);
}

/**
    Enregistre une grille (OLD)

    @param string : le nom de la grille
    @param integer : le numero du theme
    @return integer : le numero de la grille ,0 si erreur
*/
function set_grille_old($libelle,$theme){
    $sql="INSERT INTO grille (libelle_grille,theme) VALUES ('$libelle',$theme)" ;
    $ins=pg_query($sql);
     if($ins){
        $oid=pg_getlastoid($ins);
        $res=pg_query("select num_grille from grille where oid=$oid");
        return pg_result($res, 0, 0);
    }
    else
        return 0;
}
/**
    Enregistre une grille

    @param string : le nom de la grille
    @param integer : le numero du theme
    @return integer : le numero de la grille ,0 si erreur
*/
function set_grille($libelle,$theme){
    if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_set_grille('$libelle')";
		$res=pg_query($sql);
		// enregistre dans theme_categories
		set_categorie_element_theme(15, $theme, pg_fetch_result($res, 0, 0));
		return pg_fetch_result($res, 0, 0);
    }
    else
        return set_grille_old($libelle,$theme);
}

/**
    Mettre  jour une grille (OLD)

    @param integer : le numero de la grille
    @param string : le nom de la grille
    @return integer : le resultat de la requete
*/
function maj_grille_old($grille,$libelle){
    $sql="UPDATE grille SET libelle_grille ='$libelle' WHERE num_grille=$grille" ;
    return pg_query($sql);
}
/**
    Mettre  jour une grille

    @param integer : le numero de la grille
    @param string : le nom de la grille
    @return integer : le resultat de la requete
*/
function maj_grille($grille,$libelle){
    if(VERSION_BASE>VERSION){
        $sql="select * from contraintes.af_maj_grille($grille,'$libelle')";
		$res=pg_query($sql);
    }
    else
        return maj_grille_old($grille,$libelle);
	return $res;
}

/**
    Enregistre le couple grille / titrecapacite (OLD)

    @param integer : le numero de la grille
    @param integer : le numero du titrecapacite
    @return integer : le resultat de la requete
*/
function set_grille_titrecapacite_old($grille,$titrecapacite){
    $sql="INSERT INTO grilletitrecapa(gt_num_grille,gt_num_titrecapacite) VALUES ($grille, $titrecapacite)" ;
    return pg_query($sql);
}
/**
    Enregistre le couple grille / titrecapacite

    @param integer : le numero de la grille
    @param integer : le numero du titrecapacite
    @return integer : le resultat de la requete
*/
function set_grille_titrecapacite($grille,$titrecapacite){
    if(VERSION_BASE>VERSION){
        $sql="select * from contraintes.af_set_grille_capacite_titre($grille,$titrecapacite)";
		//echo "sql=$sql<br>";
		$res=pg_query($sql);
    }
    else
        return set_grille_titrecapacite_old($grille,$titrecapacite);
	return $res;
}

/**
    Supprime le couple grille / titrecapacite (OLD)

    @param integer : le numero de la grille
    @param integer : le numero du titrecapacite
    @return integer : le resultat de la requete
*/
function del_grille_titrecapacite_old($grille,$titrecapacite){
    $sql="delete from grilletitrecapa where gt_num_titrecapacite=$titrecapacite and gt_num_grille=$grille";
    return pg_query($sql);
}
/**
    Supprime le couple grille / titrecapacite

    @param integer : le numero de la grille
    @param integer : le numero du titrecapacite
    @return integer : le resultat de la requete
*/
function del_grille_titrecapacite($grille,$titrecapacite){
    if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_del_grille_capacite_titre($grille,$titrecapacite)";
		$res=pg_query($sql);
    }
    else
        return del_grille_titrecapacite_old($grille,$titrecapacite);
	return $res;
}

/**
    Obtenir les titres de capacites disponibles pour une grille et un theme (OLD)

    @param integer : le numero de la grille
    @param integer : le numero du theme
    @return integer : le resultat de la requete
*/
function get_grille_titrecapacites_disponibles_old($grille,$theme){
    $sql="select * from titrecapacite where num_titrecapacite in
            (select tr_num_titrecapacite from titrecapa) and num_titrecapacite not in
            (select gt_num_titrecapacite from grilletitrecapa where gt_num_grille=$grille) and theme=$theme order by libelle_titrecapacite";
    return pg_query($sql);

}
/**
    Obtenir les titres de capacites disponibles pour une grille et un theme

    @param integer : le numero de la grille
    @param integer : le numero du theme
    @return integer : le resultat de la requete
*/
function get_grille_titrecapacites_disponibles($grille,$theme){
     if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_get_grille_capacites_titres_disponibles($grille,$theme) as (id int4,libelle varchar,grille int4)";
//		echo $sql;
		$res=pg_query($sql);
    }
    else
        return get_grille_titrecapacites_disponibles_old($grille,$theme);
	return $res;
}

/**
	Teste si une grille est supprimable (OLD)
	@param integer : numero grille
	@return bool : true supprimable, false non supprimable
*/
function check_grille_supprimable_old($grille){
	$sql="select * from notation where num_grille=$grille";
    $res=pg_query($sql);
    if(pg_num_rows($res)==0)
        return false;
    else
        return true;
}
 /**
	Teste si une grille est supprimable
	@param integer : numero grille
	@return bool : true supprimable, false non supprimable
*/
function check_grille_supprimable($grille){
	if(VERSION_BASE>VERSION){
		 $res=!fk_finder('grille','id',$grille);
	}
	else
		$res=check_grille_supprimable_old($grille);
	return $res;
}

/**
	Obtenir les infos d'une grille (OLD)
    @param integer : le numero de la grille
	@return integer : le resultat de la requete
*/
function get_grille_old($grille){
	$sql="select * from grille where num_grille=$grille";
 	return (pg_query($sql));
}
/**
	Obtenir les infos d'une grille
    @param integer : le numero de la grille
	@return integer : le resultat de la requete
*/
function get_grille($grille){
	if(VERSION_BASE>VERSION){
        $sql="select * from contraintes.af_get_grille($grille) as (id int4,libelle varchar)";
		$res=pg_query($sql);
    }
    else
        return get_grille_old($grille);
	return $res;
}

/**
	Obtenir les themes d'une grille   (OLD)
	@param integer : numero categorie
	@param integer : numero grille
	@return resultat requete
*/
function get_grille_themes_old($grille){
	 $sql="select distinct num_themedir,nom_theme from themedir where num_themedir in 
				(select theme from grille where num_grille=$grille)";
	//echo "sql=$sql<br>";
	return pg_query($sql);
}
/**
	Obtenir les themes d'une grille
	@param integer : numero categorie
	@param integer : numero grille
	@return resultat requete
*/
function get_grille_themes($categorie,$grille){
	if(VERSION_BASE>VERSION){
		$res=get_categorie_element_themes($categorie,$grille);
	}
	else
		return get_grille_themes_old($grille);
	return $res;
}

/**
    Verifie si un titrecapaci est supprimable pour une grille donne (OLD)
    @param integer : le numero de la grille
    @param integer : le numero du titre de capacite
    @return bool : true si supprimable , false sinon
*/
function check_grille_titrecapacite_supprimable_old($grille,$titrecapacite){
    $sql="select * from notation where num_titrecapacite=$titrecapacite and num_grille=$grille";
    $res=pg_query($sql);
    if(pg_num_rows($res)==0)
        return 't';
    else
        return 'f';
}
/**
    Verifie si un titrecapaci est supprimable pour une grille donne
	@param integer : le numero de la grille
    @param integer : le numero du titre de capacite
    @return bool : true si supprimable , false sinon
*/
function check_grille_titrecapacite_supprimable($grille,$titrecapacite){
    if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_is_grille_capacite_titre_supprimable($grille,$titrecapacite)";
		$res=pg_query($sql);
    }
    else
        return check_grille_titrecapacite_supprimable_old($grille,$titrecapacite);
	return pg_fetch_result($res,0,0);
}

/**
	Obtenir les stagiaires pour une grille et une formation (OLD)
	@param integer : le numero de la grille
	@param integer : le numero de la formation
	@return integer : res req
*/
function get_grille_stagiaires_formation_old($grille,$formation){
	$sql="select num_user,nom,prenom from utilisateurs where num_user in 
				(select distinct num_user from notation where num_grille=$grille and num_cal=$formation)";
	return pg_query($sql);
}
/**
	Obtenir les stagiaires pour une grille et une formation 
	@param integer : le numero de la grille
	@param integer : le numero de la formation
	@return integer : res req
*/
function get_grille_stagiaires_formation($grille,$formation){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_get_grille_stagiaires_formation($grille,$formation) as (id int4,nom varchar,prenom varchar)";
		$res=pg_query($sql);		
	}
	else
		return  get_grille_stagiaires_formation_old($grille,$formation);
	return $res;
}
?>