<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
Fichier de dfinition de la Class Groupe
Cette classe dcrit un groupe. Un sous-groupe est un groupe dont l'attribut pere est un objet existant
La connexion  la base de donnes doit tre $db

@author CHABOISSIER Jonathan <jc@afide.fr>
@since 27/05/2004

@package groupe
*/
class Groupe
{

        /**
        * @var integer  Identifiant en base de donnes
        */
        var $id ;
        
        /**
        * @var string  Libell du groupe
        */
        var $libelle ;
        
        /**
        * @var object Groupe  Groupe pre de ce groupe. Existe si l'objet est un sous-groupe
        */
        var $pere ;
        
        /**
        * @var integer  Nombre de place minimum dans le groupe
        */
        var $placeMin ;
        
        /**
        * @var integer  Nombre de place maximum dans le groupe
        */
        var $placeMax ;

        /**
        * Constructeur de la classe Groupe
        *
        * On peut construire de deux faons. Soit on utilise le paramtre num pour rduprer les valeurs du groupe
        * en base de donnes, sinon on construit un groupe sans $id avec les deux autres paramtres
        *
        * @param integer $num_groupe L'identifiant en base de donnes (utilis pour rcuprer les informations en base)
        * @param string $nom_groupe Nom du groupe
        * @param object Groupe $pere_groupe Groupe pre si l'objet est un sous-groupe
        * @param integer $nbMin Nombre de place minimum
        * @param integer $nbMax Nombre de place maximum
        */
        function Groupe($num_groupe=0, $nom_groupe="" , $pere_groupe=null, $nbMin=0, $nbMax=0)
        {
                // echo "Class Groupe : constructeur<br>" ;

                // constructeur  partir d'un identifiant d'enregistrement en base de donnes (seul le numero doit tre pass)
                if($num_groupe!="" && $nom_groupe=="")
                {
                        // Requete sur base de donnes
						/*
                        $requete="SELECT nom, id_pere, maxplace, minplace
                                        FROM classe, placegroupe
                                        WHERE id=$num_groupe
                                        AND id=num_gest_groupe" ;
                        $result=pg_query($requete) ;
						*/
						$result=get_groupe_infos($num_groupe);
                        $row=pg_fetch_array($result) ;

                        // On copie la ligne dans les attributs
                        $this->id = $num_groupe ;
                        $this->libelle = $row["nom"] ;
                        $this->placeMin = $row["min"] ;
                        $this->placeMax = $row["max"] ;

                        // Si l'identifiant du pre est gal   0 ou NULL, alors l'attribut pre est vide
                        if($row["id_pere"]==0 || $row["id_pere"]=="")
                                $this->pere = "" ;
                        else
                                $this->pere = new Groupe($row["id_pere"]) ;
                }
                // constructeur avec des paramtres pour l'affectation des attributs
                else
                {
                        // Faut-il verifier la cohrence des donnes envoyes ?
                        $this->libelle = $nom_groupe ;
                        $this->pere = $pere_groupe ;
                        $this->placeMin = $nbMin ;
                        $this->placeMax = $nbMax ;
                }
        }
        // ------------------------------------------------------------------------------------------------------------------- fin Groupe($num_groupe, $nom_groupe, $pere_groupe)


        /**
        * Fonction qui insre un enregistrement en table classe et qui retourne l'identifiant de la ligne cre
        * On retourne l'identifiant de la ligne cre. Si l'insertion a chou, on retourne 0
        * @return integer : identifiant de l'enregistrement cre ou un code erreur ngatif
        */
        function insertToDB()
        {
                // Le nom ne doit pas tre vide
                if($this->libelle=="")
                {
                        return (-120) ; // libell vide
                }
                // Le libell est correcte
                else
                {
                        // Il ne peut y avoir deux groupes du mme nom au mme niveau ( la base ou avec le mme pre)
                        $lib=addslashes($this->libelle) ;

                        // Donne l'identifiant du groupe pre
                        if($this->pere != "")
                                $num_pere=$this->pere->id ;
                        else
                                $num_pere=0 ;

                        //if(pg_num_rows(pg_query("SELECT nom FROM classe WHERE nom='$lib' AND id_pere='$num_pere'"))>0)
						if(check_groupe($num_pere,$lib))
                        {
                                return (-121) ;  // groupe existe dj  cet endroit
                        }
                        else
                        {
                                //$insertion = "INSERT INTO classe (nom, id_pere) VALUES ('$lib','$num_pere')" ;
								$insertion=set_groupe($lib,$num_pere,$this->placeMin,$this->placeMax);

                                // On retourne l'identifiant cre ou un code erreur
                                //if($res = pg_query($insertion))
								if($insertion)
                                {
										/*
                                        // Rcupration de l'identifiant cr (trouver une autre mthode si possible)
                                        $tmp = pg_result(pg_query("SELECT id FROM classe WHERE nom='$lib'"),0,0) ;

                                        // On enregistrement le nombre de place dans place groupe s'ils sont tous les deux dfinis
                                        if($this->placeMin && $this->placeMax)
                                                pg_query("INSERT INTO placegroupe (num_gest_groupe, minplace, maxplace) VALUES ('$tmp','$this->placeMin','$this->placeMax')") ;

                                        // on retourne l'identifiant de la ligne cre
                                        return($tmp);
										*/
										return $insertion;
                                }
                                else
                                        return (-1) ; // Problme requte
                        }
                }
        }
        // ------------------------------------------------------------------------------------------------------------------- fin insertToDB()

        /**
        * Fonction qui met  jour l'enregistrement en table classe
        * Fonction qui met  jour l'enregistrement en table classe
        * Cette fonction ne peut tre utilise que si l'objet possde un identifiant.
        * @return integer : On retourne 1 si l'opration s'est correctement effectue. Autrement on retourne un code erreur
        */

        function updateToDB()
        {
                // echo "Class Groupe : updateToDB()<br>";
                // Il faut que l'identifiant soit connu
                if($this->id != 0)
                {
                        //$update = "UPDATE classe SET nom = '".addslashes($this->nom)."' WHERE id=$this->id" ;
						$lib=addslashes($this->libelle) ;
						$update=maj_groupe($this->id,$lib,$this->pere);

                        // On retourne un boolen
                        //if(pg_query($update))
						if($update)
                                return true ;
                        else
                                return -1 ; // erreur base de donnes
                }
                // Identifiant inconnu : mise  jour impossible
                else
                {
                        return -2 ;
                }
        }
        // ------------------------------------------------------------------------------------------------------------------- fin updateToDB()


        /**
        * Fonction qui retourne une chane de caractre contenant des informations sur l'objet
        *
        * Fonction qui retourne une chane de caractre contenant des informations sur l'objet.
        * Si on ne passe aucun paramtre, la chane retourne contient le nom. Par contre, si le paramtre est dfini,
        * il est utilis comme format de retour. Cet fonction peut servir d'accesseur sur les attributs de la classe.
        * (Attention cela retourne un affichage seulement... toString("P") ne retourne pas l'objet pre !)
        *
        * @param string : le paramtre determine ce qu'on retourne. Les informations disponibles sont :
        *       [nom],[id],[pere] retourne le nom du pre... Faire voluer si besoin du numero de prnom,[placeMin],[placeMax]
        *
        * @return string : On retourne la chane de caractres cre  partir du format
        */

        function toString($format="")
        {
                // echo "Class groupe : toString()<br>" ;

                // Aucun paramtre, on retourne le nom
                if($format=="")
                        return $this->libelle ;

                // Ce tableau contient tous les pattern et les nouvelles valeurs
                $tab_replace = array("\[nom\]"=>$this->libelle,"\[id\]"=>$this->id,"\[pere\]"=>$this->pere->libelle,"\[placeMin\]"=>$this->placeMin,"\[placeMax\]"=>$this->placeMax) ;

                while($tab=each($tab_replace))
                        $format = ereg_replace($tab[0],$tab[1],$format) ;


                return $format ;
        }
        // ------------------------------------------------------------------------------------------------------------------- fin toString($format)


        /**
        * Retourne la liste des individus du groupe
        *
        * Cette fonction permet de connaitre les individu affilis  ce groupe. Grace aux diffrents paramtre, on
        * peut dfinir clairement la catgorie des individus  rcuprer ("f", "fu", "u", "*")
        *
        * @param integer : 0 > toutes les catgories ou bien 1 > les formateurs et 2 > les stagiaires
        * @param string : ASC ou DESC selon le classement voulu
        * @param integer : Si vrai alors on ne retourne que les "f" ou "u" selon la selection, et non plus les "fu"
        *
        * @return integer : Liste d'infos d'individu : num_user, nom, prenom, categorie
        */
        function getIndividus($categorie=0, $ordre="ASC", $exclusif=0)
        {
                return get_classe_individus($this->id, $categorie, $ordre, $exclusif) ;
        }

        /**
        * Retourne la liste des formateurs du groupe
        *
        * Cette fonction permet de connaitre les formateurs affilis  ce groupe. On peut ne garder que les strictement 'f'
        *
        * @param string : ASC ou DESC selon le classement voulu
        * @param integer : Si vrai alors on ne retourne que les "f" ou "u" selon la selection, et non plus les "fu"
        *
        * @return integer : Liste d'infos d'formateurs : num_user, nom, prenom, categorie
        */
        function getFormateurs($ordre="ASC", $exclusif=0)
        {
                return get_individus_groupe($this->id, 1, $ordre, $exclusif) ;
        }

        /**
        * Retourne la liste des individus du groupe
        *
        * Cette fonction permet de connaitre les individu affilis  ce groupe. Grace aux diffrents paramtre, on
        * peut dfinir clairement la catgorie des individus  rcuprer ("f", "fu", "u", "*")
        *
        * @param string $ordre ASC ou DESC selon le classement voulu
        * @param integer $exclusif Si vrai alors on ne retourne que les "f" ou "u" selon la selection, et non plus les "fu"
        *
        * @return integer : Liste d'infos d'individu : num_user, nom, prenom, categorie
        */
        function getStagiaires($ordre="ASC", $exclusif=0)
        {
                return get_individus_groupe($this->id, 2, $ordre, $exclusif) ;
        }



        /**
        * Retourne la liste des formations du groupe
        * @param string $ordre "ASC" ou "DESC"
        * @param integer $par_date si VRAI alors on ordonne par date de dbut de formation, sinon on ordonne par nom de formation
        * @return integer Liste d'infos d'individu : num_user, nom, prenom, categorie
        */
        function getFormations($ordre="ASC", $par_date=0)
        {
                return get_formations_groupe($this->id,$ordre,$par_date) ;
        }
        
        function getLibelle(){
        	
        		return $this->libelle;
        }
        
        
}
?>