<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
   @package groupe
   @modulegroup plpgsql
   @module plpgsql_groupe
*/

/**
*obtenir le nombre de formations
*
*Retourne le nombre de formations pour le groupe et sur la periode spcifie
*dont user est le formateur.
*
*
*    @param  integer : e groupe dont on cherche le nombre de formations
*    @param  integer : le  formateur du groupe
*    @param  integer : la priode concerne 1,2,ou3
*
*     @return  integer : le nombre de formations
*/
function get_formations_groupe_formateur_periode_old($groupe, $user, $periode){

     $requete="SELECT DISTINCT G.g_num_cal
        from GESTIONNAIRE G, CALENDRIER C,  dates D,  dates D2
        where G.g_num_gest_g=$groupe
        and G.g_num_cal=C.num_cal
        and G.g_num_user=$user ";

        //selection en fonction de la periode
        if($periode==1)
            $requete.="and  datefin =D.num_date and D.jour < current_date";

        if($periode==2)
            $requete.="and datedeb=D.num_date
            and datefin =  D2.num_date
            and   current_date BETWEEN D.jour AND D2.jour";

        if($periode==3)
            $requete.="and   datedeb =D.num_date
            and D.jour > current_date";

        $formations=pg_query($requete);

    return  $formations;
}

/**
*obtenir le nombre de formations
*
*Retourne le nombre de formations pour le groupe et sur la periode spcifie
*dont user est le formateur.
*
*
*    @param  integer : le groupe dont on cherche le nombre de formations
*    @param  integer : le formateur du groupe
*    @param  integer :  la priode concerne 1,2,ou3
*
*     @return  integer : le nombre de formations
*/
function get_formations_groupe_formateur_periode($groupe, $user, $periode){

    if(VERSION_BASE>VERSION){

    $req="SELECT  * FROM _af_get_formations_groupe($groupe, $user, $periode) AS (num_cal integer);";
    
    $formations=pg_query($req);
    }
    else
        $formations=get_formations_groupe_periode_old($groupe, $user, $periode);

    return  $formations;
}

/**
*   Retourne les individus d'un groupe  (OLD)
*
*    Retourne les numero des individus d'un groupe
*   Le parametre de selection permet de retourner les individus (u, fu ou f),
*   les formateur(f ou fu) ou les stagiaires(u ou fu) Set l'ordre
*   d'avoir un classement par nom croissant ou decroissant
*   La selection exclusive permet de selectionner les individus strictement formateurs ou stictement
*   utilisateurs.
*
* 	@deprecated utiliser get_groupe_individus()
*   @param integer : numero du groupe
*   @param integer : 0 individus, 1 formateurs, 2 utilisateurs
*   @param string  : DESC sinon ASC
*   @param integer : 1 selection exclusive
*   @return integer : les numero d'utilisateur du groupe , leur nom,  prenom et categorie
*/
function get_individus_groupe_old($groupe, $selection, $ordre, $exclusif){

    if($groupe>=0&&!empty($groupe)){

     $requete="select num_user,nom,prenom,categorie from utilisateurs
    where categorie like ";
    if($selection==0) $requete.=" '%%' ";
    else {
           if($selection==1){
                if($exclusif!=1)$requete.="'%f%' ";
                else  $requete.="'f' ";
            }
            else {
                             if($selection==2){
                                if($exclusif!=1)$requete.="'%u%' ";
                                 else  $requete.="'u' ";
                            }
                            else {
                                    echo 'Erreur: la selection est incorrecte'.'['.$selection.']';
                             }
            }
    }
     $requete.=" and num_user in (select gu_num_user from gestionutil where gu_num_gest_gr='$groupe' )
        ORDER BY nom ";
     if($ordre=="DESC") $requete.=" DESC ";
     else  $requete.=" ASC ";
     $requete.=", prenom ASC;";

     //debug echo $requete;
     $individus=pg_query($requete);

    return  $individus;
    } else{

     //echo 'Erreur: le numero de groupe est incorrect'.'['.$groupe.']';
     return null;
    }
}

/**
*   Retourne les individus d'un groupe  (OLD)
*
*    Retourne les numero des individus d'un groupe
*   Le parametre de selection permet de retourner les individus (u, fu ou f),
*   les formateur(f ou fu) ou les stagiaires(u ou fu) Set l'ordre
*   d'avoir un classement par nom croissant ou decroissant .
*   La selection exclusive permet de selectionner les individus strictement formateurs ou stictement
*   utilisateurs.
*
*	@deprecated utiliser get_groupe_individus()
*   @param integer : numero du groupe
*   @param integer : 0 individus, 1 formateurs, 2 utilisateurs
*   @param string  : DESC sinon ASC
*   @param integer : 1 selection exclusive
*   @return integer : les numero d'utilisateur du groupe , leur nom,  prenom et categorie
*/
function get_individus_groupe($groupe, $selection, $ordre, $exclusif=0){
      
    if(VERSION_BASE>VERSION){

        $req="SELECT  * FROM _af_get_individus_groupe($groupe, $selection, '$ordre',  $exclusif) AS (num_user integer ,nom varchar ,prenom varchar ,categorie varchar);";
		echo "req=$req";
        $individus=pg_query($req);
    }
    else
        $individus=get_individus_groupe_old($groupe, $selection, $ordre, $exclusif) ;

    return  $individus;
}


/**
*   Supprime un individu d'un groupe pour une formation. (OLD)
*   Normalement, cette fonction de substitution est inutile, mais la
*   fonc plpgsql semble ne pas fonctionner
*
*   Supprime l'individu du groupe, de la formation et supprime le
*   groupe si l'individu est le dernier du groupe
*   Si le numero de formation est  negatif, supprime seulement lindividu du groupe.
*
*   @param integer : numero de l'individu
*   @param integer : numero du groupe
*   @param integer : numero de la formation
*   @return : 1 OK, 0 erreur
*/
function  del_individu_groupe_OLD($individu, $groupe, $formation){


$req1="delete from gestionutil where gu_num_user=$individu and gu_num_gest_gr=$groupe;";
pg_query($req1);

$req2= "select * from gestionutil where gu_num_gest_gr=$groupe;";
$res2=pg_query($req2);

if(pg_num_rows($res2)<=0){

    $req3="delete from gestionnaire where g_num_gest_g=$groupe";
    $res3=pg_query($req3);
}

    return  $req1;
}

/**
*   Supprime un individu d'un groupe pour une formation.
*
*   Supprime l'individu du groupe, de la formation et supprime le
*   groupe si l'individu est le dernier du groupe
*   Si le numero de formation est  negatif, supprime seulement lindividu du groupe.
*
*   @param integer : numero de l'individu
*   @param integer : numero du groupe
*   @param integer : numero de la formation
*   @return : 1 OK, 0 erreur
*/
function  del_individu_groupe($individu, $groupe, $formation="null"){

	if(empty($formation))$formation="null";

    if(VERSION_BASE>VERSION){
        $req="SELECT   _af_del_individu_groupe( $individu,  $groupe, $formation) ;";
        //echo $req;
        $ok=pg_query($req);
    }
    else $ok=del_individu_groupe_OLD($individu, $groupe, $formation);
    return  $ok;
}



/**
*   Retourne le nombre de places d'un groupe (OLD)
*
*    Retourne le nombre de places min et max
*
*	@deprecated : utiliser get_groupe_places
*   @param integer : numero du groupe
*   @return integer : le min et le max
*/
function get_places_groupe_old($groupe){

    if($groupe>=0&&!empty($groupe)){

     $requete="select minplace,maxplace from placegroupe where num_gest_groupe=$groupe;";

     $places=pg_query($requete);

    return  $places;
    } else{

     echo 'Erreur: le numero de groupe est incorrect'.'['.$groupe.']';
     return null;
    }
}
/**
*   Retourne le nombre de places d'un groupe
*
*    Retourne le nombre de places min et max
*
*	@deprecated : utiliser get_groupe_places
*   @param integer : numero du groupe
*   @return integer : le min et le max
*/
function get_places_groupe($groupe){

    if(VERSION_BASE>VERSION){

        $req="SELECT  * FROM _af_get_places_groupe($groupe) AS (min integer, max integer);";
        $places=pg_query($req);
    }
    else
        $places=get_places_groupe_old($groupe) ;
    return  $places;
}

/**
*   Retourne le nombre de places d'un groupe (OLD)
*
*    Retourne le nombre de places min et max
*
*	@deprecated : utiliser get_groupe_places
*   @param integer : numero du groupe
*   @return integer : le min et le max
*/
function get_groupe_places_old($groupe){

    if($groupe>=0&&!empty($groupe)){

     $requete="select minplace,maxplace from placegroupe where num_gest_groupe=$groupe;";

     $places=pg_query($requete);

    return  $places;
    } else{

     echo 'Erreur: le numero de groupe est incorrect'.'['.$groupe.']';
     return null;
    }
}
/**
*   Retourne le nombre de places d'un groupe
*
*    Retourne le nombre de places min et max
*
*	@deprecated : utiliser get_groupe_places
*   @param integer : numero du groupe
*   @return integer : le min et le max
*/
function get_groupe_places($groupe){

    if(VERSION_BASE>VERSION){

        $req="SELECT  * FROM _af_get_places_groupe($groupe) AS (min integer, max integer);";
        $places=pg_query($req);
    }
    else
        $places=get_groupe_places_old($groupe) ;
    return  $places;
}

/**
*   Enregistrer le nombre de places d'un groupe
*
*   Enregistrer le nombre de places min et max pour un groupe
*   Cette fonction effectue les verifications necessaires  un insert.
*   Si l'enregistrement a effectuer existe, un update est effectu au lieu
*   d'un insert.
*
*   @param integer : numero du groupe
*   @param integer : max places du groupe
*   @param integer : min places du groupe
*   @return integer : le nombre de lignes affectes
*/
function set_places_groupe($groupe, $max, $min){

    $req="SELECT  _af_set_places_groupe($groupe, $max, $min) ;";
    $nblignes=pg_query($req);
    return  $nblignes;
}


/**
*   Mettre a jour le nombre de places d'un groupe
*
*    Mettre a jour  le nombre de places min et max pour un groupe
*
*   @param integer : numero du groupe
*   @param integer : max places du groupe
*   @param integer : min places du groupe
*   @return integer : le nombre de lignes affectes
*/
function maj_places_groupe($groupe, $max, $min){

    $req="SELECT  _af_maj_places_groupe($groupe, $max, $min) ;";
    //echo $req;
    $nblignes=pg_query($req);
    return  $nblignes;
}

/**
*   Mettre a jour le nom d'un groupe(OLD)
*
	@deprecated : utiliser maj_groupe($groupe,$nom,$pere)
*   @param integer : numero du groupe
*   @param varchar : nouveau nom du groupe
*   @param integer : numero du groupe pere
*   @return integer : 1 si ok, O si ERREUR
*/
function maj_nom_groupe_old($groupe, $nom, $pere){

    if(check_groupe($pere, $nom)==0){

        $req="update classe set nom='$nom' where id=$groupe and id_pere=$pere;";
        $ok=pg_query($req);
        $ok=1;
    }
    else {
        $ok=0;
        //print("Le groupe existe deja");
    }

    return  $ok;
}

/**
*   Mettre a jour le nom d'un groupe.
*
	@deprecated : utiliser maj_groupe($groupe,$nom,$pere)
*   Effectue le changement de nom seulement si le nom n'est pas utilis
*   pour un autre groupe d'un meme pre.
*
*   @param integer : numero du groupe
*   @param varchar : nouveau nom du groupe
*   @param integer : numero du groupe pere
*   @return integer : 1 si ok, O si ERREUR
*/
function maj_nom_groupe($groupe, $nom, $pere){

    if(VERSION_BASE>VERSION)
    {
        $req="SELECT  _af_maj_nom_groupe($groupe, '$nom', $pere) ;";
        //echo $req;
        $ok=pg_query($req);
        $ok=pg_result($ok,0,0);
   }
    else   $ok=maj_nom_groupe_old($groupe, $nom, $pere);

    return  $ok;
}


/**
*   obtenir la liste des stagiaires d'un groupe qui ont des valuations corriges (OLD)
*
*   Retourne les numros des stagiaires, leur nom et prenoms
*
*    @param  integer : numro de groupe
*
*/
function get_stagiaires_evaluation_finie_groupe_old($groupe)
{
            $req="select distinct gu_num_user, nom, prenom
                                    from gestionutil, utilisateurs
                                    where gu_num_gest_gr='$groupe'
                                    and gu_num_user in ( select distinct id_stag
                                                                                    from res_serie
                                                                                    where score >=0
                                                                                    union
                                                                                    select distinct num_user
                                                                                    from resexouser
                                                                                    where num_cal <>0
                                                                                    and surtotal <>0)
                                    and num_user=gu_num_user
                                    order by nom,prenom,gu_num_user";

            return(pg_query($req));
}


/**
*   obtenir la liste des stagiaires d'un groupe qui ont des valuations corriges
*
*   Retourne les numros des stagiaires, leur nom et prenoms
*
*    @param  integer : numro de groupe
*
*/
function get_stagiaires_evaluation_finie_groupe($groupe)
{
            if(VERSION_BASE>VERSION)
            {
                        $req="select * from _af_get_stagiaires_evaluation_finie_groupe($groupe) AS (num_user integer, nom varchar, prenom varchar)";
                        $res = pg_query($req);
            }
            else
                        $res=get_stagiaires_evaluation_finie_groupe_old($groupe);
            return ($res);
}

/**
* Obtenir les formations d'un groupe donn OLD
*
* @param  integer : numero de groupe
* @return integer : liste de formations (num_formation, nom_formation, debut, fin)
*/
function get_groupe_formations_old($groupe)
{
            $sql="SELECT DISTINCT num_cal AS num_formation, nom_cal AS nom_formation, d1.jour AS debut, d2.jour AS fin
                        FROM gestionnaire, calendrier, dates d1, dates d2
                        WHERE g_num_gest_g=$groupe
                        AND g_num_cal=num_cal
                        AND d1.num_date=datedeb
                        AND d2.num_date=datefin
                        ORDER BY nom_formation " ;
    
            return(pg_query($sql));
}

/**
* Obtenir les formations d'un groupe donn
*
* @param  integer : numero de groupe
* @return integer : liste de formations (num_formation, nom_formation, debut, fin)
*/
function get_groupe_formations($groupe)
{
            if(VERSION_BASE>VERSION)
            {
                
            }
            else
                        $res=get_groupe_formations_old($groupe) ;

            return $res;
}

/**
* Obtenir les formations (et le parcours) lies  un groupe donn OLD
* DEPRECATED UTILISER get_groupe_formations()
* @param  integer : numro de groupe
* @param  string : ASC ou DESC
* @param  integer : si VRAI alors classement par date
* @return integer : liste de formations (num_formation, g_num_parcours, nom_formation, debut, fin)
*/
function get_formations_groupe_old($groupe, $classement="ASC", $par_date=0)
{
            $sql="SELECT DISTINCT num_cal AS num_formation, g_num_parcours AS num_parcours, nom_cal AS nom_formation, d1.jour AS debut, d2.jour AS fin
                        FROM gestionnaire, calendrier, dates d1, dates d2
                        WHERE g_num_gest_g=$groupe
                        AND g_num_cal=num_cal
                        AND d1.num_date=datedeb
                        AND d2.num_date=datefin
                        ORDER BY " ;
            if($par_date)
                $sql .= "debut $classement ;";
            else
                $sql .= "nom_formation $classement ;";

            return(pg_query($sql));
}

/**
* Obtenir les formations lies  un groupe donn
* DEPRECATED UTILISER get_groupe_formations()
* @param  integer : numro de groupe
* @param  string : ASC ou DESC
* @param  integer : Si gal  1 on classe par date sinon par nom de groupe
* @return integer : liste de formations (num_formation, nom_formation, debut, fin)
*/
function get_formations_groupe($groupe, $classement="ASC", $par_date=1)
{
            if(VERSION_BASE>VERSION)
            {
                        $req="select * FROM _af_get_formations_groupe($groupe, '$classement', $par_date) AS (num_formation integer, num_parcours integer, nom_formation varchar, debut date, fin date)";
                        $res = pg_query($req) ;
            }
            else
                        $res=get_formations_groupe_old($groupe, $classement, $par_date) ;

            return $res;
}

/**
*   Obtenir les individus que l'on peu ajouter a un groupe.
*
*   Les individus que l'on peut ajouter sont tous les individus qui font partis
*   d'un organisme d'un individu du groupe, ou tous les individus si le groupe est vide.
*
*   @param integer : le numero du groupe
*   @return integer : les individus affiliables.
*/
function get_individus_affiliables_old($groupe){

    $resusergp=get_individus_groupe($groupe,0,"ASC");

    if(pg_numrows($resusergp)>0  )


            $resuser=pg_query("select * from utilisateurs
            where num_user not in
            (select gu_num_user from gestionutil where gu_num_gest_gr='$groupe')
            and  num_org in (select num_org from utilisateurs where num_user in
            (select gu_num_user from gestionutil where gu_num_gest_gr='$groupe') or num_org=0)
            and categorie <> 'c' order by nom;");
    else
    {
            //recupere tous les individus
            $resuser=get_individus();
    }

    return  $resuser;
}

/**
*   Obtenir les individus que l'on peu ajouter a un groupe.
*
*   Les individus que l'on peut ajouter sont tous les individus qui font partis
*   d'un organisme d'un individu du groupe, ou tous les individus si le groupe est vide.
*
*   @param integer : le numero du groupe
*   @return integer : les individus affiliables.
*/
function get_individus_affiliables($groupe){

            if(VERSION_BASE>VERSION)
            {
                        $req="select * from _af_get_individus_affiliables($groupe) AS (num_user integer, id_user varchar, login varchar, password varchar, nom varchar, prenom varchar,
            adresse varchar, code varchar, ville varchar, email varchar, telfixe varchar, telport varchar,
            langue varchar, num_org integer, categorie varchar, session varchar, total varchar , temps integer, fic_photo varchar);" ;


                          $res = pg_query($req);
            }
            else
                      $res=get_individus_affiliables_old($groupe);

            return ($res);
}

/**
*   Vrifier si un nom de groupe est unique pour un meme pere.  (OLD)
*
*   @param integer : numero du groupe pere
*   @param string :  nom du groupe
*   @return integre : 1 si existe, 0 sinon
*/
function check_groupe_old($pere, $nomgroupe){

	//le caractere '/' est interdit
	if(strchr($nomgroupe, '/'))return 0;
    $req="select * from classe where id_pere=$pere and nom='$nomgroupe';";

    $res = pg_query($req);

    if(pg_num_rows($res)==0)return 0;
    else return 1;
}

/**
*   Vrifier si un nom de groupe est unique pour un meme pere.
*
*   @param integer : numero du groupe pere
*   @param string :  nom du groupe
*   @return integre : 1 si existe, 0 sinon
*/
function check_groupe($pere, $nomgroupe){

            if(VERSION_BASE>VERSION)
            {
                        $req="select  _af_check_groupe($pere, '$nomgroupe');";
						//echo $req;
                        $res = pg_query($req);
                        $res=pg_result($res,0,0);
            }
            else
                      $res=check_groupe_old($pere, $nomgroupe);

            return ($res);
}

/**
*   Enregistrer un nouveau groupe. (OLD)
*
*   Effectue l'enregistrement seulement si le nom n'est pas utilis
*   pour un autre groupe d'un meme pre.
*
*   @param string: nom du groupe
*   @param integer : numero du groupe pere
*   @param integer : nombre de places miminum dans le groupe
*   @param integer : nombre de places maximum dans le groupe
*   @return integer : numero du nouveau groupe , O si erreur
*/
function set_groupe_old( $libelle, $pere, $min, $max){

    $existe_deja=check_groupe($pere, $libelle);

    if(!$existe_deja){

        $res=pg_query("insert into classe (nom,id_pere)
                                    values('$libelle',$pere)");
        $oid=pg_getlastoid($res);
        $res=pg_query("SELECT id  FROM classe WHERE OID=$oid;");
        $nv_groupe=pg_result($res, 0, 0);
        $res=set_places_groupe($nv_groupe,$max,$min);

        return $nv_groupe;

    }
    else return 0;

}

/**
*   Enregistrer un nouveau groupe.
*
*   Effectue l'enregistrement seulement si le nom n'est pas utilis
*   pour un autre groupe d'un meme pre.
*
*   @param string: nom du groupe
*   @param integer : numero du groupe pere
*   @param integer : nombre de places miminum dans le groupe
*   @param integer : nombre de places maximum dans le groupe
*   @return integer : numero du nouveau groupe , O si erreur
*/
function set_groupe( $libelle, $pere, $min, $max){

            if(VERSION_BASE>VERSION)
            {
                        $req="select  _af_set_groupe('$libelle', $pere, $min, $max);";
                        //echo $req;
                        $res = pg_query($req);
                        $nv_groupe=pg_result($res, 0, 0);

            }
            else
                      $nv_groupe=set_groupe_old( $libelle, $pere, $min, $max);

            return ($nv_groupe);
}

/**
*   Obtenir les informations concernant un groupe.(OLD)
*
	@deprecated : utiliser get_groupe_infos($groupe)
*   @param integer : numero du groupe
*   @return integer : identifiant resultat ( identifiant,  nom , numero du pere , maximun de places, minimum de places)
*/
function get_infos_groupe_old($groupe ){

    $req="select id, nom, id_pere, maxplace, minplace from classe, placegroupe  where id=$groupe and id=num_gest_groupe;";

    $res = pg_query($req);

    return $res;
}

/**
*   Obtenir les informations concernant un groupe.
*
	@deprecated : utiliser get_groupe_infos($groupe)
*   @param integer : numero du groupe
*   @return integer : identifiant resultat ( identifiant,  nom , numero du pere , maximun de places, minimum de places)
*/
function get_infos_groupe($groupe){

            if(VERSION_BASE>VERSION)
            {
                        $req="select * FROM  _af_get_infos_groupe($groupe)AS (id integer, nom varchar, id_pere integer, max integer, min integer);";
                        //echo $req;
                        $res = pg_query($req);
            }
            else
                      $res=get_infos_groupe_old( $groupe);

            return ($res);
}

function get_niveau_groupe_old($groupe){

        $parent=$groupe;
        while($parent<>0){
                $res=pg_query("select * from classe where id='$parent';");
                $row=pg_fetch_row($res,0);
                $tab[]=$row[1];
                $parent=$row[2];
    }
   $niv=sizeof($tab);
   return $niv;
}

/**
*   Obtenir le niveau d'un groupe
*
*   Un groupe qui n'a pas de pre  est de niveau 1.
*
*   @param integer : numero du groupe
*   @return integer : identifiant resultat ( identifiant,  nom , numero du pere , maximun de places, minimum de places)
*/
function get_niveau_groupe($groupe){

            if(VERSION_BASE>VERSION)
            {
                        $req="select   _af_get_niveau_groupe($groupe)";
                        //echo $req;
                        $res = pg_query($req);
                        $res = pg_result($res, 0,0);
            }
            else
                      $res=get_niveau_groupe_old( $groupe);

            return ($res);
}

/**
*   Supprimer un groupe.  (OLD)
*
*   Supprime le groupe, ses relations avec les formations,
*   le nombre de places, ses groupes fils, et ne supprime pas
*   les individus qui y sont affilis.
*
*   @param integer : numero du groupe  supprimer
*   @return integer : 1
*/
function del_groupe_old($groupe){

        //suppression du pere courant
        $del=pg_query("delete from classe where id=$groupe;");

        $del=pg_query("delete from gestionutil where gu_num_gest_gr=$groupe;");
        $del=pg_query("delete from placegroupe where num_gest_groupe=$groupe;");

        //recup de ses fils
        $res=pg_query("select * from classe where id_pere=$groupe;");
        while($row=pg_fetch_array($res)){
                $groupe=$row["id"];
                del_groupe_old($groupe);
        }
        return 1;
}

/**
*   Supprimer un groupe.
*
*   Supprime le groupe, ses relations avec les formations,
*   le nombre de places, ses groupes fils, et ne supprime pas
*   les individus qui y sont affilis.
*
*   @param integer : numero du groupe  supprimer
*   @return integer : 1
*/
function del_groupe($groupe){

            if(VERSION_BASE>VERSION)
            {
                        $req="select   _af_del_groupe($groupe)";
                        echo $req;
                        $res = pg_query($req);
                        $res = pg_result($res, 0,0);
            }
            else
                      $res=del_groupe_old( $groupe);

            return ($res);
}

/**
*   Obtenir le nom (complet) d'un groupe (OLD)
*
*	Le nom du groupe est retourn prcd des noms de ses groupes peres,
*	c'est a dire sous la forme:
*	nom_groupe_pere_pere/nom_groupe_pere/nom_groupe
*	@deprecated utiliser get_groupe_nom($num)
*   @param integer : numero du groupe dont on veut le nom.
*   @return string :  la chaine contenant le nom du groupe
*/
function get_nom_groupe_old($num){
	
    $parent=$num;
    $tab1=array();
    
    while($parent<>0){
    
        $req="select * from classe where id=$parent ;" ;
        $res=pg_query($req);
        $row=pg_fetch_row($res,0);
        $tab[]=$row[1];
        $parent=$row[2];
    }
    
    $tab1=array_reverse($tab,TRUE);
   
    return (implode("/",$tab1));

}



/**
*   Obtenir le nom (complet) d'un groupe
*
*	Le nom du groupe est retourn prcd des noms de ses groupes peres,
*	c'est a dire sous la forme:
*	@deprecated utiliser get_groupe_nom($num)
*	nom_groupe_pere_pere/nom_groupe_pere/nom_groupe
*   @param integer : numero du groupe dont on veut le nom.
*   @return string :  la chaine contenant le nom du groupe
*/
function get_nom_groupe($groupe){

            if(VERSION_BASE>VERSION)
            {
                        $req="select  _af_get_nom_groupe($groupe)";
                        //echo $req;
                        $res = pg_query($req);
                        $res = pg_result($res, 0,0);
            }
            else
                      $res=get_nom_groupe_old( $groupe);

            return ($res);
}


/**
*   Obtenir le nom (complet) d'un groupe (OLD)
*
*	Le nom du groupe est retourne precede des noms de ses groupes peres,
*	c'est a dire sous la forme:
*	nom_groupe_pere_pere/nom_groupe_pere/nom_groupe
*   @param integer : numero du groupe dont on veut le nom.
*   @return string :  la chaine contenant le nom du groupe
*/
function get_groupe_nom_old($num){
	
    $parent=$num;
    $tab1=array();
    
    while($parent<>0){
    
        $req="select * from classe where id=$parent ;" ;
        $res=pg_query($req);
        $row=pg_fetch_row($res,0);
        $tab[]=$row[1];
        $parent=$row[2];
    }
    
    $tab1=array_reverse($tab,TRUE);
   
    return (implode("/",$tab1));

}

/**
*   Obtenir le nom (complet) d'un groupe
*
*	Le nom du groupe est retourne precede des noms de ses groupes peres,
*	c'est a dire sous la forme:
*	nom_groupe_pere_pere/nom_groupe_pere/nom_groupe
*   @param integer : numero du groupe dont on veut le nom.
*   @return string :  la chaine contenant le nom du groupe
*/
function get_groupe_nom($groupe){

            if(VERSION_BASE>VERSION)
            {
                  
            }
            else
                      $res=get_groupe_nom_old( $groupe);

            return ($res);
}

/**
*   Obtenir les formations d'un groupe pour une priode (OLD)
*
*   @param integer : le numero du groupe
*   @param integer : le numero de la priode 1=pass 2=prsent 3=futur>
*   @return integer : l'entier resultat de la requete
*/
function get_formations_groupe_periode_old($groupe,$periode){
    switch($periode){
        case 1: $condition=" AND D2.jour < current_date ";
        break;
        case 2: $condition=" AND NOT (D1.jour > current_date OR D2.jour < current_date) ";
        break;
        case 3: $condition=" AND D1.jour > current_date ";
        break;
    }
    $sql="SELECT DISTINCT U.nom, U.prenom, C.nom_cal as formation, C.num_cal, D1.jour as debut, D2.jour as fin
                                FROM gestionnaire G, utilisateurs U, calendrier C, dates D1, dates D2
                                WHERE U.num_user=G.g_num_user
                                AND C.num_cal=G.g_num_cal
                                AND D1.num_date=C.datedeb
                                AND D2.num_date=C.datefin
                                AND G.g_num_gest_g=$groupe
                                $condition";

    return (pg_query($sql));

}
/**
*   Obtenir les formations d'un groupe pour une priode
*
*   @param integer : le numero du groupe
*   @param integer : le numero de la priode 1=pass 2=prsent 3=futur>
*   @return integer : l'entier resultat de la requete
*/
function get_formations_groupe_periode($groupe,$periode){
    if (VERSION_BASE > VERSION) {
        // Appel de la fonction plpgsql  crer : _af_get_formation_selection_periode("groupe",$groupe,$periode)
        $sql="A IMPLEMENTER";
        $res=pg_query($sql);
    }
    else
        $res=get_formations_groupe_periode_old($groupe,$periode);
    return $res;
}

/**
	Obtenir les stagiaires du groupe qui ont des exostlc corriges. (OLD)
	
	@param integer numero du groupe
	@return l'entier resultat de la requete (num_user,nom prenom)
*/
function get_groupe_stagiaires_exotlcs_corriges_old($groupe){
        $sql="select num_user, textcat(textcat(nom,text ' '), prenom) AS nomprenom from UTILISATEURS where categorie like '%u%' and
                                   num_user in (select distinct gesttlc_user from gestexotlc) and 
                                   num_user in (select distinct gu_num_user from gestionutil where gu_num_gest_gr=$groupe) order by nomprenom;";
       return(pg_query($sql));
}

/**
	Obtenir les stagiaires du groupe qui ont des exostlc corriges. (OLD)
	
	@param integer numero du groupe
	@return l'entier resultat de la requete (num_user,nom prenom)
*/
function get_groupe_stagiaires_exotlcs_corriges($groupe){
 if (VERSION_BASE > VERSION) {
       
        $sql="A IMPLEMENTER";
        $res=pg_query($sql);
    }
    else
        $res= get_groupe_stagiaires_exotlcs_corriges_old($groupe);
    return $res;
}

/**
*   Retourne les individus d'un groupe  (OLD)
*
*    Retourne les numero des individus d'un groupe
*   Le parametre de selection permet de retourner les individus (u, fu ou f),
*   les formateur(f ou fu) ou les stagiaires(u ou fu) Set l'ordre
*   d'avoir un classement par nom croissant ou decroissant
*   La selection exclusive permet de selectionner les individus strictement formateurs ou stictement
*   utilisateurs.
*
*   @param integer : numero du groupe
*   @param integer : 0 individus, 1 formateurs, 2 utilisateurs
*   @param string  : DESC sinon ASC
*   @param integer : 1 selection exclusive
*   @return integer : les numero d'utilisateur du groupe , leur nomprenom et categorie
*/
function get_groupe_individus_old($groupe, $selection, $ordre, $exclusif){

    if($groupe>=0&&!empty($groupe)){

     $requete="select num_user, textcat( textcat( nom, text ' '),prenom) AS nomprenom ,categorie , lower(nom) AS ordre
     from utilisateurs
    where categorie like ";
    if($selection==0)
        $requete.=" '%%' ";
    else {
        if($selection==1){
            if($exclusif!=1)
                $requete.="'%f%' ";
            else
                $requete.="'f' ";
        }
        else {
            if($selection==2){
                if($exclusif!=1)
                    $requete.="'%u%' ";
                else
                    $requete.="'u' ";
            }
            else {
                echo 'Erreur: la selection est incorrecte'.'['.$selection.']';
            }
        }
    }
     $requete.=" and num_user in (select gu_num_user from gestionutil where gu_num_gest_gr='$groupe' )
        ORDER BY ordre ";
     if($ordre=="DESC") $requete.=" DESC ";
     
     //debug echo $requete;
     $individus=pg_query($requete);

    return  $individus;
    } else{

     //echo 'Erreur: le numero de groupe est incorrect'.'['.$groupe.']';
     return null;
    }
}

/**
*   Retourne les individus d'un groupe  (OLD)
*
*    Retourne les numero des individus d'un groupe
*   Le parametre de selection permet de retourner les individus (u, fu ou f),
*   les formateur(f ou fu) ou les stagiaires(u ou fu) Set l'ordre
*   d'avoir un classement par nom croissant ou decroissant .
*   La selection exclusive permet de selectionner les individus strictement formateurs ou stictement
*   utilisateurs.
*
*   @param integer : numero du groupe
*   @param integer : 0 individus, 1 formateurs, 2 utilisateurs
*   @param string  : DESC sinon ASC
*   @param integer : 1 selection exclusive
*   @return integer : les numero d'utilisateur du groupe , leur nomprenom et categorie
*/
function get_groupe_individus($groupe, $selection, $ordre, $exclusif=0){
      
    if(VERSION_BASE>VERSION){

  
    }
    else
        $individus=get_groupe_individus_old($groupe, $selection, $ordre, $exclusif) ;

    return  $individus;
}

/**
*   Obtenir le niveau d'un groupe (OLD)
*
*   Un groupe qui n'a pas de pre  est de niveau 1.
*
*   @param integer : numero du groupe
*   @return integer : identifiant resultat ( identifiant,  nom , numero du pere , maximun de places, minimum de places)
*/
function get_groupe_niveau_old($groupe){

        $parent=$groupe;
        while($parent<>0){
                $res=pg_query("select * from classe where id='$parent';");
                $row=pg_fetch_row($res,0);
                $tab[]=$row[1];
                $parent=$row[2];
    }
   $niv=sizeof($tab);
   return $niv;
}

/**
*   Obtenir le niveau d'un groupe
*
*   Un groupe qui n'a pas de pre  est de niveau 1.
*
*   @param integer : numero du groupe
*   @return integer : identifiant resultat ( identifiant,  nom , numero du pere , maximun de places, minimum de places)
*/
function get_groupe_niveau($groupe){

            if(VERSION_BASE>VERSION)
            {
                        //$req="select   _af_get_niveau_groupe($groupe)";
                        $req="select contraintes.af_gen_get_element_niveau('contraintes.classe','id',$groupe,' ',0)";
                        //echo $req;
                        $res = pg_query($req);
                        $res = pg_result($res, 0,0);
            }
            else
                      $res=get_groupe_niveau_old( $groupe);

            return ($res);
}

///**
//*   Obtenir les groupes  partir d'un pre (OLD)
//*
//*   @param integer : numero du pre.
//*   @return integer : l'entier rsultat de la requete
//*/
//function get_classe_pere_old($pere){
//    $sql="select * from classe where id_pere=$pere order by nom";
//    $res=pg_query($sql);
//    return $res;
//}
///**
//*   Obtenir les classes  partir d'un pre
//*
//*   @param integer : numero du pre.
//*   @return integer : l'entier rsultat de la requete
//*/
//function get_classe_pere($pere){
//    if(VERSION_BASE > VERSION){
//        $sql="select * from contraintes.af_get_classe_pere($pere) as (id int4,nom varchar,id_pere int4,min int4,max int4)";
//         //echo $sql;
//        $res=pg_query($sql);
//
//    }
//    else
//        $res=get_classe_pere_old($pere);
//    return $res;
//}

/**
    Vrification des heures de cours pour un groupe pour une date de formation (OLD)
*
*   @param integer : le numero de groupe
*   @param date : le jour du cours
*   @param varchar : l'heure de debut
*   @param varchar : l'heure de fin
*   @param integer : le numero de formation
*   @param varchar : debut du cours (mode edition)
*   @return integer : le resultat de la requete
*/
function get_groupe_heures_cours_formation_old($groupe,$date,$heure_debut,$heure_fin,$formation,$heure_cours=""){
    $sql="SELECT COUNT(*) FROM  dates D, gest_cal G
                WHERE D.num_date=G.num_date
                AND D.jour='$date'
                AND ( ( G.hdeb >= '$heure_debut' AND G.hdeb <= '$heure_fin')  OR ( G.hdeb <= '$heure_debut' AND G.hfin>='$heure_debut') )
                AND G.gnum_cal in (select g_num_cal from gestionnaire where g_num_gest_g=$groupe)
                AND G.gnum_cal!=$formation
                AND G.hdeb != '$heure_cours'";
    $res=pg_query($sql);
    return $res;
}
/**
    Vrification des heures de cours pour un groupe pour une date de formation
*
*   @param integer : le numero de groupe
*   @param date : le jour du cours
*   @param varchar : l'heure de debut
*   @param varchar : l'heure de fin
*   @param integer : le numero de formation
*   @param varchar : debut du cours (mode edition)
*   @return integer : le resultat de la requete
*/
function get_groupe_heures_cours_formation($groupe,$date,$heure_debut,$heure_fin,$formation,$heure_cours=""){
    if(VERSION_BASE > VERSION){

    }
    else
        $res=get_groupe_heures_cours_formation_old($groupe,$date,$heure_debut,$heure_fin,$formation,$heure_cours);
    return $res;
}

/**
    Obtenir les heures de cours d'un groupe pour un jour de formation (OLD)
*
*   @param integer : le numero du groupe
*   @param date : le jour de formation
*   @return integer : le resultat de la requete
*/
function get_groupe_cours_formation_old($groupe,$date){
    $sql="SELECT C.num_cal, nom_cal, hdeb, hfin,libelle FROM gest_cal G, calendrier C, dates D, gestionnaire Ge
                WHERE G.gnum_cal=C.num_cal
                AND D.num_date=G.num_date
                AND Ge.g_num_cal=G.gnum_cal
                AND Ge.g_num_gest_g=$groupe
                AND jour='$date'";
    $res=pg_query($sql);
    return $res;
}
/**
    Obtenir les heures de cours d'ungroupe pour un jour de formation
*
*   @param integer : le numero du groupe
*   @param date : le jour de formation
*   @return integer : le resultat de la requete
*/
function get_groupe_cours_formation($groupe,$date){
    if(VERSION_BASE > VERSION){

    }
    else
        $res=get_groupe_cours_formation_old($groupe,$date);
    return $res;
}

/**
	Enregistre les place max et min pour un groupe (OLD)
 *
 *   @param integer : le numero du groupe
 *   @param integer : le nombre de place max
 *   @param integer : le nombre de place min
*/
function set_groupe_places_old($groupe,$max,$min){
	$sql="insert into placegroupe values($groupe,$max,$min)";
	return (pg_query($sql));
}
/**
	Enregistre les place max et min pour un groupe (OLD)
 *
 *   @param integer : le numero du groupe
 *   @param integer : le nombre de place max
 *   @param integer : le nombre de place min
*/
function set_groupe_places($groupe,$max,$min){
	 if(VERSION_BASE > VERSION){

    }
    else
        $res=set_groupe_places_old($groupe,$max,$min);
    return $res;
}

/**
	Modifie les place max et min pour un groupe (OLD)
 *
 *   @param integer : le numero du groupe
 *   @param integer : le nombre de place max
 *   @param integer : le nombre de place min
*/
function maj_groupe_places_old($groupe,$max,$min){
	$sql="update placegroupe set maxplace=$max,minplace=$min where num_gest_groupe=$groupe";
 	//echo "sql=$sql<br>";
	return (pg_query($sql));
}
/**
	Modifie les  place max et min pour un groupe (OLD)
 *
 *   @param integer : le numero du groupe
 *   @param integer : le nombre de place max
 *   @param integer : le nombre de place min
*/
function maj_groupe_places($groupe,$max,$min){
	 if(VERSION_BASE > VERSION){

    }
    else
        $res=maj_groupe_places_old($groupe,$max,$min);
    return $res;
}

/**
	Obtenir les infos d'un groupe (OLD)
 *
 *	@param integer : le numero du groupe
 *	@return integer : le resultat de la requete
*/
function get_groupe_old($groupe){
	$sql="select * from classe where id=$groupe";
	return (pg_query($sql));
}
/**
	Obtenir les infos d'un groupe
 *
 *	@param integer : le numero du groupe
 *	@return integer : le resultat de la requete
*/
function get_groupe($groupe){
	 if(VERSION_BASE > VERSION){

    }
    else
        $res=get_groupe_old($groupe);
    return $res;
}

/**
*   Obtenir les informations concernant un groupe.(OLD)
*
*   @param integer : numero du groupe
*   @return integer : identifiant resultat ( identifiant,  nom , numero du pere , maximun de places, minimum de places)
*/
function get_groupe_infos_old($groupe ){

    $req="select id, nom, id_pere, maxplace, minplace from classe, placegroupe  where id=$groupe and id=num_gest_groupe;";

    $res = pg_query($req);

    return $res;
}

/**
*   Obtenir les informations concernant un groupe.
*
*   @param integer : numero du groupe
*   @return integer : identifiant resultat ( identifiant,  nom , numero du pere , maximun de places, minimum de places)
*/
function get_groupe_infos($groupe){

            if(VERSION_BASE>VERSION)
            {
                        $req="select * FROM  _af_get_infos_groupe($groupe)AS (id integer, nom varchar, id_pere integer, max integer, min integer);";
                        //echo $req;
                        $res = pg_query($req);
            }
            else
                      $res=get_groupe_infos_old( $groupe);

            return ($res);
}
/*
function get_niveau_groupe_old($groupe){

        $parent=$groupe;
        while($parent<>0){
                $res=pg_query("select * from classe where id='$parent';");
                $row=pg_fetch_row($res,0);
                $tab[]=$row[1];
                $parent=$row[2];
    }
   $niv=sizeof($tab);
   return $niv;
}
*/

/**
*   Mettre a jour le nom d'un groupe(OLD)
*
	@deprecated : utiliser maj_groupe($groupe,$nom,$pere)
*   @param integer : numero du groupe
*   @param varchar : nouveau nom du groupe
*   @param integer : numero du groupe pere
*   @return integer : 1 si ok, O si ERREUR
*/
function maj_groupe_old($groupe, $nom, $pere){

    if(check_groupe($pere, $nom)==0){

        $req="update classe set nom='$nom' where id=$groupe and id_pere=$pere;";
        $ok=pg_query($req);
        $ok=1;
    }
    else {
        $ok=0;
        //print("Le groupe existe deja");
    }

    return  $ok;
}

/**
*   Mettre a jour le nom d'un groupe.
*
	@deprecated : utiliser maj_groupe($groupe,$nom,$pere)
*   Effectue le changement de nom seulement si le nom n'est pas utilis
*   pour un autre groupe d'un meme pre.
*
*   @param integer : numero du groupe
*   @param varchar : nouveau nom du groupe
*   @param integer : numero du groupe pere
*   @return integer : 1 si ok, O si ERREUR
*/
function maj_groupe($groupe, $nom, $pere){

    if(VERSION_BASE>VERSION)
    {
        $req="SELECT  _af_maj_nom_groupe($groupe, '$nom', $pere) ;";
        //echo $req;
        $ok=pg_query($req);
        $ok=pg_result($ok,0,0);
   }
    else   $ok=maj_groupe_old($groupe, $nom, $pere);

    return  $ok;
}

?>