<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Interface CorrelationStruct
 * Spcifie les attributs et les mthodes ncessaires  l'tablissement d'une correlation entre ImportFile et ExportFile.
 * Cette classe est donc commune  tous les types de fichiers et  tous les types de donnes grs par le module d'ImportExport.
 * 
 * @package import_export
 */
class CorrelationStruct {

	/**
	 * @var array Structure de corrlation.
	 * Tableau indx par les liblls des champs d'Export et dont les valeurs sont les liblls des champs d'Import correspondants. 
	 */
	 var $struct;
	 
	/**
	 * Constructeur.
	 * Initialise la structure de corrlation.
	 */
	function CorrelationStruct(){
		$this->struct=array();
	}
	
	/**
	 * Obtenir les valeurs possibles pour un attribut.
	 * Retourne null si un attibut peu avoir n'importe quelle valeur.
	 * 
	 * @param string $var_name Nom de l'attribut.
	 * @return array Valeurs que peut avoir l'attribut. Si null, toutes les valeurs sont possibles.
	 */
	function getVarValues($var_name){
		die("CorrelationStruct::getVarValues(): Mthode abstraite devant tre surcharge.");
	}
		
	/**
	 * Obtenir la stucture de corrlation.
	 * @return array Tableau indx par les liblls des champs d'Export et dont les valeurs sont les liblls des champs d'Import correspondants.
	 */
	function getStruct(){
		  return $this->struct;
	}
		
	/**
	 * Obtenir un libll de champs d'Import  partir d'un libll de champs d'Export.
	 * @param string  $export_var_name Le libll de champs d'Import.
	 * @return string Le libll de champs d'Export.
	 */
	function exportVarName2ImportVarName($export_var_name){
		return $this->struct[$export_var_name];
	}
	
}
?>