<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Surcharge de la classe CorrelationStruct.
 * Cette classe TEMPORAIRE permet de dfinir, "EN DUR", la corrlation, pour les Ftb,
 * entre une structure d'Import pour le format CSV vers une structure d'Export pour Astairs (BDD)
 *  
 * @package import_export
 */
class CorrelationStructCsvAstairsFtb extends CorrelationStruct{

	/**
	 * Constructeur
	 */
	function CorrelationStructCsvAstairsFtb(){
		parent::CorrelationStruct();
		
		//$this->struct["libll export"]="libll import";
		
		$this->struct["libelle_ftb"]="idtmp";
		$this->struct["theme_ftb"]="theme";
		
		$this->struct["texte"]="text";
		$this->struct["interpretationHTML_texte"]="interhtml_texte";
		$this->struct["liste_mots"]="liste_mot";
		
		
		
	}
	
	/**
	 * Obtenir les valeurs possibles pour un attribut.
	 * Retourne null si un attibut peu avoir n'importe quelle valeur.
	 * 
	 * @param string $var_name Nom de l'attribut.
	 * @return array Valeurs que peut avoir l'attribut. Si null, toutes les valeurs sont possibles.
	 */
	function getVarValues($var_name){
		return Ftb::getVarValues($var_name);
	}
}
?>