<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Surcharge de la classe CorrelationStruct.
 * Cette classe TEMPORAIRE permet de dfinir, "EN DUR", la corrlation, pour les QRC,
 * entre une structure d'Import pour le format CSV vers une structure d'Export pour Astairs (BDD)
 *  
 * @package import_export
 */
class CorrelationStructCsvAstairsQrc extends CorrelationStruct{

	/**
	 * Constructeur
	 */
	function CorrelationStructCsvAstairsQrc(){
		parent::CorrelationStruct();
		//$this->struct["libll export"]="libll import";
		
		$this->struct["libelle_qrc"]="idtmp";
		$this->struct["theme_qrc"]="theme";
		$this->struct["libelle_question_commune"]="question_commune";
		
		$this->struct["interpretationHTML_question"]="interhtml_question";
		$this->struct["theme_question"]="theme";
		$this->struct["libelle_question"]="lib_question";
		
		$this->struct["libelle_reponse"]="lib_reponse";
		$this->struct["interpretationHTML_reponse"]="interhtml_reponse";
		$this->struct["theme_reponse"]="theme";
		$this->struct["juste_reponse"]="juste";
		$this->struct["radio"]="radio_ch";
		
	}
	
	/**
	 * Obtenir les valeurs possibles pour un attribut.
	 * Retourne null si un attibut peu avoir n'importe quelle valeur.
	 * 
	 * @param string $var_name Nom de l'attribut.
	 * @return array Valeurs que peut avoir l'attribut. Si null, toutes les valeurs sont possibles.
	 */
	function getVarValues($var_name){
		return Qrc::getVarValues($var_name);
	}
}
?>