<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Classe abstraite ExportStruct
 * Spcifie des mthodes et des attributs ncssaires  la dfinition
 * d'une structure d'export de donnes.
 * Permet de spcifier les donnes ncessaires  la cration d'entitits de n'importe quel type vers
 * n'importe quel format.
 * 
 * @package import_export
 */
class ExportStruct {

	/**
	 * @var array Structure des donnes d'export.
	 * Tableau contenant les liblls des champs d'Export requis. 
	 */
	var $struct;
	 
	/**
	 * Constructeur
	 */
	function ExportStruct(){
		$this->struct=array();
	}
	
	/**
	 * Obtenir la structure des donnes d'export.
	 * @return array Tableau contenant les liblls des champs d'Export requis. 
	 */
	function getStruct(){
		  return $this->struct;
	}
	
	/**
	 * Obtenir les valeurs possibles pour un attribut.
	 * Retourne null si un attribut peut avoir n'importe quelle valeur.
	 * 
	 * @param string $var_name Nom de l'attribut.
	 * @return array Valeurs que peut avoir l'attribut. Si null, toutes les valeurs sont possibles.
	 */
	function getVarValues($var_name){
		die("ExportStruct::getVarValues(): Mthode abstraite devant tre surcharge.");
	}
}
?>