<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * 
 * @package import_export
 */
class ImportFile {

	var $dataFile;
	
	var $read_data;
	
	var $importStruct;
	 
	/**
	 * Constructeur
	 * Initalise le fichier trait par l'objet.
	*/
	function ImportFile($dataFile){
		$this->dataFile=$dataFile;
	
	}
	
	// Mthodes
	
	/**
	 * Lecture du dataFile vers le format intermdiaire.
	*/
	
	function parse(){
		die("ImportFile::parse(): Mthode abstraite devant tre surcharge.");
		
	}
	
	
	/**
	 * Lit l'ensemble de lignes et de colonnes ncessaire  la cration d'une et une seule entit.
	*/
	
	function read(){
		die("ImportFile::read(): Mthode abstraite devant tre surcharge.");
		
	}
	
	
	/**
	 * Obtenir les coordonnes du champ spcifi dans l'ImportStruct.
	 * Le champ pouvant apparaitre plusieurs fois, on retourne donc un tableau de coordonnes, dans leur ordre d'apparition.
	 * La recherche l'effectue ligne  ligne, de gauche  droite.
	 * @param string $var_name Le nom du champs dans l'ImportStruct.
	 * @return array Un tableau de coordonnes. Une coordone est un tableau  2 cles, "x" pour les abscisses et "y" pour les ordonns.
	 */
	function getStructCoords($var_name){

		return $this->importStruct->getCoords($var_name);
	}

	/**
	 * Obtenir les coordonnes du champ spcifi dans l'ImportStruct.
	 * Le champ pouvant apparaitre plusieurs fois, on retourne donc un tableau de coordonnes, dans leur ordre d'apparition.
	 * La recherche l'effectue ligne  ligne, de gauche  droite.
	 * @param string $var_name Le nom du champs dans l'ImportStruct.
	 * @return array Un tableau de coordonnes. Une coordone est un tableau  2 cles, "x" pour les abscisses et "y" pour les ordonns.
	 */
	function getReadDataCoords($var_name){

		//lecture de chacunes des lignes
		foreach($this->read_data as $x => $ligne){
			
			//lecture de chacunes des colonnes.			
			foreach($ligne as $y => $column){

				//on cherche les colonnes contenant $var_name (on recupere les y pour le x courant)
				if($column[0]==$var_name){
					$coords[]=Array("x"=>$x, "y"=>$y);
				}
			}
		}
		
		return $coords;
	}
	
	/**
	 * Obtenir les donnes  importer.
	 * @return array Tableau contenant les donnes d'une entite  exporter lues dans le fichier d'import.
	 */
	function getReadData(){
		return $this->read_data;
	}
	
	/**
	* Obtenir l'attribut cellule
	*/
	function getCellule(){
		return $this->importStruct->getCellule();
	}
	
	/**
	* Obtenir l'attribut cellules Suivantes
	*/
	function getCellulesSuivantes(){
		return $this->importStruct->getCellulesSuivantes();
	}
	
	/**
	* Obtenir la structure
	*/
	function getStruct(){
		return $this->importStruct->getStruct();
	
	}
	
	/**
	* Obtenir la attribut repeatLastColonne
	*/
	function getRepeatLastColonne(){
		return $this->importStruct->getRepeatLastColonne();
	}
}


?>