<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * 
 * @package import_export
 */
class ImportStruct {

	 var $struct;
     var $nbLignes;
	 var $nbColonnes;
	 var $cellule;
	 var $cellulesSuivantes;
	 var $ligneInfo;
	 var $repeatLastColonne;

	 var $var_values;
	 
	/**
	 * Constructeur
	 * Initalise la stucture.
	 */
	function ImportStruct(){
		$this->struct=array();
	}
	
	/**
	 * Obtenir le critre de diffrenciation cellule
	 * @return string Libll de la cellule permettant de dfinir un groupe de lignes.
	 */
	function getCellule(){
		  return $this->cellule;
	}
	
	/**
	 * Obtenir le critre de rptition derniere cellule
	 * @return bool (true ou false)
	 */
	function getRepeatLastColonne(){
		  return $this->repeatLastColonne;
	}
	
	/**
	 * Obtenir le critre de diffrenciation cellulesSuivantes.
	 * Retourne un tableau indx par les liblls des cellules permettant distinguer les lignes de structures entre elles.
	 * Les valeurs de ce tableau sont des tableau contenant les diffrentes valeurs que peuvent prendre ces cllules.
	 * @return array Tableau indx par les liblls des cellules permettant distinguer les lignes de structures entre elles.
	 */
	function getCellulesSuivantes(){
		  return $this->cellulesSuivantes;
	}

	/**
	 * Obtenir la stucture de donne d'import
	 * Retourne un tableau dont les valeurs sont les libll des champs d'import lus.
	 * @param array Tableau de structure des donnes importes
	 */	
	function getStruct(){
		return $this->struct;
	}
	
	/**
	 * Obtenir les coordonnes du champ spcifi dans l'ImportStruct.
	 * Le champ pouvant apparaitre plusieurs fois, on retourne donc un tableau de coordonnes, dans leur ordre d'apparition.
	 * La recherche l'effectue ligne  ligne, de gauche  droite.
	 * @param string $var_name Le nom du champs dans l'ImportStruct.
	 * @return array Un tableau de coordonnes. Une coordone est un tableau  2 cles, "x" pour les abscisses et "y" pour les ordonns.
	 */
	function getCoords($var_name){
		//lecture de chacunes des lignes
		foreach($this->struct as $x => $ligne){
			//on cherche les colonnes contenant $var_name (on recupere les y pour le x courant)
			$cols=array_keys($ligne,$var_name);
			if($cols){
				foreach($cols as $i => $y){
					$coords[]=Array("x"=>$x, "y"=>$y);
				}
			}
		}
		
		return $coords;
	}
	
	/**
	 * Convertion d'une valeur d'import en valeur d'export.
	 * Si 
	 * @param array $export_var_values Tableau contenant les valeurs du champ possibles spcifies par l'export.
	 * @param string $import_var_name Le nom du champ d'import dont on veut convertir la valeur
	 * @param mixed $import_var_value La valeur du champ d'import que l'on veut convertir 
	 */
	function importVarValue2ExportVarValue($export_var_values, $import_var_name, $import_var_value){
		messageDebug("importVarValue2ExportVarValue($export_var_values, $import_var_name, $import_var_value)");
		print("importVarValue2ExportVarValue($export_var_values, $import_var_name, $import_var_value)<br>");
		//print_r($export_var_values);
		if(!is_array($export_var_values)||count($export_var_values)==0){
			die("ImportStruct::importVarValue2ExportVarValue($export_var_values, $import_var_name, $import_var_value): \$export_var_values ne contient pas de valeurs de remplacement pour le champs '$import_var_name'. Complter la mthode ExportStruct::getVarValues($var_name).");
		}
		
		//cas ou il y a bien des valeurs spcifies par l'export.
		if(is_array($this->var_values[$import_var_name])&& (count($export_var_values)==count($this->var_values[$import_var_name]))){
			
			//rcupration de l'indice de la valeur
			$indice_valeur=array_keys($this->var_values[$import_var_name], $import_var_value);
			
			//Erreur si plusieurs indices
			if(count($indice_valeur)>1){
				die("ImportStruct::importVarValue2ExportVarValue($export_var_values, $import_var_name, $import_var_value) : La valeur \"$import_var_value\" a plusieurs correspondances possibles. Vrifier que la classe ImportStruct est bien surcharg et que l'attribut \$var_values est correctement valu.");
			//Erreur si pas d'indice
			}elseif(!$indice_valeur){
				
				//on test si on ne chechait pas lachaine vide (LE cas particulier)
				if(empty($import_var_value)){
					
					$i=0;
					$trouve=false;
					foreach($this->var_values[$import_var_name] as $k => $v){
						if(empty($v)){
							$indice_valeur=$i;
							$trouve=true;	
						}
						$i++;
					}
					if($trouve){
						$export_var_value=$export_var_values[$indice_valeur[0]];
					}else{
						die("ImportStruct::importVarValue2ExportVarValue: Erreur cas particulier");
					}
				}
				
				die("ImportStruct::importVarValue2ExportVarValue($export_var_values, $import_var_name, $import_var_value): La valeur \"$import_var_value\" n'a pas de correspondances possibles. Vrifier que la classe ImportStruct est bien surcharg et que l'attribut \$var_values est correctement valu.");
			//L'indice unique  bien t trouv
			}else{
				$export_var_value=$export_var_values[$indice_valeur[0]];
			}
		//cas ou il n'y a pas de valeurs spcifies par l'export.
		}else{
			die("ImportStruct::importVarValue2ExportVarValue($export_var_values, $import_var_name, $import_var_value): La valeur \"$import_var_value\" n'a pas de correspondances possibles. Vrifier que la classe ExportStruct est bien surcharg et que l'attribut \$var_values est correctement valu.");
		}
		return 	$export_var_value;
	}
		
	/**
	 * Obtenir les valeurs possibles pour un attribut.
	 * Retourne null si un attibut peu avoir n'importe quelle valeur.
	 * 
	 * @param string $var_name Nom de l'attribut.
	 * @return array Valeurs que peut avoir l'attribut. Si null, toutes les valeurs sont possibles.
	 */
	function getVarValue($var_name){
		return $this->var_values[$var_name];
	}	
	
	/**
	 * Obtenir l'ensembles des valeurs possibles pour l'ensemble des attributs.
	 * @return array Valeurs que peut avoir un attribut, indxes par le libll de l'attibut. 
	 */
	function getVarValues(){
		return $this->var_values;
	}
}


?>