<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Classe TransfertBuilder
 * Cet objet permet de crer des donnes exportFile(fichier d'export)  partir d'un importFile (fichier d'import), 
 * en utilisant une correlationStruct (structure * de correlation).
 * @package import_export
 */
class TransfertBuilder {

	/**
	 * @var object ImportFile L'objet d'import des donnes
	 */
	var $importFile;

	/**
	 * @var object ExportFile L'objet d'export des donnes
	 */	
	var $exportFile;
	
	/**
	 * @var object Struct L'objet de correlation de l'ImportFile et l'ExportFile
	 */
	var $correlationStruct;
	

	/**
	 * Constructeur
	 */
	function TranfertBuilder(){
	
	}
	
//-----------------------------------------------------
//			METHODES PUBLIQUES
//-----------------------------------------------------
	
	/**
	 * Affecte la correlationStruct (structure de correlation).
	 * Ici, en l'absence de correlation manuelle, la mthode retournera une correlationStruct "en  dur". 
	 * Pour ce faire, surcharger cette mthode dans une classe fille.
	 */
	function correlate(){
		die("TransfertBuilder::correlate(): Mthode abstaite devant tre surcharge.");
	}
	
	/**
	 * Vrifie la cohrence entre la correlationStruct (structure de correlation) 
	 * et le dataFile (donnes du fichier d'import (ImportFile) ) Types des donnes, valeurs obligatoires,...
	*/
	function verify($data){
		if(count($data)>0){
			return true;
		}else{
			return false;
		}
		
	}
	/**
	 * Obtenir les donnes de l'entit du fichier d'import (ImportFile)
	 * @return array Tableau de donnes lues dans l'ImportFile 
	*/
	function read(){
		return $this->importFile->getReadData();
	}
		
	/**
	 * Utilise les donnes de l'ImportFile (dataFile) pour crer les donnes de l'ExportFile.
	 */
	function create(){
		//print_rr($this);
		//on parse l'importFile
		$this->importFile->parse();
		
		//on lit les donnes importes
		$data=$this->read();
		 //print_rr($this);
		//on les vrifie avant d'inserer
		$i=0;
		while($this->verify($data)){
			//on exporte les donnes importes
			$this->exportFile->write($this->importFile, $this->correlationStruct, $data);
			
			//on continue le parsing de l'importFile
			$this->importFile->parse();
			
			//on lit les donnes importes suivantes
			$data=$this->read();
			$i++;
		}
		print("Fin d'insertion des donnes. ($i entites cres)</br>");
	}
	
	/**
	 * Enregistre les donnes cres dans un Thme. 
	 */
	function reference($theme){
	
	}

//-----------------------------------------------------
//			METHODES PRIVEES
//-----------------------------------------------------	

	
//-----------------------------------------------------
//			ACCESSEURS
//-----------------------------------------------------
	/**
	 * Affecte l'ImportFile.
	 * @param object ImportFile $importFile L'objet d'import des donnes
	 */
	function setImportFile($importFile){
		$this->importFile=$importFile;
	}
	
	/**
	 * Obtenir l'ImportFile.
	 * @return object ImportFile L'objet d'import des donnes
	 */
	function getImportFile(){
		return $this->importFile;
	}
	
	/**
	 * Obtenir la structure de l'ImportFile.
	 * @return object ImportFile L'objet d'import des donnes
	 */
	function getImportFileStruct(){
		return $this->importFile->getStruct();
	}

	/**
	 * Affecte l'ExportFile.
	 * @param object ExportFile $exportFile L'objet d'export des donnes
	 */
	function setExportFile($exportFile){
		$this->exportFile=$exportFile;
	}

	/**
	 * Obtenir l'ExportFile.
	 * @return object ExportFile L'objet d'export des donnes
	 */
	function getExportFile(){
		return $this->exportFile;
	}	
	
	/**
	 * Obtenir la structure de l'ExportFile.
	 * @return object ExportFile L'objet d'export des donnes
	 */
	function getExportFileStruct(){
		return $this->exportFile->getStruct();
	}
}
?>