<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Classe abstraite ExportAstairs
 * Spcifie les attributs et les mthodes ncessaires  l'enregistrement(Export) de donnes vers le type de fichier Astairs (BDD), 
 * organiss selon n'importe quelle structure et ce pour n'importe quel type de donnes (Qcm, Sondages, etc...).
 * Cette classe est donc commune  tous les types de donnes grs par le module d'Export pour le format Astairs (BDD).
 *
 * 
 * @package import_export
 */
class ExportAstairs extends ExportFile {

	/**
	 * Constructeur
	 */
	function ExportAstairs(){
		parent::ExportFile();
	}

	/**
	 * Ecrit l'ensemble de lignes et de colonnes ncessaire  la cration d'une et une seule entit.
	 * @param object ImportFile $importFile Objet d'import, permet de determiner la stucture des donnes lues et de les lire.
	 * @param object CorrelationStruct $correlationStruct, permet de dterminer la correspondance entre les donnes lues et les donnes  crire.
	 * @param array $readData Donnes sources.
	 */	
	function write($importFile,$correlationStruct,$readData ){
		die("ExportAstairs::write(): Mthode abstraite devant tre surcharge.");
	}

	/**
	 * Obtenir l'identifiant d'un theme existant  partir de son libll.
	 * @param object ImportFile $importFile Objet d'import, permet de determiner la stucture des donnes lues et de les lire.
	 * @param object CorrelationStruct $correlationStruct, permet de dterminer la correspondance entre les donnes lues et les donnes  crire.
	 * @param array $readData Donnes sources.
	 * @param string $var_name Libll du champ export contenant le thme.
	 * @return integer Identifiant en base Astairs du thme.
	 */
	function getTheme($importFile, $correlationStruct, $readData,$var_name){
		//rcupration du thme
		// Pour comparer 2 AMS (en franais)
		$libelle=addslashes(trim($this->getCellValue($importFile,$readData,$correlationStruct->exportVarName2ImportVarName($var_name))));
		$libelle_ams='##AMS1##{"'.$libelle.'"}';
		//$res_theme=get_theme_by_libelle(addslashes(trim($this->getCellValue($importFile,$readData,$correlationStruct->exportVarName2ImportVarName($var_name)))));
		$res_theme=get_theme_by_libelle($libelle_ams);
		
		
		if($res_theme&&pg_num_rows($res_theme)==1){
			$id_theme=pg_fetch_result($res_theme,0,0);
		}
		
		if(empty($id_theme)){
			die("ExportAstairsQcm::getTheme($importFile, $correlationStruct, $readData): hoErreur: Le thme \"".$this->getCellValue($importFile,$readData,$correlationStruct->exportVarName2ImportVarName($var_name))."\" n'existe pas.");
		}
		return $id_theme;
	}
}


?>