<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Remplir les blancs 
 * @package import_export
 */
class ExportAstairsFtb extends ExportAstairs {

	/**
	 * Tableau indx par les liblls des champs d'export dont les valeurs sont lues par la mthode write().
	 * Les valeurs sont le nombre de fois ou l'on  appell la mthode getCellValue() sur chacunes des cls.
	 */
	var $read_var_names;
	
	/**
	 * Constructeur
	 * Initialise la structure d'Export.
	 */
	function ExportAstairsFtb(){
		parent::ExportAstairs();
		$this->exportStruct=new ExportStructAstairsFtb();
		$this->reset();
	}
	
	/**
	 * Ecrit l'ensemble de lignes et de colonnes ncessaire  la cration d'une et une seule entit.
	 * @param object ImportFile $importFile Objet d'import, permet de determiner la stucture des donnes lues et de les lire.
	 * @param object CorrelationStruct $correlationStruct, permet de dterminer la correspondance entre les donnes lues et les donnes  crire.
	 * @param array $readData Donnes  crire.
	*/
	function write($importFile, $correlationStruct, $readData){
		
		
		 //print_rr($this);
		//LE FTB
		//cration
		$libelle_ftb=$this->getCellValue($importFile,$readData,$correlationStruct->exportVarName2ImportVarName("libelle_ftb"));
		$texte_ftb=$this->getCellValue($importFile,$readData,$correlationStruct->exportVarName2ImportVarName("texte"));
		$interhtml_texte=$this->getCellValue($importFile,$readData,$correlationStruct->exportVarName2ImportVarName("interpretationHTML_texte"));
		
		echo "donnees lues: \$libelle_ftb=$libelle_ftb  <br>\$interhtml_texte=$interhtml_texte <br>\$texte_ftb=$texte_ftb<br>";
		$liste_mots=$this->getCellValue($importFile,$readData,$correlationStruct->exportVarName2ImportVarName("liste_mots"));
		
		$interhtml_texte=$importFile->importStruct->importVarValue2ExportVarValue($this->exportStruct->getVarValues("interpretationHTML_texte"),$correlationStruct->exportVarName2ImportVarName("interpretationHTML_texte"), $interhtml_texte);
		$liste_mots=$importFile->importStruct->importVarValue2ExportVarValue($this->exportStruct->getVarValues("liste_mots"),$correlationStruct->exportVarName2ImportVarName("liste_mots"), $liste_mots);
		
		//echo "inter=$interhtml_texte et liste=$liste_mots<br>";
		$ftb= new Ftb(0,$libelle_ftb,$texte_ftb,$interhtml_texte,$liste_mots);
		
		
		//rcupration du thme
		$id_theme_ftb=$this->getTheme($importFile, $correlationStruct, $readData,"theme_ftb");
		
		//insertion
		$msg="";
		if(!$ftb->insertToDB($id_theme_ftb, $msg)){
			die("Erreurs Ftb : <br>$msg");
		}
		//print_rr($ftb);
		$this->reset();		
	}
	
	/**
	 * Initialise la classe pour la lecture d'une nouvelle entit  exporter.
	 * Cel  pour effet de rinitialiser l'attribut $read_var_names utilis par la mthode getCellValue().
	 */
	function reset(){
		$this->read_var_names=Array();
	}
	
	/**
	 * Obtenir une valeur importe.
	 * Si la variable apparait plusieurs fois dans la structure, cette mthode retourne la 1ere valeur au premier appel,
	 * la seconde au second appel, etc.
	 * 
	 * @param object ImportFile $importFile Objet d'import.
	 * @param array $readData Tableau contenant les valeurs de donnes
	 * @param string $var_name Nom de la variable dont on veut la valeur 
	 * 
	 * @return mixed La valeur lue.
	 */
	function getCellValue($importFile,$readData, $var_name){
		
		//test si la variable a dja t lue
		if(!array_key_exists($var_name, $this->read_var_names)){
			$this->read_var_names[$var_name]=0; //1ere lecture
		}else{
			$this->read_var_names[$var_name]++; //lectures suivantes
		}
		
		//obtenir les coordonnes de $var_name sur le tableau de donnes importes(et non sur la structure des donnes!!)
		$coords=$importFile->getReadDataCoords($var_name);

		if(count($coords)>1)
			return $readData[$coords[$this->read_var_names[$var_name]]["x"]][$coords[$this->read_var_names[$var_name]]["y"]][1];
		else
			return $readData[$coords[0]["x"]][$coords[0]["y"]][1];
	}
	


}


?>