<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Classe ExportAstairsQcm
 * Classe d'export d'un QCM au format Astairs (BDD).
 * 
 * @package import_export
 */
class ExportAstairsQcm extends ExportAstairs {

	/**
	 * Tableau indx par les liblls des champs d'export dont les valeurs sont lues par la mthode write().
	 * Les valeurs sont le nombre de fois ou l'on  appell la mthode getCellValue() sur chacunes des cls.
	 */
	var $read_var_names;
	
	/**
	 * Constructeur
	 * Initialise la structure d'Export.
	 */
	function ExportAstairsQcm(){
		parent::ExportAstairs();
		$this->exportStruct=new ExportStructAstairsQcm();
		$this->reset();
	}

	/**
	 * Ecrit l'ensemble de lignes et de colonnes ncessaire  la cration d'une et une seule entit.
	 * @param object ImportFile $importFile Objet d'import, permet de determiner la stucture des donnes lues et de les lire.
	 * @param object CorrelationStruct $correlationStruct, permet de dterminer la correspondance entre les donnes lues et les donnes  crire.
	 * @param array $readData Donnes  crire.
	*/
	function write($importFile, $correlationStruct, $readData){
		
		//LA QUESTION
		//cration
		$val_inter_HTML_Q=$importFile->importStruct->importVarValue2ExportVarValue($this->exportStruct->getVarValues("interpretationHTML_question"),$correlationStruct->exportVarName2ImportVarName("interpretationHTML_question"),$this->getCellValue($importFile,$readData,$correlationStruct->exportVarName2ImportVarName("interpretationHTML_question")));
		$question= new Question(0,$this->getCellValue($importFile,$readData,$correlationStruct->exportVarName2ImportVarName("libelle_question")),TYPE_EVALUATION_QCM,$val_inter_HTML_Q);

		//rcupration du thme
		$id_theme_question=$this->getTheme($importFile, $correlationStruct, $readData,"theme_question");
		
		//insertion
		$msg="";
		if(!$question->insertToDB($id_theme_question, $msg)){
			die("Erreurs Question: <br>$msg");
		}

		//LES REPONSES
		//on rcupere le 1er libll de rponse.
		$libelle_reponse=$this->getCellValue($importFile,$readData,$correlationStruct->exportVarName2ImportVarName("libelle_reponse_qcm"));

		//Afin de crer le bon nombre de rponses, on considere que tant que l'on a un $libelle_reponse non null, on a une rponse.		
		$i=0;
		while(!empty($libelle_reponse)){
			//cration
			$val_inter_HTML_R=$importFile->importStruct->importVarValue2ExportVarValue($this->exportStruct->getVarValues("interpretationHTML_reponse_qcm"),$correlationStruct->exportVarName2ImportVarName("interpretationHTML_reponse_qcm"),$this->getCellValue($importFile,$readData,$correlationStruct->exportVarName2ImportVarName("interpretationHTML_reponse_qcm")));
			$reponses[$i]= new ReponseQcm(0,$libelle_reponse,TYPE_EVALUATION_QCM ,$val_inter_HTML_R);
			
			//rcupration du thme
			$id_theme_reponse=$this->getTheme($importFile, $correlationStruct, $readData,"theme_reponse_qcm");
		
			//insertion
			$msg="";
			if(!$reponses[$i]->insertToDB($id_theme_reponse, $msg)){
				die("Erreurs Rponse $i: <br>$msg");
			}
			
			//on rcupere les liblls de rponses suivants.
			$libelle_reponse=$this->getCellValue($importFile,$readData,$correlationStruct->exportVarName2ImportVarName("libelle_reponse_qcm"));
			$i++;
		} 
		
		//LE QCM
		//cration
		//print_rr($readData);
		$qcm= new Qcm(0,$this->getCellValue($importFile,$readData,$correlationStruct->exportVarName2ImportVarName("libelle_qcm")));
		//print_rr($qcm);
		//affectation question
		$qcm->setQuestion($question->getId());
		//print_rr($reponses);
		//affectation rponses
		foreach($reponses as $indice => $reponse){
			$qcm->setReponse($reponse->getId());
			if($importFile->importStruct->importVarValue2ExportVarValue($this->exportStruct->getVarValues("juste_reponse"),$correlationStruct->exportVarName2ImportVarName("juste_reponse"),$this->getCellValue($importFile,$readData,$correlationStruct->exportVarName2ImportVarName("juste_reponse"))))
				$qcm->setJuste( $reponse->getId());
			/*
			$qcm->setJuste($importFile->importStruct->importVarValue2ExportVarValue($this->exportStruct->getVarValues("juste_reponse"),$correlationStruct->exportVarName2ImportVarName("juste_reponse"),$this->getCellValue($importFile,$readData,$correlationStruct->exportVarName2ImportVarName("juste_reponse"))));
			*/
		}
		
		//rcupration du thme
		$id_theme_qcm=$this->getTheme($importFile, $correlationStruct, $readData,"theme_qcm");
		//print_rr($qcm);
		//insertion
		$msg="";
		if(!$qcm->insertToDB($id_theme_qcm, $msg)){
			die("Erreurs QCM : <br>$msg");
		}
		//print_rr($qcm);
		$this->reset();		
	}
	
	/**
	 * Obtenir une valeur importe.
	 * Si la variable apparait plusieurs fois dans la structure, cette mthode retourne la 1ere valeur au premier appel,
	 * la seconde au second appel, etc.
	 * 
	 * @param object ImportFile $importFile Objet d'import.
	 * @param array $readData Tableau contenant les valeurs de donnes
	 * @param string $var_name Nom de la variable dont on veut la valeur 
	 * 
	 * @return mixed La valeur lue.
	 */
	function getCellValue($importFile,$readData, $var_name){
		
		//test si la variable a dja t lue
		if(!array_key_exists($var_name, $this->read_var_names)){
			$this->read_var_names[$var_name]=0; //1ere lecture
		}else{
			$this->read_var_names[$var_name]++; //lectures suivantes
		}
		
		//obtenir les coordonnes de $var_name sur le tableau de donnes importes(et non sur la structure des donnes!!)
		$coords=$importFile->getReadDataCoords($var_name);

		if(count($coords)>1)
			return $readData[$coords[$this->read_var_names[$var_name]]["x"]][$coords[$this->read_var_names[$var_name]]["y"]][1];
		else
			return $readData[$coords[0]["x"]][$coords[0]["y"]][1];
	}
	
	/**
	 * Initialise la classe pour la lecture d'une nouvelle entit  exporter.
	 * Cel  pour effet de rinitialiser l'attribut $read_var_names utilis par la mthode getCellValue().
	 */
	function reset(){
		$this->read_var_names=Array();
	}

	/**
	 * Obtenir la structure d'Export. 
	 * @return array Tableau PHP dfinissant la strcuture de donnes pour l'Export.
	 */
	function getExportStruct(){
		return $this->exportStruct;
	}
}


?>