<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Src 
 * @package import_export
 */
class ExportAstairsSrc extends ExportAstairs {

	/**
	 * Tableau indx par les liblls des champs d'export dont les valeurs sont lues par la mthode write().
	 * Les valeurs sont le nombre de fois ou l'on  appell la mthode getCellValue() sur chacunes des cls.
	 */
	var $read_var_names;
	
	/**
	 * Constructeur
	 * Initialise la structure d'Export.
	 */
	function ExportAstairsSrc(){
		parent::ExportAstairs();
		$this->exportStruct=new ExportStructAstairsSrc();
		$this->reset();
	}
	
	/**
	 * Ecrit l'ensemble de lignes et de colonnes ncessaire  la cration d'une et une seule entit.
	 * @param object ImportFile $importFile Objet d'import, permet de determiner la stucture des donnes lues et de les lire.
	 * @param object CorrelationStruct $correlationStruct, permet de dterminer la correspondance entre les donnes lues et les donnes  crire.
	 * @param array $readData Donnes  crire.
	*/
	function write($importFile, $correlationStruct, $readData){
				
		// LES QUESTIONS
		//on rcupere le 1er libll de question.
		$libelle_question=$this->getCellValue($importFile,$readData,$correlationStruct->exportVarName2ImportVarName("libelle_question"));
		$i=0;
		while(!empty($libelle_question)){
			//cration
			//echo "libquest=$libelle_question<br>";
			$val_inter_HTML_Q=$importFile->importStruct->importVarValue2ExportVarValue($this->exportStruct->getVarValues("interpretationHTML_question"),$correlationStruct->exportVarName2ImportVarName("interpretationHTML_question"),$this->getCellValue($importFile,$readData,$correlationStruct->exportVarName2ImportVarName("interpretationHTML_question")));
			$questions[$i]= new Question(0,$libelle_question,TYPE_EVALUATION_SRC ,$val_inter_HTML_Q);
			
			//rcupration du thme
			$id_theme_question=$this->getTheme($importFile, $correlationStruct, $readData,"theme_question");
		    
			//insertion
			$msg="";
			if(!$questions[$i]->insertToDB($id_theme_question, $msg)){
				die("Erreurs Question $i: <br>$msg");
			}
			
			//on rcupere les liblls de rponses suivants.
			$libelle_question=$this->getCellValue($importFile,$readData,$correlationStruct->exportVarName2ImportVarName("libelle_question"));
			
			$i++;
		}
		
		
		
		
		
        
		//LES REPONSES
		//on rcupere le 1er libll de rponse.
		$libelle_reponse=$this->getCellValue($importFile,$readData,$correlationStruct->exportVarName2ImportVarName("libelle_reponse"));
         //echo "librep=$libelle_reponse<br>";
		//Afin de crer le bon nombre de rponses, on considere que tant que l'on a un $libelle_reponse non null, on a une rponse.		
		$i=0;
		while(!empty($libelle_reponse)){
			//cration
			$val_inter_HTML_R=$importFile->importStruct->importVarValue2ExportVarValue($this->exportStruct->getVarValues("interpretationHTML_reponse"),$correlationStruct->exportVarName2ImportVarName("interpretationHTML_reponse"),$this->getCellValue($importFile,$readData,$correlationStruct->exportVarName2ImportVarName("interpretationHTML_reponse")));
			$reponses[$i]= new Reponse(0,$libelle_reponse,TYPE_EVALUATION_SRC ,$val_inter_HTML_R);
			
			//rcupration du thme
			$id_theme_reponse=$this->getTheme($importFile, $correlationStruct, $readData,"theme_reponse");
		
			//insertion
			$msg="";
			if(!$reponses[$i]->insertToDB($id_theme_reponse, $msg)){
				die("Erreurs Rponse $i: <br>$msg");
			}
			
			//on rcupere les liblls de rponses suivants.
			$libelle_reponse=$this->getCellValue($importFile,$readData,$correlationStruct->exportVarName2ImportVarName("libelle_reponse"));
			//echo "librep=$libelle_reponse<br>";
			$i++;
		}
		//print_rr($reponses); 
		
		//LE SRC
		//cration
		$libelle_src=$this->getCellValue($importFile,$readData,$correlationStruct->exportVarName2ImportVarName("libelle_src"));
		$question_commune=$this->getCellValue($importFile,$readData,$correlationStruct->exportVarName2ImportVarName("libelle_question_commune"));
		$src= new Src(0,$libelle_src,TYPE_EVALUATION_SRC,null,false,$question_commune);
		//print_rr($qrc);
		//affectation question
		// boucle sur les questions
		foreach($questions as $indice => $question){
		//$src->setQuestion($question->getId());
		$src->setObjQuestion($question);
		}
		//print_rr($qrc);
		//affectation rponses
		
		foreach($reponses as $indice => $reponse){
			//$src->setReponse($reponse->getId());
			$src->setObjReponse($reponse);
		}
		/*
		foreach($questions as $indiceQ => $question){
			foreach($reponses as $indiceR => $reponse){
			if($importFile->importStruct->importVarValue2ExportVarValue($this->exportStruct->getVarValues("juste_reponse"),$correlationStruct->exportVarName2ImportVarName("juste_reponse"),$this->getCellValue($importFile,$readData,$correlationStruct->exportVarName2ImportVarName("juste_reponse")))){
			$qrc->setJuste($question->getId(),$reponse->getId());
			}
			}
		}
		*/
		//print_rr($src);
		//rcupration du thme
		$id_theme_src=$this->getTheme($importFile, $correlationStruct, $readData,"theme_src");
		
		//insertion
		$msg="";
		if(!$src->insertToDB($id_theme_src, $msg)){
			die("Erreurs SRC : <br>$msg");
		}
		//print_rr($qcm);
		$this->reset();		
	}
	
	/**
	 * Obtenir une valeur importe.
	 * Si la variable apparait plusieurs fois dans la structure, cette mthode retourne la 1ere valeur au premier appel,
	 * la seconde au second appel, etc.
	 * 
	 * @param object ImportFile $importFile Objet d'import.
	 * @param array $readData Tableau contenant les valeurs de donnes
	 * @param string $var_name Nom de la variable dont on veut la valeur 
	 * 
	 * @return mixed La valeur lue.
	 */
	function getCellValue($importFile,$readData, $var_name){
		
		//test si la variable a dja t lue
		if(!array_key_exists($var_name, $this->read_var_names)){
			$this->read_var_names[$var_name]=0; //1ere lecture
		}else{
			$this->read_var_names[$var_name]++; //lectures suivantes
		}
		
		//obtenir les coordonnes de $var_name sur le tableau de donnes importes(et non sur la structure des donnes!!)
		$coords=$importFile->getReadDataCoords($var_name);

		if(count($coords)>1)
			return $readData[$coords[$this->read_var_names[$var_name]]["x"]][$coords[$this->read_var_names[$var_name]]["y"]][1];
		else
			return $readData[$coords[0]["x"]][$coords[0]["y"]][1];
	}
	
	/**
	 * Initialise la classe pour la lecture d'une nouvelle entit  exporter.
	 * Cel  pour effet de rinitialiser l'attribut $read_var_names utilis par la mthode getCellValue().
	 */
	function reset(){
		$this->read_var_names=Array();
	}

	/**
	 * Obtenir la structure d'Export. 
	 * @return array Tableau PHP dfinissant la strcuture de donnes pour l'Export.
	 */
	function getExportStruct(){
		return $this->exportStruct;
	}
	


}


?>