<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Classe ExportStructAstairsQrc
 * Spcifie des mthodes et des attributs ncssaires  la dfinition
 * d'une structure d'export de donnes.
 * Permet de spcifier les donnes ncessaires  la cration de donnes de type Qrc (TYPE_EVALUATION_QRC) vers
 * le format Astairs(BDD).
 * 
 * @package import_export
 */
class ExportStructAstairsQrc extends ExportStructAstairs{

	/**
	 * @var object ExportStructAstairs Structure d'une Question
	 */
	var $exportStructQuestion;

	/**
	 * @var object ExportStructAstairs Structure d'une Reponse
	 */
	var $exportStructReponse;
	
	/**
	 * Constructeur
	 */
	function ExportStructAstairsQrc(){
		parent::ExportStructAstairs();
		
		$class_vars = Qrc::getRequiredVars();
		foreach ($class_vars as $i => $name) {
		    $this->struct[]=$name;
		}
		
		$this->exportStructQuestion = new ExportStructAstairsQuestion();
		$this->exportStructReponse = new ExportStructAstairsReponse();
		
		$this->struct=array_merge($this->struct, $this->exportStructQuestion->getStruct(),$this->exportStructReponse->getStruct()); 	
		
	}
	
	/**
	 * Obtenir les valeurs possibles pour un attribut.
	 * Retourne null si un attribut peut avoir n'importe quelle valeur.
	 * 
	 * @param string $var_name Nom de l'attribut.
	 * @return array Valeurs que peut avoir l'attribut. Si null, toutes les valeurs sont possibles.
	 */
	function getVarValues($var_name){
		return array_merge(Sondage::getVarValues($var_name),$this->exportStructQuestion->getVarValues($var_name),$this->exportStructReponse->getVarValues($var_name));
	}
}
?>