<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Classe abstraite ImportCsv
 * Spcifie les attributs et les mthodes ncessaires  l'importation(Import) de donnes vers le type de fichier Csvs (Dossier), 
 * organiss selon n'importe quelle structure et ce pour n'importe quel type de donnes (Qcm, Sondages, etc...).
 * Cette classe est donc commune  tous les types de donnes grs par le module d'Import pour le format Csv (Dossier).
 * 
 * @package import_export
 */
class ImportCsv extends ImportFile {

	/**
	 * Constructeur
	 */
	function ImportCsv($dataFile){
		parent::ImportFile($dataFile);
	}
	
	/**
	 * Lecture du dataFile vers le format intermdiaire.
	*/
	function parse(){
		
		// ouverture du fichier
		if(!$this->fp)
			$this->fp=fopen($this->dataFile,"r");
		// position pointeur
		$pointeur_position=ftell($this->fp);
		$this->read_data=$this->read();
		
		if(!$this->read_data)
			fclose($this->fp);
	}
	
	/**
	 * Lit l'ensemble de lignes et de colonnes ncessaire  la cration d'une et une seule entit.
	*/
	function read(){
		if(!$this->fp ||feof($this->fp))
			return null;
		// recupre le tableau de structure
		$tableStruct=$this->getStruct();
		$size_tableStruct=sizeof($tableStruct);
		// Initialisation du tableau retourn par la mthode
		$tab_retour=array();
		// analyse des attributs de la structure
		// NOTE : A SUIVRE La prise en compte des autres attributs
		$champ_reference=$this->getCellule();
		// determine la valeur du champ reference
		if($champ_reference && $champ_reference=='idtmp'){
			// recupere les coordonnes du champ dans le tableau de structure
			$tabcoords=$this->getStructCoords('idtmp');
			$val_champ=$tabcoords[0]['y'];
			// recupre la position du pointeur de fichier
			$pointeur_position=ftell($this->fp);
			// lecture d'une ligne dans le fichier
			$ligne=fgets($this->fp);
			// On met la ligne en table
			$tab=explode(";",$ligne);
			$valeur_champ=$tab[$val_champ];
			$indice=$valeur_champ;
			// repositionne le pointeur de fichier
			fseek($this->fp,$pointeur_position);
			reset($tableStruct);
			$indice_struct=0;
			while($indice==$valeur_champ && !feof($this->fp)){
				$pointeur_position=ftell($this->fp);
				$ligne=fgets($this->fp);
				$longueur_ligne=strlen($ligne);
				if($longueur_ligne>0){
					$tab=explode(";",$ligne);
					$size_ligne=sizeof($tab);
					$indice=$tab[$val_champ];
					if($indice!=$valeur_champ){
						fseek($this->fp,$pointeur_position);
						break ;
					}
					if($indice_struct<=$size_tableStruct-1)
						 list(,$val)=each($tableStruct);
					while(list($ind2,$val2)=each ($val)){
						$valeur=$this->getParseCell($tab[$ind2]);
						//$tablo[$ind2]=array("$val2",trim($tab[$ind2]));
						$tablo[$ind2]=array("$val2","$valeur");
					}
					// si colonne repetitive
					if($this->getRepeatLastColonne()){
						$size_val=sizeof($val);
						$val2=$val[$size_val -1];
						for($i=sizeof($val);$i<$size_ligne;$i++){
							$valeur=$this->getParseCell($tab[$i]);		
							//$tablo[$i]=array("$val2",trim($tab[$i]));
							$tablo[$i]=array("$val2","$valeur");
						}
					}
					 reset($val);
					$tab_retour[]=$tablo;
					$indice_struct++;
				}
			}
			reset($tableStruct);
			$indice_struct=0;
		}
		else{
			// Ici traitement des autres cas (ex : pas de champ reference ou cellules suivantes )
			// A SUIVRE ....
		}
		return $tab_retour;
	}
	
	/**
	* Parse  une cellule de fichier Csv
	* @param string : la cellule
	* @return string : la cellule parse
	*/
	function getParseCell($cellule){
		$valeur=trim($cellule);
		
		if(substr($valeur,0,1)=="\""){
			//echo "cellule=$cellule<br>";
			$valeur=substr($valeur,1);
			//echo "val=$valeur<br>";
		}
		
		
		if(substr($valeur,-1,1)=="\""){
			$valeur=substr($valeur,0,strlen($valeur)-1);
			//echo "val=$valeur<br>";
		}
		
		return $valeur;
	
	}

	
}


?>