<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Fabrique des objets
 * @package import_export
 */
class ImportFileCsvFactory {
	
	/**
	 * Constructeur de la fabrique.
	 * @param 
	 */
	 function ImportFileCsvFactory(){
	 
	 }
	 
	 /**
	 * Creation de l'objet
	 */
	 function create($type,$datafile){
		switch($type){
			case TYPE_EVALUATION_QCM :
				return new ImportCsvQcm($datafile);
			break;
			case TYPE_EVALUATION_SONDAGE :
				 return new ImportCsvSondage($datafile);
			break;
			case TYPE_EVALUATION_FTB :
				return new ImportCsvFtb($datafile);
			break;
			case TYPE_EVALUATION_QRC :
				 return new ImportCsvQrc($datafile);
			break;
			case TYPE_EVALUATION_SRC :
				 return new ImportCsvSrc($datafile);
			break;
			//TODO a dplacer dans la bonne factory
			case TYPE_CATEGORIE_RESSOURCE_GLOSSAIRE :
				return new ImportCsvGlossaire($datafile);
		}
	 }


}


?>