<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
* Cette classe d�crit un individu (nom, pr�nom, login...). Elle devrait �tre "abstraite" car on ne peut ins�rer d'enregistrement dans la base de donn�es
*
* Voici la classe dont h�ritent les classes Formateur et Utilisateur. Ici le type d'individu n'est cas connu. En contrepartie, on s'occupe
* des donn�es qui sont communes au Formateur et au Stagiaire.
*
* @author CHABOISSIER Jonathan <jc@afide.fr>
* @since 19/05/2004
* @package individu
*/
class Individu
{
        /**
        * @var string Attribut de la classe Individu
        */
        var $id ;
        /**
        * @var string Identifiant unique cod�
        */
        var $id_user ;
        /**
        * @var string Attribut de la classe Individu
        */
        var $login ;
        /**
        * @var string Attribut de la classe Individu
        */
        var $password ;
        /**
        * @var string Attribut de la classe Individu
        */
        var $nom ;
        /**
        * @var string Attribut de la classe Individu
        */
        var $prenom ;
        /**
        * @var string : Mini cha�ne determinant la cat�gorie de l'utilisateur : formateur seulement ou formateur utilisateur
        */
        var $categorie ;
        /**
        * @var string Attribut de la classe Individu
        */
        var $adresse ;
        /**
        * @var string Code postal
        */
        var $code ;
        /**
        * @var string Attribut de la classe Individu
        */
        var $ville ;
        /**
        * @var string Attribut de la classe Individu
        */
        var $email ;
        /**
        * @var string N� de t�l�phone fixe
        */
        var $telfixe ;
        /**
        * @var string N� de t�l�phone portable
        */
        var $telport ;
        /**
        * @var string Attribut de la classe Individu
        */
        var $langue ;
        /**
        * @var object Organisme : Objet organisme
        */
        var $org ;
        /**
        * @var integer Identifiant du fichier de photo
        */
        var $photo ;


        /**
        * Constructeur de la classe Individu
        *
        * Il y a deux moyens de cr�er un individu : � partir d'un identifiant $num (seul le premier param�tre doit $etre donn�) ou bien en passant
        * en param�tres toutes les valeurs � assigner � l'objet.
        * Le jour o� la surchage des m�thodes est autoris�e sur PHP (version 5 ?), il serait interessant de reprendre
        * ma premi�re id�e (deux constructeurs diff�rents)
        *
        * @param integer $num identifiant en base de donn�es de l'utilisateur
        * @param string $log Le login � saisir pour se connecter en Front Office
        * @param string $passwd Le mot de passe n�c�ssaire pour se connecter en Front Office
        * @param string $name Nom de l'individu
        * @param string $pre Pr�nom de l'individu
        * @param string $cate Cat�gorie de l'individu
        * @param string $adr Adresse de l'individu (exemple 83 boulevard Port-Royal)
        * @param string $cod Code postal de la ville de l'individu
        * @param string $vil Nom de la ville de l'individu
        * @param string $mail Adresse mel de l'individu
        * @param string $fix Num�ro de t�l�phone fixe de l'individu
        * @param string $port Num�ro de t�l�phone portable de l'individu
        * @param string $lang Langue de l'utilisateur
        * @param object Organisme $orga: Organisme de l'individu
        * @param string $fic Nom du fichier image correspondant � la photo de l'utilisateur
        */
        function Individu($num=0, $log="" , $passwd="" , $name="" , $pre="" , $cate="", $adr="" , $cod="" , $vil="" ,
                $mail="" , $fix="" , $port="" , $lang="" , $orga="" , $fic="")
        {
                // echo "Class individu : constructeur<br>" ;

                // Constructeur � partir d'un identifiant d'enregistrement en base de donn�es
                // On v�rifie que le login ne contient rien pour �tre sur qu'on d�sire construire � partir de la base de donn�es
                if(func_num_args()==1)
                {
                        // echo "Class Individu : constructeur avec num<br>" ;

                        // Ancienne m�thode
                        // $requete="SELECT * FROM utilisateurs WHERE num_user=$num" ;
                        // $result=pg_query($requete) ;

                        // Avec du PL/SQL
                        //$result=get_infos_individu($num);
						$result=get_individu($num);
                        $row=pg_fetch_array($result) ;
						
                        // On copie la ligne dans les attributs
                        $this->id = $num ;
                        $this->id_user = $row[1] ;
                        $this->login = $row[2] ;
                        $this->password = $row[3] ;
                        $this->nom = $row[4] ;
                        $this->prenom = $row[5] ;
                        //$this->categorie = $row["categorie"] ;
                        $this->adresse = $row[6] ;
                        $this->code = $row[7] ;
                        $this->ville = $row[8] ;
                        $this->email = $row[9] ;
                        $this->telfixe = $row[10] ;
                        $this->telport = $row[11] ;
                        $this->langue = $row[12] ;
//                        $this->org = $row[13];

                        // Si l'identifiant de l'oragnisme est nul ou NULL, alors l'organisme est celui par d�faut
                        
                        //if($row[13]==0 || $row[13]=="")
                        if(!$row[13])
                                $this->org = new Organisme("");
                        else
                                $this->org = new Organisme($row[13]) ;
                        
						$this->photo=$row[14];
							

                }
                // constructeur avec des param�tres pour l'affectation des attributs
                else
                {
                        // Faut-il verifier la coh�rence des donn�es envoy�es ?
                        $this->login = $log ;
                        $this->password = $passwd ;
                        $this->nom = $name ;
                        $this->prenom = $pre ;
                        $this->adresse = $adr ;
                        $this->code = $cod ;
                        $this->ville = $vil ;
                        $this->email = $mail ;
                        $this->telfixe = $fix ;
                        $this->telport = $port ;
                        $this->langue = $lang ;
                        $this->org = $orga ;
                        $this->photo = $fic ;

                        // Si le param�tre $cate existe c'est que l'on veut cr�er un formateur, donc on affecte cette valeur � l'attribut
                        // categorie de l'objet en cours de cr�ation (un Stagiaire n'a pas d'attribut categorie
                        if(isset($cate))
                                $this->categorie = $cate ;
                }
        }


        /**
        * Fonction qui tente l'insertion en base de donn�es de l'objet Individu
        *
        * Cette fonction se charge de l'insertion en base de donn�es de l'individu repr�sent� par l'objet.
        * Il faut bien sur v�rifier si le login et le passe ne sont pas d�j� utilis�s
        * Cette fonction retourne l'identifiant cr�e ou 0 si il y a eu un probl�me
        * @global string  $nombaseclient
        * @global string  $base_ref
        * @global string  $site_heberge
        * @global string  $server
        * @global string  $nombase
        * @global string  $categorie La cat�gorie de l'individu u > utilisateur, f > formateur. Si cette variable ne contient rien, alors
        * on lui affecte 'u' par d�faut
        * @return integer  Cette valeur est celle de l'identifiant de la ligne enregistr�e en base de donn�es. On retourne � 0 en cas de probl�me
        */
        function insertToDB()
        {
                // Variable globales utilis�es pour v�rifier l'existence du login dans les bases de donn�es clientes
                global $nombaseclient, $base_ref, $site_heberge, $server, $nombase, $categorie ;

                // Variables utilis�es dans la requ�te d'insertion
                $log = addslashes($this->login);
                $pass = addslashes($this->password);
                // Nom en majuscuke
                $nom=strtoupper($this->nom);
                $nom = addslashes($nom);
                // Formatage du pr�nom
                $prenom=strtolower($this->prenom);
                $prenom=ucwords($prenom);
                $prenom = addslashes($prenom);
                $email = addslashes($this->email);
                $adresse = addslashes($this->adresse);
                $codeposte = addslashes($this->codeposte);
                $ville = addslashes($this->ville);
                $email = addslashes($this->email);
                $telfixe=addslashes($this->telfixe);
                $telport=addslashes($this->telport);
                $photo = $this->photo;

                // On d�finit une variable pour l'organisme
                if($this->org)
                        // La variable $num_org est �gale � l'identifiant en base de donn�es de l'objet $org
                        $num_org = $this->org->toString("N") ;
                else
                        $num_org = 0 ;

                // G�n�ration d'un id unique
                $this->id_user = $token = md5(uniqid(rand()));

                // On test le login et le mot de passe (cha�nes alphanum�riques non vides)
                if(is_alphanum($log) && $log!='' && is_alphanum($pass) && $pass!='')
                {
                        // Note : il faut v�rifier que le $log n'est pas dans la table acces_backoffice sauf pour le temporaire
                        if($log != 'temporaire' && isset($nombaseclient))
                        {
                                // Connection � la base du client
                                $link = pg_Connect("$server", "", "", "", "$nombaseclient");
                                $sql="select * from acces_backoffice where login='$log'";
                                $reslog=pg_query($link, $sql);

                                // On test l'existence de ce login
                                $nblog=pg_numrows($reslog);
                                pg_close($link);

                                // Si il s'agit site en location, on verifie que le login n'est pas ds la base de r�f�rence
                                if($nblog==0 && $site_heberge==1)
                                {
                                        $link=pg_Connect("$server", "", "", "", "$base_ref");
                                        $req="select * from utilisateurs where login='$log'";
                                        $resref=pg_query($link, $req);
                                        $nblog=pg_numrows($resref);
                                        pg_close($link);
                                }
                        }
                        else
                                $nblog=0;

                        // Ce login n'est pas utilis� dans les tables utilisateurs et acces_backoffice des bases $nombase et $nombaseclient
                        if($nblog==0)
                        {
                                pg_Connect("$server", "", "", "", "$nombase");

                                // On regarde s'il existe d�j� ce login
                                $tst=pg_query("select * from  UTILISATEURS where login='$log';");
                                $cnt=pg_numrows($tst);

                                // Login inexistant > on effectue l'insertion
                                if($cnt==0)
                                {
                                        $req="insert into UTILISATEURS
                                        (id_user,login,password,nom,prenom,adresse,code,ville,email,telfixe,telport,fic_photo,langue,num_org,categorie)
                                        values('$token','$log','$pass','$nom','$prenom','$adresse','$codeposte','$ville','$email','$telfixe','$telport','$photo','$languestag','$num_org','$categorie');";

                                        // Insertion en base de donn�es
                                        pg_query($req);

                                        // Il faut r�cup�rer le num�ro de l'enregistrement cr�e
                                        // note � l'heure de l'�criture de cette m�thode, il n'existe pas pour postgres de fonction permettant de donner
                                        // l'identifiant de la derni�re ligne cr��e apr�s l'insertion... A changer � l'avenir !
                                        $this->num_user = $retour = pg_result(pg_query("SELECT num_user FROM utilisateurs WHERE login='$log' ;"),0,0) ;

                                        // Si $site_heberge==1 alors il faut ajouter le nouvel inscrit dans la table acces_backoffice
                                        // Note : a suivre ...
                                        if($site_heberge==1)
                                        {
                                                // pg_close($database);
                                                $client="stagiaire";
                                                $userback=0;
                                                $link=pg_connect("$server","","","","$nombaseclient");
                                                $ins=pg_query($link,"insert into acces_backoffice (login,password,serverback,client,userback) values('$log','$pass','$serverfront','$client','$userback');");
                                                pg_close($link);
                                        }
                                }
                                // Le login est d�j� utilis�
                                else
                                {
                                        // "erreur login existant"
                                        $retour = -100 ;
                                }
                        }
                        else
                        {
                                // "erreur login existant"
                                $retour = -100 ;
                        }
                }
                else
                {
                        // "erreur login non alphanum�rique"
                        $retour = -101;
                }

                // On se reconnecte � la base $nombase pour que les pg_query suivant fonctionne (car sinon il y a confusion)
                pg_Connect("$server", "", "", "", "$nombase");

                // retouner un entier code ou identifiant
                return($retour);

        }


        /**
        * Fonction qui met � jour l'enregistrement en table utilisateurs
        *
        * Cette fonction ne peut �tre utilis� que si l'objet poss�de un identifiant.
        * Ici, on a acc�s � l'attribut identifiant de l'organisme de l'utilisateur
        *
        * @return integer : Le code retour est n�gatif s'il y a une erreur, sinon on retourne vrai
        */
        function updateToDB(){
        	// echo "Class Individu : updateToDB()" ;

            // Il faut que l'identifiant soit connu
            if($this->id != 0){
            	// On d�finit une variable pour l'organisme
//                if($this->org){
//                	// La variable $num_org est �gale � l'identifiant en base de donn�es de l'objet $org
//                    //$num_org = $this->org->num_org ;
//                    $num_org = $this->org ;
//                }
//                else{
//                	//$num_org = 0 ;
//                    $num_org = null ;
//                }

                        if(maj_individu(int2Sql($this->id), string2Sql($this->login),string2Sql($this->password),string2Sql($this->nom),string2Sql($this->prenom), string2Sql($this->adresse),
                                string2Sql($this->code), string2Sql($this->ville), string2Sql($this->email), string2Sql($this->telfixe), string2Sql($this->telport), $this->langue, int2Sql($this->org->getId()), null,int2Sql($this->photo)))
                                return true ;
                        else
                                return -1 ;
                }
                // Identifiant inconnu : mise � jour impossible
                else
                {
                        return -2 ;
                }
        }


        /**
        * Fonction qui retourne une cha�ne de caract�re contenant des informations sur l'individu.
        *
        * Fonction qui retourne une cha�ne de caract�re contenant des informations sur l'individu.
        * Si on ne passe aucun param�tre, la cha�ne retourn�e contient le nom et le pr�nom. Par contre, si le param�tre est d�fini,
        * il est utilis� comme format de retour. On peut ainsi modeler l'affichage comme on le d�sire.
        *
        * @param string : le param�tre determine ce qu'on retourne. Pour afficher un attribut, il faut mettre dans le format :Nom du fichier image de l'individu
        * [nom_attribut]
        *
        * exemple : si on veut le nom, le login et le code postal > $user->toString("Nom : [nom]<br>Login : [login]<br>& code postal : [code]");
        * Ce param�tre peut �tre non d�fini. On retourne quelque chose du format : [nom] [prenom]
        *Nom du fichier image de l'individu
        * @return string : On retourne la cha�ne de caract�res cr��e � partir du format
        */
        function toString($format="")
        {
                // echo "Class individu : toString()<br>" ;
                global $serverfront;

                // Aucun param�tre, on retourne Nom Pr�nom
                if($format=="")
                        return $this->nom." ".$this->prenom ;

                // Ce tableau contient les "balises" � remplacer par des valeurs
                $tab_replace = array("\[nom\]"=>$this->nom,"\[prenom\]"=>$this->prenom,"\[org\]"=>$this->org->libelle_org,"\[login\]"=>$this->login,"\[password\]"=>$this->password,
                "\[adresse\]"=>$this->adresse,"\[code\]"=>$this->code,"\[ville\]"=>$this->ville,"\[categorie\]"=>$this->categorie,"\[email\]"=>$this->email,
                "\[telfixe\]"=>$this->telfixe,"\[telport\]"=>$this->telport,"\[langue\]"=>$this->langue,"\[photo\]"=>$this->photo,
                "\[image_photo\]" => "<img src=\"http://$serverfront/data/photos/".$this->photo."\" alt=\"nom_image : ".$this->photo."\">") ;

                while($tab=each($tab_replace))
                        $format = ereg_replace("$tab[0]",$tab[1],$format) ;

                return $format ;
        }

        /**
        * Fonction qui retourne la liste de toutes les formations de l'individu.
        *
        * Fonction qui retourne la liste de toutes les formations de l'individu. Si l'individu est de cat�gorie 'fu', cette fonction
        * donne les formations pour lesquelles il est reponsable mais aussi celles dans lesquelles il est simplement
        * stagiaire.
        * @param string $classement ASC ou DESC selon le classement d�sir�
        * @param integer $ordre_chrono Si ce param�tre est �gal � 1 alors on affiche les formation par date de d�but
        * @return integer  On retourne un r�sultat de requete qui contient (...� remplir)
        */
        function getFormations($classement="ASC", $ordre_chrono='date_debut')
        {
                // echo "Class Individu : getFormations();<br>";
                //return get_formations_individu($this->num_user, $classement, $ordre_chrono) ;
                return get_individu_formations($this->id, $classement, $ordre_chrono) ;
        }

        /**
        * Fonction qui retourne la liste de tous les groupes de l'individu.
        *
        * Fonction qui retourne la liste de tous les groupes de l'individu. On ne donne pas les droits pour chaque groupe.
        * Donc utilisez la m�thode getDroitGroupe()
        * @param string : ASC ou DESC selon le classement d�sir�
        * @return integer : On retourne un r�sultat de requete qui contient (num_groupe, nom_groupe, id_pere, placemin, placemax)
        */
        function getGroupes($classement="ASC")
        {
                //return get_classe_individus($this->num_user, $classement) ;
                return get_individu_classes($this->id, $classement) ;
        }

        /**
        * Fonction qui retourne la liste des droits de l'individu pour un groupe donn�
        * @param integer : Identifiant du groupe concern� (peut-�tre faudra-t-il un jour passer en param�tre un objet et non un identifiant... A voir
        * @param string : ASC ou DESC selon le classement d�sir�
        * @return integer : On retourne un r�sultat de requete qui contient (num_droit, libelle_droit, type_droit, acces_fichier, defaut)
        */
        function getDroitsGroupe($groupe, $classement="ASC")
        {
                // Le num�ro du groupe doit �tre connu
                if($groupe)
                        return get_droits_groupe_individu($this->id, $groupe, $classement) ;
                else
                        return false ;
        }


        /**
        * Fonction qui retourne une chaine de caract�re contenant un formulaire (name=formulaireModif)  de cr�ation et modification d'un Individu
        * Fonction qui retourne une chaine de caract�re contenant un formulaire (name=formulaireModif) de cr�ation et modification d'un Individu.
        * Attention : � l'heure actuelle il faut que le fichier style_groupe.css soit inclu dans la page utilisant cette m�thode,
        * tout comme le fichier contenant les fonctions javascript de v�rification �voqu�es plus bas.
        *
        * @param string $page_action nom de la page � charger lors de la soumission du formulaire
        * @param string $function_js nom de la fonction javascript de v�rification du formulaire
        * @param array $tab_hidden tableau associatif contenant [0] = nom input hidden & [1] = valeur de l'input hidden
        * @return string : Chaine de caract�re contenant un formulaire dans un tableau HTML
        */
        function formulaireModif($page_action, $function_js="true", $tab_hidden=Array())
        {
                global $MSG_5, $MSG_6, $MSG_7, $MSG_8, $MSG_9, $MSG_10, $MSG_11, $MSG_12, $MSG_13, $MSG_14, $MSG_15, $MSG_16, $FORM_6 ;
                global $serverfront ,$astairs_directories,$chemin_bo;
                //photo
               $photo_user=$this->getPhoto();
				if(!empty($photo_user)){
					$nom_photo=pg_fetch_result(get_fichier($photo_user),0,1);
					$photo_url=$astairs_directories['PRIVATE_USER_DATA_URL'].$this->getId().'/'.$nom_photo;	
				}

				//On creer le select pour la selection de la photo.
				$component = new guiBoSelectPhoto('select_photo',$photo_url,$this->getLogin(),"$chemin_bo/individu/templates/tpl",array('select_photo'=>'gui_bo_select_photo.tpl'));
				$component->parseComponents('select_photo');
				$component->parse('select_photo_out','select_photo');
				$gui_photo=$component->get('select_photo_out');
                
                $affichage = "
                <form name=\"formulaireModif\" OnSubmit=\"return $function_js;\" action=\"$page_action\"  method=\"POST\" enctype=\"multipart/form-data\">
                <table class=\"tableau_normal\">
                <tr class=\"couleur1\">
                        <td><b>$MSG_5 :</b></td>
                        <td>$this->login</td>" .
                        		"<td rowspan=\"2\">$gui_photo</td>
                </tr>
                <tr class=\"couleur2\">
                        <td><b>$MSG_6 :</b></td>
                        <td>$this->password</td>
                </tr>
                <tr class=\"couleur1\">
                        <td>$MSG_7 :</td>
                        <td colspan=\"2\">$this->nom</td>
                </tr>
                <tr class=\"couleur2\">
                        <td>$MSG_8 :</td>
                        <td colspan=\"2\">$this->prenom</td>
                </tr>
                <tr class=\"couleur1\">
                        <td>$MSG_9 :</td>
                        <td colspan=\"2\"><input type=\"text\" name=\"adresse\" value=\"$this->adresse\" size=\"30\" maxlen=\"50\"></td>
                </tr>
                <tr class=\"couleur2\">
                        <td>$MSG_10 :</td>
                        <td colspan=\"2\"><input type=\"text\" name=\"code\" value=\"$this->code\" size=\"30\" maxlen=\"50\"></td>
                </tr>
                <tr class=\"couleur1\">
                        <td>$MSG_11 :</td>
                        <td colspan=\"2\"><input type=\"text\" name=\"ville\" value=\"$this->ville\" size=\"30\" maxlen=\"50\"></td>
                </tr>
                <tr class=\"couleur2\">
                        <td>$MSG_12 :</td>
                        <td colspan=\"2\"><input type=\"text\" name=\"email\" value=\"$this->email\" size=\"30\" maxlen=\"50\"></td>
                </tr>
                <tr class=\"couleur1\">
                        <td>$MSG_13 :</td>
                        <td colspan=\"2\"><input type=\"text\" name=\"telfixe\" value=\"$this->telfixe\" size=\"30\" maxlen=\"50\"></td>
                </tr>
                <tr class=\"couleur2\">
                        <td>$MSG_14 :</td>
                        <td colspan=\"2\"><input type=\"text\" name=\"telport\" value=\"$this->telport\" size=\"30\" maxlen=\"50\"></td>
                </tr>
                <tr class=\"couleur1\">
                        <td><b>$MSG_16 :</b></td>
                        <td colspan=\"2\">";
                        
                         // recup type individu
                         $tab_type=array();
						 $tab_type=get_individu_types_formates($this->id);
                       if(!empty($tab_type))
							while(list($cle,$val)=each($tab_type)){
								$affichage .=eval('return '.$val.';')."&nbsp;&nbsp;";
							}
						else
							$affichage.=MSG_835;
						$affichage .= "</td>
                </tr>
                <tr class=\"couleur2\">
                        <td colspan=\"3\" align=\"center\"><input type=\"submit\" name=\"submit\" value=\"$FORM_6\"></td>
                </tr>

                </table>
                <input type=\"hidden\" name=\"id\" value=\"$this->id\">" ;

                // Ajout des input de type hidden s'il y en a :

                // Si $tab_hidden contient des informations
                if(count($tab_hidden)) // < cette v�rification n'est peut-�tre pas obligatoire selon la version de PHP
                {
                        while($hidden = each($tab_hidden))
                                $affichage .= "<input type=\"hidden\" name=\"".$hidden[0]."\" value=\"".$hidden[1]."\">\n" ;
                }

                $affichage.= "</form>";

                // Retour de la chaine contenant le formulaire
                return($affichage);
        }

        /**
            Fonction qui affiche le d�tail d'in individu

        */
        function detail(){
            global $MSG_5, $MSG_6, $MSG_7, $MSG_8, $MSG_9, $MSG_10, $MSG_11, $MSG_12, $MSG_13, $MSG_14, $MSG_15, $MSG_16, $FORM_6 ;
            global $serverfront,$astairs_directories, $MSG_78, $MSG_79,$MSG_80 ;
            
            //photo
            $photo_user=$this->getPhoto();
			if(!empty($photo_user)){
				$nom_photo=pg_fetch_result(get_fichier($photo_user),0,1);
				$photo_url=$astairs_directories['PRIVATE_USER_DATA_URL'].$this->getId().'/'.$nom_photo;	
				$photo_alt=MSG_15.$this->getLogin();
			}else{
				$photo_url =DEFAULT_PHOTO_PATH;
				$photo_alt=MSG_15.$this->getLogin();
			}
            
            $affichage = "

                <table class=\"tableau_espace\">
               	<tr class=\"couleur2\">
                        <td><b>$MSG_80 :</b></td>
                        <td>$this->id</td><td rowspan=\"3\"><img src=\"$photo_url\"  width=\"100px\" height=\"100px\" alt=\"$photo_alt\" title=\"$photo_alt\"/></td>
                </tr>
                <tr class=\"couleur1\">
                        <td><b>$MSG_5 :</b></td>
                        <td>$this->login</td>
                </tr>
                <tr class=\"couleur2\">
                        <td><b>$MSG_6 :</b></td>
                        <td>$this->password</td>
                </tr>
                <tr class=\"couleur1\">
                        <td>$MSG_7 :</td>
                        <td colspan=\"2\">$this->nom</td>
                </tr>
                <tr class=\"couleur2\">
                        <td>$MSG_8 :</td>
                        <td colspan=\"2\">$this->prenom</td>
                </tr>
                <tr class=\"couleur1\">
                        <td>$MSG_9 :</td>
                        <td colspan=\"2\">$this->adresse</td>
                </tr>
                <tr class=\"couleur2\">
                        <td>$MSG_10 :</td>
                        <td colspan=\"2\">$this->code</td>
                </tr>
                <tr class=\"couleur1\">
                        <td>$MSG_11 :</td>
                        <td colspan=\"2\">$this->ville</td>
                </tr>
                <tr class=\"couleur2\">
                        <td>$MSG_12 :</td>
                        <td colspan=\"2\">$this->email</td>
                </tr>
                <tr class=\"couleur1\">
                        <td>$MSG_13 :</td>
                        <td colspan=\"2\">$this->telfixe</td>
                </tr>
                <tr class=\"couleur2\">
                        <td>$MSG_14 :</td>
                        <td colspan=\"2\">$this->telport</td>
                </tr>";
                        // recup type individu
						 $tab_type=get_individu_types_formates($this->id);
						 //print_rr($tab_type);

                        $affichage .= "
                <tr class=\"couleur1\">
                        <td><b>$MSG_16 :</b></td>
                        <td  colspan=\"2\">";
						if(!empty($tab_type))
							 while(list($cle,$val)=each($tab_type)){
							 	$chaine=eval('return '.$val.';');
							 	//echo "val=$val et chaine=$chaine<br>";
								$affichage .=$chaine."&nbsp;&nbsp;";
							}
						else
							$affichage.=MSG_835;
						$affichage .="</td>
                </tr>


                </table>";






                // Retour de la chaine contenant le formulaire
                return($affichage);

        }
        
        /**
        * Fonction qui retourne une cha�ne de caract�re contenant des informations sur l'individu.
        * @return string retourne deux chaine de caractere contenant le nom et prenom de l'individu.
        */ 
        function getLibelle(){
        	return $this->nom." ".$this->prenom ;
        }
        
        /**
         * Retourne le Nom de l'Individu
         * @return string retourne une chaine de caractere contenant le nom de l'individu.
         */
        function getNom(){
        	return $this->nom;
        }
        
        /**
         * Retourne le Prenom de l'individu
         * @return string retourne une chaine de caractere contenant le prenom de l'individu.
         */
        function getPrenom(){
        	return $this->prenom;
        }
        
        /**
         * Retourne l'identifiant de l'organisme auquel appartien l'Individu
         * @return object organisme retourne l'Objet organisme.
         */
        function getOrganisme(){
        	return $this->org;
        	//return get_organisme($this->id);
        }
        
        /**
         * Retourne le Login de l'Individu
         * @return string retourne une chaine de caractere contenant le login de l'individu.
         */
        function getLogin(){
        	return $this->login;
        }
        
        /**
         * Retourne le mot de passe de l'Individu
         * @return string retourne une chaine de caractere contenant le mot de passe de l'individu.
         */
        function getPassword(){
        	return $this->password;
        }
        
        /**
         * Retourne l'adresse de l'Individu
         * @return string retourne une chaine de caractere contenant l'adresse de l'individu.
         */
        function getAdresse(){
        	return $this->adresse;
        }
 
        function setAdresse($adresse){
        	$this->adresse=$adresse;
        }
               
        /**
         * Retourne le Code Postal de l'Individu
         * @return string retourne une chaine de caractere contenant le code postal de l'individu.
         */
        function getCode(){
        	return $this->code;
        }
        function setCode($code){
        	$this->code=$code;
        }
        
        /**
         * Retourne la ville de l'Individu
         * @return string retourne une chaine de caractere contenant la ville de l'individu.
         */
        function getVille(){
        	return $this->ville;
        }
        
        function setVille($ville){
        	$this->ville=$ville;
        }
        
        /**
         * Retourne l'Email de l'Individu
         * @return string retourne une chaine de caractere contenant le mail de l'individu.
         */
        function getEmail(){
        	return $this->email;
        }
        
        function setEmail($email){
        	$this->email=$email;
        }
        
        /**
         * Retourne le numero de T�l�phone Fixe de l'Individu
         * @return string retourne une chaine de caractere contenant le numero de telephone fixe de l'indivu.
         */
        function getTelephonefixe(){
        	return $this->telfixe;
        }
        
        function setTelephonefixe($telfixe){
        	$this->telfixe=$telfixe;
        }
        
        /**
         * Retourne le numero de T�l�phone Portable de l'Individu
         * @return string retourne une chaine de caractere contenant le numero de telephone potable de l'individu.
         */
        function getTelephoneport(){
        	return $this->telport;
        }
        
        function setTelephoneport($telport){
        	$this->telport=$telport;
        }
        
        /**
         * Retourne la Langue parl� par l'Individu
         * @return integer retourne le numero de la langue de l'individu.
         */
        function getLangue(){
        	return $this->langue;
        }
        
        /**
         * Retourne la Photo de l'individu
         * @return integer retourne le numero de photo de l'individu.
         */
        function getPhoto(){
        	return $this->photo;
        }
        
        
        function setPhoto($photo){
        	$this->photo=$photo;
        }
        
        /**
         * Retourne l'indentifiant 
         * @return string retourne l'identifiant .
         */
        function getId(){
        	return $this->id; //ancien id_user
        }
        
        function getIdUser(){
        	return $this->id_user;
        }
        
        /**
         * Retourne l'identifiant de l'Individu
         * @deprecated version - Oct 28, 2008
         * @return integer retourne l'id de l'individu.
         */
        function getNum(){
        	echo "Individu::getNum() est depreciee";
        	return $this->id;
        }
        
        /**
         * Retourne la categorie auqel appartient l'individu
         * @return string retourne une chaine de caractere contenant la categorie de l'individu (formateur seulement).
         */
        function getCategorie(){
        	return $this->categorie;
        }
}
?>