<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
	Fichier de fonctions individu
	@package individu
	@modulegroup fonctions
*/
function get_individu_formation_javascript($individu){
	
	$date_jour=get_sql_now();
	
	$res_filieres=get_individu_filieres($individu); 
	$nb_filieres=pg_num_rows($res_filieres);
	$script="";
	$script.="var tabformations=new Array();\n";
    for($i=0;$i<$nb_filieres;$i++){
        $script.="tabformations[$i]=new Array();\n";
        $row_filiere=pg_fetch_row($res_filieres,$i);
        // r�cup�ration des formations
//		$res_formations=get_filiere_formations($row_filiere[0]);
//($individu,$filiere, $ordre='ASC', $orderby='date_debut',$periode=0)
		$res_formations=get_individu_formations_filiere($individu,$row_filiere[0],'ASC','date_debut',2);
        $nb_formations=pg_numrows($res_formations);
        $k=0;
        for($j=0;$j<$nb_formations;$j++){
			$row_formation=pg_fetch_row($res_formations,$j);
			//$tmp_formation=get_ams_libelles($row_formation[1]);
			//$row_formation[1]=get_ams_libelle($tmp_formation,50);
//			echo "\$date_jour=$date_jour et deb=".$row_formation[3]." et fin=".$row_formation[4]."<br>";
//			echo "resdeb=".compare_sql_now_to_sql_date($row_formation[3])."<br>";
//			echo "resfin=".compare_sql_now_to_sql_date($row_formation[4])."<br>";
			if(compare_sql_now_to_sql_date($row_formation[3])<=0 && compare_sql_now_to_sql_date($row_formation[4])>=0){
				$libelle_formation=get_fo_libelle($row_formation[1]);
				$script.="tabformations[$i][$k]=new Array(";
				//$script.="\"$row_formation[0]\",\"$row_formation[1]\");\n";
				$script.="\"$row_formation[0]\",\"$libelle_formation\");\n";
				$k++;
			}
        }
    }
	return $script;
}

// retourne un tableau contenant les libelles des types (categories) de l'individu
function get_individu_types_formates($individu){
	global $MSG_17,$MSG_18,$MSG_2190;
	$res=get_individu_types($individu);
	$tab=array();
	if(VERSION_BASE > VERSION){
		$nb=pg_num_rows($res);
		for($i=0;$i<$nb;$i++){
			  $row=pg_fetch_row($res,$i);
			  //print_rr($row);
			  //eval("\$row[1]=\"$row[1]\";");
			  $tab[]=$row[1];
		}
	}
	else{
		$row=pg_fetch_row($res,0);
		switch($row[0]){
			case 'u' : $tab[]=$MSG_18;break;
			case 'f' :  $tab[]=$MSG_17;break;
			case 'fu' : 
			case 'uf' : $tab[]=$MSG_17;$tab[]=$MSG_18;	break;
		}
	
	}
	return $tab;
}

// retoune la liste des type pour un individu
function get_individu_liste_type($individu){
	 $res=get_individu_types($individu);
	 if(VERSION_BASE > VERSION){
		 $nb=pg_num_rows($res);
		 $liste_type="";
		 for($i=0;$i<$nb;$i++){
			 $row=pg_fetch_row($res,$i);
			 switch($row[0]){
				case 1 : $liste_type .='u';break;
				case 2 : $liste_type .='f';break;
				case 3 : $liste_type .='i';break;
			 }
		 }
	 }
	 else{
		$row=pg_fetch_row($res,0);
		$liste_type=$row[0];
	 }
	 return $liste_type;
}

// supprime un type � un individu
function supprime_individu_type($individu,$type){
	if(VERSION_BASE > VERSION){
		switch($type){
			case 'u' : $typ=1;break;
			case 'f' : $typ=2;break;
		}
		del_individu_type($individu,$typ);
	}
	else{
		switch($type){
			case 'u' : $typ='f';break;
			case 'f' : $typ='u';break;			
		}
		maj_individu_type($individu,$typ);					
	}
}
?>