<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
         @package individu
          @modulegroup plpgsql
          @module plpgsql_individu
*/


// ---------------------------------------------- GET_NOM_PRENOM_INDIVIDU----------------------------------


/**
*   Obtenir le nom et le prenom d'un stagiaire(OLD)
*
*     Obtenir le nom et le prenom de l'stagiaire dont le num�ro est pass� en paramettre
*      L'identifiant resultat contient 2 colonnes:
*           [0] contient le nom
*           [1] contient le prenom
*
*   @param  integer : le numero de l'stagiaire
*    @return string[] : [0]  nom et  [1]prenom
*/
function get_nom_prenom_individu_old($user)
{
    $req="select nom, prenom from utilisateurs where num_user=$user ;";
    $res=pg_query($req);
    return pg_fetch_row($res,0);

}

/**
*   Obtenir le nom et le prenom d'un stagiaire
*
*     Obtenir le nom et le prenom de l'stagiaire dont le num�ro est pass� en paramettre
*      L'identifiant resultat contient 2 colonnes:
*           [0] contient le nom
*           [1] contient le prenom
*
*   @param  integer : le numero de l'stagiaire
*    @return string[] : [0]  nom et  [1]prenom
*/
function get_nom_prenom_individu($user){

    if(VERSION_BASE>VERSION){

        $req="select * from  _af_get_nom_prenom_individu($user) AS (nom varchar, prenom varchar);";
        $res=pg_query($req);
        return pg_fetch_row($res,0);
    }
    else
        return  get_nom_prenom_individu_old($user);


}

/**
*   Obtenir le nom et le prenom d'un stagiaire(OLD)
*
*     Obtenir le nom et le prenom de l'stagiaire dont le num�ro est pass� en paramettre
*      L'identifiant resultat contient 2 colonnes:
*           [0] contient le nom
*           [1] contient le prenom
*
*   @param  integer : le numero de l'stagiaire
*    @return string[] : [0]  nom et  [1]prenom
*/
function get_individu_nom_prenom_old($user)
{
    $req="select num_user,nom, prenom from utilisateurs where num_user=$user ;";
	//echo "req=$req<br>";
    $res=pg_query($req);
    //return pg_fetch_row($res,0);
    return $res;

}

/**
*   Obtenir le nom et le prenom d'un stagiaire
*
*     Obtenir le nom et le prenom de l'stagiaire dont le num�ro est pass� en paramettre
*      L'identifiant resultat contient 2 colonnes:
*           [0] contient le nom
*           [1] contient le prenom
*
*   @param  integer : le numero de l'stagiaire
*    @return string[] : [0]  nom et  [1]prenom
*/
function get_individu_nom_prenom($user){

    if(VERSION_BASE>VERSION){

        //$req="select * from  _af_get_nom_prenom_individu($user) AS (nom varchar, prenom varchar);";
		$req="select * from contraintes.fw_get_individu_nom_prenom($user) as (id int4,nom varchar,prenom varchar)";
		//echo "req=$req<br>";
        $res=pg_query($req);
        //return pg_fetch_row($res,0);
    }
    else
        $res= get_individu_nom_prenom_old($user);
	return $res;


}


// ---------------------------------------------- GET_INFOS_INDIVIDU----------------------------------
/**
* Retourne pratiquement toute la ligne d'enregistrement d'un individu (que les infos utiles) - OLD
*
* Retourne pratiquement toute la ligne d'enregistrement d'un individu (que les infos utiles). Cette fonction
* est utilis�e dans le constructeur d'individu

* @param : integer le numero de l'individu en base de donn�es
*
* @return integer : R�sultat de requete sur base de donn�es : [0 login, 1 password, 2 nom, 3 prenom, 4 id_user, 5 adresse, 6 code, ville, email, telfixe, telport, langue, num_org, categorie, fic_photo]
*/
function get_infos_individu_old($num_user)
{
        // echo "get_infos_individu_old($num_user)<br>";
        return pg_query("SELECT login , password , nom , prenom , id_user, adresse , code , ville , email , telfixe , telport ,
        langue , num_org , categorie , fic_photo
        FROM utilisateurs WHERE num_user=$num_user") ;
}

/**
* Retourne pratiquement toute la ligne d'enregistrement d'un individu (que les infos utiles)
*
* Retourne pratiquement toute la ligne d'enregistrement d'un individu (que les infos utiles). Cette fonction
* est utilis�e dans le constructeur d'individu
*
* @param : integer le numero de l'individu en base de donn�es
*
* @return integer : R�sultat de requete sur base de donn�es : [0 login, 1 password, 2 nom, 3 prenom, 4 id_user, 5 adresse, 6 code, ville, email, telfixe, telport, langue, num_org, categorie, fic_photo]
*/
function get_infos_individu($num_user)
{
        // echo "get_infos_individu" ;

        if(!$num_user)
                return false ;

        if(VERSION_BASE>VERSION){

            $req="select * from _af_get_infos_individu($num_user)
            AS (login varchar, password varchar, nom varchar, prenom varchar, id_user varchar,
            adresse varchar, code varchar, ville varchar, email varchar, telfixe varchar, telport varchar,
            langue varchar, num_org integer, categorie varchar, fic_photo varchar);" ;

            $res = pg_query($req) ;
        }
        else
            $res = get_infos_individu_old($num_user) ;

        return $res ;
}


// ---------------------------------------------- GET_FORMATIONS_INDIVIDU----------------------------------
/**
*  Obtenir les formations d'un individu (OLD)
*
*   Retourne les numeros, noms et qualit� de l'individu pour les formations auxquelles  $individu participe
*   @deprecated : utiliser get_individu_formation
*   @param  integer : le numero de l'individu
*   @param  string : Classement croissant (ASC) ou d�croissant (DESC)
*   @param  integer : si �gal � 1 on classe par date de d�but
*
*   @return  le resultat de la requete (num_cal, nom_cal, "form" ou "util", debut, fin, langue)
*/
function get_formations_individu_old($individu, $classement, $ordre_chrono)
{
        if($ordre_chrono)
                $ordre="debut";
        else
                $ordre="nom_formation";

        if($classement!="asc" && $classement!="DESC")
                $classement="";

        $req="(select  distinct ON(nom_formation) num_cal AS num_formation,nom_cal AS nom_formation,'form', d1.jour AS debut, d2.jour AS fin, langue
                from calendrier, dates d1, dates d2
                where d1.num_date=datedeb AND d2.num_date=datefin AND
                num_cal in
                (select distinct g_num_cal from gestionnaire where g_num_user='$individu') and num_cal in
                (select distinct num_cal from CALENDRIER, DATES A, DATES B where
                datedeb=A.num_date and datefin=B.num_date and current_date between A.jour and B.jour)
                )
                UNION
                (select  distinct ON(nom_formation) num_cal AS num_formation,nom_cal AS nom_formation,'util', d1.jour AS debut, d2.jour AS fin, langue
                from calendrier, dates d1, dates d2
                where d1.num_date=datedeb AND d2.num_date=datefin AND
                num_cal in
                (select g_num_cal from gestionnaire  where g_num_gest_g in
                (select distinct gu_num_gest_gr from gestionutil where gu_num_user='$individu')) and num_cal in
                (select distinct num_cal from CALENDRIER, DATES A, DATES B
                where datedeb=A.num_date and datefin=B.num_date and current_date between A.jour and B.jour)
                )ORDER BY $ordre $classement;";
		//echo $req."<BR>";
        $result=pg_query($req);
	
        return $result;
}

/**
*  Obtenir les formations  d'un individu
*
*   Retourne les numeros, noms et qualit� de l'individu pour les formations auxquelles  $individu participe
*   @deprecated : utiliser get_individu_formation
*   @param integer : le numero de l'individu
*   @param string : Classement croissant (ASC) ou d�croissant (DESC)
*   @param integer : si �gal � 1 on classe par date de d�but
*
*   @return integer : le resultat de la requete : num_cal, nom_cal, "form" ou "util", debut (format yyyy/mm/dd), fin (idem), langue
*/
function get_formations_individu($individu, $classement='ASC', $ordre_chrono=0)
{
        if(VERSION_BASE>VERSION)
        {
            // Le troisi�me champ retourn� est "form" ou "util"... Si on ne met pas text comme type de retour, il y a une erreur !
            $req="SELECT * FROM _af_get_formations_individu($individu, '$classement', $ordre_chrono)
                    AS (num_formation integer, nom_formation varchar, type text, debut date, fin date, langue varchar);";
            $formations = pg_query($req) ;
        }
        else
            $formations=get_formations_individu_old($individu, $classement, $ordre_chrono) ;
        return $formations;
}

// ---------------------------------------------- MAJ_INFOS_INDIVIDU----------------------------------
/**
* Fonction qui met � jour un enregistrement de la table utilisateurs
*
* @param integer : le numero de l'individu en base de donn�es
* @param string : login
* @param string : password
* @param string : nom
* @param string : prenom
* @param string : adresse
* @param string : code
* @param string : ville
* @param string : email
* @param string : telfixe
* @param string : telport
* @param string : langue
* @param string : num_org
* @param string : categorie
* @param string : fic_photo
* @return : retourne vrai ou bien un code erreur
*/
function maj_infos_individu($num_user, $login, $password, $nom, $prenom, $adresse, $code, $ville, $email, $telfixe, $telport, $langue, $num_org, $categorie, $fic_photo)
{
        if(!$num_user)
                return false ;
        $req = "SELECT _af_maj_infos_individu($num_user, '$login', '$password', '".addslashes($nom)."', '".addslashes($prenom)."', '".addslashes($adresse)."',
                                        '$code', '".addslashes($ville)."', '$email', '$telfixe', '$telport', '$langue', $num_org, '$categorie', '$fic_photo')" ;

        return pg_query($req) ;
}



// ---------------------------------------------- GET_GROUPES_INDIVIDU----------------------------------
/**
*  Obtenir les groupes d'un individu (OLD)
*
*  Cette fonction donne tous les groupes auxquels appartient un individu.
*
*   @param  integer : le numero de l'individu
*   @param  string : Classement croissant (ASC) ou d�croissant (DESC)
*
*   @return integer : le resultat de la requete (num_groupe, nom_groupe, id_pere, placemin, placemax)
*/
function get_groupes_individu_old($individu, $classement='ASC')
{
        return pg_query("SELECT DISTINCT id AS num_groupe, nom AS nom_groupe, id_pere, minplace AS placemin, maxplace AS placemax
        FROM classe, placegroupe, gestionutil
        WHERE num_gest_groupe=id
        AND id=gu_num_gest_gr
        AND gu_num_user=$individu
        ORDER BY nom $classement");
}

/**
*  Obtenir les groupes d'un individu
*
*  Cette fonction donne tous les groupes auxquels appartient un individu.
*
*   @param  integer : le numero de l'individu
*   @param  string : Classement croissant (ASC) ou d�croissant (DESC)
*
*   @return integer :  le resultat de la requete (num_groupe, nom_groupe, id_pere, placemin, placemax)
*/

function get_groupes_individu($individu, $classement='ASC')
{
        // Test version postgres
        if(VERSION_BASE > VERSION)
        {
                $req="SELECT * FROM _af_get_groupes_individu($individu, '$classement')
                        AS (num_groupe integer, nom_groupe varchar, id_pere integer, placemin integer, placemax integer) ;" ;
                $groupes = pg_query($req) ;
        }
        else
                // Fonction de substitution
                $groupes=get_groupes_individu_old($individu, $classement) ;

        return $groupes ;
}


// ---------------------------------------------- GET_DROITS_GROUPE_INDIVIDU--------------------------------
/**
*  Obtenir les droits d'un individu pour un groupe OLD
*   @deprecated : utiliser get_individu_droits_classe
*   @param  integer : le numero de l'individu
*   @param  integer : le numero de groupe
*   @param  string : Classement croissant (ASC) ou d�croissant (DESC)
*
*   @return integer : le resultat de la requete (num_droit, libelle_droit, type_droit, acces_fichier, defaut)
*/
function get_droits_groupe_individu_old($individu, $groupe, $classement='ASC')
{
        return pg_query("SELECT DISTINCT num_droit, libelle_droit, type_droit, acces_fichier, defaut
        FROM droit, gestionutil
        WHERE num_droit=gu_num_droit
        AND gu_num_gest_gr=$groupe
        AND gu_num_user=$individu
        ORDER BY libelle_droit $classement ;");
}

/**
*  Obtenir les droits d'un individu pour un groupe OLD
*   @deprecated : utiliser get_individu_droits_classe
*   @param  integer : le numero de l'individu
*   @param  integer : le numero de groupe
*   @param  string : Classement croissant (ASC) ou d�croissant (DESC)
*
*   @return integer :  le resultat de la requete (num_droit, libelle_droit, type_droit, acces_fichier, defaut)
*/
function get_droits_groupe_individu($individu, $groupe, $classement='ASC')
{
        // Test version postgres
        if(VERSION_BASE > VERSION)
        {
                $req="SELECT * FROM _af_get_droits_groupe_individu($individu, $groupe, '$classement')
                        AS (num_droit integer, libelle_droit varchar, type_droit varchar, acces_fichier varchar, defaut integer) ;" ;
                $droits = pg_query($req) ;
        }
        else
                // Fonction de substitution
                $droits=get_droits_groupe_individu_old($individu, $groupe, $classement) ;

        return $droits ;
}

/**
*   Mettre des droits � un individu (OLD).
*   @DEPRECATED : Utiliser set_individu_droits
*   Mets les droits pass�s en parametres � l'individu.
*   Le numero de l'individu est pass� en paramettre,
*   ainsi qu'un tableau contenant les droits.
*   Ce tableau doit avoir le format suivant:
*           -une ligne par droit,
*           -la 1ere colonne contient le numero du droit et les autres colonnes ne sont pas trait�es
*
*   NOTE: fait appel a la fonction PLPGSQL nomm�e   set_droit_individu    qui ne met qu'un droit a la foi.
*
* @param integer : numero de l'individu cible
* @param integer : numero de groupe   de l'individu cible
* @return integer : le resultat de la derniere insertion
*/
function set_droits_individu_old($individu,$groupe, $droits)
{
        for($i=0; $i<count( $droits); $i++){


                        $req="insert into gestionutil (gu_num_user , gu_num_gest_gr , gu_num_droit)
                        values ($individu, $groupe, '".$droits[$i][0]."') ";
                        //echo $req;
                        $res = pg_query($req);

    }

    return ($res);
}

 /**
*   Mettre des droits � un individu .
*   @DEPRECATED : Utiliser set_individu_droits
*   Mets les droits pass�s en parametres � l'individu.
*   Le numero de l'individu est pass� en paramettre,
*   ainsi qu'un tableau contenant les droits.
*   Ce tableau doit avoir le format suivant:
*           -une ligne par droit,
*           -la 1ere colonne contient le numero du droit et les autres colonnes ne sont pas trait�es
*
*   NOTE: fait appel a la fonction PLPGSQL nomm�e   set_droit_individu    qui ne met qu'un droit a la foi.
*
* @param integer : numero de l'individu cible
* @param integer : numero de groupe   de l'individu cible
* @return integer : le resultat de la derniere insertion
*/
function set_droits_individu($individu, $groupe , $droits)
{
           if(VERSION_BASE > VERSION )
           {

                    for($i=0; $i<count( $droits); $i++){


                                        $req="select * FROM _af_set_droit_individu($individu, $groupe, '".$droits[$i][0]."') ";
                                        //echo $req;
                                        $res = pg_query($req);

                    }
           }
           else
                      $res=set_droits_individu_old($individu, $groupe , $droits);

    return $res;

}

/**
*  Obtenir les dates de connexion d'un individu (OLD)
*
*	@deprecated : utiliser get_individu_connexion_mois
*  R�cupere la les dates de connexion et de
*  d�connexion d'un individu � la date donn�e
*
* @param integer : num�ro de stagiaire
* @param varchar : mois � laquelle on veut les connexions
* @return date : la liste des dates de connexion et d�connexion
*/
function get_connexions_old($num_user,$date)
{
            $req="SELECT date_connexion, date_deconnexion
            FROM connexion
            WHERE num_user='$num_user'
            AND date_connexion LIKE '$date%'
            ORDER BY date_connexion ";
            //echo "req=$req<br>";
            return(pg_query($req));
}

///**
//*  Obtenir les dates de connexion d'un individu
//*
//*	@deprecated : utiliser get_individu_connexion_mois
//*  R�cupere la les dates de connexion et de
//*  d�connexion d'un individu � la date donn�e
//*
//* @param integer : num�ro de stagiaire
//* @param varchar : mois � laquelle on veut les connexions
//* @return date : la liste des dates de connexion et d�connexion
//*/
//function get_connexions($user,$date)
//{
//            if(VERSION_BASE > VERSION)
//            {
//                        $req="select * from _af_get_connexions($user,'$date') as (date_connexion timestamp with time zone  , date_deconnexion timestamp with time zone, nom varchar,prenom varchar )";
//                        $res=pg_query($req);
//            }
//            else
//                        $res=get_connexions_old($user,$date);
//
//            return($res);
//}


/**
*  Obtenir les dates de connexion d'un individu (OLD)
*
*  R�cupere la les dates de connexion et de
*  d�connexion d'un individu � la date donn�e
*
* @param integer : num�ro de stagiaire
* @param varchar : mois � laquelle on veut les connexions
* @return date : la liste des dates de connexion et d�connexion
*/
function get_individu_connexions_mois_old($num_user,$date)
{
            $req="SELECT date_connexion, date_deconnexion
            FROM connexion
            WHERE num_user='$num_user'
            AND date_connexion LIKE '$date%'
            ORDER BY date_connexion ";
            //echo "req=$req<br>";
            return(pg_query($req));
}

/**
*  Obtenir les dates de connexion d'un individu
*
*  R�cupere la les dates de connexion et de
*  d�connexion d'un individu � la date donn�e
*
* @param integer : num�ro de stagiaire
* @param varchar : mois � laquelle on veut les connexions
* @return date : la liste des dates de connexion et d�connexion
*/
function get_individu_connexions_mois($user,$date)
{
            if(VERSION_BASE > VERSION)
            {
                        $req="select * from _af_get_connexions($user,'$date') as (date_connexion timestamp with time zone  , date_deconnexion timestamp with time zone, nom varchar,prenom varchar )";
                        $res=pg_query($req);
            }
            else
                        $res=get_individu_connexions_mois_old($user,$date);

            return($res);
}

/**
    V�rification des heures de cours pour un intervenant pour une date de formation (OLD)
*
*   @param integer : le numero de l'intervenant
*   @param date : le jour du cours
*   @param varchar : l'heure de debut
*   @param varchar : l'heure de fin
*   @param integer : le numero de formation
*   @param varchar : debut du cours (mode edition)
*   @return integer : le resultat de la requete
*/
function get_individu_heures_cours_formation_old($individu,$date,$heure_debut,$heure_fin,$formation,$heure_cours=""){
    $sql="SELECT COUNT(*) FROM  dates D, gest_cal G
                WHERE D.num_date=G.num_date
                AND D.jour='$date'
                AND ( ( G.hdeb >= '$heure_debut' AND G.hdeb <= '$heure_fin')  OR ( G.hdeb <= '$heure_debut' AND G.hfin>='$heure_debut') )
                AND G.num_intervenant=$individu
                AND NOT (G.hdeb = '$heure_cours' AND G.gnum_cal =$formation)";
    $res=pg_query($sql);
    return $res;
}
/**
    V�rification des heures de cours pour un intervenant pour une date de formation
*
*   @param integer : le numero de l'intervenant
*   @param date : le jour du cours
*   @param varchar : l'heure de debut
*   @param varchar : l'heure de fin
*   @param integer : le numero de formation
*   @param varchar : debut du cours (mode edition)
*   @return integer : le resultat de la requete
*/
function get_individu_heures_cours_formation($individu,$date,$heure_debut,$heure_fin,$formation,$heure_cours=""){
    if(VERSION_BASE > VERSION){

    }
    else
        $res=get_individu_heures_cours_formation_old($individu,$date,$heure_debut,$heure_fin,$formation,$heure_cours);
    return $res;
}

/**
    Obtenir les heures de cours d'un intervenant pour un jour de formation (OLD)
*
*   @param integer : le numero de la l'intervenant
*   @param date : le jour de formation
*   @return integer : le resultat de la requete
*/
function get_individu_cours_formation_old($individu,$date){
    $sql="SELECT C.num_cal, nom_cal, hdeb, hfin,libelle FROM gest_cal G, calendrier C, dates D
                WHERE G.gnum_cal=C.num_cal
                AND D.num_date=G.num_date
                AND G.num_intervenant=$individu
                AND jour='$date'";
    $res=pg_query($sql);
    return $res;
}
/**
    Obtenir les heures de cours d'unintervenant pour un jour de formation
*
*   @param integer : le numero de l'intervenant
*   @param date : le jour de formation
*   @return integer : le resultat de la requete
*/
function get_individu_cours_formation($individu,$date){
    if(VERSION_BASE > VERSION){

    }
    else
        $res=get_individu_cours_formation_old($individu,$date);
    return $res;
}

/**
    Obtenir les infos d'un individu (OLD)
* @param : integer le numero de l'individu en base de donn�es
*   @return integer : le resultat de la requete
*/
function get_individu_infos_old($individu){
    $sql="SELECT num_user,id_user,login , password , nom , prenom ,  adresse , code , ville , email , telfixe , telport , langue , categorie , fic_photo
                FROM utilisateurs WHERE num_user=$individu" ;
    return (pg_query($sql));
}
/**
    Obtenir les infos d'un individu
* @param : integer le numero de l'individu en base de donn�es
*   @return integer : le resultat de la requete
*/
function get_individu_infos($individu){
    if(VERSION_BASE > VERSION){
	    
    }
    else
        $res=get_individu_infos_old($individu);
    return $res;
}

/**
*  Obtenir les groupes d'un individu (OLD)
*
*  Cette fonction donne tous les groupes auxquels appartient un individu.
*
*   @param  integer : le numero de l'individu
*   @param  string : Classement croissant (ASC) ou d�croissant (DESC)
*
*   @return integer : le resultat de la requete (num_groupe, nom_groupe, id_pere, placemin, placemax)
*/
function get_individu_groupes_old($individu, $classement='ASC')
{
        return pg_query("SELECT DISTINCT id AS num_groupe, nom AS nom_groupe, id_pere, minplace AS placemin, maxplace AS placemax
        FROM classe, placegroupe, gestionutil
        WHERE num_gest_groupe=id
        AND id=gu_num_gest_gr
        AND gu_num_user=$individu
        ORDER BY nom $classement");
}

/**
*  Obtenir les groupes d'un individu
*
*  Cette fonction donne tous les groupes auxquels appartient un individu.
*
*   @param  integer : le numero de l'individu
*   @param  string : Classement croissant (ASC) ou d�croissant (DESC)
*
*   @return integer :  le resultat de la requete (num_groupe, nom_groupe, id_pere, placemin, placemax)
*/

function get_individu_groupes($individu, $classement='ASC')
{
        // Test version postgres
        if(VERSION_BASE > VERSION)
        {
                $req="SELECT * FROM _af_get_groupes_individu($individu, '$classement')
                        AS (num_groupe integer, nom_groupe varchar, id_pere integer, placemin integer, placemax integer) ;" ;
                $groupes = pg_query($req) ;
        }
        else
                // Fonction de substitution
                $groupes=get_individu_groupes_old($individu, $classement) ;

        return $groupes ;
}

/**
    Verifier si l'individu est un formateur (OLD)
*   @param  integer : le numero de l'individu
*   @return bool : true=formateur sinon false
*/
function check_individu_formateur_old($individu){
    $sql="select distinct g_num_cal from gestionnaire where g_num_user='$individu'";
    $res=pg_query($sql);
    if(pg_num_rows($res)>0)
        return true;
    return false;
}
/**
    Verifier si l'individu est un formateur
*   @param  integer : le numero de l'individu
*   @return bool : true=formateur sinon false
*/
//function check_individu_formateur($individu){
//    if(VERSION_BASE > VERSION){
//		$sql="select * from contraintes.af_is_individu_formateur($individu)";
//		$res=pg_query($sql);
//    }
//    else
//        $res=check_individu_formateur_old($individu);
//    return $res;
//}

/**
    Mettre � jour le login des table s du forum (OLD)
*
*   @param string : le login a modifier
*   @param string : le nouveau login
*   @return
*/
function maj_individu_login_forum_old($log,$nouveau_log){
    $sql="update c_reg_users set username='$nouveau_log' where username='$log'";
    $maj=pg_query($sql);
    $sql="update c_users set username='$nouveau_log' where username='$log'";
    $maj=pg_query($sql);
    $sql="update c_messages set username='$nouveau_log' where username='$log'";
    $maj=pg_query($sql);
    $sql="update c_ban_users set username='$nouveau_log' where username='$log'";
    $maj=pg_query($sql);
    return $maj;
}
/**
    Mettre � jour le login des table s du forum
*
*   @param string : le login a modifier
*   @param string : le nouveau login
*   @return
*/
function maj_individu_login_forum($log,$nouveau_log){
     if(VERSION_BASE > VERSION){

    }
    else
        $res=maj_individu_login_forum_old($log,$nouveau_log);
    return $res;
}

/**
    Enregistre un individu (OLD)
*
*   @param string : id_user
*   @param string : le login
*   @param string : le mot de passe
*   @param string : le nom
*   @param string : le prenom
*   @param string : l'adresse
*   @param string : le code postal
*   @param string : la ville
*   @param string : l'email
*   @param string : telephone fixe
*   @param string : telephone portable
*   @param string : la langue de l'individu
*   @param integer : le numero d'organisme
*   @param string : la categorie
*   @param string : la session
*   @param string : total
*   @param integer : temps
*   @param string : le nom du fichier photo
*/
function set_individu_old($token,$log,$pass,$nom,$pre,$adr,$cod,$vil,$mail,$telfix,$telport,$lang,$org,$cat,$sess,$total,$tps,$photo){

    $sql="insert into utilisateurs
	(id_user,login,password,nom,prenom,adresse,code,ville,email,telfixe,telport,langue,num_org,categorie,session,total,temps,fic_photo)
    values('$token','$log','$pass','$nom','$pre','$adr','$cod','$vil','$mail','$telfix','$telport','$lang',$org,'$cat','$sess','$total',$tps,'$photo')";
   //echo "sql=$sql<br>";
    $ins=pg_query($sql);
    return $ins;
}
/**
    Enregistre un individu
*
*   @param string : id_user
*   @param string : le login
*   @param string : le mot de passe
*   @param string : le nom
*   @param string : le prenom
*   @param string : l'adresse
*   @param string : le code postal
*   @param string : la ville
*   @param string : l'email
*   @param string : telephone fixe
*   @param string : telephone portable
*   @param string : la langue de l'individu
*   @param integer : le numero d'organisme
*   @param string : la categorie
*   @param string : la session
*   @param string : total
*   @param integer : temps
*   @param string : le nom du fichier photo
*/
function set_individu($token,$log,$pass,$nom,$pre,$adr,$cod,$vil,$mail,$telfix,$telport,$lang,$org,$cat,$sess,$total,$tps,$photo){
    if(VERSION_BASE > VERSION){
    	
//		// On met les types en tableau
//		$tab_type="_int4'{";
////		$sz=strlen($cat);
////		for($i=0;$i<$sz;$i++){
////			$type=substr($cat,$i,1);   
////			switch($type){
////				case 'u' : $tab_type .="1,";break;
////				case 'f' : $tab_type .="2,";break;
////				case 'i' : $tab_type .="3,";break;
////			}
////		}
////		$tab_type=substr($tab_type,0,-1);
//	// Modif du 04/01/08
//		$tab_type.=$cat.",";
//		$tab_type=substr($tab_type,0,-1);
//		$tab_type .="}'";
		
//		die($tab_type);
//		$tab_type=int_array_to_plpgsql_array($cat);

		
	    $sql="select * from contraintes.af_set_individu($token,$log,$pass,$nom,$pre,$adr,$cod,$vil,$mail,$telfix,$telport,$lang,$org,$photo,$cat)";
		//print("sql=$sql<br>");
		$res=pg_query($sql);
    }
    else{
		$total='NULL';
		$session='NULL';
		$temps='NULL';
        $res=set_individu_old($token,$log,$pass,$nom,$pre,$adr,$cod,$vil,$mail,$telfix,$telport,$lang,$org,$cat,$session,$total,$temps,$photo);
	}
    return pg_fetch_result($res,0,0);
}

/**
    Mettre � jour  un individu (OLD)
*
*   @param integer : le numero de l'individu
*   @param string : le login
*   @param string : le mot de passe
*   @param string : le nom
*   @param string : le prenom
*   @param string : l'adresse
*   @param string : le code postal
*   @param string : la ville
*   @param string : l'email
*   @param string : telephone fixe
*   @param string : telephone portable
*   @param string : la langue de l'individu
*   @param integer : le numero d'organisme
*   @param string : la categorie
*   @param string : le nom du fichier photo
*/
function maj_individu_old($individu,$log,$pass,$nom,$pre,$adr,$cod,$vil,$mail,$telfix,$telport,$lang,$org,$cat,$photo){
    $sql="update utilisateurs set login='$log',password='$pass',nom='$nom',prenom='$pre',adresse='$adr',code='$cod',ville='$vil',email='$mail',telfixe='$telfix',telport='$telport',
            langue='$lang',num_org=$org,categorie='$cat',fic_photo='$photo' where num_user=$individu";
    //echo "sql=$sql<br>";
    $maj=pg_query($sql);
    return $maj;
}
/**
    Mettre � jour un individu
*
*   @paraminteger : le numero de l'individu
*   @param string : le login
*   @param string : le mot de passe
*   @param string : le nom
*   @param string : le prenom
*   @param string : l'adresse
*   @param string : le code postal
*   @param string : la ville
*   @param string : l'email
*   @param string : telephone fixe
*   @param string : telephone portable
*   @param string : la langue de l'individu
*   @param integer : le numero d'organisme
*   @param string : la categorie
*   @param string : le nom du fichier photo
*/
function maj_individu($individu,$log,$pass,$nom,$pre,$adr,$cod,$vil,$mail,$telfix,$telport,$lang,$org,$cat,$photo){
    if(VERSION_BASE > VERSION){
	    // On met les types en tableau
//		$tab_type="_int4'{";
		/*
		$sz=strlen($cat);
		for($i=0;$i<$sz;$i++){
			$type=substr($cat,$i,1);
			switch($type){
				case 'u' : $tab_type .="1,";break;
				case 'f' : $tab_type .="2,";break;
				case 'i' : $tab_type .="3,";break;
			}
		}
		$tab_type=substr($tab_type,0,-1);
		*/
		// Modif du 04/01/08
////		$tab_type.=$cat.",";
////		$tab_type=substr($tab_type,0,-1);
////		$tab_type .="}'";
////		
//		if($org==0)
//			$org='NULL';
//		
		$sql="select * from 
		contraintes.af_maj_individu($individu,$log,$pass,$nom,$pre,$adr,$cod,$vil,$mail,$telfix,$telport,$lang,$org,$photo)";
//		echo "sql=$sql<br>";
		$res=pg_query($sql);
    }
    else
        $res=maj_individu_old($individu,$log,$pass,$nom,$pre,$adr,$cod,$vil,$mail,$telfix,$telport,$lang,$org,$cat,$photo);
        
    return sql2Bool(pg_fetch_result($res,0,0));
}

/**
    Obtenir le numero d'un individu � partir de son login et mot de passe (OLD)
*
*   @param string : le login
*   @param string : le mot de passe
*   @return integer : le numero de l'individu si existe sinon 0
*/
function get_individu_numero_old($log,$pass){
    $sql="select num_user from utilisateurs where login='$log' and password='$pass'";
    $res=pg_query($sql);
    if(pg_num_rows($res)==1){
        $row=pg_fetch_row($res,0);
        $num=$row[0];
    }
    else
        $num=0;
    return $num;
}
/**
    Obtenir le numero d'un individu � partir de son login et mot de passe
*
*   @param string : le login
*   @param string : le mot de passe
*   @return integer : le numero de l'individu si existe sinon 0
*/
function get_individu_numero($log,$pass){
    if(VERSION_BASE > VERSION){

    }
    else
        $res=get_individu_numero_old($log,$pass);
    return $res;
}

/**
    Mettre � jour la categorie d'un individu (OLD)
*
*   @param integer : le numero de l'individu
*   @param string : la nouvelle categorie
*   @return integer : le resultat de la requete
*/
function maj_individu_categorie_old($individu,$categorie){
    $sql="update utilisateurs set categorie='$categorie' where num_user=$individu";
    return (pg_query($sql));
}
/**
    Mettre � jour la categorie d'un individu
*
*   @param integer : le numero de l'individu
*   @param string : la nouvelle categorie
*   @return integer : le resultat de la requete
*/
function maj_individu_categorie($individu,$categorie){
    if(VERSION_BASE > VERSION){

    }
    else
        $res=maj_individu_categorie_old($individu,$categorie);
    return $res;
}

/**
    Supprimer un individu (OLD)
*
*   @param integer : le numero de l'individu
*   @return integer : le resultat de la requete
*/
function del_individu_old($individu){
    $sql="delete from utilisateurs where num_user=$individu";
    return pg_query($sql);
	
	
}
/**
    Supprimer un individu
*
*   @param integer : le numero de l'individu
*   @return integer : le resultat de la requete
*/
function del_individu($individu){
     if(VERSION_BASE > VERSION){
	     $sql="select * from contraintes.af_del_individu($individu)";
		 $res=pg_query($sql);
    }
    else
        $res=del_individu_old($individu);
    return $res;
}

/**
    Obtenir les infos d'un individu (OLD)
* @param : integer le numero de l'individu en base de donn�es
*   @return integer : le resultat de la requete
*/
function get_individu_old($individu){
    $sql="SELECT num_user,id_user,login , password , nom , prenom , adresse , code , ville , email , telfixe , telport , langue , num_org ,  fic_photo
                FROM utilisateurs WHERE num_user=$individu" ;
    return (pg_query($sql));
}
/**
    Obtenir les infos d'un individu
* @param : integer le numero de l'individu en base de donn�es
*   @return integer : le resultat de la requete :(id int4,identifiant_md5 varchar,login varchar,password varchar,nom varchar,prenom varchar,adresse varchar,code varchar,ville varchar,
		email varchar,tel_fix varchar,tel_port varchar,langue int4,organisme int4,photo int4)
*/
function get_individu($individu){
    if(VERSION_BASE > VERSION){
	    $sql="select * from contraintes.fw_get_individu($individu) as 
		(id int4,identifiant_md5 varchar,login varchar,password varchar,nom varchar,prenom varchar,adresse varchar,code varchar,ville varchar,
		email varchar,tel_fix varchar,tel_port varchar,langue int4,organisme int4,photo int4)";
//		echo "sql=$sql<br>";
		$res=pg_query($sql);
    }
    else
        $res=get_individu_old($individu);
    return $res;
}

/**
	Obtenir les types (categories) d'un individu (OLD)
	@param integer : numero utilisateur
	@return integer : resultat requete
*/
function get_individu_types_old($individu){
	$sql="select categorie from utilisateurs where num_user=$individu";
	return pg_query($sql);
}
/**
	Obtenir les types (categories) d'un individu 
	@param integer : numero utilisateur
	@return integer : resultat requete (id int4,libelle varchar)
*/
function get_individu_types($individu){
	if(VERSION_BASE > VERSION){
		
		$sql="select * from contraintes.fw_get_individu_types($individu) as (id int4,libelle varchar)";
		//echo $sql;
		$res=pg_query($sql);
	}
	else
		$res=get_individu_types_old($individu);
	return $res;
}

/**
	Obtenir tous les types (categories) 
	@param integer : numero utilisateur
	@return integer : resultat requete (id int4,libelle varchar)
*/
function get_individu_type(){
	echo "la fonction get_individu_type() est deprecie";
		if(VERSION_BASE > VERSION){	
			$sql="select * from contraintes.fw_get_individu_types() as (id int4,libelle varchar,code varchar)";
//			echo $sql;
			$res=pg_query($sql);
		}
		return $res;
}

	
/**
    Mettre � jour le type d'un individu (OLD)
*
*   @param integer : le numero de l'individu
*   @param string : le nouveau type
*   @return integer : le resultat de la requete
*/
function maj_individu_type_old($individu,$type){
    $sql="update utilisateurs set categorie='$type' where num_user=$individu";
    return (pg_query($sql));
}
/**
    Mettre � jour la categorie d'un individu
*
*   @param integer : le numero de l'individu
*   @param string : la nouvelle categorie
*   @return integer : le resultat de la requete
*/
function maj_individu_type($individu,$categorie){
    if(VERSION_BASE > VERSION){

    }
    else
        $res=maj_individu_type_old($individu,$categorie);
    return $res;
}

/**
	Supprime un type � un individu 
	@param integer : le numero de l'individu
	@param integer : le numero du type
	@return integer : resultat requete
*/
function del_individu_type($individu,$type){
	if(VERSION_BASE > VERSION){
		$sql="select * from contraintes.af_del_individu_type($individu,$type)";
		$res=pg_query($sql);

    }
	else
		die("Erreur : pas de fonction pour l'ancienne version");
	return $res;
}

/**
*   Mettre des droits � un individu (OLD).
*   Mets les droits pass�s en parametres � l'individu.
*   Le numero de l'individu est pass� en paramettre,
*   ainsi qu'un tableau contenant les droits.
*   Ce tableau doit avoir le format suivant:
*           -une ligne par droit,
*           -la 1ere colonne contient le numero du droit et les autres colonnes ne sont pas trait�es
*
*   NOTE: fait appel a la fonction PLPGSQL nomm�e   set_droit_individu    qui ne met qu'un droit a la foi.
*
* @param integer : numero de l'individu cible
* @param integer : numero de groupe   de l'individu cible
* @return integer : le resultat de la derniere insertion
*/
function set_individu_droits_classe_old($individu,$classe, $droits){
	for($i=0; $i<count( $droits); $i++){
		$req="insert into gestionutil (gu_num_user , gu_num_gest_gr , gu_num_droit)
					values ($individu, $classe, '".$droits[$i][0]."') ";
		//echo $req;
		$res = pg_query($req);
	}
    return ($res);
}

 /**
*   Mettre des droits � un individu .

*   Mets les droits pass�s en parametres � l'individu.
*   Le numero de l'individu est pass� en paramettre,
*   ainsi qu'un tableau contenant les droits.
*   Ce tableau doit avoir le format suivant:
*           -une ligne par droit,
*           -la 1ere colonne contient le numero du droit et les autres colonnes ne sont pas trait�es
*
*   NOTE: fait appel a la fonction PLPGSQL nomm�e   set_droit_individu    qui ne met qu'un droit a la foi.
*
* @param integer : numero de l'individu cible
* @param integer : numero de groupe   de l'individu cible
* @return integer : le resultat de la derniere insertion
*/
function set_individu_droits_classe($individu, $classe , $droits){
	if(VERSION_BASE > VERSION ){
		$sql="select * from contraintes.af_set_individu_droits_classe($individu,$classe,$droits)";
		//echo "sql=$sql<br>";
		$res=pg_query($sql);
		return $res;
	}
    else
		$res=set_individu_droits_classe_old($individu, $groupe , $droits);
	return $res;
}

/**
	Ajoute un droit � un individu  (OLD)
* @param integer : numero de l'individu cible
* @param integer : numero de groupe   de l'individu cible
* @return integer : le resultat de la derniere insertion
*/
function set_individu_droit_classe_old($individu,$classe,$droit){
	$sql="insert into gestionutil (gu_num_user,gu_num_gest_gr,gu_num_droit) values($individu,$classe,$droit)";
	//echo "sql=$sql<br>";
	return pg_query($sql);
}
/**
	Ajoute un droit � un individu  
* @param integer : numero de l'individu cible
* @param integer : numero de groupe   de l'individu cible
* @return integer : le resultat de la derniere insertion
*/
function set_individu_droit_classe($individu,$classe,$droit){
	if(VERSION_BASE > VERSION ){
		$sql="select * from contraintes.af_set_individu_droit_classe($individu,$classe,$droit)";
		$res=pg_query($sql);
	}
	else
		$res=set_individu_droit_classe_old($individu,$classe,$droit);
	return $res;
}


/**
*  Obtenir les formations d'un individu (OLD)
*
*   Retourne les numeros, noms et qualit� de l'individu pour les formations auxquelles  $individu participe
*   
*   @param  integer : le numero de l'individu
*   @param  string : Classement croissant (ASC) ou d�croissant (DESC)
*   @param  integer : si �gal � 1 on classe par date de d�but
*
*   @return  le resultat de la requete (num_cal, nom_cal, "form" ou "util", debut, fin, langue)
*/
function get_individu_formations_old($individu, $ordre, $orderby,$periode){
	/*
	$req="(select  distinct ON(nom_formation) num_cal AS num_formation,nom_cal AS nom_formation,'form', d1.jour AS debut, d2.jour AS fin, langue
                from calendrier, dates d1, dates d2
                where d1.num_date=datedeb AND d2.num_date=datefin AND
                num_cal in
                (select distinct g_num_cal from gestionnaire where g_num_user='$individu') and num_cal in
                (select distinct num_cal from CALENDRIER, DATES A, DATES B where
                datedeb=A.num_date and datefin=B.num_date and current_date between A.jour and B.jour)
                )
                UNION
                (select  distinct ON(nom_formation) num_cal AS num_formation,nom_cal AS nom_formation,'util', d1.jour AS debut, d2.jour AS fin, langue
                from calendrier, dates d1, dates d2
                where d1.num_date=datedeb AND d2.num_date=datefin AND
                num_cal in
                (select g_num_cal from gestionnaire  where g_num_gest_g in
                (select distinct gu_num_gest_gr from gestionutil where gu_num_user='$individu')) and num_cal in
                (select distinct num_cal from CALENDRIER, DATES A, DATES B
                where datedeb=A.num_date and datefin=B.num_date and current_date between A.jour and B.jour)
                )ORDER BY $ordre $classement;";
	*/
	$sql="select  DISTINCT num_cal AS num_formation,nom_cal AS nom_formation,  
				g_num_parcours AS num_parcours,D1.jour AS debut, D2.jour AS fin,langue
				FROM gestionnaire, calendrier, dates D1, dates D2
				where D1.num_date=datedeb and D2.num_date=datefin 
				and g_num_cal=num_cal
				and num_cal in 
				(select g_num_cal from gestionnaire where g_num_gest_g in
				(select distinct gu_num_gest_gr from gestionutil where gu_num_user=$individu))";
	// traitement periode
			switch($periode){
				case 1 : $sql .=" and D2.jour<current_date ";
				break;
				case 2 : $sql .=" and current_date between D1.jour and D2.jour ";
				break;
				case 3 : $sql .=" and D1.jour>current_date ";
				break;
			}
			// traitement du tri
			if($orderby=='libelle')
				$sql .=" order by nom_cal ";
			else
				$sql .=" order by D1.jour ";
					
				// classement
				$sql .="  $ordre";
	
	$res=pg_query($sql);
	return $res;
}

/**
*  Obtenir les formations  d'un individu
*
*   Retourne les numeros, noms et qualit� de l'individu pour les formations auxquelles  $individu participe
*   
*   @param integer : le numero de l'individu
*   @param string : Classement croissant (ASC) ou d�croissant (DESC)
*   @param string : order by 'date_debut' ou 'libelle'
	@param integer : 1 pass�es, 2 pr�sentes, 3 futures, 0 toutes
*
*   @return integer : le resultat de la requete : num_cal, nom_cal, "form" ou "util", debut (format yyyy/mm/dd), fin (idem), langue
*/
function get_individu_formations($individu, $ordre='ASC', $orderby='date_debut',$periode=0){
	if(VERSION_BASE>VERSION){
		global $auth;
		$user_id=$auth->getUserId();
		// Le troisi�me champ retourn� est "form" ou "util"... Si on ne met pas text comme type de retour, il y a une erreur !
		$req="SELECT * FROM contraintes.af_get_individu_formations($individu, '$ordre', '$orderby',$periode,$user_id)
                     as (id int4,libelle varchar,parcours int4,date_debut date,date_fin date,langue int4,ressources_fusionnees bool)";
        //echo"sql=$req";            
		$res = pg_query($req) ;
		
	}
	else
		$res=get_individu_formations_old($individu, $ordre, $orderby,$periode) ;
	return $res;
}

/**
*  Obtenir les formations d'un individu pour une filire
*
*   Retourne les numeros, noms et qualit� de l'individu pour les formations auxquelles  $individu participe
*   
*   @param integer : le numero de l'individu
* 	@param integer : l'identifiant de la filiere
*   @param string : Classement croissant (ASC) ou d�croissant (DESC)
*   @param string : order by 'date_debut' ou 'libelle'
	@param integer : 1 pass�es, 2 pr�sentes, 3 futures, 0 toutes
*
*   @return integer : le resultat de la requete : num_cal, nom_cal, "form" ou "util", debut (format yyyy/mm/dd), fin (idem), langue
*/
function get_individu_formations_filiere($individu,$filiere, $ordre='ASC', $orderby='date_debut',$periode=0){
	if(VERSION_BASE>VERSION){
		// Le troisi�me champ retourn� est "form" ou "util"... Si on ne met pas text comme type de retour, il y a une erreur !
		$req="SELECT * FROM contraintes.af_get_individu_formations($individu, $filiere,'$ordre', '$orderby',$periode)
                     as (id int4,libelle varchar,parcours int4,date_debut date,date_fin date,langue int4,individu int4, filiere int4)";
//         echo"sql=$req";            
		$res = pg_query($req) ;
		return $res;
	}
	
}

/**
	Obtenir les classes d'un individu (OLD)
	@param integer : numero individu
	@return integer : resultat requete
*/
function get_individu_classes_old($individu){
	$sql="select distinct id,nom from classe,gestionutil where gu_num_gest_gr=id and gu_num_user=$individu";
	return pg_query($sql);
}
/**
	Obtenir les classes d'un individu 
	@param integer : numero individu
	@return integer : resultat requete
*/
function get_individu_classes($individu,$ordre=""){
	if(VERSION_BASE>VERSION){
		if($ordre=="DESC")$txt_ordre=" ORDER BY libelle DESC ";
		$sql="select * from contraintes.af_get_individu_classes($individu) as (id int4,libelle varchar,pere int4,min int4,max int4) $txt_ordre";
		$res=pg_query($sql);
//		echo"$sql";
	}
	else
		$res=get_individu_classes_old($individu);
	return $res;
}

/**
	Supprime un droit individu (OLD)
* @param integer : numero de l'individu cible
* @param integer : numero de groupe   de l'individu cible
* @return integer : le resultat de la derniere insertion
*/
function del_individu_droit_classe_old($individu,$classe,$droit){
	$sql=" delete from gestionutil where gu_num_user=$individu and gu_num_gest_gr=$classe and gu_num_droit=$droit";
	return pg_query($sql);
}
 /**
	Supprime un droit individu 
* @param integer : numero de l'individu cible
* @param integer : numero de groupe   de l'individu cible
* @return integer : le resultat de la derniere insertion
*/
function del_individu_droit_classe($individu,$classe,$droit){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_del_individu_droit_classe($individu,$classe,$droit)";
		$res=pg_query($sql);
	}
	else
		$res=del_individu_droit_classe_old($individu,$classe,$droit);
	return $res;
}

/**
	Teste si un individu poss�de un droit  pour une classe(OLD)
	@param integer : numero individu
	@param integer : numero classe
	@param integer : numero droit
	@return bool : true si l'individu possede le droit , false sinon
*/
function check_individu_droit_classe_old($individu,$classe,$droit){
	$sql="select * from gestionutil  where gu_num_gest_gr=$classe and gu_num_droit=$droit and gu_num_user=$individu";
	//echo "sql=$sql<br>";
	$res=pg_query($sql);
	return $res;
	
	/*
	if(pg_num_rows($res)==0)
        return 'true';
    else
        return 'false';
	*/
	
	
}
/**
	Teste si un individu poss�de un droit pour une classe 
	@param integer : numero individu
	@param integer : numero classe
	@param integer : numero droit
	@return bool : true si l'individu possede le droit , false sinon
*/
function check_individu_droit_classe($individu,$classe,$droit){
	 if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_is_individu_droit_classe($individu,$classe,$droit)";
		//echo "sql=$sql<br>";
		$res=pg_query($sql);
	 }
	 else{
		$res=check_individu_droit_classe_old($individu,$classe,$droit);
		if(pg_num_rows($res)==0)
        return 'f';
    else
        return 't';
	 }
	 return pg_fetch_result($res,0,0);
	 
	 
}

/**
	Obtenir les droits d'un individu pour une classe (OLD)
	@param integer : numero individu
	@param integer : numero classe
	@return integer : resultat requete
*/
function get_individu_droits_classe_old($individu,$classe){
	$sql=" select distinct num_droit,libelle_droit,type_droit,dafaut from droit, gestionutil 
				where num_droit=gu_num_droit and gu_num_gest_gr=$classe and gu_num_user=$individu";
	return pg_query($sql);
}
/**
	Obtenir les droits d'un individu pour une classe 
	@param integer : numero individu
	@param integer : numero classe
	@return integer : resultat requete
*/
function get_individu_droits_classe($individu,$classe){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_get_individu_droits_classe($individu,$classe) as (id int4,libelle varchar,type int4,defaut bool)";
		$res=pg_query($sql);
	}
	else
		$res=get_individu_droits_classe_old($individu,$classe);
	return $res;
}

/**
	Teste si un individu est supprimable (OLD)
	@param integer : individu
	@return bool : true si supprimable ,false sinon
*/
function check_individu_supprimable_old($individu){

}
/**
	Teste si un individu est supprimable 
	@param integer : individu
	@return bool : true si supprimable ,false sinon
*/
function check_individu_supprimable($individu){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_is_individu_supprimable($individu)";
		$res=pg_query($sql);
	}
	else
		return check_individu_supprimable_old($individu);
	return pg_fetch_result($res,0,0);
}

/**
	Obtenir les filieres d'un individu (OLD)
	@param integer : individu
	@return integer : res req
*/
function get_individu_filieres_old($individu){
	$sql="select id,nom from filiere where id in 
				(select g_num_gest_c from gestionnaire where g_num_gest_g in 
				(select gu_num_gest_gr from gestionutil where gu_num_user=$individu))";
	return pg_query($sql);
			
}
/**
	Obtenir les filieres d'un individu 
	@param integer : individu
	@return integer : res req
*/
function get_individu_filieres($individu){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_get_individu_filieres($individu) as (id int4,libelle varchar)";
//		echo "$sql<br>";
		$res=pg_query($sql);
	}
	else
		$res= get_individu_filieres_old($individu);
	return $res;

}

/**
	Enregistre la date de connexion (OLD)
	@param integer : individu
	@param date : connexion
	@param integer : deconnexion
	@param string : ip
	@return integer : res req
*/                
function set_individu_connexion_old($individu,$connexion,$deconnexion,$ip){
	$sql="insert into connexion values($individu,'$connexion','$deconnexion','$ip')";
	return pg_query($sql);
}
 /**
	Enregistre la date de connexion 
	@param integer : individu
	@param date : connexion
	@param integer : deconnexion
	@param string : ip
	@return integer : res req
*/                
function set_individu_connexion($individu,$connexion,$deconnexion,$ip){
	 if(VERSION_BASE>VERSION){
		// conversion
		//$connexion=date_en_seconde($connexion);
		//$deconnexion=date_en_seconde($deconnexion);
		$sql="select * from contraintes.af_set_individu_connexion($individu,'$connexion','$deconnexion','$ip')";
		$res=pg_query($sql);
	 
	 }
	 else
		$res=set_individu_connexion_old($individu,$connexion,$deconnexion,$ip);
	 return $res; 
}

/**
	Supprime la session d'un individu (OLD)
	@param integer : individu
	@return bool :
*/
function del_individu_session_old($individu){
	$sql="delete from session where num_user=$individu";
	return pg_query($sql);
}
/**
	Supprime la session d'un individu 
	@param integer : individu
	@return bool :
*/
function del_individu_session($individu){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_del_individu_session($individu)";
		//echo "sql=$sql<br>";
		$res=pg_query($sql);
	}
	else
		$res= del_individu_session_old($individu);
	return $res;
}

/**
	Enregistre la session d'un individu (OLD)
	@param integer : individu
	@param string : session
	@param integer : formation
	@return integer : res req
*/
function set_individu_session_old($individu,$id_session,$formation){
	$sql="insert into session (num_user,session,num_cal) values('$s_numuser','$id_session',$formation)";
	return pg_query($sql);
}
/**
	Enregistre la session d'un individu 
	@param integer : individu
	@param string : session
	@param integer : formation
	@return integer : res req
*/
function set_individu_session($individu,$id_session,$formation){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_set_individu_session($individu,'$id_session',$formation)";
		$res=pg_query($sql);
	}
	else
		$res= set_individu_session_old($individu,$id_session,$formation);
	return $res;
}


/**
	Obtenir la date de connexion max pour un individu (OLD)
	@param integer : individu
	@return integer : res req
*/
function get_individu_date_connexion_max_old($individu){
	$sql="select max(date_connexion) from connexion where num_user=$individu";
	return pg_query($sql);
}
/**
	Obtenir la date de connexion max pour un individu 
	@param integer : individu
	@return integer : res req
*/
function get_individu_date_connexion_max($individu){
	 if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_get_individu_date_connexion_max($individu) as (connexion timestamp)";
		$res=pg_query($sql);
	 }
	 else
		$res=get_individu_date_connexion_max_old($individu);
	 return $res;
}

/**
	Obtenir la date de deconnexion max pour un individu (OLD)
	@param integer : individu
	@return integer : res req
*/
function get_individu_date_deconnexion_max_old($individu){
	$sql="select max(date_deconnexion) from connexion where num_user=$individu";
	return pg_query($sql);
}
/**
	Obtenir la date de deconnexion max pour un individu 
	@param integer : individu
	@return integer : res req
*/
function get_individu_date_deconnexion_max($individu){
	 if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_get_individu_date_deconnexion_max($individu) as (deconnexion timestamp)";
		$res=pg_query($sql);
	 }
	 else
		$res=get_individu_date_deconnexion_max_old($individu);
	 return $res;
}

/**
	Mettre � jour la date de deconnexion pour un individu (OLD)
	@param integer : individu
	@param date : date deconnexion
	@return integer : res req
*/
function maj_individu_date_deconnexion_old($individu,$date){
	$sql="UPDATE connexion SET date_deconnexion = '$date'
          WHERE num_user=$individu
          AND date_connexion IN
          ( SELECT MAX(date_connexion) FROM connexion
          WHERE num_user=$individu)";
	return pg_query($sql);
}
/**
	Mettre � jour la date de deconnexion pour un individu 
	@param integer : individu
	@param date : date deconnexion
	@return integer : res req
*/
function maj_individu_date_deconnexion($individu,$date){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_maj_individu_date_deconnexion($individu,'$date')";
		$res=pg_query($sql);
	}
	else
		$res=maj_individu_date_deconnexion_old($individu,$date);
	return $res;
}

/**
	Met � jour la session d'un individu (OLD)
	@param integer : individu
	
	@param integer : formation
	@return integer : res req
*/
function maj_individu_session_old($individu,$formation){
	$sql="update session set num_cal=$formation where num_user=$individu";
	//echo "sql=$sql<br>";
	return pg_query($sql);
}
/**
	Met � jour la session d'un individu 
	@param integer : individu
	
	@param integer : formation
	@return integer : res req
*/
function maj_individu_session($individu,$formation){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_maj_individu_session($individu,$formation)";
		$res=pg_query($sql);
	}
	else
		$res=maj_individu_session_old($individu,$formation);
	return $res;
}


//FUNCTION CI-DESSOUS MIS PAR GREG

/**
	Mettre � jour la table stagiaire_grille (OLD)
	@param integer : formation
	@param integer : stagiaire
	@param integer : grille
	
	@param bool : visible(true),false sinon
	@return bool : res req
*/
function maj_individu_grille_old($formation,$stagiaire,$grille,$visible){
	$sql="update config_grille set voir='$visible' where num_cal=$formation and num_user=$stagiaire and num_grille=$grille";
	return pg_query($sql);
}
/**
	Mettre � jour la table stagiaire_grille 
	@param integer : formation
	@param integer : stagiaire
	@param integer : grille
	
	@param bool : visible(true),false sinon
	@return bool : res req
*/
function maj_individu_grille($formation,$stagiaire,$grille,$visible){
	if (VERSION_BASE > VERSION) {
		$sql="select * from contraintes.af_maj_presentiel_stagiaire_grille($formation,$stagiaire,$grille,'$visible')";
		//echo "sql=$sql<br>";
		$res=pg_query($sql);
	}
	else
		return maj_individu_grille_old($formation,$stagiaire,$grille,$visible);
	return $res;
}

///**
//	Obtenir les infos de la table stagiaire_grille (OLD)
//	@param integer : formation
//	@param integer : stagiaire
//	@param integer : grille
//*/
//function get_presentiel_stagiaire_grille_old($formation,$stagiaire,$grille){
//	$sql="select * from config_grille where num_cal=$formation and num_grille=$grille and num_user=$stagiaire";
//	return pg_query($sql);
//}
/**
	Obtenir les infos de la table stagiaire_grille 
	@param integer : formation
	@param integer : stagiaire
	@param integer : grille
*/
function get_individu_grille($formation,$stagiaire,$grille){
	if (VERSION_BASE > VERSION) {
		$sql="select * from contraintes.af_get_individu_grille($formation,$stagiaire,$grille) 
					as (formation int4,stagiaire int4,grille int4,visible bool)";
		$res=pg_query($sql); 
	}
	else
		return get_presentiel_stagiaire_grille_old($formation,$stagiaire,$grille);
	return $res;
}

/**
*   Ajouter un type d'individu � un individu.
*
*   @param integer : le numero de l'individu
*   @param integer : le numero de type d'individu
*   @return integer : le resultat de la requete
*/
function set_individu_type($individu,$type){
     if(VERSION_BASE > VERSION){
	     $sql="select * from contraintes.af_set_individu_type($individu,$type)";
		 return sql2Bool(pg_fetch_result(pg_query($sql),0,0));
    }
    else
		die("La fonction set_individu_type($individu,$type) n'existe pas pour cette version.");        
}

/**
    Mettre � jour  un individu en fo
*
*   @param integer : le numero de l'individu
*   @param string : le login
*   @param string : le mot de passe
*   @param string : le nom
*   @param string : le prenom
*   @param string : l'adresse
*   @param string : le code postal
*   @param string : la ville
*   @param string : l'email
*   @param string : telephone fixe
*   @param string : telephone portable
*   @param string : la langue de l'individu
*   @param integer : le fichier photo
*/
function maj_individu_fo($individu,$pass,$nom,$prenom,$adr,$code,$ville,$mail,$telfixe,$telporte,$langue,$photo){
    $sql="select * from 
		contraintes.af_maj_individu($individu,$pass,$nom,$prenom,$adr,$code,$ville,$mail,$telfixe,$telporte,$langue,$photo)";
//		echo "sql=$sql<br>";
		$res=pg_query($sql);
   //Quand la base fichier_photo sera faite on pourra modifier la fonction pl afin de pouvoir mettre a jour la photo. 
 return sql2Bool(pg_fetch_result($res,0,0));
}

function maj_individu_langue($individu,$langue){
	$sql="select * from	contraintes.fw_maj_individu_langue($individu,$langue)";
//	echo "sql=$sql<br>";
	return pg_query($sql);
}

/**
*   Ajouter des types d'individus � un individu.
*
*   @param integer $individu le numero de l'individu
*   @param integer[] $types le numero de type d'individu
*   @return integer  le resultat de la requete
*/
function set_individu_individus_types($individu,$types){
     if(VERSION_BASE > VERSION){
	     $sql="select * from contraintes.fw_set_individu_individus_types($individu,".int_array_to_plpgsql_array($types).")";
//	     echo $sql;
		 return sql2Bool(pg_fetch_result(pg_query($sql),0,0));
    }
    else
		die("La fonction set_individu_individus_types($individu,$types) n'existe pas pour cette version.");        
}
/**
*   Enlever des types d'individus � un individu.
*
*   @param integer $individu le numero de l'individu
*   @param integer[] $types le numero de type d'individu
*   @return integer  le resultat de la requete
*/
function del_individu_individus_types($individu,$types){
     if(VERSION_BASE > VERSION){
	     $sql="select * from contraintes.fw_del_individu_individus_types($individu,".int_array_to_plpgsql_array($types).")";
		 return pg_fetch_result(pg_query($sql),0,0)=='t';
    }
    else
		die("La fonction del_individu_individus_types($individu,$types) n'existe pas pour cette version.");        
}

function get_individu_modules($individu){

	$sql="select * from	contraintes.fw_get_individu_modules($individu) AS (id integer,libelle character varying,code character varying , type character varying,version character varying, directory text,active boolean,description character varying)";
	echo "sql=$sql<br>";
	return pg_query($sql);
}

/**
 * Obtenir la derniere deconnexion d'un individu
 * @param integer :individu
 * @return integer : res req
 */
 function get_individu_last_deconnexion($individu){
 	$sql="select * from contraintes.af_get_individu_last_deconnexion($individu) as (deconnexion timestamp)";
 	return pg_query($sql);
 }
 
 /**
  * Obtenir les themes d'un individu
  * @param integer individu
  * @return integer : res req
  */
  function get_individu_themes($individu){
  	$sql="select * from contraintes.af_get_individu_themes($individu) AS (id int4, libelle varchar, repertoire text)";
  	return pg_query($sql);
  }
  
  
  /**
 * Obtenir la derniere deconnexion d'un individu
 * @param integer :individu
 * @return integer : res req
 */
 function check_individu_modules_access_by_type($individu,$code){
 	$sql="select * from contraintes.fw_check_individu_modules_access_by_type($individu,'$code') ";
// 	echo $sql;
 	return sql2Bool(pg_fetch_result(pg_query($sql),0,0));
 }
 
 function is_individu_individu_type($individu,$individu_type){
 	$sql="select * from contraintes.is_individu_individu_type($individu,$individu_type) ";
// 	echo $sql;
 	return sql2Bool(pg_fetch_result(pg_query($sql),0,0));
 }
 

?>