<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/*
 * Created on 16 nov. 07
 *
 * To change the template for this generated file go to
 * Window - Preferences - PHPeclipse - PHP - Code Templates
 */
 
/**
  * Obtenir les modules pour lesquels un individu type  un droit
  * @param integer $individu_type individu type
  * @return integer : resultat requete (id int4,libelle varchar,code varchar,type varchar,version varchar,directory text,active boolean,individu_type integer)
*/
function get_individu_type_modules($individu_type){
	$sql="select * from contraintes.fw_get_individu_type_modules($individu_type) as (id int4,libelle varchar,code varchar,type varchar,version varchar,directory text,active boolean,individu_type integer)";
//	echo $sql;
	return pg_query($sql);
}

/**
  * Obtenir les identifiants de droits pour les modules et les individus types 
  * @return integer : resultat requete (individu_type integer,module integer,droit integer)
*/
function get_individus_types_modules_droits(){
	$sql="select * from contraintes.fw_get_individus_types_modules_droits() as (individu_type integer,module integer,droit integer)";
//	echo $sql;
	return pg_query($sql);
}


/**
  * Affecter des modules  un individu type 
  * @param integer $individu_type individu type
  * @param integer[] $modules les indentifiants de modules  affecter au type d'individu.
  * @return bool true si l'affectation s'est bien effectue, false sinon
  */
function set_individu_type_modules($individu_type, $modules){
	
	$sql="select * from contraintes.fw_set_individu_type_modules($individu_type,".int_array_to_plpgsql_array($modules).") ";
//	echo $sql;
	$res=pg_query($sql);
	return sql2Bool(pg_fetch_result($res,0,0));
}

/**
  * Retirer des modules  un individu type 
  * @param integer $individu_type individu type
  * @param integer[] $modules les indentifiants de modules dsafillier du type d'individu.
  * @return bool true si la suppression s'est bien effectue, false sinon
  */
function del_individu_type_modules($individu_type,$modules){
	
	$sql="select * from contraintes.fw_del_individu_type_modules($individu_type,".int_array_to_plpgsql_array($modules).") ";
//	echo $sql;
	$res=pg_query($sql);
	return sql2Bool(pg_fetch_result($res,0,0));
}

/**
  * Affecter des droits  un individu type pour un module 
  * @param integer $individu_type individu type
  * @param integer $module identifiant du module
  * @param integer[] $droits les indentifiants des droits  affecter
  * @return bool true si l'affectation s'est bien effectue, false sinon
  */
function set_individu_type_module_droits($individu_type, $module,$droits){
	
	$sql="select * from contraintes.fw_set_individu_type_module_droits($individu_type,$module,".int_array_to_plpgsql_array($droits).") ";
//	echo $sql;
	$res=pg_query($sql);
	return sql2Bool(pg_fetch_result($res,0,0));
}


/**
 * Crer un type d'individu
 * 
 * @return varchar Le r�sultat de la requete (id integer, libelle varchar, code varchar)
 */
function set_plateforme_individu_type($libelle){
	$sql="select * from contraintes.fw_set_individu_type('$libelle') ";
	echo $sql;
	$res = pg_query($sql);
	return $res;
}

/**
 * Retourne tous les types d'individus
 * Retourne le profile 'root' uniquement si l'utilisateur connect est 'root' lui meme.
 * @return varchar Le r�sultat de la requete (id integer, libelle varchar, code varchar)
 */
function get_plateforme_individus_types(){
			
	global $auth;
	$with_root=false;
	if($auth->is_root()){
		$with_root=true;
	}	
	$sql="select * from contraintes.fw_get_individus_types(".bool2Sql($with_root).") AS (id integer, libelle varchar, code varchar)";
//	echo $sql;
	$res = pg_query($sql);
	return $res;
}

/**
 * Retourne les libelles de types d'individus  partir de leur code.
 * 
 * Le sparateur des codes dans la chaine est le caractre ',' (virgule).
 * Si un code ne trouve pas de correspondance avec un libll, une erreur est provoque.
 *
 * @param string Une chaine contenant des codes de types d'individus spars par une virgule ','
 * @param string Une chaine contenant les libells des codes de types d'individus spars par une virgule ','
 */
function get_plateforme_individus_types_libelles_by_codes($individu_type_codes){
			
	$sql="select * from contraintes.fw_get_individus_types_libelles_by_codes(".string_array_to_plpgsql_array($individu_type_codes).")";
//	echo $sql;
	$res = pg_query($sql);
	return pg_fetch_result($res,0,0);
}



/**
 * Retourne tous les types d'utilisateur
 * 
 * @return integer  Le type
 * @return varchar Le r�sultat de la requete (id integer, libelle varchar, code varchar)
 *
 */
 //TODO a supprimer
function get_plateforme_individu_types(){
	echo "Fonction get_plateforme_individu_types() deprecie utiliser get_plateforme_individus_types()<br>";
	$sql="select * from contraintes.fw_get_individu_types() AS (id integer, libelle varchar, code varchar)";
	$res = pg_query($sql);
	return $res;
}

?>
