<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
         @package inscription
          @modulegroup plpgsql
          @module plpgsql_inscription
*/


/**
    Enregistre une inscription
*
*   @param string : id_user
*   @param string : le login
*   @param string : le mot de passe
*   @param string : le nom
*   @param string : le prenom
*   @param string : l'adresse
*   @param string : le code postal
*   @param string : la ville
*   @param string : l'email
*   @param string : telephone fixe
*   @param string : telephone portable
*   @param string : la langue de l'individu
*   @param integer : le numero d'organisme
*   @param string : la categorie
*   @param string : la session
*   @param string : total
*   @param integer : temps
*   @param string : le nom du fichier photo
*/
function set_inscription($token,$log,$pass,$nom,$pre,$adr,$cod,$vil,$mail,$telfix,$telport,$lang,$org,$sess,$total,$tps,$photo){
    if(VERSION_BASE > VERSION){
//		// On met les types en tableau
//		$tab_type="_int4'{";
//		$sz=strlen($sess);
//		for($i=0;$i<$sz;$i++){
//			$type=substr($sess,$i,1);
//			switch($type){
//				case 'u' : $tab_type .="1,";break;
//				case 'f' : $tab_type .="2,";break;
//				case 'i' : $tab_type .="3,";break;
//			}
//		}
//		$tab_type=substr($tab_type,0,-1);
//		$tab_type .="}'";
	    $sql="select * from 
		contraintes.af_set_inscription($token,$log,$pass,$nom,$pre,$adr,$cod,$vil,$mail,$telfix,$telport,$lang,$org,$photo)";
//		echo "sql=$sql<br>";
		$res=pg_query($sql);
    }
    else{
		}
    return pg_fetch_result($res,0,0);
}


/**
    Mettre  jour un individu
*
*   @paraminteger : le numero de l'individu
*   @param string : le login
*   @param string : le mot de passe
*   @param string : le nom
*   @param string : le prenom
*   @param string : l'adresse
*   @param string : le code postal
*   @param string : la ville
*   @param string : l'email
*   @param string : telephone fixe
*   @param string : telephone portable
*   @param string : la langue de l'individu
*   @param integer : le numero d'organisme
*   @param string : la categorie
*   @param string : le nom du fichier photo
*/
function maj_inscription($individu,$log,$pass,$nom,$pre,$adr,$cod,$vil,$mail,$telfix,$telport,$lang,$org,$photo){
    if(VERSION_BASE > VERSION){
	    // On met les types en tableau
//		$tab_type="_int4'{";
//		$sz=strlen($cat);
//		for($i=0;$i<$sz;$i++){
//			$type=substr($cat,$i,1);
//			switch($type){
//				case 'u' : $tab_type .="1,";break;
//				case 'f' : $tab_type .="2,";break;
//				case 'i' : $tab_type .="3,";break;
//			}
//		}
//		$tab_type=substr($tab_type,0,-1);
//		$tab_type .="}'";
		$sql="select * from 
		contraintes.af_maj_inscription($individu,$log,$pass,$nom,$pre,$adr,$cod,$vil,$mail,$telfix,$telport,$lang,$org,$photo)";
//		echo "sql=$sql<br>";
		$res=pg_query($sql);
    }
        //$res=maj_individu_old($individu,$log,$pass,$nom,$pre,$adr,$cod,$vil,$mail,$telfix,$telport,$lang,$org,$cat,$photo);
    return sql2Bool(pg_fetch_result($res,0,0));
}


/**
    Supprimer une inscription
*
*   @param integer : le numero de l'individu
*   @return integer : le resultat de la requete
*/
function del_inscription($individu){
     if(VERSION_BASE > VERSION){
	     $sql="select * from contraintes.af_del_inscription($individu)";
		 $res=pg_query($sql);
    }
    else
        $res=del_individu_old($individu);
    return pg_fetch_result($res,0,0);
}


/**
    Obtenir les infos d'une inscription
* @param : integer le numero de l'individu en base de donnes
*   @return integer : le resultat de la requete :(id int4,identifiant_md5 varchar,login varchar,password varchar,nom varchar,prenom varchar,adresse varchar,code varchar,ville varchar,
		email varchar,tel_fix varchar,tel_port varchar,langue int4,organisme int4,photo int4)
*/
function get_inscription($individu){
    if(VERSION_BASE > VERSION){
	    $sql="select * from contraintes.af_get_inscription($individu) as 
		(id int4,identifiant_md5 varchar,login varchar,password varchar,nom varchar,prenom varchar,adresse varchar,code varchar,ville varchar,
		email varchar,tel_fix varchar,tel_port varchar,langue int4,organisme int4,photo int4)";
		//echo "sql=$sql<br>";
		$res=pg_query($sql);
    }
    else
        $res=get_individu_old($individu);
    return $res;
}













?>