<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Fonctions d'appel au fonctions PL/PGSQL pour les intervenants.
 * 
 * @package intervenant
 * @modulegroup plpgsql
 * @module plpgsql_intervenant
 */
 
 /**
	Obtenir les evenements d'un intervenant pour un jour de formation (OLD)
*   @param integer : le numero de la salle
*   @param date : le jour de formation
*   @return integer : le resultat de la requete
*/
function get_intervenant_evenements_old($intervenant,$date){
	$sql="SELECT gnum_cal,libelle,
				 cast(D.jour as timestamp)+cast(hdeb as time),
				cast(hfin as time)-cast(hdeb as time),
				numtype,type,num_intervenant,num_salle
				FROM dates D,gest_cal G 
				where num_intervenant=$intervenant and D.num_date=G.num_date and D.jour='$date' ";
	
	
    $res=pg_query($sql);
    return $res;
}
 /**
	Obtenir les evenements d'un intervenant pour un jour de formation
*   @param integer : le numero de la salle
*   @param date : le jour de formation
*   @return integer : le resultat de la requete
*/
function get_intervenant_evenements($intervenant,$date){
	if(VERSION_BASE > VERSION){
		$sql="select * from contraintes.af_get_intervenant_evenements($intervenant,'$date') 
				as (formation int4,libelle varchar,date timestamp,duree interval,modalite int4,intervention int4,intervenant int4,salle int4)";
		//echo "sql=$sql<br>";
		$res=pg_query($sql);
	}
	else
		$res=get_intervenant_evenements_old($intervenant,$date);
	return $res;
}

/**
	Obtenir les formations presentielles d'un intervenant  (OLD)
	@param integer : intervenant
	@return integer : le resultat de la requete(formation,libelle)
*/
function get_intervenant_formations_presentielles_old($intervenant){

}
/**
	Obtenir les formations presentielles d'un intervenant  
	@param integer : intervenant
	@return integer : le resultat de la requete(formation,libelle)
*/
function get_intervenant_formations_presentielles($intervenant){
	if(VERSION_BASE > VERSION){
		$sql="select * from contraintes.af_get_intervenant_formations_presentielles($intervenant) as (id int4,libelle varchar)";
		$res=pg_query($sql);
	}
	else
		return get_intervenant_formations_presentielles_old($intervenant);
	return $res; 
}

/**
	Obtenir les evenements presentiels pour un intervenant (OLD)
	@param integer : intervenant
	@param integer : formation
	@return integer : resultat requete
*/
function get_intervenant_evenements_presentiels_old($intervenant,$formation){

}
/**
	Obtenir les evenements presentiels pour un intervenant 
	@param integer : intervenant
	@param integer : formation
	@return integer : resultat requete
*/
function get_intervenant_evenements_presentiels($intervenant,$formation){
	if(VERSION_BASE > VERSION){
		$sql="select * from contraintes.af_get_intervenant_evenements_presentiels($intervenant,$formation) 
					as (formation int4,libelle varchar,date timestamp,duree interval,modalite int4,intervention int4,intervenant int4,salle int4)";
		$res=pg_query($sql);
	}
	else
		return get_intervenant_evenements_presentiels_old($intervenant,$formation);
	return $res;
}

/**
	Obtenir les formations presentielles avec grille pour un intervenant (OLD)
	@param integer : intervenant
	@return integer : resultat requete
*/
function get_intervenant_formations_grille_old($intervenant){
	$sql="select distinct c.num_cal,c.nom_cal from calendrier c,gest_cal g,config_grille cg where c.num_cal=g.gnum_cal and g.num_intervenant=$intervenant
				and g.numtype=3 and c.num_cal=cg.num_cal";
	return pg_query($sql);
}
/**
	Obtenir les formations presentielles avec grille pour un intervenant
	@param integer : intervenant
	@return integer : resultat requete
*/
function get_intervenant_formations_grille($intervenant){
	 if(VERSION_BASE > VERSION){
		 $sql="select * from contraintes.af_get_intervenant_formations_grille($intervenant) as (id int4,libelle varchar)";
		 $res=pg_query($sql);
	 }
	 else
		return get_intervenant_formations_grille_old($intervenant);
	 return $res;
}