<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
Dfinition de la classe intervention(num_intervention, nom_salle).

@author LADJANI said <sladjani@afide.fr>
@since 29/03/2005

@package intervention
*/
class Intervention
{
        /**
        * @var integer : Identifiant en base de donnes
        */
        var $num_intervention ;

        /**
        * @var string : Nom de la salle
        */
        var $nom_intervention ;

        /**
        * @var string : code couleur
        */
        var $code_couleur ;

        /**
        * Constructeur
        * Ce constructeur permet de crer un objet Salle de deux faon diffrentes. Soit il va chercher un nom dans
        * la base de donnes et dans ce cas il faut lui donner l'identifiant. Autrement, on lui passe une chane de caractre
        * qui sera affecte au nom.
        * 
        * @param string $num_ou_lib Peut-tre ou bien un identifiant de ligne en base de donnes (c'est donc un entier), ou une chane soit une
        * nouvelle intervention
        * 
        * @param string $code Code couleur de l'Intervention
        */
        function Intervention($num_ou_lib,$code)
        {

                // On determine le type du paramtre  l'aide d'une expression regulire (on reoit toujours une String en php si c'est une rsultat de BD)
                $une_chaine  = ereg("[^0-9]",$num_ou_lib) ;

                // Deux constructions diffrentes selon le type du paramtre ( refaire le jour o on pourra surcharger les fonctions !!!)
                if(!$une_chaine)
                {
                        $this->num_intervention = $num_ou_lib ;
                        // echo "Class Salle : constructeur avec identifiant<br>" ;
                        /*
                        $requete="SELECT * FROM intervention WHERE id=$num_ou_lib" ;
                        $result=pg_query($requete) ;
                        */
                        $result=get_intervention($num_ou_lib);
                        $row=pg_fetch_row($result) ;
                        $this->nom_intervention = $row[1] ;
                        $this->code_couleur = $row[2] ;

                }
                // Construction  partir d'un nom
                else
                {
                       $this->nom_intervention = $num_ou_lib ;
                       $this->code_couleur = $code;
                }
        }
        // ------------------------------------------------------------------------------------------------------------------- fin Organisme($num_ou_lib)


        /**
        * Fonction qui insre un enregistrement en table intervention et qui retourne l'identifiant de la ligne cre
        * On retourne l'identifiant de la ligne cre. Si l'insertion a chou, on retourne 0
        * @return integer : identifiant de l'enregistrement cre ou un code erreur ngatif
        */
        function insertToDB()
        {
                // On n'insre une ligne que si la intervention n'existe pas dj
                if($this->nom_intervention=="")
                {
                        return (-110) ; // libell vide
                }
                // Le libell est correcte
                else
                {
                        //$lib=addslashes($this->nom_intervention) ;
                        $lib=$this->nom_intervention ;
                        $codecoul=$this->code_couleur;
                        // Cet organisme existe-il dj ?
                        //if(pg_num_rows(pg_query("SELECT id FROM intervention WHERE nom='$lib'"))>0)
                        if(check_intervention($lib))
                        {
                                return (-111);  // intervention existe dj
                        }
                        else
                        {
                                //$insertion = "INSERT INTO intervention (nom,code_couleur) VALUES ('$lib','$codecoul')" ;
                                $insertion=set_intervention(set_ams_libelle($lib),$codecoul);

                                // On retourne un boolen
                                //if($res = pg_query($insertion))
                                if($intervention)
                                {
                                        /*
                                        $tmp = pg_result(pg_query("SELECT id FROM intervention WHERE nom='$lib'"),0,0) ;
                                        // on retourne l'identifiant de la ligne cre
                                        return($tmp);
                                        */
                                        return $intervention;
                                }
                                else
                                        return (-1) ; // Problme requte
                        }
                }
        }
        // ------------------------------------------------------------------------------------------------------------------- fin insertToDB()

        /**
        * Fonction qui met  jour l'enregistrement en table intervention
        *
        * Fonction qui met  jour l'enregistrement en table intervention
        * Cette fonction ne peut tre utilise que si l'objet possde un identifiant.
        *
        * @return integer : On retourne 1 si l'opration s'est correctement effectue. Autrement on retourne un code erreur
        */

        function updateToDB()
        {
                // Il faut que l'identifiant soit connu
                if($this->num_intervention != 0)
                {
                        //$update = "UPDATE intervention SET nom = '".addslashes($this->nom_intervention)."',code_couleur='".$this->code_couleur."' WHERE id=$this->num_intervention" ;
                        //$lib=addslashes($this->nom_intervention) ;
                        $lib=$this->nom_intervention ;
                        $code=$this->code_couleur;
                        $update=maj_intervention($this->num_intervention,set_ams_libelle($lib),$code);

                        // echo "Class Salle : updateToDB. Requete =<br>$update<br>" ;

                        // On retourne un boolen
                        //if(pg_query($update))
                        if($update)
                                return true ;
                        else
                                return -1 ; // erreur base de donnes
                }
                // Identifiant inconnu : mise  jour impossible
                else
                {
                        return -2 ;
                }
        }
        // ------------------------------------------------------------------------------------------------------------------- fin updateToDB()

        /**
        * Fonction qui retourne une chane de caractre contenant des informations sur l'objet
        *
        * Fonction qui retourne une chane de caractre contenant des informations sur l'objet.
        * Si on ne passe aucun paramtre, la chane retourne contient le libell de l'organisme. Par contre, si le paramtre est dfini,
        * il est utilis comme format de retour. Cet fonction peut servir d'accesseur sur les attributs de la classe.
        *
        * @param string : le paramtre determine ce qu'on retourne.
        * [num_org] - [libelle_org]
        * @return string : On retourne la chane de caractres cre  partir du format
        */

        function toString($format="")
        {
                // Aucun paramtre, on retourne le libell
                if($format=="")
                        return $this->nom_intervention ;

                // Ce tableau contient tous les pattern et les nouvelles valeurs
                $tab_replace = array("\[num_intervention\]"=>$this->num_intervention,"\[nom_intervention\]"=>$this->nom_intervention) ;

                while($tab=each($tab_replace))
                        $format = ereg_replace($tab[0],$tab[1],$format) ;

                return $format ;
        }
        // ------------------------------------------------------------------------------------------------------------------- fin toString($format)

       
}

?>