<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**

       @package intervention
       @modulegroup plpgsql
       @module plpgsql_intervention
*/

/**
*   Test si l'intervention donne est supprimable (OLD)
*
*   Retourne 0 si non supprimable et >0 sinon
*
*    @param  integer : numro de salle
*
*   @return integer : entier 0 ou >0
*/
function check_intervention_supprimable_old($intervention){
    $sql="select * from gest_cal where type=$intervention";
	$res=pg_query($sql);
	return pg_numrows($res);
}
/**
*   Test si l'intervention donne est supprimable
*
*   Retourne 0 si non supprimable et >0 sinon
*
*    @param  integer : numro de salle
*
*   @return integer : entier 0 ou >0
*/
function check_intervention_supprimable($intervention){
     if(VERSION_BASE>VERSION){
		$res=!fk_finder('intervention','id',$intervention);
     }
     else
        $res=check_intervention_supprimable_old($intervention);

     return $res;
}

/**
*   Supprimer une intervention.  (OLD)
*
*   Supprime la intervention

*
*   @param integer : numero de la intervention  supprimer
*   @return integer : 1
*/
function del_intervention_old($intervention){

    //suppression
    $del=pg_query("delete from intervention where id=$intervention;");

    return 1;
}

/**
*   Supprimer une intervention.
*
*   Supprime la intervention
*
*   @param integer : numero de la intervention  supprimer
*   @return integer : 1
*/
function del_intervention($intervention){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_del_intervention($intervention)";
		$res=pg_query($sql);
	}
    else
		$res=del_intervention_old($intervention);
	return ($res);
}

/**
    Obtenir les infos d'un type d'intervention (OLD)
*
*   @param integer : le numero d'intervention
*   @return integer : le resultat de la requete
*/
function get_intervention_old($intervention){
    $sql="select * from intervention where id=$intervention";
    $res=pg_query($sql);
    return $res;
}
/**
    Obtenir les infos d'un type d'intervention
*
*   @param integer : le numero d'intervention
*   @return integer : le resultat de la requete
*/
function get_intervention($intervention){
    if(VERSION_BASE>VERSION){
        $sql="select * from contraintes.af_get_intervention($intervention) as (id int4,libelle varchar,couleur varchar)";
		$res=pg_query($sql);
    }
    else
        $res=get_intervention_old($intervention);
    return ($res);
}

/**
    Verifie si une intervention existe (OLD)

    @param string : le nom d'intervention
    @return bool:  true si existe ,false sinon
*/
function check_intervention_old($libelle){
    $sql="SELECT id FROM intervention WHERE nom='$libelle'";
    $res=pg_query($sql);
    if(pg_num_rows($res)==0)
        return false;
    return true;
}
/**
    Verifie si une intervention existe

    @param string : le nom d'intervention
    @return bool:  true si existe ,false sinon
*/
function check_intervention($libelle){
    if(VERSION_BASE>VERSION){
        return false;
    }
    else
        $res=check_intervention_old($libelle);
    return ($res);
}

/**
    Enregistre une intervention (OLD)

    @param string : le nom d'intervention
    @param strinf : le code couleur
    @return interger : le numero d'intervention ,0 si erreur
*/
function set_intervention_old($libelle,$code){
    $sq="INSERT INTO intervention (nom,code_couleur) VALUES ('$libelle','$code')" ;
    $ins=pg_query($sql);
    if($ins){
        $oid=pg_getlastoid($ins);
        $res=pg_query("select id from intervention where id=$oid");
        return pg_result($res, 0, 0);
    }
    else
        return 0;
}
/**
    Enregistre une intervention

    @param string : le nom d'intervention
    @param strinf : le code couleur
    @return interger : le numero d'intervention ,0 si erreur
*/
function set_intervention($libelle,$code){
    if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_set_intervention('$libelle','$code')";
		echo "sql=$sql<br>";
		$res=pg_query($sql);
		return pg_fetch_result($res,0,0);
    }
    else
        $res=set_intervention_old($libelle,$code);
    //return ($res);
}

/**
    Mettre  jour une intervention (OLD)

    @param integer : le numero d'intervention
    @param string : le nom d'intervention
    @param strinf : le code couleur
    @return interger : le nresultat de la requete
*/
function maj_intervention_old($intervention,$libelle,$code){
    $sql="update intervention set nom='$libelle',code_couleur='$code' where id=$intervention";
    return pg_query($sql);
}
/**
    Mettre  jour une intervention

    @param integer : le numero d'intervention
    @param string : le nom d'intervention
    @param strinf : le code couleur
    @return interger : le nresultat de la requete
*/
function maj_intervention($intervention,$libelle,$code){
    if(VERSION_BASE>VERSION){
        $sql="select * from contraintes.af_maj_intervention($intervention,'$libelle','$code')";
		$res=pg_query($sql);
    }
    else
        $res=maj_intervention_old($intervention,$libelle,$code);
    return ($res);
}
?>