<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Objet permettant le chargement d'une langue.
 * Cet objet est un parseur XML permettant l'analyse et le traitement des fichier lang.xml
 */
class LangueLoader{
	
	/**
	 * @var string Lib�ll� du repertoire de Langue
	 */
	var $directory;
	
	/**
	 * @var ressource Parseur XML.
	 */
	var $xml_parseur;
	
	/**
	 * @var integer Indice de la Page courante. Cette variable temporaire permet le rep�rage de la page courante lors du parsing.
	 */
	var $indice_page=0;
	
	/**
	 * @var integer Indice du sous Module courant. Cette variable temporaire permet le rep�rage du sous module courant lors du parsing.
	 */
	var $indice_module=0;
	
	/**
	 * @var boolean Variable temporaire. Permet d'indiquer si il y a un texte contenu entre des balises ouvrantes et fermante � utiliser.  
	 */
	var $read_txt=false;
	
	/**
	 * @var string Variable temporaire. Permet de stocker temporairement un texte contenu entre des balises ouvrantes et fermante.
	 */
	var $read_txt_buffer=null;
	
	/**
	 * @var object Langue La langue charg�e par le parseur XML
	 */
	var $langue;
	
	/**
	 * @var string[] Arbre permettant le stockage de l'arborescence des balises pour permettre de connaitre le niveau d'imbrication des balises au cours du parsing.
	 */
	var $arbre=array();
	
	/**
	 * Constructeur.
	 * @param string $root Chemin racine dans lequel est localis� le r�pertoire du Module
	 * @param string $directory Lib�ll� du r�pertoire du Module
	 */
	function LangueLoader($root,$directory){
		$this->directory=$directory;
		$this->langue=new Langue($directory);
		
		//creation du parseur xml
		$this->xml_parseur = xml_parser_create(); 
		
		//parametrage du parseur xml
//		xml_parser_set_option($this->xml_parseur, XML_OPTION_TARGET_ENCODING, 'ISO-8859-1');
		xml_set_object($this->xml_parseur, &$this);
		xml_set_element_handler($this->xml_parseur, "ouverture", "fermeture");		
		xml_set_character_data_handler($this->xml_parseur, "texte");
		xml_set_default_handler($this->xml_parseur,"defaut");
		//ouverture du manifeste
		$chemin_fichier="$directory/lang.xml";
		$fp = file_exists($root.$chemin_fichier);
		if(!$fp){
			die("Pas de lang.xml ($root$chemin_fichier)<br>");
			return false;	
		}
		$ok=$this->verify($root,$chemin_fichier);
		if(!$ok){
			die("lang.xml n'est pas conforme.<br>");
			return false;	
		}
		
		//lecture du manifeste
		//on trim les donn�es lues pour supporter le caractere & dans le fichier xml
//		while ($fdata = fread($fp, 2048)){
			$fdata=file_get_contents($root.$chemin_fichier);
			$xml_data=strtr($fdata,array("&"=>"&#38;"));
			xml_parse($this->xml_parseur, $xml_data) or die(
				sprintf("Erreur XML :Fichier %s: %s � la ligne %d\n",
				$chemin_fichier,
				xml_error_string(xml_get_error_code($this->xml_parseur)),
				xml_get_current_line_number($this->xml_parseur))
				);
//		}
		xml_parser_free($this->xml_parseur);
	}
	
	/**
	 * Fonction d�clench� � la lecture d'une balise ouvrante.
	 * La fonction est appell�e automatiquement � l'appel de la fonction xml_parse
	 * @param ressource $parser Le parseur XML.
	 * @param string $name La balise XML courante.
	 * @param string[] Les attributs de la balise XML courante. Le tableau est ind�x� par les noms des attributs en majuscules.
	 */
	function ouverture ($parser, $name, $attrs){
		
		array_push($this->arbre,$name);
		
		switch($name){
			case 'LANGUE':
				//d�but manifest
				if(count($this->arbre)==1){ //balise niveau1
				}else{
					die("Erreur parsing.<br/>");
				} 
				break;	
				
			case 'TITLE':
				//balise niveau 2, apres LANGUE			
				if($this->arbre[count($this->arbre)-2]!='LANGUE')
					die("Erreur parsing.1(".count($this->arbre)."-".$this->arbre[count($this->arbre)-2].")<br/>");
					
				//creation de l'objet Module
				$this->read_txt=true;
				break;
			case 'CODE':
				//balise niveau 2, apres LANGUE			
				if($this->arbre[count($this->arbre)-2]!='LANGUE')
					die("Erreur parsing.2(".count($this->arbre)."-".$this->arbre[count($this->arbre)-2].")<br/>");
				$this->read_txt=true;
				break;
			case 'LOCALE':
				//balise niveau 2, apres LANGUE			
				if($this->arbre[count($this->arbre)-2]!='LANGUE')
					die("Erreur parsing.3(".count($this->arbre)."-".$this->arbre[count($this->arbre)-2].")<br/>");
				$this->read_txt=true;
				break;
			}
	}

	/**
	 * Fonction d�clench� � la lecture d'une balise fermante.
	 * La fonction est appell�e automatiquement � l'appel de la fonction xml_parse
	 * @param ressource $parser Le parseur XML.
	 * @param string $name La balise XML courante.
	 */
	function fermeture ($parser, $name){
	
		switch($name){
			case 'TITLE':
				$this->langue->setLibelle($this->useBuffer());
				$this->read_txt=false;
				break;
				
			case 'CODE':
				$this->langue->setCode($this->useBuffer());
				$this->read_txt=false;
				break;
			
			case 'LOCALE':
				$this->langue->setLocale($this->useBuffer());
				$this->read_txt=false;
				break;
			
			case 'LANGUE':
				//d�but manifest
				if(count($this->arbre)==1){ //balise niveau1
					
				}else{
					die("Erreur parsing.<br/>");
				}
				$this->read_txt=false;
				break;	 
		}
		array_pop($this->arbre);
	}
	
	/**
	 * Fonction d�clench� � la lecture du texte entre une balise ouverte et une balise ferm�e.
	 * La fonction est appell�e automatiquement � l'appel de la fonction xml_parse
	 * @param ressource $parser Le parseur XML.
	 * @param string $data_text Le texte entre balises.
	 */
	function texte($parser, $data_text){
		if($this->read_txt==true){
			$this->read_txt_buffer.=trim($data_text);
		}
	}
	
	function defaut (){
		return TRUE;
	}
	
	/**
	 * Obtenir le texte dans le buffer, cad le texte lu entre 2 balises.
	 * Le texte contenu dans le buffer est retourn�e puis vid� � l'appel de la fonction.
	 * @return Le texte contenu dans le buffer.
	 */
	function useBuffer(){
		$tmp=$this->read_txt_buffer;
		$this->read_txt_buffer=null;
		return $tmp;
	}
	
	/**
	 * Obtenir le parseur XML.
	 * @return ressource Parseur XML.
	 */
	function &getLoader(){
		return $this->xml_parseur;
	}
	
	/**
	 * Obtenir le Module analys� par le parsing.
	 */
	function &getLangue(){
		return $this->langue;
	}
	
	function verify($racine,$chemin_fichier){
		$error = array();
		global $root;
			if (version_compare(PHP_VERSION,'5','>='))
		 require_once("$root/lib/contrib/domxml-php4-to-php5.php");	  
		 
		// chargement en m�moire du fichier xml
		$dom = xmldocfile($racine.$chemin_fichier, DOMXML_LOAD_VALIDATING, $error);

		// test pour voir si le document xml est 'well formed'
		if(!is_object($dom)){
			echo("Le document XML n'est pas 'Well Formed' !\n");
			print_rr($error);
			return false;
		}
		  
		// test pour voir si le document est conforme � sa DTD
//		if(!domxml_doc_validate($dom, $error)){
//			echo "Validation DTD n'est pas OK\n";
//			print_rr($error);
//			return false;
//		} else {
			return true;
//		}
	}
}
?>
