<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
	Fichier de fonctions des langues.
	@package langue
	@modulegroup fonctions
*/

/**
 *  Configurer la langue par d�faut.
 * 
 *	Met en place le fichier /lang/default_lang.php3
 *	qui contient la variable MY_LANG precisant la langue a utiliser
 *	Si pas de parametre prend la premiere langue disponible.
 *	
 *	@param string $choix_lang le code de la langue.
 */
function set_langue_defaut($choix_lang = "") {
	global $chemin_bo;
	$lang_def = $chemin_bo . "/lang/default_lang.php3";
	//Si le fichier default_lang.php3 n'existe pas
	if (!file_exists($lang_def)) {
		//On recupere les langues disponibles
		$lang_dispo = available_lang();
		if (count($lang_dispo) > 0) {
			//print "LANGUE DEFAUT<BR>";
			//On prend la premiere langue disponible par defaut
			$contenu = "<?php\n";
			$contenu .= "define(\"MY_LANG\",\"$lang_dispo[0]\");\n";
			$contenu .= "?>\n";
			$fp = @ fopen("$lang_def", "w");
			if (!$fp)
				die("Erreur, impossible de cr&eacute;er le fichier default_lang.php3");
			fwrite($fp, $contenu);
			fclose($fp);
		} else
			die("Erreur, il semble n'y avoir aucun fichier de langue");
	} else {
		if ($choix_lang != "") {
			//print "LANGUE CHOISIE<BR>";
			$contenu = "<" . "?" . "php\n";
			$contenu .= "define(\"MY_LANG\",\"$choix_lang\");\n";
			$contenu .= "?" . ">\n";
			$fp = @ fopen("$lang_def", "w");
			if (!$fp)
				die("Erreur, impossible de cr&eacute;er le fichier default_lang.php3");
			fwrite($fp, $contenu);
			fclose($fp);
		}

	}
}

function obj_get_langues_installes() {
	global $dbpath;
	
	if (VERSION_BASE > VERSION) {
		$lang_dispo = array ();
		
		$lang_bo = "$dbpath/ressources/langues/";
		$badRep = array (".","..");
		if ($dirLang = opendir($lang_bo)) {
			while ($repLang = readdir($dirLang)) {
				$cheminRepLang = $lang_bo . $repLang;
				if (is_dir($cheminRepLang) && !in_array($repLang, $badRep)) {
				$langue_loader=new LangueLoader($lang_bo,$repLang);
				$langue=$langue_loader->getLangue();
				$lang_dispo[] = $langue;
				}
			}
		}
		return $lang_dispo;
	} else {
		die("erreur: obj_get_langues_installes() n'existe pas pour la version ".VERSION."<br>");
	}
}

function get_langues_installees() {
	global $dbpath;
	global $root;
	
	if (VERSION_BASE > VERSION) {
		$lang_dispo = array ();
		
		$lang_bo = $root."langues/";
		$badRep = array (".","..");
		if ( $dirLang= opendir($lang_bo)) {
			$i = 0;
			while ($repLang = readdir($dirLang)) {
				$cheminRepLang = $lang_bo . $repLang;
				if (is_dir($cheminRepLang) && !in_array($repLang, $badRep)&& '.'!=substr($repLang, 0, 1)) {
					$langue_loader=new LangueLoader($lang_bo,$repLang);
					$langue=$langue_loader->getLangue();
					$lang_dispo[$i][0] = $langue->getId();
					$lang_dispo[$i][1] = $langue->getLibelle();
					$lang_dispo[$i][2] = $langue->getCode();
					$i++;
				}
			}
		}
		return $lang_dispo;
	} else {
		die("erreur: get_langues_installes() n'existe pas pour la version ".VERSION."<br>");
	}
}

/**
 * Savoir si une chaine contient un message de langue ou une chaine classique
 * @param string $string La chaine � analyser
 * boolean $dollar indique si la chaine contient un dollar. true par d�fault. si a false, ajoute le dollar
 * @return boolean true si c'est un message de langue, false sinon
 */
function is_langue_message($string,$dollar=false){
		if($dollar){
			$prefixe=substr($string,0,strpos($string,'_')+1);
		}else{
			$prefixe=substr('$'.$string,0,strpos('$'.$string,'_')+1); //ajoute le dollar
		}
		if(in_array(strtoupper($prefixe),get_langues_types_prefixes())){ 
			return true;
		}
		else{
			return false;
		}
}

/**
 * Obtenir une chaine � partir d'un message de langue ou une chaine classique
 * @param string $string La chaine � obtenir
 * @param boolean $dollar indique si la chaine contient un dollar. true par d�fault. si a false, ajoute le dollar
 * @return string la chaine originale ou la chaine �valu�e selon besoin
 */
function get_langue_message($string,$dollar=true){
	// chaine ams
	if(is_ams_libelle($string)){
		$tmp_chaine=get_ams_libelles($string);
		$string=get_ams_libelle($tmp_chaine);
		return $string;
	}

	
	if(is_langue_message($string,$dollar)){
		
		eval('$tmp= '.strtoupper($string).';');
		return $tmp;
	}
	return $string;
}

/**
 * Obtenir les pr�fixes des variables de messsage (YXXX_ o� Y=$ ou rien)
 *
 * @deprecated � Modififier pour que la m�thode soit dynamique (lecture en bdd avec ajout d'un champ bool 'constante')
 * @return array un tableau avec toud les pr�fixes des variables de messsage 
 */
//TODO Modififier pour que la m�thode soit dynamique (lecture en bdd avec ajout d'un champ bool 'constante')
//precision: � faire quand tous les messages de langues seront des constantes et non plus des variables
function get_langues_types_prefixes(){
	return array('$MENU_',
				'$MSG_',
				'$WARN_',
				'$FORM_',
				'$ERROR_',
				'$BULLE_',
				'$CHAT_',
				'$FORUM_',
				'$MOT_',
				'$MOIS_',
				'$JOUR_',
				'$M_',
				'$I_',
				'MENU_',
				'MSG_',
				'WARN_',
				'FORM_',
				'ERROR_',
				'BULLE_',
				'CHAT_',
				'FORUM_',
				'MOT_',
				'MOIS_',
				'JOUR_',
				'M_',
				'I_'
				);
}

/**
 * Extrait, � partir d'une chaine SQL brute (cad sans addslashes ni traitenement autre),
 * la ou les ams qui y sont contenues.
 * Une ams est caract�ris�e par un identifiant de langue et une chaine.
 * Par soucis de compatibilit�, si la chaine pass�e en parametre ne correspond pas � des ams mais � une chaine standard,
 * la fonction la retourne telle quelle.
 * 
 * Pr�cisions sur le format des tableaux retourn�s:
 * Si la fonction retourne un tableau, chacuns de ses �l�ments est un tableau dont le premier �l�ment est la langue de l'ams,
 * et le second la chaine de l'ams.
 *  
 * @param string $string_libelles Le contenu brut d'un champ SQL, contenant des ams ou non
 * @return mixed Retourne la chaine $string_libelles si pas d'ams, ou un tableau correspondant aux ams extraites. 
 * 
 */
function get_ams_libelles($string_libelles){ 
	
	//echo "get_ams_libelles=".$string_libelles."<br>";
	
	
	global $ams_langue,$langue_par_defaut;
	//$ams_langue=2;
	//si pas d' ams_langue, erreur
	if(empty($ams_langue)){
		AstairsTemplate::setPageMessage('Vous devez selectionner une langue pour vos contenus',MSG_ERROR);
		return;		
//		die("Erreur: la langue des contenus (ams_langue) a été perdue");
	}
	
	//on cheche la string correspondant à l'ams_langue
	$pattern = '%##AMS(\d+)##{"(.*?[^\\\])"}(,|$)%';
	$found=preg_match_all($pattern, $string_libelles, $matches);
	//print_rr($matches);
	//si on a trouvé une ams
//	echo "found=$found";
	
	if($found==1){
		//on le retourne en indiquant son ams langue
		return array(array($matches[1][0],$matches[2][0]));
	}
	//sinon le libellé est en plusieurs langues 
	elseif($found>1){
		$tab=array();
		for($i=0;$i<$found;$i++){
			$tab[]=array($matches[1][$i],$matches[2][$i]);
		}
		return $tab;
	}
	//sinon le libellé n'est pas au format ams, on le retourne
	else{
		return 	$string_libelles;		
	}
		
}

function get_fo_libelle($string_libelles){ 
	
//	echo $string_libelles."<br>";
	global $s_langue,$langue_par_defaut;
	
	//si pas d' s_langue, erreur
	if(empty($s_langue)){
		die("Erreur: la langue a été perdue");
	}
	
	//on cheche la string correspondant à l's_langue
	$pattern = '%##AMS('.$s_langue.')##{"(.*?)"}%';
	$found=preg_match_all($pattern, $string_libelles, $matches);
	//print_rr($matches);
	//si on a trouvé une ams
	//echo "found=$found<br>";
	if($found==1){
		//on la retourne
		return $matches[2][0];
	}
	//sinon le libellé est en plusieurs langues 
	else{
		//on cheche la string correspondant à la langue par défaut
		$pattern = '%##AMS('.$langue_par_defaut.')##{"(.*?)"}%';
		$found=preg_match_all($pattern, $string_libelles, $matches);
//		print_rr($matches);
		//si on a trouvé une ams
		if($found==1){
			//on la retourne
			return  $matches[2][0];
		}else{
			//on cheche la string correspondant à n'importe quelle langue
			$pattern = '%##AMS(\d+)##{"(.*?)"}%';
			//$pattern = '%##AMS(\d+)##{".*?"}%';
			$found=preg_match_all($pattern, $string_libelles, $matches);
		//	print_rr($matches);
			//si on a trouvé une ams
			if($found==1){
				//on la retourne
				return $matches[2][0];
			}
			//sinon le libellé n'est pas au format ams, on le retourne
			else{
				return 	$string_libelles;		
			}
		}
	}
}



function get_bo_fo_libelle($string_libelles,$langue_trouvee=null){ 
	
	if(empty($string_libelles)) return null;
//	echo "<br><br><br><b>STRING_LIBELLES</b>=$string_libelles<br>";
	global $ams_langue,$s_langue,$langue_par_defaut;
	
	//si pas d' s_langue, erreur
	if(empty($ams_langue))
		$int_langue=$s_langue;
	else
		$int_langue=$ams_langue;
		

	if(empty($int_langue)){
		die("Erreur: la langue a été perdue");
		
	}
//	echo "cherche ams de langue $int_langue<br>";
	//on cheche la string correspondant à l's_langue
	$pattern = '%##AMS('.$int_langue.')##{"(.*?[^\\\])"}(,|$)%'; //{\\"}}?
	$found=preg_match_all($pattern, $string_libelles, $matches);
//	echo "matches1====>";
//	print_rr($matches);
	//si on a trouvé une ams
	//echo "found=$found<br>";

	if($found==1){
		//on la retourne
		$langue_trouvee=$int_langue;
		return $matches[2][0];
	}
	//sinon le libellé est en plusieurs langues 
	else{
		
		
//	echo "cherche ams de langue  par d�faut $langue_par_defaut<br>";
		//on cheche la string correspondant à la langue par défaut
		$pattern = '%##AMS('.$langue_par_defaut.')##{"(.*?[^\\\])"}(,|$)%';
		$found=preg_match_all($pattern, $string_libelles, $matches);
//		echo "matches2====>";
//		print_rr($matches);
		//si on a trouvé une ams
		if($found==1){
			//on la retourne
			$langue_trouvee=$langue_par_defaut;
			return  $matches[2][0];
		}else{
			//on cheche la string correspondant à n'importe quelle langue
			$pattern = '%##AMS(\d+)##{"(.*?[^\\\])"}(,|$)%';
			//$pattern = '%##AMS(\d+)##{".*?"}%';
			$found=preg_match_all($pattern, $string_libelles, $matches);
//			echo "matches3==$found==>";
//			print_rr($matches);
			//si on a trouvé une ams
			if($found==1){
				//on la retourne
				$langue_trouvee=$matches[1][0];
				return $matches[2][0];
			}
			//sinon le libellé n'est pas au format ams, on le retourne
			else{
				return 	"-Contenu indisponible dans la langue choisie-";		
			}
		}
		
	}
}


/**
 * Retourne une ams au format SQL � partir d'une chaine pass�e en parametre et de l'ams_langue stock�e en session.
 * Cette valeur retourn�e est � utiliser directement pour une insertion en base de donn�es, brute et sans traitements suppl�mentaires (addslashes, etc..).
 * 
 * @param string $libelle Le lib�ll� � formater en ams SQL.
 * @return string L' ams au format SQL pour insertion en base de donn�es.
 */
function set_ams_libelle($libelle){ 
	global $ams_langue;
	$ams_string = '##AMS'.$ams_langue.'##{"'.addslashes($libelle).'"}';
	return 	$ams_string;
}

/**
 * Helper.
 * Retourne une chaine contenant un guiAmsLibelle pour affichage d'une ams, � partir d'une chaine SQL brute contenant une, plusieurs ou aucune ams.
 * Un guiAmsLibelle affiche l'ams correspondant � la langue_ams de la session, ainsi que le code de pays de la langue en question.
 * Cet �l�ment graphique provoque l'affichage d'une bulle lorsqu'il est survol� par le curseur de la souris, qui indique les autres traductions disponibles pour l'ams
 * 
 * Par soucis de compatibilit�, cet affichage fonction avec les chaines non ams
 * 
 * NB: Cette fonction est � utiliser pour l'affectation d'une variable ou au sein d'une chaine de caract�re.
 * 
 * @param string $string_libelles Le contenu brut d'un champ SQL, contenant des ams ou non
 * @param boolean $interpretationHTML Permet l'interpretation HTML de la chaine � afficher si � true. A false par d�fault.
 * @return string Le composant graphique
 */
function get_gui_libelle($string_libelles,$interpretationHTML=false){
	global $root;
	$component= new guiAmsLibelle($string_libelles,"$root/lib_graphique/objets/langue/templates/tpl",array('component_ams_libelle'=>'gui_ams_libelle.tpl'),$interpretationHTML);
	$component->parse('component_ams_libelle_out','component_ams_libelle');
	return $component->get('component_ams_libelle_out');
}

/**
 * Helper.
 * Affiche un guiAmsLibelle pour affichage d'une ams, � partir d'une chaine SQL brute contenant une, plusieurs ou aucune ams.
 * Un guiAmsLibelle affiche l'ams correspondant � la langue_ams de la session, ainsi que le code de pays de la langue en question.
 * Cet �l�ment graphique provoque l'affichage d'une bulle lorsqu'il est survol� par le curseur de la souris, qui indique les autres traductions disponibles pour l'ams
 * 
 * Par soucis de compatibilit�, cet affichage fonctionne avec les chaines non ams
 * 
 * NB: Cette fonction est � utiliser pour un affichage direct. (Equivalent � print( get_gui_libelle($string_libelles,$interpretationHTML)))
 * 
 * @param string $string_libelles Le contenu brut d'un champ SQL, contenant des ams ou non
 * @param boolean $interpretationHTML Permet l'interpretation HTML de la chaine � afficher si � true. A false par d�fault.
 * @return void
 */
function p_gui_libelle($string_libelles,$interpretationHTML=false){
	global $root;
	$component= new guiAmsLibelle($string_libelles,"$root/lib_graphique/objets/langue/templates/tpl",array('component_ams_libelle'=>'gui_ams_libelle.tpl'),$interpretationHTML);
	$component->parse('component_ams_libelle_out','component_ams_libelle');
	return $component->p('component_ams_libelle_out');
}

/**
 * Helper.
 * Retourne une chaine contenant un guiAmsLibelleInput pour la saisie d'une ams, � partir d'une chaine SQL brute contenant une, plusieurs ou aucune ams.
 * Un guiAmsLibelleInput affiche un champ imput initalis� avec l'ams correspondant � la langue_ams de la session, ainsi que le code de pays de la langue en question.
 * Cet �l�ment graphique provoque l'affichage d'une bulle lorsqu'il est survol� par le curseur de la souris, qui indique les autres traductions disponibles pour l'ams
 * 
 * Par soucis de compatibilit�, cet affichage fonctionne avec les chaines non ams
 * 
 * NB: Cette fonction est � utiliser pour l'affectation d'une variable ou au sein d'une chaine de caract�re.
 * 
 * @param string $input_name Le nom du champ input pour une utilisation au sein de n'importe quel formulaire
 * @param string $string_libelles Le contenu brut d'un champ SQL, contenant des ams ou non
 * @return string Le composant graphique
 */
function get_gui_libelle_input($input_name,$string_libelles,$disabled=false,$taille=80,$onKeyUp=''){
	global $root;
	$component= new guiAmsLibelleInput($string_libelles,$input_name,"$root/lib_graphique/objets/langue/templates/tpl",array('component_ams_libelle_input'=>'gui_ams_libelle_input.tpl'),$disabled,$taille,$onKeyUp);
	$component->parse('component_ams_libelle_input_out','component_ams_libelle_input');
	return $component->get('component_ams_libelle_input_out');
}

/**
 * Helper.
 * Affiche un guiAmsLibelleInput pour la saisie d'une ams, � partir d'une chaine SQL brute contenant une, plusieurs ou aucune ams.
 * Un guiAmsLibelleInput affiche un champ imput initalis� avec l'ams correspondant � la langue_ams de la session, ainsi que le code de pays de la langue en question.
 * Cet �l�ment graphique provoque l'affichage d'une bulle lorsqu'il est survol� par le curseur de la souris, qui indique les autres traductions disponibles pour l'ams
 * 
 * Par soucis de compatibilit�, cet affichage fonctionne avec les chaines non ams
 * 
 * NB: Cette fonction est � utiliser pour un affichage direct. (Equivalent � print( get_gui_libelle_input($input_name,$string_libelles)))
 * 
 * @param string $input_name Le nom du champ input pour une utilisation au sein de n'importe quel formulaire
 * @param string $string_libelles Le contenu brut d'un champ SQL, contenant des ams ou non
 * @return void
 */
function p_gui_libelle_input($input_name,$string_libelles,$disabled=false,$taille=80,$onKeyUp=''){
	global $root;
	$component= new guiAmsLibelleInput($string_libelles,$input_name,"$root/lib_graphique/objets/langue/templates/tpl",array('component_ams_libelle_input'=>'gui_ams_libelle_input.tpl'),$disabled,$taille,$onKeyUp);
	$component->parse('component_ams_libelle_input_out','component_ams_libelle_input');
	return $component->p('component_ams_libelle_input_out');
}

/**
 * Affiche la boite de selection de la langue de contenus (ams_langue).
 * Cet affichage est un select proposant les diff�rentes langues disponibles de la plateforme, avec comme valeur par d�fault (pas de selection) la langue par
 * d�fault de la plateforme, ainsi qu'un bouton de soumission. De plus il se positionne automatiquement � l' ams_langue en session.
 * 
 * Ce composant graphique est autonome, il dispose de son formulaire permettant de valuer $_POST['ChAmsLangue']. 
 * 
 * NB: Pour utiliser ce composant convenablement, il convient de le faire pr�c�der de l'appel � sa m�thode de soumission. A savoir:
 * 
 * guiAmsLangues::submit($_POST);
 * p_gui_ams_langues();
 * 
 * @return void
 */
function p_gui_ams_langues(){
	global $root;
	$component= new guiAmsLangues('component_ams_langues',"$root/lib_graphique/objets/langue/templates/tpl",array('component_ams_langues'=>'gui_ams_langues.tpl'));
	$component->parseBlocks('component_ams_langues',true);
	$component->parse('component_ams_langues_out','component_ams_langues');
	
	return $component->p('component_ams_langues_out');
}

/**
 * Helper.
 * Retourne une chaine contenant un guiAmsLibelleTextarea pour la saisie d'une ams, � partir d'une chaine SQL brute contenant une, plusieurs ou aucune ams.
 * Un guiAmsLibelleTextarea affiche un champ textearea initalis� avec l'ams correspondant � la langue_ams de la session, ainsi que le code de pays de la langue en question.
 * Cet �l�ment graphique provoque l'affichage d'une bulle lorsqu'il est survol� par le curseur de la souris, qui indique les autres traductions disponibles pour l'ams
 * 
 * Par soucis de compatibilit�, cet affichage fonctionne avec les chaines non ams
 * 
 * NB: Cette fonction est � utiliser pour l'affectation d'une variable ou au sein d'une chaine de caract�re.
 * 
 * @param string $input_name Le nom du champ input pour une utilisation au sein de n'importe quel formulaire
 * @param string $string_libelles Le contenu brut d'un champ SQL, contenant des ams ou non
 * @return string Le composant graphique
 */
function get_gui_libelle_textearea($input_name,$string_libelles,$disabled=false){
	global $root;
	$component= new guiAmsLibelleTextarea($string_libelles,$input_name,"$root/lib_graphique/objets/langue/templates/tpl",array('component_ams_libelle_input'=>'gui_ams_libelle_textarea.tpl'),$disabled);
	$component->parse('component_ams_libelle_input_out','component_ams_libelle_input');
	return $component->get('component_ams_libelle_input_out');
}

/**
 * Helper.
 * Retourne une chaine contenant un guiAmsLibelleTextarea pour la saisie d'une ams, � partir d'une chaine SQL brute contenant une, plusieurs ou aucune ams.
 * Un guiAmsLibelleTextarea affiche un champ textearea initalis� avec l'ams correspondant � la langue_ams de la session, ainsi que le code de pays de la langue en question.
 * Cet �l�ment graphique provoque l'affichage d'une bulle lorsqu'il est survol� par le curseur de la souris, qui indique les autres traductions disponibles pour l'ams
 * 
 * Par soucis de compatibilit�, cet affichage fonctionne avec les chaines non ams
 * 
 * NB: Cette fonction est � utiliser pour l'affectation d'une variable ou au sein d'une chaine de caract�re.
 * 
 * @param string $input_name Le nom du champ input pour une utilisation au sein de n'importe quel formulaire
 * @param string $string_libelles Le contenu brut d'un champ SQL, contenant des ams ou non
 * @return string Le composant graphique
 */
function p_gui_libelle_textearea($input_name,$string_libelles){
	global $root;
	$component= new guiAmsLibelleTextarea($string_libelles,$input_name,"$root/lib_graphique/objets/langue/templates/tpl",array('component_ams_libelle_input'=>'gui_ams_libelle_textarea.tpl'));
	$component->parse('component_ams_libelle_input_out','component_ams_libelle_input');
	return $component->p('component_ams_libelle_input_out');
}

/**
 * Retourne un texte ams parmi plusieurs
 * 
 * 
 * 
 * 
 */
 function get_ams_libelle($ams,$taille=0){
 	global $ams_langue;
 	// TODO
 	// Si pas de taille alors pas de substring
// 	echo "\$ams=$ams<br>";
 	//PAS D'AMS
 	$tmp_reponse=$ams;
	if(!is_array($tmp_reponse)){
		if($taille>0)
			$reponse=substr($tmp_reponse,0,$taille)."(X)";
		else
			$reponse=$tmp_reponse;
	}
    //UNE OU PLUSIEURS AMS
    else{
		//1 SEULE AMS
		if(count($tmp_reponse)==1){
			$cur_ams=$tmp_reponse[0];
			if($cur_ams[0]!=$ams_langue){
				$cur_ams=array($ams_langue,'');
			}
		}
		//PLUSIEURS AMS
		else{
			$trouve=false;					
			foreach($tmp_reponse as $indice => $tmp_rep){
				if($tmp_rep[0]==$ams_langue){
					$cur_ams=$tmp_rep;
					$trouve=true;
				}
			}
			if(!$trouve){
				$cur_ams=array($ams_langue,'');
			}
		}
		if($taille>0){
			$reponse=substr($cur_ams[1],0,$taille);
			if(strlen($reponse)>$taille){
		    	$reponse.="...";
			}
	    }
	    $reponse=$cur_ams[1];
		$res_langue=get_langue($cur_ams[0]);
        $cur_langue=pg_fetch_result($res_langue,0,3);
        
        if(!empty($cur_langue)){ //n'arrive jamaais
	    	$reponse.="(".get_country_code_primary($cur_langue).")";
        }
        
        else{
        	$reponse.="(X)";
        }
        
	}
	return $reponse;	
  }
  
 /**
  * Test si une chaine est une AMS
  * @param string : la chaine
  * @return bool : true si ams false sinon
  */ 
  function is_ams_libelle($libelle){
  	//echo "lib=$libelle<br>";
  	$pattern = '%##AMS(\d+)##{"(.*?)"}%';
  	//$pattern = '%##AMS(\d+)##{"(.*?)"}%';
	$found=preg_match_all($pattern, $libelle, $matches);
	if($found)
		return true;
	return false;
		
  }
?>