<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/


/**
 * Fonctions d'appel au fonctions PL/PGSQL pour les langues.
 * 
 * @package langue
 * @modulegroup plpgsql
 * @module plpgsql_langue
 */

/**
 * Obtenir une langue.(OLD)
 * 
 * @param integer : numero langue
 * @return integer : resultat requete :(id int4,libelle varchar, code varchar, locale varchar)
 */
function get_langue_old($langue) {
	global $site_heberge;
	global $MSG_1594, $MSG_1595, $MSG_1596, $MSG_1597, $MSG_1598, $MSG_2175, $MSG_2176;
    //echo "langue=$langue<br>";
	switch ($langue) {
		case 'french' :
			$langue_option = $MSG_1594;
			$locale="fr_FR";
			break;
		case 'english' :
			$langue_option = $MSG_1595;
			$locale="en_GB";
			break;
		case 'chinese' :
			$langue_option = $MSG_1596;
			$locale="zn_CN";
			break;
		case 'japanese' :
			$langue_option = $MSG_1597;
			$locale="ja_JP";
			break;
		case 'korean' :
			$langue_option = $MSG_1598;
			$locale="ko_KR";
			break;
		case 'russian' :
			$langue_option = $MSG_2175;
			$locale="ru_RU";
			break;
		case 'sudan' :
			$langue_option = $MSG_2176;
			$locale="sd_SD";
			break;
		default:
			print("La langue $langue n'est pas supporte par la fonction get_langue($langue)");
			return null;
	}

	//si la plate-forme est une pgr, on affiche forcement
	$sql="SELECT '$langue', '$langue_option', '$langue', '$locale' ";
	//echo "$sql<br>";
	return pg_query($sql);
}

/**
 * Obtenir une langue.
 * 
 * @param integer : numero langue
 * @return integer : resultat requete :(id int4,libelle varchar, code varchar, locale varchar)
 */
function get_langue($langue) {
	//echo "langue=$langue<br>";
	if (VERSION_BASE > VERSION) {
		if(!is_numeric($langue))$langue="'$langue'";
		$sql = "select * from contraintes.fw_get_langue($langue) as (id int4,libelle varchar, code varchar, locale varchar)";
		//echo"sql=$sql";
		return pg_query($sql);

	} else
		return get_langue_old($langue);
}

/**
 * Obtenir une langue.
 * 
 * @param integer : numero langue
 * @return integer : resultat requete :(id int4,libelle varchar, code varchar, locale varchar)
 */
function set_langue($libelle,$code,$locale) {
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.fw_set_langue('$libelle','$code','$locale')";
		//echo"sql=$sql";
		return pg_query($sql);

	} else
		die("la fonction  set_langue($libelle,$code,$locale) n'existe pas pour la version ".VERSION);
}

/**
 * Enregistre un message langue
 * @param integer : numero message
 * @param integer : numero langue
 * @param integer : numero type
 * @param string : libelle message
 */
 //Cette fonction etait utile au debut pour la copie des messages d'un fichier vers la base
 /*
 function set_langue_message_num($num,$langue,$type,$libelle){
 	$sql="select * from contraintes.af_set_langue($num,$langue,$type,'$libelle')";
 	return pg_query($sql);
 }
 */
 
 /**
 * Enregistre un message langue (sans numero)
 * @param integer : numero langue
 * @param integer : numero type
 * @param string : libelle message
 */
 function set_langue_message($langue,$type,$libelle){
 	$libelle=string2sql($libelle);
 	$sql="select * from contraintes.af_set_langue_message($langue,$type,$libelle)";
// 	echo "sql=$sql<br>";
 	$res=pg_query($sql);
 	return pg_fetch_result($res,0,0);
 	
 }

/**
 *  Enregistre les messages langue en table
 * @param array : tableau des numero de message
 * @param integer : numero langue
 * @param integer : type message langue
 * @param array : tableau des message de langue
 */
 function set_langue_messages($tabnum,$langue,$type,$tablib){
 	$sql_tabnum=int_array_to_plpgsql_array($tabnum);	
 	$sql_tablib=string_array_to_plpgsql_array($tablib);
 	//pg_query("set names 'utf8'");
 	//pg_query("SET CLIENT_ENCODING TO 'utf8'");
 	$sql="select * from contraintes.af_set_langue_messages($sql_tabnum,$langue,$type,$sql_tablib)";
 	return pg_query($sql);
 }
 
 /**
  * Obtenir les messages de langue pour une langue donne
  * @param integer : langue
  * @return integer : res req (id int4,libelle text,type int4,langue int4,variable text)
  */
function get_langue_messages($langue){
	$sql="select * from contraintes.af_get_langue_messages($langue) as (id int4,libelle text,type int4,langue int4,variable text)";
	return pg_query($sql); 	
  }
  
  /**
  * Obtenir les messages de langue pour une langue et un type donns
  * @param integer : langue
  * @param integer : type
  * @return integer : res req 
  */
function get_langue_messages_type($langue,$type,$message=null){
	$message=string2Sql($message);	
	$sql="select * from contraintes.af_get_langue_messages_type($langue,$type,$message) as (id int4,libelle text,type int4,langue int4,variable text)";
	//echo "ici sql=$sql<br>";
	return pg_query($sql); 	
  }
  
/**
 * Obtenir le libelle pour un numero,un type et une langue
 * @param integer : numero id
 * @param integer : langue
 * @param integer : type
 * @return integer : res req
 */
 function get_langue_message_libelle($id,$langue,$type){
 	$sql="select * from contraintes.af_get_langue_message_libelle($id,$langue,$type) as (id int4,libelle text,type int4,langue int4)";
 	echo "sql=$sql<br>";
 	return pg_query($sql);
 }
 
/**
 * Obtenir les libelles des langues pour un type donn
 * @param array : tableau de langues
 * @param integer : type
 * @param integer : numero champ pour order by
 * @param string : classement (asc ou desc)
 * @param integer : limit
 * @param integer : offset
 * @param string : message  rechercher
 */
 function get_langue_libelles($tab_langue,$type,$orderby,$classement='desc',$limit=1000,$offset=0,$message=null){
 	global $MSG_1594,$MSG_1595,$MSG_1596,$MSG_1597;
 	$sql_tab_langue=int_array_to_plpgsql_array($tab_langue);
 	$message=string2Sql($message);	
 	$sql="select * from contraintes.af_get_langue_libelles($sql_tab_langue,$type,$orderby,'$classement',$limit,$offset,$message) as (id integer,";
 	for($i=0;$i<count($tab_langue);$i++){
 		$reslibelle=get_langue($tab_langue[$i]);
 		$libelle=pg_fetch_result($reslibelle,0,1);
 		$libelle=substr($libelle,1);
 		//echo "lib=$libelle<br>";
 		//eval("\$libelle=$libelle;");
 		$sql .=$libelle;
 		$sql .=" text,";
 		
 	}
 	$sql=substr($sql,0,-1);
 	$sql.=")";
 	//echo "<br>sql=$sql<br>";
 	return pg_query($sql);
 }
 
 /**
 * Obtenir les libelles des langues pour un type donn
 * @param array : tableau de langues
 * @param integer : type
 * @param integer : limit
 * @param string : message  rechercher
 * @param integer : numero champ pour order by
 * @param string : classement (asc ou desc)
  * @param integer : offset
 */
 function get_langue_message_type_langues_libelles($tab_langue,$type,$message=null,$limit=1000,$orderby=0,$classement='desc',$offset=0){
 	//global $MSG_1594,$MSG_1595,$MSG_1596,$MSG_1597;
 	$sql_tab_langue=int_array_to_plpgsql_array($tab_langue);
 	//echo "coucou<br>";
 	//print_rr($tab_langue);
 	$message=string2Sql(addslashes($message));	
 	$sql="select * from contraintes.af_get_langue_libelles($sql_tab_langue,$type,$orderby,'$classement',$limit,$offset,$message) as (id integer,";
 	for($i=0;$i<count($tab_langue);$i++){
 		$reslibelle=get_langue($tab_langue[$i]);
 		$libelle=pg_fetch_result($reslibelle,0,1);
 		//eval("\$libelle=$libelle;");
 		$sql .=$libelle;
 		$sql .=" text,";			
 		
 	}
 	$sql=substr($sql,0,-1);
 	$sql.=")";
// 	echo "<br>sql=$sql<br>";
 	return pg_query($sql);
 }
 
 
 
 /**
  * Mettre  jour un libelle
  * @param integer : langue
  * @param integer : type
  * @param integer  : id
  * @param string : libelle
  * @return bool : true si ok,false sinon
  */
  function maj_langue_libelle($langue,$type,$id,$libelle){
  	$libelle=string2sql($libelle);
  	$sql="select * from contraintes.af_maj_langue_libelle($langue,$type,$id,$libelle)";	
  	//echo "sql=$sql";
  	exit;
  	return pg_query($sql);
  } 
  
  /**
  * Mettre  jour un libelle
  * @param integer : langue
  * @param integer : type
  * @param integer  : id
  * @param string : libelle
  * @return bool : true si ok,false sinon
  */
  function maj_langue_libelles($langue,$type,$tab_id,$tab_libelle){
  	$sql_tabid=int_array_to_plpgsql_array($tab_id);	
 	$sql_tablib=text_array_to_plpgsql_array($tab_libelle);
//  	$libelle=string2sql($libelle);
  	$sql="select * from contraintes.af_maj_langue_libelles($langue,$type,$sql_tabid,$sql_tablib)";	
  	//echo "sql=$sql";
//  	exit;
  	return pg_query($sql);
  } 
  
 /**
  * Supprime un message de langue
  * @param integer : type de message
  * @param integer : numero message  supprimer
  */
  function del_langue_message($type,$message){
  	$sql="select * from contraintes.af_del_langue_message($type,$message)";
  	echo "sql=$sql";
  	return pg_query($sql);
  }
  
 /**
  * Supprime des message de langue
  * @param integer : type de message
  * @param string : tableau d'id  supprimer
 */
 function del_langue_messages($type,$tab){
 	$sql_tabid=int_array_to_plpgsql_array($tab);	
 	$sql="select * from contraintes.af_del_langue_messages($type,$sql_tabid)";
 	echo "sql=$sql<br>";
 	return pg_query($sql);
 }


/**
 * Obtenir les langues disponibles de la plate-forme.(OLD)
 * 
 * Retourne un tableau contenant les chemins vers les langues disponibles.
 * Toutes les langues sont disponibles si la plate-forme n'est pas une plate-forme h�berg�e (pas une PGR).
 * Si la plate-forme est herg�e (donc une PGR), les langues disponibles sont celles qui sont
 * pr�sentes dans le fichier config_site.php. 
 * 
 *  @return array() un tableau contenant les chemins vers les langues disponibles [0]contient le code de la langue,[1] son lib�ll� et [2] le code.
 */
function get_langues_disponibles_old() {
	global $chemin_bo;
	global $serverback;
	global $site_heberge;
	global $MSG_1594, $MSG_1595, $MSG_1596, $MSG_1597, $MSG_1598, $MSG_2175, $MSG_2176;
	$lang_dispo = array ();
	$badRep = array (
		".",
		".."
	);
	//$lang_bo = $chemin_bo . "/lang/";
	// NOUVEAU SYSTEME DE LANGUE
	$lang_bo = $chemin_bo . "/langues/";
	if ($dirLang = opendir($lang_bo)) {
		$i = 0;
		while ($repLang = readdir($dirLang)) {
			$cheminRepLang = $lang_bo . $repLang;
			if (is_dir($cheminRepLang) && !in_array($repLang, $badRep)) {
				switch ($repLang) {
					case 'french' : case 1 :
						$langue_option = $MSG_1594;
						if (L_French == 1)
							$affiche_langue = true;
						else
							$affiche_langue = false;
						break;
					case 'english' : case 2 :
						$langue_option = $MSG_1595;
						if (L_English == 1)
							$affiche_langue = true;
						else
							$affiche_langue = false;
						break;
					case 'chinese' : case 3 :
						$langue_option = $MSG_1596;
						if (L_Chinese == 1)
							$affiche_langue = true;
						else
							$affiche_langue = false;
						break;
					case 'japanese' : case 4 :
						$langue_option = $MSG_1597;
						if (L_Japanese == 1)
							$affiche_langue = true;
						else
							$affiche_langue = false;
						break;
					case 'korean' : case 5 :
						$langue_option = $MSG_1598;
						if (L_Korean == 1)
							$affiche_langue = true;
						else
							$affiche_langue = false;
						break;
					case 'russian' : case 6 :
						$langue_option = $MSG_2175;
						if (L_Russian == 1)
							$affiche_langue = true;
						else
							$affiche_langue = false;
						break;
					case 'sudan' : case 7 :
						$langue_option = $MSG_2176;
						if (L_Sudan == 1)
							$affiche_langue = true;
						else
							$affiche_langue = false;
						break;
				}

				//si la plate-forme est une pgr, on affiche toutes les langues
				if ($site_heberge != 1) {
					$affiche_langue = true;
				}
				if ($affiche_langue) {
					$lang_dispo[$i][0] = $repLang;
					$lang_dispo[$i][1] = $langue_option;
					$lang_dispo[$i][2] = $repLang;
					$i++;
				}
			}
		}
	} else
		print die("Impossible de lire le r&eacute;pertoire des langues");

	return $lang_dispo;
}

/**
 * Obtenir les langues disponibles de la plate-forme.
 * 
 * Retourne un tableau contenant les chemins vers les langues disponibles.
 * Toutes les langues sont disponibles si la plate-forme n'est pas une plate-forme h�berg�e (pas une PGR).
 * Si la plate-forme est herg�e (donc une PGR), les langues disponibles sont celles qui sont
 * pr�sentes dans le fichier config_site.php. 
 * 
 * @return array() un tableau contenant les chemins vers les langues disponibles [0]contient le code de la langue,[1] son lib�ll� et [2] le code.
 */
function get_langues_disponibles() {
	global $chemin_bo;
	global $serverback;
	global $site_heberge;

	if (VERSION_BASE > VERSION) {
		$lang_dispo = array ();
		$lang_bo = $chemin_bo . "/lang/";

		$sql = "select * from contraintes.fw_get_langues() as (id int4,libelle varchar, code varchar, locale varchar)";
		$res = pg_query($sql);
		$nb_langues = pg_num_rows($res);
		$j = 0;
		for ($i = 0; $i < $nb_langues; $i++) {
			$row = pg_fetch_row($res, $i);
			//site heberg�?
			/*
			if ($site_heberge == 1) {
				//langue autoris�e?
				//eval ("$exp=($row[2]==1);");
				//if ($exp) {
					$lang_dispo[] = $row[1];
				//}
			} else {
			*/
				$lang_dispo[$j][0] = $row[0];
				$lang_dispo[$j][1] = $row[1];
				$lang_dispo[$j][2] = $row[2];
				$j++;
			//}
		}
		return $lang_dispo;
	} else {
		return get_langues_disponibles_old();
	}
}

/**
 * Obtenir les infos d'un type de message de langue
 * @param integer : type de message de langue
 * @return integer : res req
 */
 function get_langue_type($type){
 	$sql="select * from contraintes.af_get_langue_type($type) as (id int4,libelle varchar,code varchar)";
 	return pg_query($sql);
 }

  	
?>