<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * D�finition d'un DoListe.
 * Un DoListe est l'objet de base servant � gerer l'avancement des
 * Etapes sous forme de liste d'un parcours.
 * Ainsi, chaque objet d'avancement des diff�rents types d'Etapes en liste (Series, Tests)
 * d'un parcours doivent h�riter de cette classe.
 * Chacun de ses noeuds se doit d'h�riter de la classe DoNode.
 * 
 * @package liste
 */
class DoListe extends DoEtapeRenewable{ 
	
	/**
	 * @var object DoNode Objet d'avancement du noeud courant de la Liste.
	 */
	var $obj_DoNode;
	
	/**
	 * @var object DoNodeFactory  Fabrique des objets d'avancement des noeuds de la Liste.
	 */
	var $obj_DoNodeFactory;
	
	
	var $duree;
	
	/**
	 * Constructeur
	 * 
	 * Creation de l'objet et initialisation
	 * de ses attributs h�rit�s.
	 * 
	 * @param integer $formation la formation de l'individu
	 * @param integer $individu l'individu qui effectue la formation
	 * @param integer $parcours le parcours
	 * @param integer $etape l'�tape Liste
	 * @param object DoNodeFactory &$obj_DoNodeFactory Fabrique servant � la cr�ation des objets d'avancement des Nodes de la Liste
	 */
	function DoListe($formation,$individu,$parcours,$etape,&$obj_DoNodeFactory){
		
		messageDebug("DoListe:DoLIste()");
		parent::DoEtapeRenewable($formation,$individu);
		$this->initDoListe($parcours,$etape, TYPE_ETAPE_LISTE,$obj_DoNodeFactory);
	}
	
	/**
	 * Initialisation.
	 * Initialise les attributs propres a l'objet.
	 * 
	 * @param integer $parcours Identifiant du parcours courant.
	 * @param integer $etape Identifiant de l'�tape courante.
	 * @param integer $type Identifiant du type de l'�tape courante.
	 * @param object DoNodeFactory &$obj_DoNodeFactory  Fabrique servant � la cr�ation des objets d'avancement des Nodes de la Liste
	 */
	function initDoListe($parcours,$etape, $type,&$obj_DoNodeFactory){
		messageDebug("DoListe:initDoLIste()");
		parent::initDoEtapeRenewable($parcours,$etape, $type);
		if(is_object($obj_DoNodeFactory)){
			$this->obj_DoNodeFactory=&$obj_DoNodeFactory;
		}else{
			die("Erreur DoListe::initDoListe(): L'objet ne peut etre initialis�.");
		}	
	}
	
//-----------------------------------------------------
//			METHODES
//-----------------------------------------------------
	
	/**
	 * D�but de l'�tape.
	 * Initialise l'avancement de l'�tape.
	 * Cr�ation de l'identifiant r�sultat et enregistrement de la date de d�but de l'�tape.
	 * Si l'identifiant r�sultat existe d�j�, une erreur est g�n�r�e.
	 * 
	 * @return integer idenfiant r�sultat en base de donn�es
	 */
	function beginCurrentEtape(){
		messageDebug("DoListe::beginCurrentEtape()");
		return parent::beginCurrentEtape();
	}
	
	/**
	 * Construction des objets associ�s � l'avancement au sein de la Liste.
	 * L'objet associ� � l'avancement, de type Evaluation, est construit � partir
	 * de l'identifiant Resultat cr�� par la methode beginCurrentEtape(). Elle doit
	 * donc avoir �t� appell�e auparavent. Si non, une erreur est g�n�r�e.
	 * @return object DoNode  L'objet correspondant � l'�valuation courante de la Liste (au DoNode) 
	 */
	function &performCurrentEtape($obj_EtapeFactory){
		messageDebug("DoListe::performCurrentEtape()");
		$this->obj_node=$obj_EtapeFactory->createEtape($this);
		return $this->obj_DoNode;
	}

	/**
	 * Termine l'�tape.
	 * Enregistre la date de fin de l'�tape et detruit les attributs de l'objet inutiles (resultat et obj_node). 
	 * Cette m�thode n�c�ssite un objet Resultat en parametre, qui est obtenu par la methode getCurrentResultat()
	 * 
	 * @param object Resultat $obj_resultat : Resultat associ� � l'objet associ� � l'avancement.
	 * @return boolean true ou false suivant le succ�s ou non de la m�thode.
	 */
	function endCurrentEtape($obj_resultat){
		messageDebug("DoListe::endCurrentEtape($obj_resultat)");
		if($this->obj_DoNode==null){
//			unset($this->obj_DoNodeFactory);
			return parent::endCurrentEtape($obj_resultat);
		}else{
			die("Erreur DoListe::endCurrentEtape(): La liste ne peut etre termin�e: le Node courant n'est pas null.<br/>");
			return false;
		}
	}	
	
	/**
	 * Retourne le temps restant pour le chrono,  en secondes.
	 * Attention, ce temps est calcul� par rapport � la somme des dur�es des �valuations.
	 * Les �valuation non termin�es ne sont donc pas prises en compte.
	 */
	function getChronoRestant($evaluation=null){
		
		
		//CHRONO SERIE		
		$duree_evaluations=$this->duree_evaluations;
//		$duree_chrono_serie=$this->obj_node->getChrono();
		$duree_chrono_serie=$this->obj_node->getChrono();	
		
		//CHRONO EVALUATION	
		if(is_object($this->obj_DoNode)&&!empty($evaluation)){
//			echo "\$evaluation=$evaluation";
			$duree_chrono_evaluation=$this->obj_node->getChronoEvaluation($evaluation);	
		}
		
	
//		echo "duree des evaluations=$duree_evaluations<br>";
//		echo "chrono eval (glob ou indiv)=$duree_chrono_evaluation<br>";
//		echo "chrono serie=$duree_chrono_serie<br>";
		
		if(!is_null($duree_chrono_serie)){
//			echo "<b>chrono s�rie</b><br>";
			$duree_chrono=$duree_chrono_serie;
			
		}elseif(!is_null($duree_chrono_evaluation)){
//			echo "<b>chrono eval</b><br>";
			if($this->obj_DoNode!=null){
				$temps_restant=$this->obj_DoNode->getChronoRestant($this->obj_node);	
//				echo "<br>ffffffffffffffffffffffffffff$temps_restant<br>";
				return $temps_restant;
			}
			$duree_chrono=$duree_chrono_evaluation;

		}else{
//			echo "pas de chrono";
			$duree_chrono=null;
		}
		
		if(is_null($duree_chrono))return null;
		
		$chrono_restant=$duree_chrono-$duree_evaluations;
		//il faut aussi v�rifier que la date de d�but de l'�valuation en cours n'est pas trop ancienne par rapport au chrono
		
		
		if($chrono_restant>0){
			
//			echo "debut evaluation=<br><br>";
//			print_rr($this->obj_DoNode);
//				echo "debut evaluation=".$this->obj_DoNode->getDebut()."<br>";
//				echo "<br><br>";
		}
		
//		echo "chrono restant=$chrono_restant<br>";
		return $chrono_restant;
	}
	
	
	function isChronoValid($chrono_restant,$evaluation){
//		$chrono_restant=$this->getChronoRestant($evaluation);
		if(is_object($this->obj_DoNode))$this->obj_DoNode->isChronoValid($this->obj_node,$chrono_restant);
		
		if(!is_null($chrono_restant)&&$chrono_restant<=0){
			return false;
		}else{
			return true;
		}
	}

//-----------------------------------------------------
//			ACCESSEURS
//-----------------------------------------------------

	/**
	 * Obtenir l'objet Liste associ� � cet objet d'avancement.
	 * @return object Liste L'objet Liste associ�. 
	 */
	function &getListe(){
		return parent::getObjEtape();
	}
	
	/**
	 * Obtenir l'identifiant r�sultat correspondant � l'avancement actuel.
	 * @return integer Identifiant en base de r�sutat (formation, individu, parcours, etape). 
	 */
	function getResultat(){
		return $this->resultat;
	}
	
	/**
	 * Obtenir l'objet d'avancement correspondant au noeud courant de la Liste 
	 * @return object DoNode L'objet d'avancement du Node courant
	 */
	function &getCurrentDoNode(){
		return $this->obj_DoNode;
	}
	
	/**
	 * Obtenir la fabrique utilis�e pour la cr�ation des noeuds de la Liste
	 * @param object DoNodeFactory La fabrique de DoNode
	 */
	function &getDoNodeFactory(){
		return $this->obj_DoNodeFactory;
	}
	
	/**
	 * Obtenir l'objet R�sultat associ� � l'avancement actuel.
	 * @return object Resultat Objet � utiliser avec la m�thode endCurrentEtape(). 
	 */
	function &getCurrentResultat(){
		return $this->obj_DoNode->obj_resultat;
	}
	
	/**
	 * Obtenir le type (complet) de la S�rie
	 * @return string Le type de S�rie
	 */
	function getType(){
		return TYPE_ETAPE_LISTE;
	}
	
	/**
	 * Indique si l'Etape � donn� lieu � une correction.
	 * Retourne toujours true, car une Liste est autocorrig�e, et donc corrig�e par d�faut.
	 * @return boolean true si l'Etape � �t� corrig�e, false sinon.
	 */
	function isCorrected(){
		return true;
	}
	
	/**
	 * Indique que l'Etape n'est jamais finie.
	 * @return boolean Toujours false. 
	 */
	function isEnd(){
		
//		echo "est commence=".$this->isBegin()."<br>";
//		echo "evaluaonti=".$this->obj_DoNode."<br>";
		if($this->isBegin()&&!empty($this->duree)){//$this->obj_DoNode==null
			return true;
		}
		else{
			return false;
		}	
	}
		
	function getDuree(){
		return $this->duree;
	}
	
	function getDureeFormate(){
//		echo "duree=".$this->duree."<br>";
		return sql_interval_to_string($this->duree);
	}
}
?>
