<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Fichier de dfinition de la classe Liste
 * Une Liste est une Etape contenant d'autres entits (Nodes) lies entre
 * elles sous la forme d'une liste chaine.
 * 
 * @package liste
 */
class Liste extends Etape{

	/**
	 * @var integer Le type de Liste
	 */
	var $type_liste;
	
	/**
	 * Construit la Liste.
	 * La Liste peut tre construit  partir d'un identifiant (1 seul parametre), auquel cas les donnes sont rcupres en base de donnes,
	 * ou  partir de l'ensemble des donnes (tous les parametres), pour ensuite tre enregistr en base.
	 *  
	 * @param integer $id identifiant de la Liste
	 * @param string $libelle Libell de la Liste
	 * @param string $date_creation date de cration (format SQL)
	 * @param integer $type_liste Type de Liste (Srie, Test, ...)
	 */
	function Liste($id, $libelle="Etape Liste", $date_creation="27.11.2006",$type_liste=0){
		if(func_num_args()==1){
			$res_etape=get_liste($id);
			$row_etape=pg_fetch_row($res_etape);
			$libelle=$row_etape[1];
			$date_creation=$row_etape[3];
		}else{
			
		}
		parent::Etape($id, $libelle,$date_creation, TYPE_ETAPE_LISTE);
		$this->initListe($row_etape[2]);
	}
	
	/**
	 * Initialise les attributs propres  la Liste
	 * @param integer $type_liste Type de Liste (Srie, Test, ...)  
	 */
	function initListe($type_liste){
		parent::initEtape();
		$this->type_liste=$type_liste;
	}
	
	/**
	 * Obtenir le type de la Liste
	 * @return string Le type de liste
	 */
	function getType(){
		return parent::getType().'_'.$this->type_liste;
	}
	
	/**
	 * Obtenir l'identifiant du mdia de la Liste
	 * @return integer l'identifiant du mdia
	 */
	function getMedia(){
		return null;
	}
	
	/**
	 * Indique si l'Etape peut donner lieu  une correction.
	 * Retourne toujours true, car une Liste donne lieu  une correction.
	 * @return boolean Retourne true.
	 */
	function isCorrectable(){
		return true;
	}
	
	/**
	 * Indique si l'Etape peut possder son propre chrono.
	 * Retourne toujours false, car une tape ne possede pas de chrono par dfaut.
	 * @return boolean true si l'Etape donne lieu  un chrono, false sinon.
	 */
	function isChronometrable(){
		return true;
	}	
}
?>