<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Dfinition d'un ListeCorrection.
 * Un ListeCorrection est l'objet  utilis pour exploiter la correction d'une Liste.
 * Cet objet de correction est constuit  partir d'un DoListe, l'objet d'avancement des Listes.
 * 
 * @package liste
 */
class ListeCorrection extends EtapeCorrection{ 

	var $current_evaluation_correction_obj;
	var $current_evaluation_correction_indice;
	
	/**
	 * Constructeur
	 * 
	 * Creation de l'objet et initialisation
	 * de ses attributs hrits.
	 * 
	 * @param object DoListe $obj_DoListe
	 */
	function ListeCorrection($obj_DoListe){
		messageDebug("ListeCorrection::ListeCorrection( $obj_DoListe)");
		parent::EtapeCorrection($obj_DoListe);
		$this->current_evaluation_correction_indice=null;
		$this->current_evaluation_correction_obj=null;
	}
	
	function initListeCorrection(){
		$res_resultat=get_resultat_serie($this->obj_DoEtape->getFormation(), $this->obj_DoEtape->getIndividu(), $this->obj_DoEtape->getParcours(), $this->obj_DoEvaluation->getEvaluation());
		if($res_resultat&&pg_num_rows($res_resultat)==1){
			$row_resultat=pg_fetch_row($res_resultat);
			$this->resultat=$row_resultat[0];
			$this->debut=$row_resultat[2];
			$this->fin=$row_resultat[2];
		}
		else{
			die("Erreur ListeCorrection::ListeCorrection($obj_DoEtape): L'objet d'avancement ne possde pas d'identifiant de rsultat.(Le DoListe a-t-il bien t commenc?)");
		}
	}
	
	function getCurrentEvaluationCorrectionType(){
		if(is_object($this->current_evaluation_correction_obj)){
			return $this->current_evaluation_correction_obj->getType();
		}
	}
//-----------------------------------------------------
//			METHODES PUBLIQUES
//-----------------------------------------------------
//	/**
//	 * Obtenir les scores des Evaluations de la Srie
//	 * @return integer Le resultat de la requete :(id int4, libelle varchar, serie int4, pere int4, commentaire varchar, bareme int4, chrono int4, points int4, type int4 )
//	 */
//	function getEvaluationsScores(){
//		return get_resultat_serie_evaluations_scores($this->getResultat());
//	}
//	
//	/**
//	 * Obtenir les Evaluations de la Srie
//	 * @return integer Le resultat de la requete :(id int4, libelle varchar, serie int4, pere int4, commentaire varchar, bareme int4, chrono int4, points int4, type int4 )
//	 */
//	function getScoreTotal(){
//		return 8;
//	}	
//
//	function getNextEvaluation($indice=0){
//		if(empty($indice)){
//			$indice=$this->current_row;
//		}
//		$res_evaluations=get_serie_evaluations($this->obj_DoEtape->getEtape());
//		if($indice<=pg_num_rows($res_evaluations)){
//			$row=pg_fetch_row($res_evaluations,$indice-1);
//			$this->current_row++;
//			return EvaluationCorrectionFactory::createEvaluationCorrection($this,$this->obj_DoEtape->obj_DoNodeFactory->createDoEvaluation($this->resultat,$row[0],$row[8],$indice));
//		}else{
//			return null;
//		}
//	}
//-----------------------------------------------------
//			METHODES PRIVEES
//-----------------------------------------------------
	
//-----------------------------------------------------
//			ACCESSEURS
//-----------------------------------------------------
	

}
?>
