<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 
	@package liste 
	@modulegroup plpgsql
	@module plpgsql_liste
*/

/**
 * Obtenir une liste.
 * @param integer : identifiant de la liste
 * @return integer : resultat de la requete : (id int4,libelle varchar, type int4,date_creation timestamp)
 */
function get_liste($liste){
	if(VERSION_BASE>VERSION){
        $sql="SELECT * FROM contraintes.af_get_liste($liste) AS (id int4,libelle varchar, type int4,date_creation timestamp)";
		//echo "$sql<br>";
		$res=pg_query($sql);
    }
    else
        print("La fonction get_liste($liste) n'existe pas pour la version ".VERSION);
        
    return $res ;
}

/**
 * Obtenir les themes d'une liste.
 * @param integer : identifiant de la liste
 * @return integer : resultat de la requete : (id int4,libelle varchar)
 */
function get_liste_themes($liste){
	if(VERSION_BASE>VERSION){
        $sql="SELECT * FROM contraintes.af_get_liste_themes($liste) AS (id int4,libelle varchar)";
		//echo "$sql<br>";
		$res=pg_query($sql);
    }
    else
        print("La fonction get_liste($liste) n'existe pas pour la version ".VERSION);
        
    return $res ;
}



?>