<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
* Fichier de dfinition de la classe Media
* Cette classe dcrit un mdia (identifiant, longueur & largeur)
*
* @package media
*/
class Media{
	
    /**
    * @var integer : Identifiant base de donnes
    */
    var $id ;

    /**
    * @var string : Nom du fichier
    */
    var $libelle ;


    /**
    * @var integer : Hauteur du media
    */
    var $hauteur ;

    /**
    * @var integer : Largeur du media
    */
    var $largeur ;

    /**
    * Constructeur de la classe Media
    * @param integer : identifiant en base de donnes
    * @param String : Nom du fichier media
    * @param integer : hauteur
    * @param integer : largeur
    */
    function Media($id=0, $hauteur=0, $largeur=0,$libelle=""){
            $this->id = (int)$id ;
            $this->hauteur = (int)$hauteur ;
            $this->largeur = (int)$largeur ;
            $this->libelle = $libelle ;
	}


//-----------------------------------------------------
//			ACCESSEURS
//-----------------------------------------------------

	/**
	 * Identifiant du Mdia
	 * @return integer identifiant en base de donnes.
	 */
    function getId() { return $this->id ; }
    
    /**
	 * Obtenir le libll du mdia
	 * @return string Le libll du mdia.
	 */
    function getLibelle() { return $this->libelle ; }
    
    /**
	 * Obtenir la hauteur du Mdia
	 * @return integer Hauteur en pixel du Mdia.
	 */
    function getHauteur() { return $this->hauteur ; }
    
    /**
	 * Obtenir la largeur du Mdia
	 * @return integer Largeur en pixel du Mdia.
	 */
    function getLargeur() { return $this->largeur ; }
    
    /**
	 * Affecter la hauteur du Mdia
	 * @param  $hauteur integer Hauteur en pixel du Mdia.
	 */
    function setHauteur($hauteur) { $this->hauteur=$hauteur ; }
    
    /**
	 * Affecter la largeur du Mdia
	 * @param  $largeur integer Largeur en pixel du Mdia.
	 */
    function setLargeur($largeur) { $this->largeur=$largeur ; }
    
    /**
     * Obtenir le chemin absolu du Mdia.
     * @return string : l'emplacement sur disque du mdia, sous la forme http://xx.xx.xx.xx./xxx/xxx.xx
     */
    function getChemin(){
    	$theme=pg_fetch_result(get_categorie_element_themes(4,$this->id),0,0);
    	return get_fichier_chemin($this->getId(), $theme, 4);
    }

}
?>